/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.config;

import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.console.config.BGImageNode;
import com.sun.management.viperimpl.console.config.PropertiesNode;
import com.sun.management.viperimpl.console.config.VBaseNode;
import com.sun.management.viperimpl.console.config.VConfigurationNode;
import com.sun.xml.tree.NodeEx;
import com.sun.xml.tree.ParseContext;
import java.util.Properties;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ToolNode
extends VBaseNode
implements VConfigurationNode {
    protected String serverName;
    protected int serverPort;
    protected String className;
    protected boolean autoLoad;
    protected boolean backgroundLoad;
    protected Properties properties;
    protected int SLOT_SERVERNAME;
    protected int SLOT_SERVERPORT;
    protected int SLOT_CLASSNAME;
    protected int SLOT_PROPERTIES;

    public ToolNode() {
        this.setTag("Tool");
        this.SLOT_NAME = 0;
        this.SLOT_DESCRIPTION = 1;
        this.SLOT_ICON = 2;
        this.SLOT_LARGEICON = 3;
        this.SLOT_SCOPE = 4;
        this.SLOT_SERVERNAME = 5;
        this.SLOT_SERVERPORT = 6;
        this.SLOT_CLASSNAME = 7;
        this.SLOT_BGIMAGE = 8;
        this.SLOT_PROPERTIES = 9;
        this.slots = new Node[10];
    }

    public void startParse(ParseContext context) throws SAXException {
        super.startParse(context);
        try {
            this.serverName = this.baseURL.getHost();
            this.serverPort = this.baseURL.getPort();
        }
        catch (Exception e) {
            this.serverName = "";
            this.serverPort = -1;
        }
        NamedNodeMap nnm = this.getAttributes();
        if (nnm == null) {
            return;
        }
        for (int i = 0; i < nnm.getLength(); ++i) {
            String attrName = nnm.item(i).getNodeName();
            String attrValue = nnm.item(i).getNodeValue();
            if (attrName.equals("AutoLoad")) {
                this.autoLoad = this.isTrueValue(attrValue);
                continue;
            }
            if (attrName.equals("BackgroundLoad")) {
                this.backgroundLoad = this.isTrueValue(attrValue);
                continue;
            }
            if (!attrName.equals("TreeDisplay")) continue;
            this.treeDisplay = this.isTrueValue(attrValue);
        }
    }

    public void doneChild(NodeEx n, ParseContext context) throws SAXException {
        super.doneChild(n, context);
        String childName = n.getNodeName();
        Node child = n.getFirstChild();
        String childValue = null;
        if (child != null) {
            childValue = child.getNodeValue();
        }
        try {
            if (childName.equals("ServerName")) {
                this.serverName = childValue;
                this.slots[this.SLOT_SERVERNAME] = n;
            } else if (childName.equals("ServerPort")) {
                this.serverPort = Integer.parseInt(childValue);
                this.slots[this.SLOT_SERVERPORT] = n;
            } else if (childName.equals("Name")) {
                this.name = childValue;
                this.slots[this.SLOT_NAME] = n;
            } else if (childName.equals("Description")) {
                this.description = childValue;
                this.slots[this.SLOT_DESCRIPTION] = n;
            } else if (childName.equals("Icon")) {
                this.smallIcon = childValue;
                this.slots[this.SLOT_ICON] = n;
            } else if (childName.equals("LargeIcon")) {
                this.largeIcon = childValue;
                this.slots[this.SLOT_LARGEICON] = n;
            } else if (childName.equals("ClassName")) {
                this.className = childValue;
                this.slots[this.SLOT_CLASSNAME] = n;
            } else if (childName.equals("Scope")) {
                this.scope = childValue;
                this.slots[this.SLOT_SCOPE] = n;
            } else if (childName.equals("BackgroundImage")) {
                this.bgImage = ((BGImageNode)n).getURL();
                this.bgImageLoc = ((BGImageNode)n).getLocation();
                this.slots[this.SLOT_BGIMAGE] = n;
            } else if (childName.equals("Properties")) {
                this.properties = ((PropertiesNode)n).getProperties();
                this.slots[this.SLOT_PROPERTIES] = n;
            }
        }
        catch (Exception e) {
            Debug.trace((String)"Configuration", (int)Debug.WARNING, (String)"Configuration error", (Throwable)e);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String name) {
        if (name == null) {
            return;
        }
        this.className = name;
        this.setTaggedNode("ClassName", name, this.SLOT_CLASSNAME);
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String name) {
        this.serverName = name;
        if (name != null && name.length() > 0) {
            this.setTaggedNode("ServerName", name, this.SLOT_SERVERNAME);
        } else if (this.slots[this.SLOT_SERVERNAME] != null) {
            this.removeChild(this.slots[this.SLOT_SERVERNAME]);
            this.slots[this.SLOT_SERVERNAME] = null;
        }
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int port) {
        if (port < 0) {
            port = -1;
        }
        this.serverPort = port;
        if (port >= 0) {
            this.setTaggedNode("ServerPort", "" + port, this.SLOT_SERVERPORT);
        } else if (this.slots[this.SLOT_SERVERPORT] != null) {
            this.removeChild(this.slots[this.SLOT_SERVERPORT]);
            this.slots[this.SLOT_SERVERPORT] = null;
        }
    }

    public boolean isAutoLoad() {
        return this.autoLoad;
    }

    public void setAutoLoad(boolean autoLoad) {
        this.autoLoad = autoLoad;
        if (autoLoad) {
            this.setAttribute("AutoLoad", "true");
        } else if (this.getAttribute("AutoLoad") != null && !this.getAttribute("AutoLoad").equals("")) {
            this.removeAttribute("AutoLoad");
        }
    }

    public boolean isBackgroundLoad() {
        return this.backgroundLoad;
    }

    public void setBackgroundLoad(boolean backgroundLoad) {
        this.backgroundLoad = backgroundLoad;
        if (backgroundLoad) {
            this.setAttribute("BackgroundLoad", "true");
        } else if (this.getAttribute("BackgroundLoad") != null && !this.getAttribute("BackgroundLoad").equals("")) {
            this.removeAttribute("BackgroundLoad");
        }
    }

    public Properties getParameters() {
        return this.properties;
    }

    public void setParameters(Properties properties) {
        this.properties = properties;
        if (properties != null && properties.size() > 0) {
            PropertiesNode newNode = this.getConfiguration().createPropertiesNode(properties);
            this.setTaggedNode((Node)((Object)newNode), this.SLOT_PROPERTIES);
        } else if (this.slots[this.SLOT_PROPERTIES] != null) {
            this.removeChild(this.slots[this.SLOT_PROPERTIES]);
            this.slots[this.SLOT_PROPERTIES] = null;
        }
    }

    public boolean getAllowsChildren() {
        return false;
    }

    protected void printNode(int indent) {
        System.out.println(this.indent(indent) + this.getNodeName() + ": " + this.getClassName() + " (scope = " + this.getScope() + ")" + " len = " + this.getLength() + ", " + this.getFilteredLength());
        String nindent = this.indent(indent + 1);
        System.out.println(nindent + "Server Name: " + (this.serverName.equals("") ? "Default" : this.serverName));
        System.out.println(nindent + "Server Port: " + (this.serverPort == -1 ? "Default" : "" + this.serverPort));
        System.out.println(nindent + (this.autoLoad ? "Automatically loaded" : "Loaded at user request"));
        System.out.println(nindent + (this.backgroundLoad ? "Loads in background" : "Blocks on load"));
        System.out.println(nindent + (this.treeDisplay ? "Displayed in Nav Panel" : "Hidden from Nav Panel"));
    }
}

