/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.config;

import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.console.config.BGImageNode;
import com.sun.management.viperimpl.console.config.VBaseNode;
import com.sun.management.viperimpl.console.config.VConfigurationNode;
import com.sun.xml.tree.NodeEx;
import com.sun.xml.tree.ParseContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ToolBoxURLNode
extends VBaseNode
implements VConfigurationNode {
    protected String url;
    protected String information;
    protected int SLOT_URL;
    protected int SLOT_INFORMATION;

    public ToolBoxURLNode() {
        this.setTag("ToolBoxURL");
        this.SLOT_URL = 0;
        this.SLOT_NAME = 1;
        this.SLOT_DESCRIPTION = 2;
        this.SLOT_INFORMATION = 3;
        this.SLOT_BGIMAGE = 4;
        this.SLOT_ICON = 5;
        this.SLOT_LARGEICON = 6;
        this.SLOT_SCOPE = 7;
        this.slots = new Node[8];
    }

    public void startParse(ParseContext context) throws SAXException {
        super.startParse(context);
        NamedNodeMap nnm = this.getAttributes();
        if (nnm == null) {
            return;
        }
        for (int i = 0; i < nnm.getLength(); ++i) {
            String attrName = nnm.item(i).getNodeName();
            String attrValue = nnm.item(i).getNodeValue();
            if (!attrName.equals("TreeDisplay")) continue;
            this.treeDisplay = this.isTrueValue(attrValue);
        }
    }

    public void doneChild(NodeEx n, ParseContext context) throws SAXException {
        super.doneChild(n, context);
        String childName = n.getNodeName();
        Node child = n.getFirstChild();
        String childValue = null;
        if (child != null) {
            childValue = child.getNodeValue();
        }
        try {
            if (childName.equals("URL")) {
                this.url = childValue;
                this.slots[this.SLOT_URL] = n;
            } else if (childName.equals("Name")) {
                this.name = childValue;
                this.slots[this.SLOT_NAME] = n;
            } else if (childName.equals("Information")) {
                this.information = childValue;
                this.slots[this.SLOT_INFORMATION] = n;
            } else if (childName.equals("Description")) {
                this.description = childValue;
                this.slots[this.SLOT_DESCRIPTION] = n;
            } else if (childName.equals("Scope")) {
                this.scope = childValue;
                this.slots[this.SLOT_SCOPE] = n;
            } else if (childName.equals("Icon")) {
                this.smallIcon = childValue;
                this.slots[this.SLOT_ICON] = n;
            } else if (childName.equals("LargeIcon")) {
                this.largeIcon = childValue;
                this.slots[this.SLOT_LARGEICON] = n;
            } else if (childName.equals("BackgroundImage")) {
                this.bgImage = ((BGImageNode)n).getURL();
                this.bgImageLoc = ((BGImageNode)n).getLocation();
                this.slots[this.SLOT_BGIMAGE] = n;
            }
        }
        catch (Exception e) {
            Debug.trace((String)"Configuration", (int)Debug.WARNING, (String)"Configuration error", (Throwable)e);
        }
    }

    public String getURLText() {
        return this.url;
    }

    public URL getURL() {
        try {
            return new URL(this.baseURL, this.url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public void setURL(String url) {
        this.url = url;
        if (url != null && url.length() > 0) {
            this.setTaggedNode("URL", url, this.SLOT_URL);
        } else if (this.slots[this.SLOT_URL] != null) {
            this.removeChild(this.slots[this.SLOT_URL]);
            this.slots[this.SLOT_URL] = null;
        }
    }

    public String getType() {
        return null;
    }

    public void setType(String type) {
    }

    public Properties getProperties() {
        return null;
    }

    public void setProperties(Properties properties) {
    }
}

