/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console;

import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.ToolInfo;
import com.sun.management.viper.VLocalizedInfo;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.console.config.ToolBoxNode;
import com.sun.management.viperimpl.console.config.ToolNode;
import com.sun.management.viperimpl.console.config.VConfigurationNode;
import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.tree.MutableTreeNode;

public class ManagerUtility {
    public static String parseHostFromString(String hostPort) {
        int i = hostPort.lastIndexOf(58);
        if (i > 0) {
            try {
                return hostPort.substring(0, i);
            }
            catch (Exception exception) {
            }
        } else if (i == 0) {
            return null;
        }
        return hostPort;
    }

    public static int parsePortFromString(String hostPort) {
        int i = hostPort.lastIndexOf(58);
        if (i >= 0) {
            try {
                return Integer.parseInt(hostPort.substring(i + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    public static boolean toolSupportsContext(ToolInfo info, String context) {
        if (info == null || context == null) {
            return false;
        }
        String[] contexts = info.getSupportedContexts();
        if (contexts == null) {
            return false;
        }
        boolean isSupported = false;
        for (int x = 0; x < contexts.length; ++x) {
            if (!contexts[x].equals(context)) continue;
            isSupported = true;
            break;
        }
        return isSupported;
    }

    public static boolean toolSupportsScope(ToolInfo info, AdminMgmtScope scope) {
        if (info == null || scope == null) {
            return false;
        }
        String[] scopes = info.getSupportedScopes();
        if (scopes == null) {
            return false;
        }
        boolean isSupported = false;
        for (int x = 0; x < scopes.length; ++x) {
            if (!scopes[x].equals(scope.getMgmtScopeType())) continue;
            isSupported = true;
            break;
        }
        return isSupported;
    }

    public static VScopeNode createScopeNodeFor(VLocalizedInfo locInfo, VConfigurationNode cNode, Component c) {
        if (locInfo == null) {
            return null;
        }
        try {
            VScopeNode node = new VScopeNode();
            node.setResultPane(c);
            node.setSmallIcon(locInfo.getSmallIcon());
            node.setLargeIcon(locInfo.getLargeIcon());
            node.setDescription(locInfo.getDescription());
            node.setText(locInfo.getName());
            if (cNode == null) {
                return node;
            }
            if (cNode.getName() != null) {
                node.setText(cNode.getName());
            }
            if (cNode.getDescription() != null) {
                node.setDescription(cNode.getDescription());
            }
            if (cNode.getSmallIcon() != null) {
                node.setSmallIcon(new ImageIcon(cNode.getSmallIcon()));
            }
            if (cNode.getLargeIcon() != null) {
                node.setLargeIcon(new ImageIcon(cNode.getLargeIcon()));
            }
            return node;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static VScopeNode createScopeNodeFor(VConfigurationNode node) {
        if (node == null) {
            return null;
        }
        VScopeNode sNode = new VScopeNode();
        try {
            sNode.setText(node.getName());
            String info = null;
            if (node instanceof ToolBoxNode) {
                info = ((ToolBoxNode)node).getInformation();
            }
            if (info != null) {
                sNode.setDescription(info);
            } else {
                sNode.setDescription(node.getDescription());
            }
            URL u = node.getLargeIcon();
            if (u != null) {
                sNode.setLargeIcon(new ImageIcon(u));
            }
            if ((u = node.getSmallIcon()) != null) {
                sNode.setSmallIcon(new ImageIcon(u));
            }
            ManagerUtility.setBackgroundImage(node, sNode);
        }
        catch (Throwable t) {
            Debug.trace((String)"BaseConsoleManager", (int)Debug.WARNING, (String)"Unexpected error", (Throwable)t);
        }
        return sNode;
    }

    public static void setBackgroundImage(VConfigurationNode configNode, VScopeNode scopeNode) {
        if (configNode == null || scopeNode == null) {
            return;
        }
        URL bgI = configNode.getBackgroundImage();
        if (bgI == null) {
            return;
        }
        try {
            scopeNode.setPFImage(new ImageIcon(bgI).getImage());
        }
        catch (Throwable t) {
            return;
        }
        String pfImageLoc = configNode.getBackgroundImageLocation();
        if (pfImageLoc == null) {
            scopeNode.setPFImageLoc(4);
            return;
        }
        if (pfImageLoc.equals("N")) {
            scopeNode.setPFImageLoc(1);
        } else if (pfImageLoc.equals("NE")) {
            scopeNode.setPFImageLoc(2);
        } else if (pfImageLoc.equals("E")) {
            scopeNode.setPFImageLoc(5);
        } else if (pfImageLoc.equals("SE")) {
            scopeNode.setPFImageLoc(8);
        } else if (pfImageLoc.equals("S")) {
            scopeNode.setPFImageLoc(7);
        } else if (pfImageLoc.equals("SW")) {
            scopeNode.setPFImageLoc(6);
        } else if (pfImageLoc.equals("W")) {
            scopeNode.setPFImageLoc(3);
        } else if (pfImageLoc.equals("NW")) {
            scopeNode.setPFImageLoc(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VScopeNode addChildToParent(VConfigurationNode configChild, VScopeNode scopeParent, VScopeNode scopeChild) {
        if (configChild == null || scopeChild == null || scopeParent == null) {
            return null;
        }
        if (configChild.getTreeDisplay()) {
            VScopeNode vScopeNode = scopeParent;
            synchronized (vScopeNode) {
                VConfigurationNode origParent = configChild.getParent();
                int origIndex = origParent.getIndex(configChild);
                int childCount = scopeParent.getChildCount();
                if (origIndex > childCount) {
                    scopeParent.add((MutableTreeNode)scopeChild);
                } else {
                    scopeParent.insert((MutableTreeNode)scopeChild, origIndex);
                }
                return scopeParent;
            }
        }
        VScopeNode iRoot = scopeParent.getInternalRoot();
        if (iRoot == null) {
            iRoot = new VScopeNode();
            scopeParent.setInternalRoot(iRoot);
        }
        VScopeNode newChild = new VScopeNode();
        if (configChild instanceof ToolNode) {
            iRoot.add((MutableTreeNode)scopeChild);
        } else {
            VScopeNode surrogate = new VScopeNode();
            surrogate.setText(scopeChild.getText());
            surrogate.setSmallIcon(scopeChild.getSmallIcon());
            surrogate.setLargeIcon(scopeChild.getLargeIcon());
            surrogate.setDescription(scopeChild.getDescription());
            surrogate.setInternalRoot(scopeChild);
            iRoot.add((MutableTreeNode)surrogate);
        }
        return iRoot;
    }
}

