/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl;

import com.sun.audit.AuditSession;
import com.sun.management.viper.ServiceContext;
import com.sun.management.viper.VException;
import com.sun.management.viper.VIdentity;
import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.VAuditSession;
import com.sun.management.viperimpl.VCallerImpl;
import com.sun.management.viperimpl.services.authentication.SecurityToken;
import com.sun.management.viperimpl.services.authentication.server.AuthenticationLibrary;
import com.sun.management.viperimpl.services.authentication.server.AuthenticationService;
import com.sun.management.viperimpl.services.authentication.server.ServerSecurityContext;
import java.io.Serializable;

public class VAuditSessionImpl
implements VAuditSession,
Serializable {
    private AuditSession auditSession = null;

    public VAuditSessionImpl() {
        byte[] context = null;
        this.auditSession = new AuditSession(context);
        if (this.auditSession != null && !this.auditSession.auditOn()) {
            Debug.trace((String)"VAuditSessionImpl()", (int)Debug.WARNING, (String)"auditing subsytem unavailable", null);
            this.auditSession = null;
        }
    }

    public VAuditSessionImpl(byte[] context) {
        this.auditSession = new AuditSession(context);
        if (this.auditSession != null && !this.auditSession.auditOn()) {
            this.auditSession = null;
            Debug.trace((String)"VAuditSessionImpl(context)", (int)Debug.WARNING, (String)"auditing subsytem unavailable", null);
        }
    }

    public Object getPlatformAuditSession() {
        return this.auditSession;
    }

    public static Object getPlatformAuditSession(ServiceContext serviceContext) {
        VAuditSession vAuditSession = VAuditSessionImpl.getVAuditSession(serviceContext);
        if (vAuditSession != null) {
            return vAuditSession.getPlatformAuditSession();
        }
        return null;
    }

    public static VAuditSession getVAuditSession(ServiceContext serviceContext) {
        VAuditSession vAuditSession = null;
        VCallerImpl vCallerImpl = (VCallerImpl)serviceContext.getCaller();
        SecurityToken token = vCallerImpl.getToken();
        if (token == null) {
            Debug.trace((String)"getVAuditSession()", (int)Debug.WARNING, (String)"vCallerImpl.getToken() returned null.", null);
            return null;
        }
        try {
            ServerSecurityContext ssc = AuthenticationService.lookupSecurityContext((SecurityToken)token);
            vAuditSession = ssc == null || ssc.getAuthState() != 4 ? null : ssc.getAuditSession();
        }
        catch (AuthenticationException ae) {
            vAuditSession = null;
            Debug.trace((String)"getVAuditSession()", (int)Debug.WARNING, (String)"Failed to get VAuditSession from ServiceContext.", (Throwable)ae);
        }
        catch (Exception ex) {
            vAuditSession = null;
            Debug.trace((String)"getVAuditSession()", (int)Debug.WARNING, (String)"Failed to get VAuditSession from ServiceContext.", (Throwable)ex);
        }
        return vAuditSession;
    }

    public String getSessionId() throws VException {
        if (this.auditSession == null) {
            return null;
        }
        String sessionString = null;
        try {
            sessionString = this.auditSession.getSessionId();
        }
        catch (Exception ex) {
            throw new VException(ex.getLocalizedMessage());
        }
        return sessionString;
    }

    public boolean auditOn() {
        if (this.auditSession == null) {
            return false;
        }
        return this.auditSession.auditOn();
    }

    public byte[] exportSession() throws VException {
        if (this.auditSession == null) {
            return null;
        }
        byte[] es = null;
        try {
            es = this.auditSession.exportSession();
        }
        catch (Exception ex) {
            throw new VException(ex.getLocalizedMessage());
        }
        return es;
    }

    public void setIdentity(VIdentity id, String hostname) {
        if (this.auditSession == null) {
            return;
        }
        String username = id.getPrimaryName();
        int uid = -1;
        int gid = -1;
        try {
            uid = Integer.parseInt(AuthenticationLibrary.getUid((String)username));
            gid = Integer.parseInt(AuthenticationLibrary.getGid((String)username));
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.auditSession.setUser(uid, gid, uid, gid, hostname, 0);
        if (id.isInRole()) {
            String rolename = id.getName();
            try {
                uid = Integer.parseInt(AuthenticationLibrary.getUid((String)rolename));
                gid = Integer.parseInt(AuthenticationLibrary.getGid((String)rolename));
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.auditSession.setUser(uid, gid, uid, gid, hostname, 1);
        }
    }

    public void setLabel(String label) throws VException {
    }
}

