/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util;

import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.PlatformSecureReader;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class DefaultSecureReader
implements PlatformSecureReader,
PrivilegedAction {
    protected InputStream iStream = null;
    protected static boolean libraryLoaded = false;

    protected static void loadLibrary() {
        try {
            String osID = System.getProperty("os.name");
            osID = osID.toUpperCase();
            osID.replace(' ', '-');
            String library = osID + "EchoOff";
            System.loadLibrary(library);
            libraryLoaded = true;
        }
        catch (Throwable t) {
            Debug.trace((String)"DefaultSecureReader", (int)Debug.WARNING, (String)"No platform secure reader available!", (Throwable)t);
        }
    }

    public Object run() {
        if (!libraryLoaded) {
            DefaultSecureReader.loadLibrary();
        }
        if (this.iStream == null) {
            return null;
        }
        try {
            StringBuffer strBuff = new StringBuffer("");
            int ch = 0;
            String input = "";
            this.echoOff();
            while ((ch = this.iStream.read()) != -1) {
                strBuff.append((char)ch);
                if (ch != 10 && ch != 13) continue;
            }
            input = strBuff.toString();
            this.echoOn();
            return input;
        }
        catch (Throwable t) {
            Debug.trace((String)"DefaultSecureReader", (int)Debug.ERROR, (String)"Problem reading secure information", (Throwable)t);
            return null;
        }
    }

    public String readLine(InputStream stream) {
        this.iStream = stream;
        try {
            Object o = AccessController.doPrivileged(this);
            return (String)o;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected void echoOff() {
        if (libraryLoaded) {
            DefaultSecureReader.doEchoOff();
        }
    }

    protected void echoOn() {
        if (libraryLoaded) {
            DefaultSecureReader.doEchoOn();
        }
    }

    protected static native void doEchoOff();

    protected static native void doEchoOn();
}

