/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.gui;

import com.sun.management.viper.console.gui.VDialog;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.resources.ContextHelpLoader;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class LoginChooser
extends VOptionPane
implements Serializable {
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    public static final int PREF_WIDTH = 500;
    public static final int PREF_HEIGHT = 300;
    protected JPasswordField passField = null;
    protected JLabel serverLabel = null;
    protected JLabel userLabel = null;
    protected JLabel passLabel = null;
    protected JTextField serverField = null;
    protected JTextField nameField = null;
    protected JButton okButton = null;
    protected JButton cancelButton = null;
    protected JDialog dialog = null;
    protected int returnValue = 1;
    protected transient String normalHelp = null;
    protected transient String failedHelp = null;
    protected transient String baseTitle = null;
    protected transient String normalTitle = null;
    protected transient String failedTitle = null;
    protected transient Dimension prefSize = new Dimension(500, 300);

    public LoginChooser() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setBorder(new EmptyBorder(30, 15, 15, 15));
        this.toggleContentTitle(false);
        this.serverLabel = new JLabel();
        this.userLabel = new JLabel();
        this.passLabel = new JLabel();
        this.serverField = new JTextField(10){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }
        };
        this.serverField.setEditable(false);
        this.serverLabel.setLabelFor(this.serverField);
        this.nameField = new JTextField(10){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }
        };
        this.userLabel.setLabelFor(this.nameField);
        try {
            this.nameField.setText(System.getProperty("user.name"));
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.passField = new JPasswordField(10){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }
        };
        this.passField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginChooser.this.returnValue = 0;
                if (LoginChooser.this.dialog != null) {
                    LoginChooser.this.dialog.setVisible(false);
                }
            }
        });
        this.passLabel.setLabelFor(this.passField);
        this.okButton = new JButton();
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginChooser.this.returnValue = 0;
                if (LoginChooser.this.dialog != null) {
                    LoginChooser.this.dialog.setVisible(false);
                }
            }
        });
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginChooser.this.returnValue = 1;
                if (LoginChooser.this.dialog != null) {
                    LoginChooser.this.dialog.setVisible(false);
                }
            }
        });
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 1));
        labelPanel.add(this.serverLabel);
        labelPanel.add(Box.createVerticalStrut(31));
        labelPanel.add(this.userLabel);
        labelPanel.add(Box.createVerticalStrut(12));
        labelPanel.add(this.passLabel);
        JPanel fieldPanel = new JPanel();
        fieldPanel.add(Box.createVerticalStrut(2));
        fieldPanel.setLayout(new BoxLayout(fieldPanel, 1));
        fieldPanel.add(this.serverField);
        fieldPanel.add(Box.createVerticalStrut(30));
        fieldPanel.add(this.nameField);
        fieldPanel.add(Box.createVerticalStrut(10));
        fieldPanel.add(this.passField);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        topPanel.add(labelPanel);
        topPanel.add(Box.createHorizontalStrut(10));
        topPanel.add(fieldPanel);
        JPanel bodyPanel = new JPanel();
        bodyPanel.setLayout(new BoxLayout(bodyPanel, 1));
        bodyPanel.add(topPanel);
        bodyPanel.add(Box.createVerticalGlue());
        this.getContentPane().add((Component)bodyPanel, "North");
        this.getButtonPane().add(this.okButton);
        this.getButtonPane().add(this.cancelButton);
        this.passField.requestDefaultFocus();
        this.init();
    }

    public void init() {
        this.installStrings();
        this.updateFontAndColor();
    }

    public String getUserName() {
        return this.nameField.getText();
    }

    public String getPassword() {
        return new String(this.passField.getPassword());
    }

    public int showLoginDialog(Component parent, String serverName, boolean previouslyFailed) {
        Frame frame;
        if (serverName != null) {
            this.serverField.setText(serverName);
        }
        this.passField.setText("");
        this.passField.setCaretPosition(0);
        Frame frame2 = frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        if (previouslyFailed) {
            this.dialog = new VDialog(frame, null, true);
            this.setHelpHTML(this.failedHelp);
            this.setTitle(this.baseTitle + " " + this.failedTitle);
        } else {
            this.dialog = new VDialog(frame, null, true);
            this.setHelpHTML(this.normalHelp);
            this.setTitle(this.baseTitle + " " + this.normalTitle);
        }
        super.setContainer((Component)this.dialog);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parent);
        this.passField.requestFocus();
        this.dialog.show();
        return this.returnValue;
    }

    protected void installStrings() {
        this.serverLabel.setText(ImplResourceManager.getString("SMC Server:"));
        this.serverLabel.setDisplayedMnemonic(ImplResourceManager.getString("SMC Server:_mnemonic").charAt(0));
        this.serverLabel.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("SMC Server:_accessible_name"));
        this.userLabel.setText(ImplResourceManager.getString("User Name:"));
        this.userLabel.setDisplayedMnemonic(ImplResourceManager.getString("User Name:_mnemonic").charAt(0));
        this.userLabel.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("User Name:_accessible_name"));
        this.passLabel.setText(ImplResourceManager.getString("Password:"));
        this.passLabel.setDisplayedMnemonic(ImplResourceManager.getString("Password:_mnemonic").charAt(0));
        this.passLabel.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("Password:_accessible_name"));
        this.cancelButton.setText(ResourceManager.getString((String)"CANCEL_BUTTON"));
        this.cancelButton.setMnemonic(ResourceManager.getString((String)"CANCEL_BUTTON_mnemonic").charAt(0));
        this.cancelButton.getAccessibleContext().setAccessibleName(ResourceManager.getString((String)"CANCEL_BUTTON_accessible_name"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(ResourceManager.getString((String)"CANCEL_BUTTON_accessible_desc"));
        this.okButton.setText(ResourceManager.getString((String)"OK_BUTTON"));
        this.okButton.setMnemonic(ResourceManager.getString((String)"OK_BUTTON_mnemonic").charAt(0));
        this.okButton.getAccessibleContext().setAccessibleName(ResourceManager.getString((String)"OK_BUTTON_accessible_name"));
        this.okButton.getAccessibleContext().setAccessibleDescription(ResourceManager.getString((String)"OK_BUTTON_accessible_name"));
        this.normalHelp = ImplResourceManager.getString("LoginChooserHelp");
        this.normalHelp = ContextHelpLoader.getContextHelp((String)this.normalHelp, null);
        this.failedHelp = ImplResourceManager.getString("LoginFailedChooserHelp");
        this.failedHelp = ContextHelpLoader.getContextHelp((String)this.failedHelp, null);
        this.baseTitle = ImplResourceManager.getString("Log In:");
        this.normalTitle = ImplResourceManager.getString("User Name");
        this.failedTitle = ImplResourceManager.getString("Login Failed");
        this.setTitle(this.normalTitle);
        this.setHelpHTML(this.normalHelp);
    }

    protected void updateFontAndColor() {
        this.serverLabel.setFont(ResourceManager.labelFont);
        this.serverLabel.setForeground(ResourceManager.labelColor);
        this.serverField.setFont(ResourceManager.bodyFont);
        this.serverField.setForeground(ResourceManager.bodyColor);
        this.userLabel.setFont(ResourceManager.labelFont);
        this.userLabel.setForeground(ResourceManager.labelColor);
        this.nameField.setFont(ResourceManager.bodyFont);
        this.nameField.setForeground(ResourceManager.bodyColor);
        this.passLabel.setFont(ResourceManager.labelFont);
        this.passLabel.setForeground(ResourceManager.labelColor);
        this.passField.setFont(ResourceManager.bodyFont);
        this.passField.setForeground(ResourceManager.bodyColor);
        this.okButton.setFont(ResourceManager.menuFont);
        this.okButton.setForeground(ResourceManager.menuColor);
        this.cancelButton.setFont(ResourceManager.menuFont);
        this.cancelButton.setForeground(ResourceManager.menuColor);
    }

    protected Dimension calculatePreferredSize() {
        Dimension d1 = super.calculatePreferredSize();
        Dimension prefSize = this.prefSize;
        if (!this.infoOn) {
            prefSize = new Dimension(500 - this.prefInfoWidth, 300);
        }
        if (d1.width > prefSize.width && d1.height > prefSize.height) {
            return d1;
        }
        if (d1.width < prefSize.width && d1.height < prefSize.height) {
            return prefSize;
        }
        int w = Math.max(d1.width, prefSize.width);
        int h = Math.max(d1.height, prefSize.height);
        return new Dimension(w, h);
    }

    public static void main(String[] args) {
        ResourceManager.seed((boolean)true);
        LoginChooser chooser = new LoginChooser();
        int r = chooser.showLoginDialog(null, "dodgeviper", args.length > 0);
        System.exit(0);
    }
}

