/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.gui;

import com.sun.management.viperimpl.console.PrivilegeManager;
import com.sun.management.viperimpl.console.gui.PrivilegeDialog;
import java.awt.Component;
import java.io.FileDescriptor;
import java.net.URL;
import java.security.CodeSource;
import java.util.LinkedList;

public final class GUIPrivilegeManager
implements PrivilegeManager {
    protected Component compParent = null;
    protected boolean trustedMode = false;
    protected LinkedList grantSet = null;
    protected LinkedList denySet = null;
    protected PrivilegeDialog dialog = new PrivilegeDialog();

    void init(Component compParent, boolean trusted) {
        this.compParent = compParent;
        this.trustedMode = trusted;
    }

    boolean checkGrantSet(URL location) {
        if (this.grantSet == null) {
            return false;
        }
        if (location == null) {
            return this.grantSet.contains(null);
        }
        return this.grantSet.contains(location.toString());
    }

    void checkDenySet(URL location) {
        if (this.denySet == null) {
            return;
        }
        if (location == null && this.denySet.contains(null)) {
            throw new SecurityException();
        }
        if (this.denySet.contains(location.toString())) {
            throw new SecurityException();
        }
    }

    protected synchronized void showPrivilegeDialog(CodeSource codeSource, int type, Object[] args) {
        URL location = null;
        if (codeSource != null) {
            location = codeSource.getLocation();
        }
        if (this.checkGrantSet(location)) {
            return;
        }
        this.checkDenySet(location);
        int userPref = this.dialog.showDialog(this.compParent, codeSource, type, args);
        if (userPref == 1) {
            if (this.grantSet == null) {
                this.grantSet = new LinkedList();
            }
            if (location == null) {
                this.grantSet.add(null);
            } else {
                this.grantSet.add(location.toString());
            }
        } else {
            if (userPref == 3) {
                if (this.denySet == null) {
                    this.denySet = new LinkedList();
                }
                if (location == null) {
                    this.denySet.add(null);
                } else {
                    this.denySet.add(location.toString());
                }
                throw new SecurityException();
            }
            if (userPref == 2) {
                throw new SecurityException();
            }
        }
    }

    public void checkReadPrivilege(FileDescriptor fd, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.showPrivilegeDialog(codeSource, 0, new Object[]{fd});
    }

    public void checkReadPrivilege(String file, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.showPrivilegeDialog(codeSource, 0, new Object[]{file});
    }

    public void checkReadPrivilege(String file, Object context, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.showPrivilegeDialog(codeSource, 0, new Object[]{file, context});
    }

    public void checkWritePrivilege(FileDescriptor fd, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.showPrivilegeDialog(codeSource, 1, new Object[]{fd});
    }

    public void checkWritePrivilege(String file, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.showPrivilegeDialog(codeSource, 1, new Object[]{file});
    }

    public void checkDeletePrivilege(String file, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.showPrivilegeDialog(codeSource, 2, new Object[]{file});
    }

    public void checkExecPrivilege(String cmd, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.showPrivilegeDialog(codeSource, 3, new Object[]{cmd});
    }

    public void checkLinkPrivilege(String lib, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.showPrivilegeDialog(codeSource, 4, new Object[]{lib});
    }
}

