/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.gui;

import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.console.gui.BaseToolBoxChooser;
import com.sun.management.viperimpl.console.gui.LocalToolBoxChooserUI;
import com.sun.management.viperimpl.console.gui.ServerToolBoxChooserUI;
import com.sun.management.viperimpl.console.gui.ToolBoxChooser;
import com.sun.management.viperimpl.console.gui.ToolBoxChooserUI;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.URL;
import javax.accessibility.AccessibleContext;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;

public class ComboToolBoxChooserUI
extends ComponentUI
implements ToolBoxChooserUI {
    protected JTabbedPane tabPane = null;
    protected BaseToolBoxChooser chooser = null;
    protected LocalToolBoxChooserUI localUI = null;
    protected ServerToolBoxChooserUI serverUI = null;
    protected String comboTitle = null;
    protected JButton approveButton = null;
    protected JButton cancelButton = null;
    protected URL localTB = null;
    protected URL serverTB = null;

    public ComboToolBoxChooserUI(BaseToolBoxChooser chooser) {
        this.chooser = chooser;
        this.comboTitle = ImplResourceManager.getString("Open Toolbox");
        this.installUI(null);
        MaskedToolBoxChooser maskedChooser = new MaskedToolBoxChooser();
        this.localUI = new LocalToolBoxChooserUI(maskedChooser);
        this.serverUI = new ServerToolBoxChooserUI(maskedChooser);
        this.installComponents(chooser);
        chooser.setUIReference(this);
        chooser.setTitle(this.comboTitle);
    }

    public void setNetworkTimeout(int timeMillis) {
        if (this.serverUI != null) {
            this.serverUI.setNetworkTimeout(timeMillis);
        }
    }

    public void installComponents(BaseToolBoxChooser chooser) {
        this.localUI.installComponents(chooser);
        this.serverUI.installComponents(chooser);
        this.tabPane = new JTabbedPane();
        this.tabPane.addTab(this.serverUI.getTitle(), this.serverUI.getResultPanel());
        this.tabPane.addTab(this.localUI.getTitle(), this.localUI.getResultPanel());
        this.tabPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int selTab = ComboToolBoxChooserUI.this.tabPane.getSelectedIndex();
                ComboToolBoxChooserUI.this.setSelectedTab(selTab);
            }
        });
        chooser.getContentPane().removeAll();
        chooser.getContentPane().setLayout(new BorderLayout());
        chooser.getContentPane().add((Component)this.tabPane, "Center");
        chooser.getButtonPane().removeAll();
        this.approveButton = new JButton();
        this.approveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComboToolBoxChooserUI.this.chooser.approveSelection();
            }
        });
        this.approveButton.setEnabled(false);
        chooser.getButtonPane().add(this.approveButton);
        chooser.getButtonPane().add(Box.createHorizontalStrut(5));
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComboToolBoxChooserUI.this.chooser.cancelSelection();
            }
        });
        chooser.getButtonPane().add(this.cancelButton);
        this.installStrings();
    }

    public void seedRemoteServer(String server) {
        if (server != null) {
            this.serverUI.seedServer(server);
        } else {
            try {
                String host = InetAddress.getLocalHost().getHostName();
                this.serverUI.seedServer(host);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void installStrings() {
        AccessibleContext ac;
        if (this.chooser.getDialogType() == 0) {
            this.approveButton.setText(ImplResourceManager.getString("OPEN_BUTTON"));
            this.approveButton.setToolTipText(ImplResourceManager.getString("OPEN_BUTTON_tooltip"));
            this.approveButton.setMnemonic(ImplResourceManager.getString("OPEN_BUTTON_mnemonic").charAt(0));
            ac = this.approveButton.getAccessibleContext();
            ac.setAccessibleName(ImplResourceManager.getString("OPEN_BUTTON_access_name"));
            ac.setAccessibleDescription(ImplResourceManager.getString("OPEN_BUTTON_access_desc"));
        } else {
            this.approveButton.setText(ImplResourceManager.getString("SAVE_BUTTON"));
            this.approveButton.setToolTipText(ImplResourceManager.getString("SAVE_BUTTON_tooltip"));
            this.approveButton.setMnemonic(ImplResourceManager.getString("SAVE_BUTTON_mnemonic").charAt(0));
            ac = this.approveButton.getAccessibleContext();
            ac.setAccessibleName(ImplResourceManager.getString("SAVE_BUTTON_access_name"));
            ac.setAccessibleDescription(ImplResourceManager.getString("SAVE_BUTTON_access_desc"));
        }
        this.cancelButton.setText(ImplResourceManager.getString("CANCEL_BUTTON"));
        this.cancelButton.setToolTipText(ImplResourceManager.getString("CANCEL_BUTTON_tooltip"));
        this.cancelButton.setMnemonic(ImplResourceManager.getString("CANCEL_BUTTON_mnemonic").charAt(0));
        ac = this.cancelButton.getAccessibleContext();
        ac.setAccessibleName(ImplResourceManager.getString("CANCEL_BUTTON_access_name"));
        ac.setAccessibleDescription(ImplResourceManager.getString("CANCEL_BUTTON_access_desc"));
    }

    protected void updateFontAndColor() {
        this.tabPane.setFont(ResourceManager.menuFont);
        this.tabPane.setForeground(ResourceManager.menuColor);
        this.approveButton.setFont(ResourceManager.menuFont);
        this.approveButton.setForeground(ResourceManager.menuColor);
        this.cancelButton.setFont(ResourceManager.menuFont);
        this.cancelButton.setForeground(ResourceManager.menuColor);
    }

    protected void setSelectedTab(int selectedTab) {
        if (selectedTab == 0) {
            this.chooser.setToolBoxURL(this.localTB);
        } else {
            this.chooser.setToolBoxURL(this.serverTB);
        }
        this.approveButton.setEnabled(this.chooser.getToolBoxURL() != null);
        this.setHelpHTML(selectedTab);
    }

    protected void setHelpHTML(int selectedTab) {
        if (this.chooser == null) {
            return;
        }
        if (selectedTab == 0) {
            this.chooser.setHelpHTML(this.serverUI.getHelpHTML());
        } else if (selectedTab == 1) {
            this.chooser.setHelpHTML(this.localUI.getHelpHTML());
        }
    }

    public void refreshDisplay() {
        this.localUI.refreshDisplay();
        this.serverUI.refreshDisplay();
        this.tabPane.setSelectedIndex(0);
        this.setHelpHTML(0);
        this.updateFontAndColor();
    }

    public void setApproveButtonText(String text) {
    }

    public void setOptionPane(VOptionPane optionPane) {
    }

    class MaskedToolBoxChooser
    implements ToolBoxChooser {
        MaskedToolBoxChooser() {
        }

        public void showBusyState(boolean onOff) {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                ComboToolBoxChooserUI.this.chooser.showBusyState(onOff);
            }
        }

        public void setProperties(VConsoleProperties properties) {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                ComboToolBoxChooserUI.this.chooser.setProperties(properties);
            }
        }

        public VConsoleProperties getProperties() {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                return ComboToolBoxChooserUI.this.chooser.getProperties();
            }
            return null;
        }

        public void refreshDisplay() {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                ComboToolBoxChooserUI.this.chooser.refreshDisplay();
            }
        }

        public int showOpenDialog(Component parent) {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                return ComboToolBoxChooserUI.this.chooser.showOpenDialog(parent);
            }
            return -1;
        }

        public int showSaveDialog(Component parent) {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                return ComboToolBoxChooserUI.this.chooser.showSaveDialog(parent);
            }
            return -1;
        }

        public void setDialogType(int type) {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                ComboToolBoxChooserUI.this.chooser.setDialogType(type);
            }
        }

        public int getDialogType() {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                return ComboToolBoxChooserUI.this.chooser.getDialogType();
            }
            return -1;
        }

        public URL getToolBoxURL() {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                return ComboToolBoxChooserUI.this.chooser.getToolBoxURL();
            }
            return null;
        }

        public void setToolBoxURL(URL toolBoxURL) {
            if (ComboToolBoxChooserUI.this.chooser != null && ComboToolBoxChooserUI.this.tabPane != null) {
                int selTab = ComboToolBoxChooserUI.this.tabPane.getSelectedIndex();
                if (selTab == 0) {
                    ComboToolBoxChooserUI.this.localTB = toolBoxURL;
                } else {
                    ComboToolBoxChooserUI.this.serverTB = toolBoxURL;
                }
                if (toolBoxURL == null) {
                    ComboToolBoxChooserUI.this.approveButton.setEnabled(false);
                } else {
                    ComboToolBoxChooserUI.this.approveButton.setEnabled(true);
                }
                ComboToolBoxChooserUI.this.chooser.setToolBoxURL(toolBoxURL);
            }
        }

        public void overrideUI(ComponentUI newUI) {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                ComboToolBoxChooserUI.this.chooser.overrideUI(newUI);
            }
        }

        public void setUIReference(ToolBoxChooserUI uiReference) {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                ComboToolBoxChooserUI.this.chooser.setUIReference(uiReference);
            }
        }

        public void approveSelection() {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                ComboToolBoxChooserUI.this.chooser.approveSelection();
            }
        }

        public void cancelSelection() {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                ComboToolBoxChooserUI.this.chooser.cancelSelection();
            }
        }

        public void setHelpHTML(String help) {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                ComboToolBoxChooserUI.this.chooser.setHelpHTML(help);
            }
        }

        public void setTitle(String title) {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                ComboToolBoxChooserUI.this.chooser.setTitle(title);
            }
        }

        public JComponent getButtonPane() {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                return ComboToolBoxChooserUI.this.chooser.getButtonPane();
            }
            return null;
        }

        public JComponent getContentPane() {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                return ComboToolBoxChooserUI.this.chooser.getContentPane();
            }
            return null;
        }

        public void toggleContentTitle(boolean onOff) {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                ComboToolBoxChooserUI.this.chooser.toggleContentTitle(onOff);
            }
        }
    }
}

