/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.editor.lf.toolboxurlwizard;

import com.sun.management.viper.console.gui.wizard.VWizardCard;
import com.sun.management.viper.resources.ContextHelpLoader;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.console.ManagerUtility;
import com.sun.management.viperimpl.console.config.ConfigManagement;
import com.sun.management.viperimpl.console.config.VConfigurationInfo;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ToolBoxURLSelection
extends VWizardCard
implements Runnable {
    private JLabel l1 = null;
    private JLabel l2 = null;
    private JLabel l3 = null;
    private JLabel l4 = null;
    private JLabel url_label = null;
    private JTextField urlField = null;
    private JList l5 = null;
    private JScrollPane l6 = null;
    private JTextArea l7 = null;
    private JScrollPane l8 = null;
    private String host = null;
    private String fullHostString = null;
    private Thread serverQueryThread = null;
    private Thread myWatchDog = null;
    protected static int netTimeOut = 20000;
    protected ErrMsgPanel hostNotFound = this.createHostNotFound();
    protected ErrMsgPanel serverDown = this.createServerDown();
    protected ErrMsgPanel hostUnreachable = this.createHostUnreachable();
    protected transient String selectionHelp = ContextHelpLoader.getContextHelp((String)this.selectionHelp, null);

    protected ErrMsgPanel createHostNotFound() {
        return new ErrMsgPanel(0);
    }

    protected ErrMsgPanel createServerDown() {
        return new ErrMsgPanel(1);
    }

    protected ErrMsgPanel createHostUnreachable() {
        return new ErrMsgPanel(2);
    }

    protected void seedRemoteTBlist(String host) {
        try {
            if (host == null) {
                return;
            }
            this.urlField.setText("");
            this.l7.setText("");
            this.l5.setModel(new DefaultListModel());
            this.l6.setViewportView(this.l5);
            this.validate();
            this.repaint();
            int index1 = host.indexOf("//");
            this.host = index1 > 0 ? host.substring(index1 + 2) : host;
            this.fullHostString = host;
            this.serverQueryThread = new Thread(this);
            this.serverQueryThread.start();
            this.myWatchDog = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.currentThread();
                        Thread.sleep(netTimeOut);
                        if (!ToolBoxURLSelection.this.serverQueryThread.isAlive()) {
                            return;
                        }
                        ToolBoxURLSelection.this.serverQueryThread.interrupt();
                        ToolBoxURLSelection.this.l5.setModel(new DefaultListModel());
                        ToolBoxURLSelection.this.urlField.setText("");
                        ToolBoxURLSelection.this.l7.setText("");
                    }
                    catch (Throwable t) {
                        Debug.trace((String)"TB Chooser", (int)Debug.WARNING, (String)"Watchdog interrupt", (Throwable)t);
                    }
                }
            });
            this.myWatchDog.start();
        }
        catch (Throwable t) {
            Debug.trace((String)"TB Chooser", (int)Debug.WARNING, (String)"Unexpected error", (Throwable)t);
        }
    }

    public void run() {
        block12: {
            try {
                Thread.currentThread();
                Thread.sleep(1500L);
                int port = ManagerUtility.parsePortFromString(this.host);
                if (port < 0) {
                    port = 898;
                }
                this.host = ManagerUtility.parseHostFromString(this.host);
                InetAddress ipAddr = InetAddress.getByName(this.host);
                Locale loc = ResourceManager.currentLocale;
                if (loc == null) {
                    loc = Locale.getDefault();
                }
                URL u = new URL("http://" + this.host + ":" + port + "/toolboxes/");
                URLConnection uc = u.openConnection();
                uc.setRequestProperty("Locale", loc.toString());
                ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(uc.getInputStream()));
                Object o = ois.readObject();
                VConfigurationInfo[] infoList = (VConfigurationInfo[])o;
                for (int i = 0; i < infoList.length; ++i) {
                    infoList[i].setURL(ToolBoxURLSelection.cleanURL(infoList[i].getURL()));
                }
                this.l6.setViewportView(this.l5);
                this.l5.setModel(new TBListModel(infoList));
                this.l7.setEnabled(true);
                if (infoList != null && infoList.length > 0) {
                    String oldToolBox = (String)this.getProperty("OLDTOOLBOXURLTOOLBOX");
                    for (int x = 0; x < infoList.length; ++x) {
                        String tmp1 = infoList[x].getURL().toString();
                        if (!tmp1.equals(oldToolBox)) continue;
                        this.l5.setSelectedIndex(x);
                        this.urlField.setText(ConfigManagement.aliasifyURL(infoList[x].getURL()).toString());
                        this.l7.setText(infoList[x].getDescription());
                        this.validate();
                        this.repaint();
                        break block12;
                    }
                    break block12;
                }
                this.urlField.setText("");
                this.l7.setText("");
            }
            catch (UnknownHostException uhe) {
                Debug.trace((String)"TB Chooser", (int)Debug.WARNING, (String)"Unknown Host", (Throwable)uhe);
                this.l5.setModel(new DefaultListModel());
                this.urlField.setText("");
                this.l7.setText("");
                this.l7.setEnabled(false);
                this.l6.setViewportView(this.hostNotFound);
            }
            catch (IOException ioe) {
                Debug.trace((String)"TB Chooser", (int)Debug.WARNING, (String)"Server Not Running", (Throwable)ioe);
                this.l5.setModel(new DefaultListModel());
                this.urlField.setText("");
                this.l7.setText("");
                this.l7.setEnabled(false);
                this.l6.setViewportView(this.serverDown);
            }
            catch (Throwable t) {
                Debug.trace((String)"TB Chooser", (int)Debug.WARNING, (String)"Query interrupt", (Throwable)t);
                this.l5.setModel(new DefaultListModel());
                this.urlField.setText("");
                this.l7.setText("");
                this.l7.setEnabled(false);
                this.l6.setViewportView(this.hostUnreachable);
            }
        }
        try {
            if (this.myWatchDog != null && this.myWatchDog.isAlive()) {
                this.myWatchDog.interrupt();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.validate();
        this.repaint();
    }

    protected static URL cleanURL(URL u) {
        try {
            String tbU = u.toString();
            int i = tbU.indexOf("//");
            int j = tbU.indexOf(":", i + 2);
            if (j == -1) {
                j = tbU.indexOf("/", i + 2);
            }
            String ip = tbU.substring(i + 2, j);
            ip = InetAddress.getByName(ip).getHostName();
            String tbLocation = tbU.substring(0, i + 2) + ip;
            tbLocation = tbLocation + tbU.substring(j, tbU.length());
            return new URL(tbLocation);
        }
        catch (Throwable throwable) {
            return u;
        }
    }

    public void init() {
        this.l1 = new JLabel("Step 3 - " + ImplResourceManager.getString("toolboxurl_lbl4"));
        this.l2 = new JLabel(ImplResourceManager.getString("toolboxurl_lbl5"));
        this.l3 = new JLabel(ImplResourceManager.getString("Toolboxes:"));
        this.l3.setDisplayedMnemonic(ImplResourceManager.getString("Toolboxes:_mnemonic").charAt(0));
        this.l4 = new JLabel(ImplResourceManager.getString("Description:"));
        this.l4.setDisplayedMnemonic(ImplResourceManager.getString("Description:_mnemonic").charAt(0));
        this.url_label = new JLabel(ImplResourceManager.getString("URL:"));
        this.url_label.setDisplayedMnemonic(ImplResourceManager.getString("URL:_mnemonic").charAt(0));
        this.setLayout(new BorderLayout());
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 1));
        p1.add(Box.createVerticalStrut(4));
        JPanel p2 = new JPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }
        };
        p2.setLayout(new FlowLayout(0));
        p2.add(this.l1);
        p1.add(p2);
        p1.add(Box.createVerticalStrut(5));
        JPanel p3 = new JPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }
        };
        p3.setLayout(new FlowLayout(0));
        p3.add(this.l2);
        p1.add(p3);
        p1.add(Box.createVerticalStrut(5));
        JPanel p4 = new JPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }
        };
        p4.setLayout(new FlowLayout(0));
        p4.add(this.l3);
        p1.add(p4);
        this.l5 = new JList();
        this.l5.setCellRenderer(new TBRenderer());
        this.l5.setSelectionMode(0);
        this.l5.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ToolBoxURLSelection.this.handleTBListSelection();
            }
        });
        this.l3.setLabelFor(this.l5);
        this.l5.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                try {
                    int index = ToolBoxURLSelection.this.l5.locationToIndex(e.getPoint());
                    Object o = ToolBoxURLSelection.this.l5.getModel().getElementAt(index);
                    VConfigurationInfo info = (VConfigurationInfo)o;
                    ToolBoxURLSelection.this.urlField.setText(ConfigManagement.aliasifyURL(info.getURL()).toString());
                    ToolBoxURLSelection.this.l7.setText(info.getDescription());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ToolBoxURLSelection.this.updateStatus();
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        this.l6 = new JScrollPane(this.l5, 22, 30);
        p1.add(this.l6);
        p1.add(Box.createVerticalStrut(5));
        JPanel p12 = new JPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }
        };
        p12.setLayout(new FlowLayout(0));
        p12.add(this.url_label);
        p1.add(p12);
        this.urlField = new JTextField(50);
        this.url_label.setLabelFor(this.urlField);
        this.urlField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ToolBoxURLSelection.this.updateStatus();
            }
        });
        JPanel p13 = new JPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }
        };
        p13.setLayout(new FlowLayout(0));
        p13.add(this.urlField);
        p1.add(p13);
        p1.add(Box.createVerticalStrut(5));
        JPanel p5 = new JPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }
        };
        p5.setLayout(new FlowLayout(0));
        p5.add(this.l4);
        p1.add(p5);
        this.l7 = new JTextArea(){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 80);
            }
        };
        this.l7.setLineWrap(true);
        this.l7.setWrapStyleWord(true);
        this.l7.setEditable(false);
        this.l8 = new JScrollPane(this.l7);
        this.l4.setLabelFor(this.l7);
        p1.add(this.l8);
        p1.add(Box.createVerticalGlue());
        this.add(p1, "Center");
        this.setHelpHTML(this.selectionHelp);
    }

    public void start() {
        super.start();
        this.setProperty("vwp.canmovebackward", "vwp.true");
        String getURLName = (String)this.getProperty("TOOLBOXURLTOOLBOX");
        if (getURLName == null || getURLName.trim().length() <= 0) {
            this.seedRemoteTBlist((String)this.getProperty("TOOLBOXURLSERVER"));
        }
        this.updateStatus();
    }

    public boolean stop(boolean movingForward) {
        if (!movingForward) {
            return true;
        }
        this.getManager().setPrevious("toolboxurl-namedescription", "toolboxurl-selection");
        if (movingForward) {
            String s = this.urlField.getText();
            if (s != null && s.trim().length() > 0) {
                this.setProperty("TOOLBOXURLTOOLBOX", s.trim());
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), ImplResourceManager.getString("invalidtoolurl"), ImplResourceManager.getString("invalidtoolurltitle"), 0);
                return false;
            }
        }
        return true;
    }

    public void reset() {
    }

    public boolean isSubStep() {
        return false;
    }

    protected void updateStatus() {
        if (this.urlField.getText() != null && this.urlField.getText().trim().length() > 0) {
            this.setProperty("vwp.canmoveforward", "vwp.true");
        } else {
            this.setProperty("vwp.canmoveforward", "vwp.false");
        }
    }

    protected void handleTBListSelection() {
        try {
            if (this.l5.isSelectionEmpty()) {
                return;
            }
            VConfigurationInfo info = (VConfigurationInfo)this.l5.getSelectedValue();
            this.urlField.setText(ConfigManagement.aliasifyURL(info.getURL()).toString());
            this.l7.setText(info.getDescription());
            this.updateStatus();
        }
        catch (Throwable e) {
            this.urlField.setText("");
            this.l5.setModel(new DefaultListModel());
            this.l7.setText("");
            this.updateStatus();
        }
    }

    protected class TBRenderer
    extends DefaultListCellRenderer {
        protected TBRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            VConfigurationInfo cInfo = (VConfigurationInfo)value;
            this.setText(cInfo.getName());
            this.setIcon(new ImageIcon(cInfo.getSmallIcon()));
            return this;
        }
    }

    protected class TBListModel
    implements ListModel {
        protected VConfigurationInfo[] infoList = null;

        public TBListModel(VConfigurationInfo[] infoList) {
            this.infoList = infoList;
        }

        public void addListDataListener(ListDataListener l) {
        }

        public Object getElementAt(int index) {
            return this.infoList[index];
        }

        public int getSize() {
            return this.infoList.length;
        }

        public void removeListDataListener(ListDataListener l) {
        }
    }

    class ErrMsgPanel
    extends JPanel {
        protected JLabel title = null;
        protected JTextArea desc = null;
        protected ImageIcon errIcon = null;
        protected int type = 0;

        public ErrMsgPanel(int type) {
            if (type < 0 || type > 2) {
                type = 0;
            }
            this.type = type;
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel iconPanel = new JPanel();
            iconPanel.setBorder(new EmptyBorder(0, 0, 0, 5));
            iconPanel.setLayout(new BoxLayout(iconPanel, 1));
            if (this.errIcon == null) {
                this.errIcon = ConsoleUtility.loadImageIcon((String)"images/Event_Err16.gif", this.getClass());
            }
            iconPanel.add(new JLabel(this.errIcon));
            iconPanel.add(Box.createVerticalGlue());
            this.add((Component)iconPanel, "West");
            JPanel msgPanel = new JPanel(new BorderLayout());
            this.title = new JLabel();
            msgPanel.add((Component)this.title, "North");
            this.desc = new JTextArea();
            msgPanel.add((Component)this.desc, "Center");
            this.desc.setEditable(false);
            this.desc.setOpaque(false);
            this.desc.setLineWrap(true);
            this.desc.setWrapStyleWord(true);
            this.add((Component)msgPanel, "Center");
            this.installStrings();
        }

        protected void installStrings() {
            if (this.type == 0) {
                this.title.setText(ImplResourceManager.getString("Host Not Found"));
                this.desc.setText(ImplResourceManager.getString("NoServerFound"));
            } else if (this.type == 1) {
                this.title.setText(ImplResourceManager.getString("Server Not Running"));
                this.desc.setText(ImplResourceManager.getString("NoServerOnHost"));
            } else if (this.type == 2) {
                this.title.setText(ImplResourceManager.getString("Connection Timeout"));
                this.desc.setText(ImplResourceManager.getString("ConnectionTimeout"));
            }
        }
    }
}

