/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.editor;

import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VDialog;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.console.ManagerUtility;
import com.sun.management.viperimpl.console.config.ConfigManagement;
import com.sun.management.viperimpl.console.config.FolderNode;
import com.sun.management.viperimpl.console.config.ToolBoxNode;
import com.sun.management.viperimpl.console.config.ToolBoxURLNode;
import com.sun.management.viperimpl.console.config.ToolNode;
import com.sun.management.viperimpl.console.config.VBaseConfiguration;
import com.sun.management.viperimpl.console.config.VBaseNode;
import com.sun.management.viperimpl.console.config.VConfigurationInfo;
import com.sun.management.viperimpl.console.config.VConfigurationNode;
import com.sun.management.viperimpl.console.editor.lf.NodeInfoPane;
import com.sun.management.viperimpl.console.editor.lf.folderwizard.FolderWizard;
import com.sun.management.viperimpl.console.editor.lf.legacywizard.LegacyWizard;
import com.sun.management.viperimpl.console.editor.lf.toolboxurlwizard.ToolBoxURLWizard;
import com.sun.management.viperimpl.console.editor.lf.toolboxwizard.ToolBoxWizard;
import com.sun.management.viperimpl.console.editor.lf.toolwizard.ToolWizard;
import com.sun.management.viperimpl.console.gui.GUIConsoleManager;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Node;

public class EditorConsoleManager
extends GUIConsoleManager {
    protected NodeInfoPane nodeInfoPane = new NodeInfoPane();
    protected ImageIcon smallToolbox = null;
    protected ImageIcon largeToolbox = null;
    protected ImageIcon smallToolboxLink = null;
    protected ImageIcon largeToolboxLink = null;
    protected ImageIcon smallTool = null;
    protected ImageIcon largeTool = null;
    protected ImageIcon smallFolder = null;
    protected ImageIcon largeFolder = null;
    protected VScopeNode selNode = null;
    protected FolderWizard folderWizard = null;
    protected LegacyWizard legacyWizard = null;
    protected ToolBoxURLWizard toolBoxURLWizard = null;
    protected ToolWizard toolWizard = null;
    protected ToolBoxWizard toolBoxWizard = null;
    public static final String legacyToolName = "LegacyAppTool.client.LaunchLegacyAppTool";
    public static final int LARGE_ICON_SIZE = 32;
    public static final int SMALL_ICON_SIZE = 16;

    public EditorConsoleManager() {
        try {
            this.smallToolbox = ConsoleUtility.loadImageIcon((String)"lf/images/toolbox16.gif", this.getClass());
            this.largeToolbox = ConsoleUtility.loadImageIcon((String)"lf/images/toolbox32.gif", this.getClass());
            this.smallToolboxLink = ConsoleUtility.loadImageIcon((String)"lf/images/toolboxlink16.gif", this.getClass());
            this.largeToolboxLink = ConsoleUtility.loadImageIcon((String)"lf/images/toolboxlink32.gif", this.getClass());
            this.smallTool = ConsoleUtility.loadImageIcon((String)"lf/images/tool16.gif", this.getClass());
            this.largeTool = ConsoleUtility.loadImageIcon((String)"lf/images/tool32.gif", this.getClass());
            this.smallFolder = ConsoleUtility.loadImageIcon((String)"lf/images/folder16.gif", this.getClass());
            this.largeFolder = ConsoleUtility.loadImageIcon((String)"lf/images/folder32.gif", this.getClass());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void consoleAction(VConsoleEvent vce) {
        block66: {
            super.consoleAction(vce);
            if (vce == null) {
                return;
            }
            String eventID = vce.getID();
            try {
                if (eventID.equals("editor.moveup") && this.selNode != null) {
                    VScopeNode parent = (VScopeNode)this.selNode.getParent();
                    if (parent == null) {
                        return;
                    }
                    int childCount = parent.getChildCount();
                    int childIndex = parent.getIndex((TreeNode)this.selNode);
                    if (childIndex == 0) {
                        return;
                    }
                    parent.remove((MutableTreeNode)this.selNode);
                    parent.insert((MutableTreeNode)this.selNode, childIndex - 1);
                    VBaseNode p = (VBaseNode)parent.getPayload();
                    VBaseNode c = (VBaseNode)this.selNode.getPayload();
                    childCount = p.getChildCount();
                    childIndex = p.getIndex(c);
                    if (childIndex != 0) {
                        p.remove(c);
                        p.insert(c, childIndex - 1);
                    }
                    this.updateScope(parent, this.selNode);
                    this.toolBoxHasChanged();
                    break block66;
                }
                if (eventID.equals("editor.movedown") && this.selNode != null) {
                    VScopeNode parent = (VScopeNode)this.selNode.getParent();
                    if (parent == null) {
                        return;
                    }
                    int childCount = parent.getChildCount();
                    int childIndex = parent.getIndex((TreeNode)this.selNode);
                    if (childIndex > childCount - 1) {
                        return;
                    }
                    parent.remove((MutableTreeNode)this.selNode);
                    parent.insert((MutableTreeNode)this.selNode, childIndex + 1);
                    VBaseNode p = (VBaseNode)parent.getPayload();
                    VBaseNode c = (VBaseNode)this.selNode.getPayload();
                    childCount = p.getChildCount();
                    childIndex = p.getIndex(c);
                    if (childIndex < childCount - 2) {
                        p.remove(c);
                        p.insert(c, childIndex + 1);
                    } else if (childIndex == childCount - 2) {
                        p.remove(c);
                        p.appendChild((Node)((Object)c));
                    }
                    this.updateScope(parent, this.selNode);
                    this.toolBoxHasChanged();
                    break block66;
                }
                if (eventID.equals("vconsole.delete") && this.selNode != null) {
                    int askUser;
                    VScopeNode parent = (VScopeNode)this.selNode.getParent();
                    if (parent == null) {
                        return;
                    }
                    int childIndex = parent.getIndex((TreeNode)this.selNode) - 1;
                    if (this.selNode.getChildCount() > 0 && (askUser = JOptionPane.showConfirmDialog(this.parentComp, "Remove this object and all its contents?")) != 0) {
                        return;
                    }
                    parent.remove((MutableTreeNode)this.selNode);
                    VBaseNode p = (VBaseNode)parent.getPayload();
                    VBaseNode c = (VBaseNode)this.selNode.getPayload();
                    p.remove(c);
                    if (childIndex >= 0) {
                        VScopeNode newSel = (VScopeNode)parent.getChildAt(childIndex);
                        this.updateScope(parent, newSel);
                    } else {
                        this.updateScope(parent, null);
                    }
                    this.toolBoxHasChanged();
                    break block66;
                }
                if (eventID.equals("editor.newtoolbox")) {
                    VBaseConfiguration tempConfig = VBaseConfiguration.createConfiguration();
                    this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatestatus", (Object)(ImplResourceManager.getString("launching_lbl") + " " + ImplResourceManager.getString("toolboxwizard"))));
                    Frame f1 = new Frame();
                    this.toolBoxWizard = new ToolBoxWizard(ImplResourceManager.getString("toolboxwizard"), f1, true, null);
                    this.toolBoxWizard.init();
                    VDialog d = new VDialog(f1, ImplResourceManager.getString("toolboxwizard"), true);
                    this.toolBoxWizard.setContainer((Component)d);
                    d.pack();
                    d.setLocationRelativeTo(null);
                    this.toolBoxWizard.start();
                    d.show();
                    ToolBoxNode node = this.toolBoxWizard.createToolBoxNode(tempConfig);
                    if (node != null) {
                        this.destroy();
                        node.setAttribute("Version", "0.0");
                        this.currentConfig = tempConfig;
                        this.currentConfig.appendChild((Node)((Object)node));
                        VScopeNode newRootNode = this.createScopeNodeFromConfigNode(node);
                        VConsoleEvent vce2 = new VConsoleEvent((Object)this, "vconsole.openconsole", (Object)newRootNode);
                        this.notifyListeners(vce2);
                        this.configHasChanged = true;
                    }
                    break block66;
                }
                if (eventID.equals("editor.addlegacyapp") && this.selNode != null) {
                    if (this.currentConfig == null) {
                        this.currentConfig = VBaseConfiguration.createConfiguration();
                    }
                    this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatestatus", (Object)(ImplResourceManager.getString("launching_lbl") + " " + ImplResourceManager.getString("legacywizard"))));
                    Frame f1 = new Frame();
                    this.legacyWizard = new LegacyWizard(ImplResourceManager.getString("legacywizard"), f1, true, null);
                    this.legacyWizard.init();
                    VDialog d = new VDialog(f1, ImplResourceManager.getString("legacywizard"), true);
                    this.legacyWizard.setContainer((Component)d);
                    d.pack();
                    d.setLocationRelativeTo(null);
                    this.legacyWizard.start();
                    d.show();
                    ToolNode node = this.legacyWizard.createToolNode(this.currentConfig);
                    if (node == null) break block66;
                    node.setTreeDisplay(false);
                    this.processChildNode(this.selNode, node);
                    VBaseNode p = (VBaseNode)this.selNode.getPayload();
                    try {
                        p.appendChild((Node)((Object)node));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.updateScope(this.selNode, this.selNode);
                    this.toolBoxHasChanged();
                    break block66;
                }
                if (eventID.equals("editor.addfolder") && this.selNode != null) {
                    if (this.currentConfig == null) {
                        this.currentConfig = VBaseConfiguration.createConfiguration();
                    }
                    this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatestatus", (Object)(ImplResourceManager.getString("launching_lbl") + " " + ImplResourceManager.getString("folderwizard"))));
                    Frame f1 = new Frame();
                    this.folderWizard = new FolderWizard(ImplResourceManager.getString("folderwizard"), f1, true, null);
                    this.folderWizard.init();
                    VDialog d = new VDialog(f1, ImplResourceManager.getString("folderwizard"), true);
                    this.folderWizard.setContainer((Component)d);
                    d.pack();
                    d.setLocationRelativeTo(null);
                    this.folderWizard.start();
                    d.show();
                    FolderNode node = this.folderWizard.createFolderNode(this.currentConfig);
                    if (node == null) break block66;
                    this.processChildNode(this.selNode, node);
                    VBaseNode p = (VBaseNode)this.selNode.getPayload();
                    try {
                        p.appendChild((Node)((Object)node));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.updateScope(this.selNode, this.selNode);
                    this.toolBoxHasChanged();
                    break block66;
                }
                if (eventID.equals("editor.addtool") && this.selNode != null) {
                    if (this.currentConfig == null) {
                        this.currentConfig = VBaseConfiguration.createConfiguration();
                    }
                    this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatestatus", (Object)(ImplResourceManager.getString("launching_lbl") + " " + ImplResourceManager.getString("toolwizard"))));
                    Frame f1 = new Frame();
                    this.toolWizard = new ToolWizard(ImplResourceManager.getString("toolwizard"), f1, true, null);
                    this.toolWizard.init();
                    VDialog d = new VDialog(f1, ImplResourceManager.getString("toolwizard"), true);
                    this.toolWizard.setContainer((Component)d);
                    d.pack();
                    d.setLocationRelativeTo(null);
                    this.toolWizard.start();
                    d.show();
                    ToolNode node = this.toolWizard.createToolNode(this.currentConfig);
                    if (node == null) break block66;
                    this.processChildNode(this.selNode, node);
                    VBaseNode p = (VBaseNode)this.selNode.getPayload();
                    try {
                        p.appendChild((Node)((Object)node));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.updateScope(this.selNode, this.selNode);
                    this.toolBoxHasChanged();
                    break block66;
                }
                if (eventID.equals("editor.addtoolbox") && this.selNode != null) {
                    if (this.currentConfig == null) {
                        this.currentConfig = VBaseConfiguration.createConfiguration();
                    }
                    this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatestatus", (Object)(ImplResourceManager.getString("launching_lbl") + " " + ImplResourceManager.getString("toolboxurlwizard"))));
                    Frame f1 = new Frame();
                    this.toolBoxURLWizard = new ToolBoxURLWizard(ImplResourceManager.getString("toolboxurlwizard"), f1, true, null);
                    this.toolBoxURLWizard.init();
                    VDialog d = new VDialog(f1, ImplResourceManager.getString("toolboxurlwizard"), true);
                    this.toolBoxURLWizard.setContainer((Component)d);
                    d.pack();
                    d.setLocationRelativeTo(null);
                    this.toolBoxURLWizard.start();
                    d.show();
                    ToolBoxURLNode node = this.toolBoxURLWizard.createToolBoxURLNode(this.currentConfig);
                    if (node == null) break block66;
                    this.toolBoxURLWizard.setMiscToolBoxURLProperties(node);
                    this.processChildNode(this.selNode, node);
                    VBaseNode p = (VBaseNode)this.selNode.getPayload();
                    try {
                        p.appendChild((Node)((Object)node));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.updateScope(this.selNode, this.selNode);
                    this.toolBoxHasChanged();
                    break block66;
                }
                if (eventID.equals("vconsole.scopeselected") || eventID.equals("vconsole.updatescope")) {
                    this.selNode = (VScopeNode)vce.getPayload();
                    String onValue = "true";
                    if (this.selNode == null) {
                        onValue = "false";
                    }
                    this.properties.setProperty("vconsole.propertiesenabled", onValue);
                    if (this.selNode != null && this.selNode.getParent() == null) {
                        onValue = "false";
                    }
                    this.properties.setProperty("vconsole.deleteenabled", onValue);
                    VConfigurationNode node = null;
                    if (this.selNode != null) {
                        node = (VConfigurationNode)this.selNode.getPayload();
                    }
                    this.nodeInfoPane.setSelectedNode(node);
                    try {
                        int level;
                        VScopeNode parentNode = (VScopeNode)this.selNode.getParent();
                        if (parentNode == null) {
                            this.properties.setProperty("editor.moveup", "false");
                            this.properties.setProperty("editor.movedown", "false");
                        }
                        if ((level = parentNode.getIndex((TreeNode)this.selNode)) > 0) {
                            this.properties.setProperty("editor.moveup", "true");
                        } else {
                            this.properties.setProperty("editor.moveup", "false");
                        }
                        int cc = parentNode.getChildCount();
                        if (level < cc - 1) {
                            this.properties.setProperty("editor.movedown", "true");
                        } else {
                            this.properties.setProperty("editor.movedown", "false");
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    try {
                        Object o = null;
                        if (this.selNode != null) {
                            o = this.selNode.getPayload();
                        }
                        if (o instanceof FolderNode || o instanceof ToolBoxNode) {
                            this.properties.setProperty("editor.addlegacyapp", "true");
                            this.properties.setProperty("editor.addtool", "true");
                            this.properties.setProperty("editor.addtoolbox", "true");
                            this.properties.setProperty("editor.addfolder", "true");
                            break block66;
                        }
                        this.properties.setProperty("editor.addlegacyapp", "false");
                        this.properties.setProperty("editor.addtool", "false");
                        this.properties.setProperty("editor.addtoolbox", "false");
                        this.properties.setProperty("editor.addfolder", "false");
                    }
                    catch (Throwable t) {}
                    break block66;
                }
                if (eventID.equals("vconsole.displayproperties") && this.selNode != null && this.selNode.getPayload() != null) {
                    Object o = this.selNode.getPayload();
                    if (o instanceof ToolBoxNode) {
                        Frame f1 = new Frame();
                        VDialog d = new VDialog(f1, ImplResourceManager.getString("toolboxwizard"), true);
                        this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatestatus", (Object)(ImplResourceManager.getString("launching_lbl") + " " + ImplResourceManager.getString("toolboxwizard"))));
                        this.toolBoxWizard = new ToolBoxWizard(ImplResourceManager.getString("toolboxwizard"), f1, false, (ToolBoxNode)o);
                        this.toolBoxWizard.init();
                        this.toolBoxWizard.setContainer((Component)d);
                        d.pack();
                        d.setLocationRelativeTo(null);
                        this.toolBoxWizard.start();
                        d.show();
                        if (this.toolBoxWizard.setToolBoxProperties(this.selNode)) {
                            this.updateScope(this.selNode, this.selNode);
                            this.toolBoxHasChanged();
                        }
                    } else if (o instanceof ToolNode) {
                        ToolNode t = (ToolNode)o;
                        String toolClassName = t.getClassName();
                        Frame f1 = new Frame();
                        VDialog d = new VDialog(f1, ImplResourceManager.getString("legacywizard"), true);
                        if (toolClassName.equals(legacyToolName)) {
                            this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatestatus", (Object)(ImplResourceManager.getString("launching_lbl") + " " + ImplResourceManager.getString("legacywizard"))));
                            this.legacyWizard = new LegacyWizard(ImplResourceManager.getString("legacywizard"), f1, false, (ToolNode)o);
                            this.legacyWizard.init();
                            this.legacyWizard.setContainer((Component)d);
                            d.pack();
                            d.setLocationRelativeTo(null);
                            this.legacyWizard.start();
                            d.show();
                            if (this.legacyWizard.setLegacyProperties(this.selNode)) {
                                this.updateScope(this.selNode, this.selNode);
                                this.toolBoxHasChanged();
                            }
                        } else {
                            this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatestatus", (Object)(ImplResourceManager.getString("launching_lbl") + " " + ImplResourceManager.getString("toolwizard"))));
                            this.toolWizard = new ToolWizard(ImplResourceManager.getString("toolwizard"), f1, false, (ToolNode)o);
                            this.toolWizard.init();
                            this.toolWizard.setContainer((Component)d);
                            d.pack();
                            d.setLocationRelativeTo(null);
                            this.toolWizard.start();
                            d.show();
                            if (this.toolWizard.setNonLegacyProperties(this.selNode)) {
                                this.updateScope(this.selNode, this.selNode);
                                this.toolBoxHasChanged();
                            }
                        }
                    } else if (o instanceof ToolBoxURLNode) {
                        this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatestatus", (Object)(ImplResourceManager.getString("launching_lbl") + " " + ImplResourceManager.getString("toolboxurlwizard"))));
                        Frame f1 = new Frame();
                        this.toolBoxURLWizard = new ToolBoxURLWizard(ImplResourceManager.getString("toolboxurlwizard"), f1, false, (ToolBoxURLNode)o);
                        this.toolBoxURLWizard.init();
                        VDialog d = new VDialog(f1, ImplResourceManager.getString("toolboxurlwizard"), true);
                        this.toolBoxURLWizard.setContainer((Component)d);
                        d.pack();
                        d.setLocationRelativeTo(null);
                        this.toolBoxURLWizard.start();
                        d.show();
                        if (this.toolBoxURLWizard.setToolBoxURLProperties(this.selNode)) {
                            this.updateScope(this.selNode, this.selNode);
                            this.toolBoxHasChanged();
                        }
                    } else if (o instanceof FolderNode) {
                        this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatestatus", (Object)(ImplResourceManager.getString("launching_lbl") + " " + ImplResourceManager.getString("folderwizard"))));
                        Frame f1 = new Frame();
                        VDialog d = new VDialog(f1, ImplResourceManager.getString("folderwizard"), true);
                        this.folderWizard = new FolderWizard(ImplResourceManager.getString("folderwizard"), f1, false, (FolderNode)o);
                        this.folderWizard.init();
                        this.folderWizard.setContainer((Component)d);
                        d.pack();
                        d.setLocationRelativeTo(null);
                        this.folderWizard.start();
                        d.show();
                        if (this.folderWizard.setFolderProperties(this.selNode)) {
                            this.updateScope(this.selNode, this.selNode);
                            this.toolBoxHasChanged();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void destroy() {
        int response;
        if (this.configHasChanged && (response = JOptionPane.showConfirmDialog(this.parentComp, ImplResourceManager.getString("The current toolbox has been edited, do you wish to save it?"), ImplResourceManager.getString("Save Current Toolbox?"), 0)) == 0) {
            this.saveConsole();
        }
        super.destroy();
    }

    protected void establishConsoleModel() {
        super.establishConsoleModel();
        this.properties.setProperty("vconsole.saveconsoleasenabled", "true");
    }

    protected void updateScope(VScopeNode node, VScopeNode sel) {
        if (node == null) {
            return;
        }
        VConsoleEvent vce = new VConsoleEvent((Object)this, "vconsole.updatescope", (Object)node);
        this.notifyListeners(vce);
        if (sel != null) {
            VConsoleEvent vce2 = new VConsoleEvent((Object)this, "vconsole.scopeselected", (Object)sel);
            this.notifyListeners(vce2);
        }
    }

    protected void processChildNode(VScopeNode parent, VConfigurationNode child) {
        if (parent == null || child == null) {
            return;
        }
        try {
            VScopeNode childNode = this.createScopeNodeFromConfigNode(child);
            if (childNode == null) {
                return;
            }
            parent.add((MutableTreeNode)childNode);
            Enumeration e = child.children();
            while (e.hasMoreElements()) {
                VConfigurationNode cNode = (VConfigurationNode)e.nextElement();
                this.processChildNode(childNode, cNode);
            }
        }
        catch (Throwable t) {
            Debug.trace((String)"EditorManager", (int)Debug.WARNING, (String)"Problem processing nodes", (Throwable)t);
        }
    }

    protected VScopeNode buildConfiguration(VBaseConfiguration config, String scopeOverride) {
        VScopeNode rootNode = super.buildConfiguration(config, scopeOverride);
        if (rootNode != null) {
            VScopeNode surrogate = this.createScopeNodeFromConfigNode((VConfigurationNode)rootNode.getPayload());
            rootNode.setResultPane(surrogate.getResultPane());
            rootNode.setLargeIcon(surrogate.getLargeIcon());
            rootNode.setSmallIcon(surrogate.getSmallIcon());
        }
        return rootNode;
    }

    protected VScopeNode createScopeNodeFromConfigNode(VConfigurationNode node) {
        VScopeNode sNode;
        block15: {
            sNode = ManagerUtility.createScopeNodeFor(node);
            if (sNode != null) {
                sNode.setPayload((Object)node);
                sNode.setResultPane((Component)this.nodeInfoPane);
            }
            try {
                if (node instanceof ToolNode) {
                    ToolNode n = (ToolNode)node;
                    String s2 = n.getClassName();
                    if (s2.equals(legacyToolName)) {
                        String command;
                        String legacyText = "Legacy Application";
                        Properties p = n.getParameters();
                        if (p != null && p.size() > 0 && (command = p.getProperty("Command")) != null && command.trim().length() > 0) {
                            legacyText = legacyText + " (" + command + ")";
                        }
                        sNode.setText(legacyText);
                    } else {
                        sNode.setText("Tool (" + n.getClassName() + ")");
                    }
                    sNode.setSmallIcon(this.smallTool);
                    sNode.setLargeIcon(this.largeTool);
                    break block15;
                }
                if (node instanceof FolderNode) {
                    FolderNode n = (FolderNode)node;
                    try {
                        n.setLargeIcon(n.getLargeIcon());
                        n.setSmallIcon(n.getSmallIcon());
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    sNode.setSmallIcon(this.smallFolder);
                    sNode.setLargeIcon(this.largeFolder);
                    break block15;
                }
                if (node instanceof ToolBoxURLNode) {
                    ToolBoxURLNode n = (ToolBoxURLNode)node;
                    URL u = n.getURL();
                    if (u != null) {
                        URL aU = ConfigManagement.aliasifyURL(u);
                        sNode.setText("Toolbox URL (" + aU.toString() + ")");
                        n.setURL(u.toString());
                    } else {
                        sNode.setText("Toolbox URL (empty)");
                    }
                    sNode.setSmallIcon(this.smallToolboxLink);
                    sNode.setLargeIcon(this.largeToolboxLink);
                    break block15;
                }
                if (!(node instanceof ToolBoxNode)) break block15;
                ToolBoxNode n = (ToolBoxNode)node;
                try {
                    n.setLargeIcon(n.getLargeIcon());
                    n.setSmallIcon(n.getSmallIcon());
                }
                catch (Throwable t) {
                    // empty catch block
                }
                sNode.setText("Toolbox (" + n.getName() + ")");
                sNode.setSmallIcon(this.smallToolbox);
                sNode.setLargeIcon(this.largeToolbox);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return sNode;
    }

    protected void toolBoxHasChanged() {
        if (this.configHasChanged) {
            return;
        }
        try {
            String fileName;
            File f;
            this.configHasChanged = true;
            VConfigurationInfo configInfo = this.currentConfig.getInfo();
            URL u = configInfo.getURL();
            if (u.toString().startsWith("file") && (f = new File(fileName = u.getFile())).canWrite()) {
                this.properties.setProperty("vconsole.saveconsoleenabled", "true");
            }
            this.properties.setProperty("vconsole.saveconsoleasenabled", "true");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

