/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.config;

import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.console.config.BGImageNode;
import com.sun.management.viperimpl.console.config.VBaseNode;
import com.sun.management.viperimpl.console.config.VConfigurationNode;
import com.sun.xml.tree.NodeEx;
import com.sun.xml.tree.ParseContext;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ToolBoxNode
extends VBaseNode
implements VConfigurationNode {
    protected Locale locale;
    protected Properties properties;
    protected String information;
    protected int SLOT_INFORMATION;

    public ToolBoxNode() {
        this.setTag("ToolBox");
        this.SLOT_NAME = 0;
        this.SLOT_DESCRIPTION = 1;
        this.SLOT_INFORMATION = 2;
        this.SLOT_BGIMAGE = 3;
        this.SLOT_ICON = 4;
        this.SLOT_LARGEICON = 5;
        this.SLOT_SCOPE = 6;
        this.slots = new Node[7];
    }

    public void startParse(ParseContext context) throws SAXException {
        super.startParse(context);
        NamedNodeMap nnm = this.getAttributes();
        if (nnm == null) {
            return;
        }
        for (int i = 0; i < nnm.getLength(); ++i) {
            String attrName = nnm.item(i).getNodeName();
            String attrValue = nnm.item(i).getNodeValue();
            if (!attrName.equals("Locale")) continue;
            int n = attrValue.indexOf("_");
            this.locale = new Locale(attrValue.substring(0, n), attrValue.substring(n + 1));
        }
    }

    public void doneChild(NodeEx n, ParseContext context) throws SAXException {
        super.doneChild(n, context);
        String childName = n.getNodeName();
        Node child = n.getFirstChild();
        String childValue = null;
        if (child != null) {
            childValue = child.getNodeValue();
        }
        try {
            if (childName.equals("Name")) {
                this.name = childValue;
                this.slots[this.SLOT_NAME] = n;
            } else if (childName.equals("Information")) {
                this.information = childValue;
                this.slots[this.SLOT_INFORMATION] = n;
            } else if (childName.equals("Description")) {
                this.description = childValue;
                this.slots[this.SLOT_DESCRIPTION] = n;
            } else if (childName.equals("Scope")) {
                this.scope = childValue;
                this.slots[this.SLOT_SCOPE] = n;
            } else if (childName.equals("Icon")) {
                this.smallIcon = childValue;
                this.slots[this.SLOT_ICON] = n;
            } else if (childName.equals("LargeIcon")) {
                this.largeIcon = childValue;
                this.slots[this.SLOT_LARGEICON] = n;
            } else if (childName.equals("BackgroundImage")) {
                this.bgImage = ((BGImageNode)n).getURL();
                this.bgImageLoc = ((BGImageNode)n).getLocation();
                this.slots[this.SLOT_BGIMAGE] = n;
            }
        }
        catch (Exception e) {
            Debug.trace((String)"Configuration", (int)Debug.WARNING, (String)"Configuration error", (Throwable)e);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getInformation() {
        return this.information;
    }

    public void setInformation(String information) {
        this.information = information;
        if (information != null && information.length() > 0) {
            this.setTaggedNode("Information", information, this.SLOT_INFORMATION);
        } else if (this.slots[this.SLOT_INFORMATION] != null) {
            this.removeChild(this.slots[this.SLOT_INFORMATION]);
            this.slots[this.SLOT_INFORMATION] = null;
        }
    }

    public String getType() {
        return null;
    }

    public void setType(String type) {
    }

    public Properties getProperties() {
        return null;
    }

    public void setProperties(Properties properties) {
    }

    public URL getURL() {
        return null;
    }

    public void setURL(String url) {
    }

    protected void printNode(int indent) {
        super.printNode(indent);
        String nindent = this.indent(indent + 1);
        System.out.println(nindent + "Description: " + this.description);
        System.out.println(nindent + "Small Icon: " + this.smallIcon);
        System.out.println(nindent + "Large Icon: " + this.largeIcon);
        System.out.print(nindent + "Known Scopes: ");
        Enumeration en = this.getConfiguration().enumerateScopes();
        while (en != null && en.hasMoreElements()) {
            System.out.print(en.nextElement());
            if (!en.hasMoreElements()) continue;
            System.out.print(", ");
        }
        System.out.println("");
    }
}

