/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl;

import com.sun.management.viper.ComponentInfo;
import com.sun.management.viper.ServiceInfo;
import com.sun.management.viperimpl.LibInfoImpl;
import com.sun.management.viperimpl.server.repository.VRegistry;
import java.util.Date;
import java.util.Properties;

public class ServiceInfoImpl
extends LibInfoImpl
implements ServiceInfo,
Cloneable {
    private static final long serialVersionUID = -3162847516320098460L;
    private String[] interfaces = null;
    private String classname = null;
    private int implType = 0;
    private String helpBase = null;
    private String APIversion = "0.0";
    private boolean bSingle = true;
    private String[] scopeList = null;
    private String[] parameterList = null;
    private String[] dependency = null;
    private Date editDate = null;
    private LibInfoImpl[] attachments = null;
    public static final String PROPERTY_CONFIG_TOOL = "config-tool";
    public static final String PROPERTY_IS_DAEMON = "is-daemon";

    public ServiceInfoImpl(ServiceInfo aInfo) {
        super((ComponentInfo)aInfo);
        if (aInfo != null) {
            this.interfaces = aInfo.getInterfaces();
            this.classname = aInfo.getClassName();
            this.implType = aInfo.getImplType();
            this.helpBase = aInfo.getHelpBaseName();
            this.APIversion = aInfo.getAPIVersion();
            this.parameterList = aInfo.getParameterList();
            this.scopeList = aInfo.getSupportedScopes();
            this.bSingle = aInfo.isSingleton();
            this.dependency = aInfo.getLoadDependencies();
            if (aInfo instanceof ServiceInfoImpl) {
                this.editDate = ((ServiceInfoImpl)aInfo).getEditDate();
                this.attachments = ((ServiceInfoImpl)aInfo).getAttachments();
            }
            if (this.attachments == null) {
                this.attachments = new LibInfoImpl[0];
            }
            if (this.editDate == null) {
                this.editDate = new Date();
            }
            if (this.getJarName() == null) {
                this.setJarName(VRegistry.toJarName((int)1, (String)this.classname));
            }
        }
    }

    public ServiceInfoImpl(String className, int implType, String[] interfaces, String resourceBase, String helpBase, String version, String APIversion, String[] parameterList, Properties props, boolean singleton, String[] scopeList, String[] dependency, String id) {
        super(version, resourceBase, props, id);
        this.classname = className;
        this.implType = implType;
        this.interfaces = interfaces;
        this.helpBase = helpBase;
        this.APIversion = APIversion;
        this.parameterList = parameterList;
        this.scopeList = scopeList;
        this.bSingle = singleton;
        this.dependency = dependency;
        this.setJarName(VRegistry.toJarName((int)2, (String)this.classname));
        this.setComponentType(2);
        this.attachments = new LibInfoImpl[0];
        this.editDate = new Date();
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public String getClassName() {
        return this.classname;
    }

    public int getImplType() {
        return this.implType;
    }

    public String getHelpBaseName() {
        return this.helpBase;
    }

    public String getConfigToolName() {
        return this.getProperty(PROPERTY_CONFIG_TOOL);
    }

    public String getAPIVersion() {
        return this.APIversion;
    }

    public boolean isSingleton() {
        return this.bSingle;
    }

    public boolean isDaemon() {
        String value = this.getProperty(PROPERTY_IS_DAEMON);
        return value != null && value.trim().equalsIgnoreCase("true");
    }

    public String[] getLoadDependencies() {
        return this.dependency;
    }

    public String[] getParameterList() {
        return this.parameterList;
    }

    public String[] getSupportedScopes() {
        return this.scopeList;
    }

    public Date getEditDate() {
        return this.editDate;
    }

    public LibInfoImpl[] getAttachments() {
        return this.attachments;
    }

    public void setAttachments(LibInfoImpl[] l) {
        this.attachments = l != null ? l : new LibInfoImpl[]{};
        this.editDate = new Date();
    }

    public String[] getJarPaths() {
        String[] result = new String[1 + this.attachments.length];
        result[0] = this.getJarPath();
        for (int i = 0; i < this.attachments.length; ++i) {
            result[1 + i] = this.attachments[i].getJarPath();
        }
        return result;
    }

    public synchronized Object clone() {
        return new ServiceInfoImpl(this);
    }

    public String toString() {
        return "Service info:\n\timpl-class=" + this.getClassName() + "\n\timpl-type=" + (this.implType == 0 ? "proxy" : "provider") + "\n\tinterfaces=" + this.printArray(this.getInterfaces()) + "\n\thelp-base=" + this.getHelpBaseName() + "\n\tapi-version=" + this.getAPIVersion() + "\n\tis-singleton=" + this.isSingleton() + "\n\tis-daemon=" + this.isDaemon() + "\n\tconfig-tool=" + this.getConfigToolName() + "\n\tdependencies=" + this.printArray(this.getLoadDependencies()) + "\n\tparam-list=" + this.printArray(this.getParameterList()) + "\n\tsupported-scopes=" + this.printArray(this.getSupportedScopes()) + "\n" + "\n\tlast-modified=" + this.getEditDate() + "\n\tattachments=" + this.printArray(this.getAttachments()) + "\n" + super.toString();
    }
}

