/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util;

import com.sun.management.viperimpl.util.TaskQueue;
import com.sun.management.viperimpl.util.TimerTask;
import com.sun.management.viperimpl.util.TimerThread;
import java.util.Date;

public class Timer {
    private TaskQueue queue = new TaskQueue();
    private TimerThread thread = new TimerThread(this.queue);
    private Object threadReaper = new Object(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            TaskQueue taskQueue = Timer.this.queue;
            synchronized (taskQueue) {
                ((Timer)Timer.this).thread.newTasksMayBeScheduled = false;
                Timer.this.queue.notify();
            }
        }
    };

    public Timer() {
        this.thread.start();
    }

    public Timer(boolean isDaemon) {
        this.thread.setDaemon(isDaemon);
        this.thread.start();
    }

    public void schedule(TimerTask task, long delay) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        this.sched(task, System.currentTimeMillis() + delay, 0L);
    }

    public void schedule(TimerTask task, Date time) {
        this.sched(task, time.getTime(), 0L);
    }

    public void schedule(TimerTask task, long delay, long period) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        if (period <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(task, System.currentTimeMillis() + delay, -period);
    }

    public void schedule(TimerTask task, Date firstTime, long period) {
        if (period <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(task, firstTime.getTime(), -period);
    }

    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        if (period <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(task, System.currentTimeMillis() + delay, period);
    }

    public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        if (period <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(task, firstTime.getTime(), period);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sched(TimerTask task, long time, long period) {
        if (time < 0L) {
            throw new IllegalArgumentException("Illegal execution time.");
        }
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            if (!this.thread.newTasksMayBeScheduled) {
                throw new IllegalStateException("Timer already cancelled.");
            }
            Object object = task.lock;
            synchronized (object) {
                if (task.state != 0) {
                    throw new IllegalStateException("Task already scheduled or cancelled");
                }
                task.nextExecutionTime = time;
                task.period = period;
                task.state = 1;
            }
            this.queue.add(task);
            if (this.queue.getMin() == task) {
                this.queue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            this.thread.newTasksMayBeScheduled = false;
            this.queue.clear();
            this.queue.notify();
        }
    }
}

