/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.servlet;

import com.sun.management.viper.CriticalStopException;
import com.sun.web.core.Context;
import com.sun.web.server.HttpServer;
import com.sun.web.server.HttpServerException;
import java.io.File;
import java.net.InetAddress;
import java.net.URL;

public class ServletServer {
    private HttpServer server = null;

    public ServletServer(int port, URL docbase, String tempdir) throws CriticalStopException {
        InetAddress inet = null;
        String hostname = null;
        this.server = new HttpServer(port, inet, hostname);
        try {
            this.server.setDocumentBase(docbase);
            this.server.setTempDir(new File(tempdir));
            this.server.start();
        }
        catch (HttpServerException hse) {
            throw new CriticalStopException("HttpServer failed", (Exception)((Object)hse));
        }
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (HttpServerException hse) {
                System.err.println("HTTP Server threw an exception during shutdown:");
                hse.printStackTrace();
            }
            this.server = null;
        }
    }

    protected void addDocbase(String name, String mappingPath, URL docbase) {
        Context context = this.server.createContext(name, mappingPath);
        context.setDocumentBase(docbase);
        context.init();
    }

    protected void finalize() throws Throwable {
        this.stop();
    }
}

