/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server.repository;

import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.BeanLoader;
import com.sun.management.viperimpl.ServiceAgent;
import com.sun.management.viperimpl.ServiceContainer;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class ObjectFactory {
    private String msg = null;
    private BeanLoader loader = new BeanLoader();

    public Object[] createCAPair(String beanClassname, String[] paths) {
        Object[] result = new Object[2];
        result[1] = null;
        result[0] = null;
        String containerName = beanClassname + "_Container";
        String agentName = beanClassname + "_Agent";
        this.setClassPath(beanClassname, paths);
        try {
            Class<?> c = this.loader.loadClass(containerName);
            if (ServiceContainer.class.isAssignableFrom(c)) {
                result[0] = c.newInstance();
            }
            if (ServiceAgent.class.isAssignableFrom(c = this.loader.loadClass(agentName))) {
                result[1] = c.newInstance();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return result;
    }

    public void setClassPath(String beanClassname, String[] paths) {
        if (!beanClassname.equalsIgnoreCase("ALL")) {
            // empty if block
        }
        try {
            for (int i = 0; i < paths.length; ++i) {
                this.loader.addURL(this.toURL(paths[i]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object createObject(String beanClassname, String path) {
        Object obj = null;
        try {
            obj = this.createObject(beanClassname, this.toURL(path));
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        return obj;
    }

    public Object createObject(String beanClassname, URL url) {
        Object obj = null;
        String msg = "Factory create bean " + beanClassname + " from " + url;
        Debug.trace((String)"ObjectFactory", (int)Debug.INFORMATION, (String)msg, null);
        try {
            this.loader.addURL(url);
            obj = this.loader.instantiate(beanClassname);
            msg = "object is " + obj.toString();
            Debug.trace((String)"ObjectFactory", (int)Debug.INFORMATION, (String)msg, null);
        }
        catch (Exception e) {
            Debug.trace((String)"ObjectFactory", (int)Debug.ERROR, (String)e.getMessage(), (Throwable)e);
        }
        return obj;
    }

    private URL toURL(String jarpath) throws MalformedURLException {
        File jar = new File(jarpath);
        return jar.toURL();
    }
}

