/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server.repository;

import com.sun.management.viper.ComponentInfo;
import com.sun.management.viper.ServiceInfo;
import com.sun.management.viper.ToolInfo;
import com.sun.management.viperimpl.ExternalClientProviderInfo;
import com.sun.management.viperimpl.ExternalClientProviderInfoImpl;
import com.sun.management.viperimpl.LibInfoImpl;
import com.sun.management.viperimpl.ServiceInfoImpl;
import com.sun.management.viperimpl.ToolInfoImpl;
import com.sun.management.viperimpl.rmic2.Main;
import com.sun.management.viperimpl.server.repository.VRegistry;
import com.sun.management.viperimpl.util.ResourceStringReader;
import com.sun.management.viperimpl.xml.viperbean.DescriptorManager;
import java.io.File;

public class InfoAdder {
    private static final int R_OPTION = 2;
    private static final int A_OPTION = 3;
    private static final int P_OPTION = 4;
    static final String RESOURCE_BUNDLE = "com.sun.management.viperimpl.server.repository.RepositoryServiceResources";
    private static ResourceStringReader resource;

    public static void usage() {
        System.out.println("InfoAdder -R <info_xml>");
        System.out.println("-or-");
        System.out.println("InfoAdder -A <bean_class> <base_jar_name>");
        System.out.println("-or-");
        System.out.println("InfoAdder -P <key=value> <pseudo-beanname> <lib.jar> ");
        System.out.println("For example:");
        System.out.println("\tInfoAdder -R com/sun/print/printerInfo.xml");
        System.out.println("-or-");
        System.out.println("InfoAdder -A com.sun.print.prtMgr tools/com.sun.print.prtMgr.resources.jar");
        System.out.println("-or-");
        System.out.println("InfoAdder -P \"x1=1 x2=2 x3=3\" ALLTOOL libx");
    }

    public static void main(String[] argv) {
        resource = new ResourceStringReader(RESOURCE_BUNDLE);
        String[] names = null;
        int j = 0;
        int nameLen = 0;
        int optionLen = 0;
        if (argv[0].equals("-R")) {
            optionLen = 2;
        } else if (argv[0].equals("-A")) {
            optionLen = 3;
        } else if (argv[0].equals("-P")) {
            optionLen = 4;
        }
        nameLen = argv.length - optionLen;
        if (nameLen > 0) {
            names = new String[nameLen];
            for (int i = optionLen; i < argv.length; ++i) {
                names[j++] = argv[i] != null && argv[i].trim().length() > 0 ? argv[i] : "";
            }
        }
        VRegistry.makeDirectories();
        if (argv[0].equals("-R")) {
            InfoAdder.addBean(argv[1], names);
        } else if (argv[0].equals("-A")) {
            InfoAdder.attach(argv[1], argv[2], names);
        } else if (argv[0].equals("-P")) {
            InfoAdder.attachProperties(argv[1].trim(), argv[2].trim(), argv[3]);
        } else {
            InfoAdder.usage();
        }
        System.exit(0);
    }

    private static void attachProperties(String keyString, String beanName, String libName) {
        int retValue = VRegistry.addProperties(keyString, beanName, libName);
        if (retValue == 1) {
            System.out.println(resource.getString("BeanNotFound", beanName));
        } else if (retValue == 2) {
            System.out.println(resource.getString("LibNotAttached", libName, beanName));
        }
    }

    private static void addBean(String infoXMLName, String[] libs) {
        Object info;
        ComponentInfo obj = null;
        try {
            obj = DescriptorManager.createDescriptor(new File(infoXMLName).toURL());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        if (obj == null) {
            System.err.println();
            System.err.println(resource.getString("InfoReadError", infoXMLName));
            System.exit(1);
        }
        String all_jars = "";
        String allservice_jars = "";
        String alltool_jars = "";
        LibInfoImpl[] shared = VRegistry.readAllLibJars();
        if (shared != null) {
            for (int i = 0; i < shared.length; ++i) {
                String jarName = shared[i].getJarName();
                if (jarName.startsWith("ALL@")) {
                    all_jars = all_jars + ":" + shared[i].getJarPath();
                    continue;
                }
                if (jarName.startsWith("services/ALLSERVICE@")) {
                    allservice_jars = allservice_jars + ":" + shared[i].getJarPath();
                    continue;
                }
                if (!jarName.startsWith("tools/ALLTOOL@")) continue;
                alltool_jars = alltool_jars + ":" + shared[i].getJarPath();
            }
        }
        String classpath = System.getProperty("java.class.path") + all_jars;
        if (obj instanceof ServiceInfo) {
            info = (ServiceInfo)obj;
            classpath = classpath + allservice_jars;
            String[] rmicargv = new String[]{"-classpath", classpath, "-d", ".", info.getClassName()};
            boolean good = new Main(System.out, "rmic").compile(rmicargv);
            if (good) {
                ServiceInfoImpl si = VRegistry.addEntry(info, libs);
                System.out.println("Jar Path:" + si.getJarPaths()[0]);
                System.out.println("Class Path:" + classpath);
            } else {
                System.err.println(resource.getString("CompileFailed"));
            }
        } else if (obj instanceof ToolInfo) {
            info = (ToolInfo)obj;
            ToolInfoImpl ti = VRegistry.addEntry((ToolInfo)info, libs);
            System.out.println("Jar Path:" + ti.getJarPaths()[0]);
            classpath = classpath + alltool_jars;
            System.out.println("Class Path:" + classpath);
        } else if (obj instanceof ExternalClientProviderInfo) {
            info = (ExternalClientProviderInfo)obj;
            ExternalClientProviderInfoImpl xcpi = VRegistry.addEntry((ExternalClientProviderInfo)info, libs);
            System.out.println("Jar Path:" + xcpi.getJarPaths()[0]);
            System.out.println("Class Path:" + classpath);
        } else {
            System.err.println(resource.getString("UnknownInfoDescriptor", infoXMLName));
        }
    }

    private static void attach(String beanName, String jarBasename, String[] libs) {
        String jarPath = VRegistry.addJarToEntry(beanName, jarBasename, libs);
        if (jarPath == null) {
            System.out.println(resource.getString("BeanNotFound", beanName));
        } else {
            System.out.println("Jar Path:" + jarPath);
        }
    }

    private static String baseName(String filename) {
        int i = filename.indexOf(64);
        if (i >= 0) {
            return filename.substring(i + 1);
        }
        return filename;
    }
}

