/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server;

import com.sun.management.viper.ComponentInfo;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.QuotedStringTokenizer;
import com.sun.management.viperimpl.LibInfoImpl;
import com.sun.management.viperimpl.console.config.toolInf;
import com.sun.management.viperimpl.server.RegistryProgress;
import com.sun.management.viperimpl.server.ViperServer;
import com.sun.management.viperimpl.server.repository.VRegistry;
import com.sun.management.viperimpl.util.SectionedProperties;
import com.sun.management.viperimpl.xml.viperbean.DescriptorManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Registry {
    protected SectionedProperties reg;
    protected SectionedProperties prereg;
    protected SectionedProperties smcreg;
    protected SectionedProperties smcunreg;
    protected ArrayList addedSet;
    protected ArrayList removedSet;
    protected Vector classlistRemovals = new Vector();
    protected static String regPath;
    protected static String preregDir;
    protected static String STAMP;
    protected static String SUFFIX;
    protected static String VIPER_HOME;
    protected static String VIPER_RTHOME;
    protected static String STANDALONE;
    private ResourceBundle resource = null;
    protected static String SMCREG;
    protected static String SMCUNREG;
    protected static String LIB;
    protected static String CODEBASE;
    protected static String SCRIPTS;
    protected static String CLASSLIST;
    protected static String[] envArray;
    protected static SimpleDateFormat dateFmt;
    protected static int totalElements;
    protected static int elementsCompleted;
    protected static String currentTask;
    private boolean standalone = false;
    private static final String SMCREG_VERSION = "1.0";
    private String regPhase = null;
    private final int NO_REGLEVEL = 99999;
    private boolean bSetup = true;
    protected static final String NATIVELIB_KEY = "nativelib";
    protected static final String SRCJAR_KEY = "srcjar";
    protected static final String XMLFILE_KEY = "xmlfile";
    protected static final String JARFILE_KEY = "jarfile";
    protected static final String SCOPE_KEY = "scope";
    protected static final String CLASSLIST_KEY = "classlist";
    protected static final String KEY_KEY = "key";
    protected static final String VALUE_KEY = "value";
    protected static final String VERSION_KEY = "version";
    protected static final String RUN_KEY = "run";
    protected static final String PROPERTY = "property";
    protected static final String TOOL = "tool";
    protected static final String SERVICE = "service";
    protected static final String LIBRARY = "library";
    protected static final String RUNCOMMAND = "run";
    protected static final String TOOLBOX = "toolbox";
    protected static final int A_LIBRARY = 0;
    protected static final int A_TOOL = 1;
    protected static final int A_SERVICE = 2;
    protected static final int A_PROPERTY = 3;
    protected static final int A_RUN = 4;
    protected static final int A_TOOLBOX = 5;

    protected Registry(boolean bSetup) {
        try {
            this.resource = ResourceBundle.getBundle("com.sun.management.viperimpl.server.ViperServerResources");
        }
        catch (Exception mre) {
            System.out.println("Can't load server resource.");
        }
        regPath = VIPER_RTHOME + "/properties/registry.properties";
        preregDir = VIPER_HOME + "/prereg";
        this.reg = new SectionedProperties();
        this.prereg = new SectionedProperties();
        this.smcreg = new SectionedProperties();
        this.smcunreg = new SectionedProperties();
        this.addedSet = new ArrayList();
        this.removedSet = new ArrayList();
        dateFmt = new SimpleDateFormat("yyyyMMddHHmmss");
        dateFmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        totalElements = 0;
        elementsCompleted = 0;
        this.bSetup = bSetup;
        this.regPhase = bSetup ? this.getMessage("RegisterSetup", null) : this.getMessage("RegisterComponents", null);
        if (STANDALONE != null && STANDALONE.equals("true")) {
            this.standalone = true;
        }
        envArray = new String[]{"VIPER_HOME=" + VIPER_HOME, "SMC_HOME=" + VIPER_HOME, "SMC_RTHOME=" + VIPER_RTHOME, "PATH=/usr/sbin:/usr/bin"};
    }

    private String getMessage(String key, Object[] args) {
        if (key == null) {
            return null;
        }
        if (this.resource == null) {
            return key;
        }
        String result = key;
        try {
            result = this.resource.getString(result);
            result = MessageFormat.format(result, args);
        }
        catch (Exception x) {
            // empty catch block
        }
        return result;
    }

    protected void findNewFragments() {
        String key;
        Iterator it = this.prereg.blockNames();
        while (this.bSetup && it.hasNext()) {
            key = (String)it.next();
            if (this.reg.containsKey(key)) continue;
            this.addedSet.add(key);
        }
        it = this.smcreg.blockNames();
        while (it.hasNext()) {
            key = (String)it.next();
            if (this.reg.containsKey(key)) continue;
            this.addedSet.add(key);
        }
    }

    protected void findRemovedFragments() {
        String key;
        Iterator it = this.reg.blockNames();
        while (this.bSetup && it.hasNext()) {
            key = (String)it.next();
            if (this.reg.getProperty(key, "install") == null || this.reg.getProperty(key, "remove") == null || this.prereg.containsKey(key)) continue;
            this.removedSet.add(key);
        }
        it = this.reg.blockNames();
        while (it.hasNext()) {
            key = (String)it.next();
            if (!this.smcunreg.containsKey(key)) continue;
            this.removedSet.add(key);
        }
    }

    protected void findUpdatedFragments() {
        String regStamp;
        String block2;
        ArrayList<String> updatedSet = new ArrayList<String>();
        Iterator it = this.reg.blockNames();
        while (this.bSetup && it.hasNext()) {
            block2 = (String)it.next();
            regStamp = this.reg.getProperty(block2, STAMP);
            if (!this.prereg.containsKey(block2)) continue;
            String preregStamp = this.prereg.getProperty(block2, STAMP);
            if (regStamp == null) {
                Debug.trace((String)"Registry", (int)Debug.WARNING, (String)("Bad registry block " + block2 + ": no timestamp"), null);
                continue;
            }
            try {
                if (Long.parseLong(regStamp) >= Long.parseLong(preregStamp)) continue;
                updatedSet.add(block2);
            }
            catch (NumberFormatException e) {}
        }
        it = this.reg.blockNames();
        while (it.hasNext()) {
            block2 = (String)it.next();
            regStamp = this.reg.getProperty(block2, STAMP);
            if (!this.smcreg.containsKey(block2)) continue;
            String smcregStamp = this.smcreg.getProperty(block2, STAMP);
            if (regStamp == null) {
                Debug.trace((String)"Registry", (int)Debug.WARNING, (String)("Bad registry block " + block2 + ": no timestamp"), null);
                continue;
            }
            try {
                if (Long.parseLong(regStamp) >= Long.parseLong(smcregStamp)) continue;
                updatedSet.add(block2);
            }
            catch (NumberFormatException e) {}
        }
        for (String block2 : updatedSet) {
            String smcregStamp = this.smcreg.getProperty(block2, STAMP);
            if (this.removedSet.contains(block2)) {
                String smcunregStamp = this.smcunreg.getProperty(block2, STAMP);
                try {
                    if (Long.parseLong(smcunregStamp) > Long.parseLong(smcregStamp)) continue;
                    int n = this.removedSet.indexOf(block2);
                    this.removedSet.remove(n);
                }
                catch (NumberFormatException e) {
                    continue;
                }
            }
            this.addedSet.add(block2);
        }
    }

    private int countEmptyRemoves() {
        int n = 0;
        for (String key : this.removedSet) {
            String command = this.reg.getProperty(key, "remove");
            if (command == null || command.trim().length() != 0) continue;
            ++n;
        }
        return n;
    }

    protected void addFragments() {
        Object[] array = this.addedSet.toArray();
        Arrays.sort(array, new Comparator(){

            public int compare(Object o1, Object o2) {
                int regLevel1 = 99999;
                int regLevel2 = 99999;
                try {
                    regLevel1 = Registry.this.prereg.getProperty((String)o1, "install") != null ? Integer.parseInt(Registry.this.prereg.getProperty((String)o1, "regLevel")) : Integer.parseInt(Registry.this.smcreg.getProperty((String)o1, "regLevel"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    regLevel2 = Registry.this.prereg.getProperty((String)o1, "install") != null ? Integer.parseInt(Registry.this.prereg.getProperty((String)o2, "regLevel")) : Integer.parseInt(Registry.this.smcreg.getProperty((String)o2, "regLevel"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (regLevel1 != 99999 && regLevel2 != 99999) {
                    return regLevel1 - regLevel2;
                }
                if (regLevel1 != 99999 && regLevel2 == 99999) {
                    return 1;
                }
                if (regLevel1 == 99999 && regLevel2 != 99999) {
                    return -1;
                }
                long timeStamp1 = 0L;
                long timeStamp2 = 0L;
                try {
                    timeStamp1 = Registry.this.prereg.getProperty((String)o1, "install") != null ? Long.parseLong(Registry.this.prereg.getProperty((String)o1, STAMP)) : Long.parseLong(Registry.this.smcreg.getProperty((String)o1, STAMP));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    timeStamp2 = Registry.this.prereg.getProperty((String)o1, "install") != null ? Long.parseLong(Registry.this.prereg.getProperty((String)o2, STAMP)) : Long.parseLong(Registry.this.smcreg.getProperty((String)o2, STAMP));
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (timeStamp1 < timeStamp2) {
                    return -1;
                }
                if (timeStamp1 > timeStamp2) {
                    return 1;
                }
                return 0;
            }

            public boolean equals(Object o) {
                return false;
            }
        });
        block7: for (int i = 0; i < array.length; ++i) {
            String key = (String)array[i];
            switch (this.whatIsIt(key)) {
                case 3: {
                    this.registerProperty(key);
                    continue block7;
                }
                case 1: 
                case 2: {
                    this.registerToolOrService(key);
                    continue block7;
                }
                case 0: {
                    this.registerLibrary(key);
                    continue block7;
                }
                case 5: {
                    this.registerToolbox(key);
                    continue block7;
                }
                case 4: {
                    this.runCommandFromProperties(this.smcreg.getBlock(key));
                    this.reg.setBlock(key, this.smcreg.getBlock(key));
                    this.reg.setProperty(key, STAMP, dateFmt.format(new Date()));
                    continue block7;
                }
                default: {
                    this.runInstallCommand(key);
                }
            }
        }
        if (!this.bSetup) {
            VRegistry.deleteFile(SMCREG);
        }
    }

    protected void removeFragments() {
        Object[] array = this.removedSet.toArray();
        Arrays.sort(array, new Comparator(){

            public int compare(Object o1, Object o2) {
                int regLevel1 = 99999;
                int regLevel2 = 99999;
                try {
                    regLevel1 = Registry.this.prereg.getProperty((String)o1, "remove") != null ? Integer.parseInt(Registry.this.prereg.getProperty((String)o1, "regLevel")) : Integer.parseInt(Registry.this.smcunreg.getProperty((String)o1, "regLevel"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    regLevel2 = Registry.this.prereg.getProperty((String)o1, "remove") != null ? Integer.parseInt(Registry.this.prereg.getProperty((String)o2, "regLevel")) : Integer.parseInt(Registry.this.smcunreg.getProperty((String)o2, "regLevel"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (regLevel1 != 99999 && regLevel2 != 99999) {
                    return regLevel1 - regLevel2;
                }
                if (regLevel1 != 99999 && regLevel2 == 99999) {
                    return 1;
                }
                if (regLevel1 == 99999 && regLevel2 != 99999) {
                    return -1;
                }
                long timeStamp1 = 0L;
                long timeStamp2 = 0L;
                try {
                    timeStamp1 = Registry.this.prereg.getProperty((String)o1, "remove") != null ? Long.parseLong(Registry.this.prereg.getProperty((String)o1, STAMP)) : Long.parseLong(Registry.this.smcunreg.getProperty((String)o1, STAMP));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    timeStamp2 = Registry.this.prereg.getProperty((String)o1, "remove") != null ? Long.parseLong(Registry.this.prereg.getProperty((String)o2, STAMP)) : Long.parseLong(Registry.this.smcunreg.getProperty((String)o2, STAMP));
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (timeStamp1 < timeStamp2) {
                    return 1;
                }
                if (timeStamp1 > timeStamp2) {
                    return -1;
                }
                return 0;
            }

            public boolean equals(Object o) {
                return false;
            }
        });
        for (int i = 0; i < array.length; ++i) {
            String key = (String)array[i];
            switch (this.whatIsIt(key)) {
                case 3: {
                    this.unRegisterProperty(key);
                    break;
                }
                case 1: 
                case 2: {
                    this.unRegisterToolOrService(key);
                    break;
                }
                case 0: {
                    this.unRegisterLibrary(key);
                    break;
                }
                case 5: {
                    this.registerToolbox(key);
                    break;
                }
                case 4: {
                    this.runCommandFromProperties(this.smcunreg.getBlock(key));
                    break;
                }
                default: {
                    this.runRemoveCommand(key);
                }
            }
            this.reg.remove(key);
        }
        if (!this.bSetup) {
            VRegistry.deleteFile(SMCUNREG);
            this.updateClasslist();
        }
    }

    protected void loadSmcreg() throws FileNotFoundException, IOException {
        this.smcreg.load(new FileInputStream(SMCREG));
    }

    protected void loadSmcunreg() throws FileNotFoundException, IOException {
        this.smcunreg.load(new FileInputStream(SMCUNREG));
    }

    protected void loadPrereg() throws FileNotFoundException, IOException {
        FilenameFilter dirf = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File d = new File(dir + "/" + name);
                return d.isDirectory();
            }
        };
        FilenameFilter regf = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(SUFFIX);
            }
        };
        File[] dirs = new File(preregDir).listFiles(dirf);
        if (dirs == null) {
            String s = ViperServer.getMessage("NoPreregDirs", null);
            throw new FileNotFoundException(s);
        }
        for (int i = 0; i < dirs.length; ++i) {
            File[] frags = dirs[i].listFiles(regf);
            for (int j = 0; j < frags.length; ++j) {
                this.prereg.load(new FileInputStream(frags[j]));
            }
        }
    }

    protected void loadRegistry() throws FileNotFoundException, IOException {
        this.reg.load(new FileInputStream(regPath));
    }

    protected void storeRegistry() throws FileNotFoundException, IOException {
        this.reg.store(new FileOutputStream(regPath), null);
    }

    protected void updateRegistry() {
        this.findRemovedFragments();
        this.findNewFragments();
        this.findUpdatedFragments();
        totalElements = this.addedSet.size() + this.removedSet.size();
        this.removeFragments();
        this.addFragments();
        if ((totalElements -= this.countEmptyRemoves()) > 0) {
            System.err.println("");
        }
    }

    protected void outputProgress(boolean overlay) {
        if (!overlay) {
            System.err.println(this.regPhase + " " + (elementsCompleted + 1) + "/" + totalElements + " (" + currentTask + ")");
        } else {
            System.err.print("\r                                                                            ");
            System.err.print("\r" + this.regPhase + " " + (elementsCompleted + 1) + "/" + totalElements + " (" + currentTask + ")");
        }
    }

    public static RegistryProgress getProgress() {
        RegistryProgress progress = new RegistryProgress();
        progress.completed = elementsCompleted;
        progress.total = totalElements;
        progress.task = currentTask;
        return progress;
    }

    protected int whatIsIt(String blockName) {
        if (blockName.startsWith(PROPERTY)) {
            return 3;
        }
        if (blockName.startsWith(TOOLBOX)) {
            return 5;
        }
        if (blockName.startsWith(TOOL)) {
            return 1;
        }
        if (blockName.startsWith(SERVICE)) {
            return 2;
        }
        if (blockName.startsWith(LIBRARY)) {
            return 0;
        }
        if (blockName.startsWith("run")) {
            return 4;
        }
        return -1;
    }

    protected boolean isValidVersionNumber(String versionNumber) {
        if (versionNumber == null) {
            return false;
        }
        return versionNumber.compareTo(SMCREG_VERSION) == 0;
    }

    protected void runInstallCommand(String sectionName) {
        String command = this.prereg.getProperty(sectionName, "install");
        if (command == null) {
            return;
        }
        Debug.trace((String)"Registry", (int)Debug.INFORMATION, (String)("fragment " + sectionName + " with: " + command), null);
        if (command.trim().length() > 0) {
            currentTask = this.getMessage("Executing", new String[]{new File(command).getName()});
            this.outputProgress(!this.standalone);
            ++elementsCompleted;
            if (!this.standalone) {
                StringBuffer output = new StringBuffer();
                int status = this.runCommand(command, output);
                if (output.length() > 0) {
                    System.out.println(output);
                }
            }
        }
        this.reg.setBlock(sectionName, this.prereg.getBlock(sectionName));
        this.reg.setProperty(sectionName, STAMP, dateFmt.format(new Date()));
        command = this.prereg.getProperty(sectionName, "remove");
        if (command != null && command.trim().length() > 0) {
            String dirName = SCRIPTS + "/" + sectionName;
            File dir = new File(dirName);
            dir.mkdirs();
            String dst = dirName + "/" + new File(command).getName();
            try {
                this.copyFile(command, dst);
                this.runCommand("chmod +x " + dst, new StringBuffer());
                this.reg.setProperty(sectionName, "remove", dst);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    protected void runRemoveCommand(String sectionName) {
        String command = this.reg.getProperty(sectionName, "remove");
        if (command == null) {
            return;
        }
        Debug.trace((String)"Registry", (int)Debug.INFORMATION, (String)("Removing fragment " + sectionName + " with: " + command), null);
        if (command.trim().length() > 0) {
            File file = new File(command);
            int idx = command.indexOf("smcconf");
            if (idx < 0) {
                idx = 0;
            }
            currentTask = this.getMessage("Executing", new String[]{file.exists() ? file.getName() : command.substring(idx)});
            this.outputProgress(command.indexOf(32) < 0);
            ++elementsCompleted;
            if (!this.standalone) {
                String[] list;
                StringBuffer output = new StringBuffer();
                int status = this.runCommand(command, output);
                if (output.length() > 0 && command.indexOf("smcconf") < 0 && command.indexOf(TOOLBOX) < 0) {
                    System.out.println("\n" + output);
                }
                if ((file = new File(command)).exists()) {
                    file.delete();
                    if (file.getParentFile().exists()) {
                        file.getParentFile().delete();
                    }
                }
                if ((file = new File(SCRIPTS)).exists() && ((list = file.list()) == null || list.length <= 0)) {
                    file.delete();
                }
            }
        }
    }

    protected int runCommand(String command, StringBuffer output) {
        int idx;
        if (this.standalone) {
            return 0;
        }
        while ((idx = command.indexOf("$SMC_HOME")) != -1) {
            command = command.substring(0, idx) + VIPER_HOME + command.substring(idx + 9);
        }
        while ((idx = command.indexOf("$SMC_RTHOME")) != -1) {
            command = command.substring(0, idx) + VIPER_RTHOME + command.substring(idx + 11);
        }
        String[] cmdArray = QuotedStringTokenizer.toArray((String)command);
        Process p = null;
        int status = -1;
        try {
            p = Runtime.getRuntime().exec(cmdArray, envArray);
        }
        catch (IOException e) {
            output.append(e.getMessage());
            return status;
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = br.readLine()) != null) {
                output.append("\n  " + line);
            }
            br.close();
        }
        catch (IOException e) {
            Debug.trace((String)"Registry", (int)Debug.WARNING, (String)"Failed to read from process", (Throwable)e);
        }
        boolean finished = false;
        while (!finished) {
            try {
                status = p.waitFor();
                finished = true;
            }
            catch (InterruptedException e) {}
        }
        return status;
    }

    protected void runCommandFromProperties(Properties sectionProperties) {
        if (sectionProperties == null) {
            return;
        }
        String sectionPropertiesVersion = sectionProperties.getProperty(VERSION_KEY);
        if (!this.isValidVersionNumber(sectionPropertiesVersion)) {
            System.out.println(this.getMessage("BadSmcregVersion", new String[]{"", SMCREG_VERSION}));
            System.out.println(this.getMessage("RegistryUpdateFailed", null));
            return;
        }
        String commandToRun = sectionProperties.getProperty("run");
        currentTask = "Running Command: " + commandToRun;
        this.outputProgress(!this.standalone);
        ++elementsCompleted;
        if (!this.standalone) {
            StringBuffer output = new StringBuffer();
            int status = this.runCommand(commandToRun, output);
            if (output.length() > 0) {
                System.out.println(output);
            }
        }
    }

    protected void unRegisterProperty(String sectionName) {
        int retval;
        Properties sectionProperties = this.smcunreg.getBlock(sectionName);
        if (sectionProperties == null) {
            return;
        }
        String sectionPropertiesVersion = sectionProperties.getProperty(VERSION_KEY);
        if (!this.isValidVersionNumber(sectionPropertiesVersion)) {
            System.out.println(this.getMessage("BadSmcregVersion", new String[]{sectionName, SMCREG_VERSION}));
            System.out.println(this.getMessage("RegistryUpdateFailed", null));
            return;
        }
        String propertyToDelete = sectionProperties.getProperty(KEY_KEY);
        String propertyScope = sectionProperties.getProperty(SCOPE_KEY);
        currentTask = "Unregistering property " + propertyToDelete;
        this.outputProgress(!this.standalone);
        ++elementsCompleted;
        if (!this.standalone && (retval = VRegistry.removeProperties(propertyToDelete, propertyScope, null)) != 0) {
            System.out.println(this.getMessage("CantUnRegisterProperty", new String[]{propertyToDelete, String.valueOf(retval)}));
            System.out.println(this.getMessage("RegistryUpdateFailed", null));
        }
    }

    protected void unRegisterToolOrService(String sectionName) {
        String jarFileToUnRegister;
        Properties sectionProperties = this.smcunreg.getBlock(sectionName);
        if (sectionProperties == null) {
            return;
        }
        String sectionPropertiesVersion = sectionProperties.getProperty(VERSION_KEY);
        if (!this.isValidVersionNumber(sectionPropertiesVersion)) {
            System.out.println(this.getMessage("BadSmcregVersion", new String[]{sectionName, SMCREG_VERSION}));
            System.out.println(this.getMessage("RegistryUpdateFailed", null));
            return;
        }
        String baseJar = jarFileToUnRegister = sectionProperties.getProperty(JARFILE_KEY);
        int i = jarFileToUnRegister.lastIndexOf(".jar");
        if (i >= 0 && (i = jarFileToUnRegister.lastIndexOf(46, i - 1)) >= 0) {
            baseJar = jarFileToUnRegister.substring(i + 1);
        }
        currentTask = "Unregistering " + baseJar;
        this.outputProgress(!this.standalone);
        ++elementsCompleted;
        if (!this.standalone) {
            File src = new File(CODEBASE + "/" + jarFileToUnRegister);
            src.delete();
            this.classlistRemovals.add(jarFileToUnRegister);
            if (!VRegistry.removeEntry(jarFileToUnRegister)) {
                System.out.println(this.getMessage("CantUnRegister", new String[]{jarFileToUnRegister}));
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
            }
        }
    }

    protected void unRegisterLibrary(String sectionName) {
        Properties sectionProperties = this.smcunreg.getBlock(sectionName);
        if (sectionProperties == null) {
            return;
        }
        String sectionPropertiesVersion = sectionProperties.getProperty(VERSION_KEY);
        if (!this.isValidVersionNumber(sectionPropertiesVersion)) {
            System.out.println(this.getMessage("BadSmcregVersion", new String[]{sectionName, SMCREG_VERSION}));
            System.out.println(this.getMessage("RegistryUpdateFailed", null));
            return;
        }
        String jarFileToUnRegister = sectionProperties.getProperty(JARFILE_KEY);
        String scopeToUnregister = sectionProperties.getProperty(SCOPE_KEY);
        String baseJar = jarFileToUnRegister;
        int i = jarFileToUnRegister.lastIndexOf(".jar");
        if (i >= 0 && (i = jarFileToUnRegister.lastIndexOf(46, i - 1)) >= 0) {
            baseJar = jarFileToUnRegister.substring(i + 1);
        }
        currentTask = "Unregistering " + baseJar;
        this.outputProgress(!this.standalone);
        ++elementsCompleted;
        if (!this.standalone) {
            File src = new File(CODEBASE + "/" + scopeToUnregister + "@" + jarFileToUnRegister);
            src.delete();
            this.classlistRemovals.add(scopeToUnregister + "@" + jarFileToUnRegister);
            String path = VRegistry.removeJarFromEntry(scopeToUnregister, jarFileToUnRegister);
            if (path == null) {
                System.out.println(this.getMessage("CantUnRegister", new String[]{jarFileToUnRegister}));
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
            }
        }
    }

    protected void updateClasslist() {
        if (this.classlistRemovals.size() == 0) {
            return;
        }
        BufferedReader reader = null;
        PrintWriter writer = null;
        File scratch = new File(CLASSLIST + ".new");
        try {
            String line;
            reader = new BufferedReader(new FileReader(CLASSLIST));
            writer = new PrintWriter(new BufferedWriter(new FileWriter(scratch)));
            while ((line = reader.readLine()) != null) {
                boolean deleteIt = false;
                for (int i = 0; i < this.classlistRemovals.size(); ++i) {
                    String pattern = (String)this.classlistRemovals.elementAt(i);
                    if (line.indexOf(pattern) < 0) continue;
                    deleteIt = true;
                    break;
                }
                if (deleteIt) continue;
                writer.println(line);
            }
            writer.flush();
            writer.close();
            reader.close();
            scratch.renameTo(new File(CLASSLIST));
        }
        catch (Exception e) {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            scratch.delete();
        }
    }

    protected void copyFile(String src, String dst) throws Exception {
        int CHUNKSIZE = 8192;
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            int n;
            is = new FileInputStream(src);
            os = new FileOutputStream(dst);
            byte[] b = new byte[CHUNKSIZE];
            while ((n = is.read(b)) > 0) {
                os.write(b, 0, n);
            }
            os.flush();
        }
        catch (Exception e) {
            throw new Exception(this.getMessage("FileCopyFailed", new String[]{src, dst, e.getMessage()}));
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    protected void appendFile(String src, String dst) throws Exception {
        int n;
        int CHUNKSIZE = 8192;
        File file = new File(dst);
        if (!file.exists()) {
            this.copyFile(src, dst);
            return;
        }
        File scratch = new File(dst + ".new");
        scratch.createNewFile();
        FileInputStream is = null;
        FileOutputStream os = null;
        byte[] b = new byte[CHUNKSIZE];
        try {
            is = new FileInputStream(dst);
            os = new FileOutputStream(scratch);
            while ((n = is.read(b)) > 0) {
                os.write(b, 0, n);
            }
            is.close();
        }
        catch (Exception e) {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
            throw new Exception(this.getMessage("FileAppendFailed", new String[]{src, dst, e.getMessage()}));
        }
        is = null;
        try {
            is = new FileInputStream(src);
            while ((n = is.read(b)) > 0) {
                os.write(b, 0, n);
            }
            os.flush();
        }
        catch (Exception e) {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
            throw new Exception(this.getMessage("FileAppendFailed", new String[]{src, dst, e.getMessage()}));
        }
        is.close();
        os.close();
        scratch.renameTo(new File(dst));
    }

    private String generateClasslist(String jarPath, String scope, String type, String altName) {
        String baseName = new File(jarPath).getName();
        int i = baseName.lastIndexOf(".jar");
        if (i >= 0) {
            baseName = baseName.substring(0, i);
        }
        String classListPath = VIPER_RTHOME + "/" + baseName + "_classlist.txt";
        JarFile jarFile = null;
        PrintWriter writer = null;
        try {
            jarFile = new JarFile(jarPath);
            writer = new PrintWriter(new BufferedWriter(new FileWriter(new File(classListPath))));
        }
        catch (Exception e) {
            return null;
        }
        String newName = scope + "@";
        newName = altName != null && altName.length() > 0 ? newName + altName : newName + new File(jarPath).getName();
        writer.println("# classes in " + newName);
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            JarEntry jarEntry = e.nextElement();
            if (jarEntry.getName().startsWith("META-INF")) continue;
            writer.println(jarEntry.getName() + ":" + newName + ":" + type);
        }
        writer.flush();
        writer.close();
        return classListPath;
    }

    protected void registerToolOrService(String sectionName) {
        String jarFileToRegister;
        Properties sectionProperties = this.smcreg.getBlock(sectionName);
        if (sectionProperties == null) {
            return;
        }
        String sectionPropertiesVersion = sectionProperties.getProperty(VERSION_KEY);
        if (!this.isValidVersionNumber(sectionPropertiesVersion)) {
            System.out.println(this.getMessage("BadSmcregVersion", new String[]{sectionName, SMCREG_VERSION}));
            System.out.println(this.getMessage("RegistryUpdateFailed", null));
            return;
        }
        String baseJar = jarFileToRegister = sectionProperties.getProperty(JARFILE_KEY);
        int i = jarFileToRegister.lastIndexOf(".jar");
        if (i >= 0 && (i = jarFileToRegister.lastIndexOf(46, i - 1)) >= 0) {
            baseJar = jarFileToRegister.substring(i + 1);
        }
        currentTask = "Registering " + baseJar;
        this.outputProgress(!this.standalone);
        ++elementsCompleted;
        String infoXMLName = sectionProperties.getProperty(XMLFILE_KEY);
        if (!this.standalone) {
            LibInfoImpl ti;
            String src = "";
            String dst = "";
            Vector<String> vNativeLibs = new Vector<String>();
            for (i = 0; i < 4; ++i) {
                src = sectionProperties.getProperty(NATIVELIB_KEY + i);
                if (src == null || src.length() == 0) continue;
                String baseName = new File(src).getName();
                vNativeLibs.add(baseName);
                dst = LIB + "/" + baseName;
                try {
                    this.copyFile(src, dst);
                    continue;
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    System.out.println(this.getMessage("RegistryUpdateFailed", null));
                    return;
                }
            }
            try {
                src = sectionProperties.getProperty(SRCJAR_KEY);
                if (src == null || src.length() == 0) {
                    throw new Exception(this.getMessage("CantFindJar", new String[]{baseJar}));
                }
                dst = CODEBASE + "/" + jarFileToRegister;
                this.copyFile(src, dst);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
                return;
            }
            try {
                src = sectionProperties.getProperty(CLASSLIST_KEY);
                if (src == null || src.length() == 0) {
                    throw new Exception(this.getMessage("CantFindClasslist", null));
                }
                this.appendFile(src, CLASSLIST);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
                return;
            }
            ComponentInfo obj = null;
            try {
                obj = DescriptorManager.createDescriptor(new File(infoXMLName).toURL());
            }
            catch (Exception e) {
                System.out.println(this.getMessage("CantParseDescriptor", new String[]{jarFileToRegister, e.getMessage()}));
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
                return;
            }
            Object[] names = null;
            if (vNativeLibs.size() > 0) {
                names = new String[vNativeLibs.size()];
                vNativeLibs.copyInto(names);
            }
            if ((ti = VRegistry.addEntry(obj, names)) == null) {
                System.out.println(this.getMessage("CantRegister", new String[]{jarFileToRegister}));
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
                return;
            }
        }
        this.reg.setBlock(sectionName, this.smcreg.getBlock(sectionName));
        this.reg.setProperty(sectionName, STAMP, dateFmt.format(new Date()));
    }

    protected void registerLibrary(String sectionName) {
        Properties sectionProperties = this.smcreg.getBlock(sectionName);
        if (sectionProperties == null) {
            return;
        }
        String sectionPropertiesVersion = sectionProperties.getProperty(VERSION_KEY);
        if (!this.isValidVersionNumber(sectionPropertiesVersion)) {
            System.out.println(this.getMessage("BadSmcregVersion", new String[]{sectionName, SMCREG_VERSION}));
            System.out.println(this.getMessage("RegistryUpdateFailed", null));
            return;
        }
        String jarFileToRegister = sectionProperties.getProperty(JARFILE_KEY);
        String scopeOfJar = sectionProperties.getProperty(SCOPE_KEY);
        String baseJar = jarFileToRegister;
        int i = jarFileToRegister.lastIndexOf(".jar");
        if (i >= 0 && (i = jarFileToRegister.lastIndexOf(46, i - 1)) >= 0) {
            baseJar = jarFileToRegister.substring(i + 1);
        }
        currentTask = "Registering " + baseJar;
        this.outputProgress(!this.standalone);
        ++elementsCompleted;
        if (!this.standalone) {
            String path;
            String src = "";
            String dst = "";
            Vector<String> vNativeLibs = new Vector<String>();
            for (i = 0; i < 4; ++i) {
                src = sectionProperties.getProperty(NATIVELIB_KEY + i);
                if (src == null || src.length() == 0) continue;
                String baseName = new File(src).getName();
                vNativeLibs.add(baseName);
                dst = LIB + "/" + baseName;
                try {
                    this.copyFile(src, dst);
                    continue;
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    System.out.println(this.getMessage("RegistryUpdateFailed", null));
                    return;
                }
            }
            try {
                src = sectionProperties.getProperty(SRCJAR_KEY);
                if (src == null || src.length() == 0) {
                    throw new Exception(this.getMessage("CantFindJar", new String[]{baseJar}));
                }
                dst = CODEBASE + "/" + scopeOfJar + "@" + jarFileToRegister;
                this.copyFile(src, dst);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
                return;
            }
            boolean isAutoGeneratedClasslist = false;
            try {
                src = sectionProperties.getProperty(CLASSLIST_KEY);
                if (src == null || src.length() == 0) {
                    src = this.generateClasslist(sectionProperties.getProperty(SRCJAR_KEY), scopeOfJar, LIBRARY, jarFileToRegister);
                    isAutoGeneratedClasslist = true;
                }
                if (src == null || src.length() == 0) {
                    throw new Exception(this.getMessage("CantFindClasslist", null));
                }
                this.appendFile(src, CLASSLIST);
                if (isAutoGeneratedClasslist) {
                    new File(src).delete();
                }
            }
            catch (Exception e) {
                if (isAutoGeneratedClasslist) {
                    new File(src).delete();
                }
                System.out.println(e.getMessage());
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
                return;
            }
            Object[] names = null;
            if (vNativeLibs.size() > 0) {
                names = new String[vNativeLibs.size()];
                vNativeLibs.copyInto(names);
            }
            if ((path = VRegistry.addJarToEntry(scopeOfJar, jarFileToRegister, (String[])names)) == null) {
                System.out.println(this.getMessage("CantRegister", new String[]{jarFileToRegister}));
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
                return;
            }
        }
        this.reg.setBlock(sectionName, this.smcreg.getBlock(sectionName));
        this.reg.setProperty(sectionName, STAMP, dateFmt.format(new Date()));
    }

    protected synchronized void registerToolbox(String sectionName) {
        String action;
        Properties sectionProperties = this.smcreg.getBlock(sectionName);
        if (sectionProperties == null) {
            return;
        }
        String sectionPropertiesVersion = sectionProperties.getProperty(VERSION_KEY);
        if (!this.isValidVersionNumber(sectionPropertiesVersion)) {
            System.out.println(this.getMessage("BadSmcregVersion", new String[]{sectionName, SMCREG_VERSION}));
            System.out.println(this.getMessage("RegistryUpdateFailed", null));
            return;
        }
        String beanNameToRegister = "???";
        String whatIsIt = "???";
        if (sectionProperties.getProperty(TOOL) != null) {
            whatIsIt = TOOL;
            beanNameToRegister = sectionProperties.getProperty(TOOL);
        } else if (sectionProperties.getProperty("folderName") != null) {
            whatIsIt = "folder";
            beanNameToRegister = sectionProperties.getProperty("folderName");
        } else if (sectionProperties.getProperty(TOOLBOX) != null) {
            whatIsIt = TOOLBOX;
            beanNameToRegister = sectionProperties.getProperty(TOOLBOX);
        } else if (sectionProperties.getProperty("tbxUrl") != null) {
            whatIsIt = "tbxUrl";
            beanNameToRegister = sectionProperties.getProperty("tbxUrl");
        }
        String baseName = beanNameToRegister;
        int i = beanNameToRegister.lastIndexOf(46);
        if (i >= 0) {
            if (beanNameToRegister.endsWith(".tbx")) {
                i = beanNameToRegister.lastIndexOf(47);
            }
            baseName = i >= 0 ? beanNameToRegister.substring(i + 1) : beanNameToRegister.substring(i + 1);
        }
        currentTask = (action = sectionProperties.getProperty("action")).equals("add") ? this.getMessage("RegisterToolbox", new String[]{baseName}) : (action.equals("create") ? this.getMessage("RegisterToolbox", new String[]{baseName}) : this.getMessage("UnregisterToolbox", new String[]{baseName}));
        this.outputProgress(!this.standalone);
        ++elementsCompleted;
        boolean forceFlag = false;
        String force = sectionProperties.getProperty("force");
        if (force != null && (force == "1" || force == "true")) {
            forceFlag = true;
        }
        String[] operations = new String[]{"pre-operation", "operation"};
        for (i = 0; i < operations.length; ++i) {
            toolInf cl;
            String[] args;
            block16: {
                String op = sectionProperties.getProperty(operations[i]);
                if (op == null || op.length() == 0) continue;
                args = QuotedStringTokenizer.toArray((String)op);
                if (this.standalone) continue;
                cl = null;
                try {
                    cl = (toolInf)Class.forName(args[0]).newInstance();
                    cl.exec(args);
                }
                catch (Exception e) {
                    if (e.getMessage().length() <= 0) break block16;
                    System.out.println("\n" + e.getMessage());
                    if (cl != null && cl.getExecStatus() != 0) {
                        this.handleToolboxResult(action, args, whatIsIt, forceFlag, cl.getExecStatus());
                    }
                    return;
                }
            }
            if (this.handleToolboxResult(action, args, whatIsIt, forceFlag, cl.getExecStatus()) == 0) continue;
            return;
        }
    }

    private int handleToolboxResult(String action, String[] args, String type, boolean force, int result) {
        if (action.equalsIgnoreCase("create")) {
            if (args[0].indexOf("checktool") >= 0) {
                switch (result) {
                    case 0: {
                        String outName = this.getArgValue(args, "-o");
                        String name = outName.substring(0, outName.length() - 4);
                        File tbxout = new File(outName);
                        File tbx = new File(name);
                        tbxout.renameTo(tbx);
                        return 0;
                    }
                }
                String outName = this.getArgValue(args, "-o");
                String name = outName.substring(0, outName.length() - 4);
                File tbxout = new File(outName);
                tbxout.delete();
                String argT = this.getArgValue(args, "-T");
                if (argT != null && argT.equals("urlLink")) {
                    System.out.println(this.getMessage("InvalidURL", new String[]{this.getArgValue(args, "-t")}));
                } else {
                    System.out.println(this.getMessage("CantCreateToolbox", new String[]{name}));
                }
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
                return 1;
            }
            return 0;
        }
        if (action.equalsIgnoreCase("add")) {
            if (args[0].indexOf("checktool") >= 0) {
                switch (result) {
                    case 0: {
                        if (!force) {
                            System.out.println(this.getMessage("CantOverwriteToolbox", new String[]{this.getMessage(type, null), this.getMessage(type, null)}));
                            System.out.println(this.getMessage("RegistryUpdateFailed", null));
                            return 1;
                        }
                        File tbx = new File(this.getArgValue(args, "-f"));
                        tbx.setLastModified(new Date().getTime());
                        return 0;
                    }
                    case 2: {
                        System.out.println(this.getMessage("CantLocate", new String[]{this.getMessage("folder", null), this.getArgValue(args, "-F")}));
                        System.out.println(this.getMessage("RegistryUpdateFailed", null));
                        return 1;
                    }
                    case 3: {
                        System.out.println(this.getMessage("BadSmallIcon", new String[]{this.getArgValue(args, "-m")}));
                        System.out.println(this.getMessage("RegistryUpdateFailed", null));
                        return 1;
                    }
                    case 4: {
                        System.out.println(this.getMessage("BadLargeIcon", new String[]{this.getArgValue(args, "-L")}));
                        System.out.println(this.getMessage("RegistryUpdateFailed", null));
                        return 1;
                    }
                    case 5: {
                        System.out.println(this.getMessage("MultipleFolders", new String[]{this.getArgValue(args, "-F")}));
                        System.out.println(this.getMessage("RegistryUpdateFailed", null));
                        return 1;
                    }
                }
                return 0;
            }
            if (args[0].indexOf("addtool") >= 0) {
                switch (result) {
                    case 0: {
                        File tbxout = new File(this.getArgValue(args, "-o"));
                        File tbx = new File(this.getArgValue(args, "-f"));
                        tbxout.renameTo(tbx);
                        return 0;
                    }
                }
                if (type.equals(TOOL)) {
                    System.out.println(this.getMessage("AddToolFailed", new String[]{this.getMessage(type, null), this.getArgValue(args, "-c")}));
                } else {
                    System.out.println(this.getMessage("AddToolFailed", new String[]{this.getMessage(type, null), this.getArgValue(args, "-t")}));
                }
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
                return 1;
            }
            return 0;
        }
        if (action.equalsIgnoreCase("remove")) {
            if (args[0].indexOf("checktool") < 0) {
                return 0;
            }
            if (this.getArgValue(args, "-O").equals("check")) {
                switch (result) {
                    case 0: {
                        return 0;
                    }
                    case 2: {
                        System.out.println(this.getMessage("CantLocate", new String[]{this.getMessage("folder", null), this.getArgValue(args, "-F")}));
                        System.out.println(this.getMessage("RegistryUpdateFailed", null));
                        return 1;
                    }
                    case 3: {
                        System.out.println(this.getMessage("BadSmallIcon", new String[]{this.getArgValue(args, "-m")}));
                        System.out.println(this.getMessage("RegistryUpdateFailed", null));
                        return 1;
                    }
                    case 4: {
                        System.out.println(this.getMessage("BadLargeIcon", new String[]{this.getArgValue(args, "-L")}));
                        System.out.println(this.getMessage("RegistryUpdateFailed", null));
                        return 1;
                    }
                    case 5: {
                        System.out.println(this.getMessage("MultipleFolders", new String[]{this.getArgValue(args, "-F")}));
                        System.out.println(this.getMessage("RegistryUpdateFailed", null));
                        return 1;
                    }
                }
                if (type.equals(TOOL)) {
                    System.out.println(this.getMessage("CantLocate", new String[]{this.getMessage(type, null), this.getArgValue(args, "-c")}));
                } else if (type.equals("tbxUrl")) {
                    System.out.println(this.getMessage("CantLocate", new String[]{this.getMessage(type, null), this.getArgValue(args, "-t")}));
                } else {
                    System.out.println(this.getMessage("CantLocate", new String[]{this.getMessage(type, null), this.getArgValue(args, "-n")}));
                }
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
                return 1;
            }
            if (this.getArgValue(args, "-O").equals("delete")) {
                switch (result) {
                    case 0: {
                        File tbxout = new File(this.getArgValue(args, "-o"));
                        File tbx = new File(this.getArgValue(args, "-f"));
                        tbxout.renameTo(tbx);
                        return 0;
                    }
                }
                if (type.equals(TOOL)) {
                    System.out.println(this.getMessage("DeleteToolFailed", new String[]{this.getMessage(type, null), this.getArgValue(args, "-c")}));
                } else {
                    System.out.println(this.getMessage("DeleteToolFailed", new String[]{this.getMessage(type, null), this.getArgValue(args, "-n")}));
                }
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
                return 1;
            }
            return 0;
        }
        return 0;
    }

    private String getArgValue(String[] args, String option) {
        String value = "";
        if (args == null) {
            return value;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(option)) continue;
            value = args[i + 1];
            break;
        }
        return value;
    }

    protected void registerProperty(String sectionName) {
        int retval;
        Properties sectionProperties = this.smcreg.getBlock(sectionName);
        if (sectionProperties == null) {
            return;
        }
        String sectionPropertiesVersion = sectionProperties.getProperty(VERSION_KEY);
        if (!this.isValidVersionNumber(sectionPropertiesVersion)) {
            System.out.println(this.getMessage("BadSmcregVersion", new String[]{sectionName, SMCREG_VERSION}));
            System.out.println(this.getMessage("RegistryUpdateFailed", null));
            return;
        }
        String keyToRegister = sectionProperties.getProperty(KEY_KEY);
        String valueToRegister = sectionProperties.getProperty(VALUE_KEY);
        String scopeToRegister = sectionProperties.getProperty(SCOPE_KEY);
        String keyValuePair = keyToRegister + "=" + valueToRegister;
        currentTask = "Registering " + keyValuePair;
        this.outputProgress(!this.standalone);
        ++elementsCompleted;
        if (!this.standalone && (retval = VRegistry.addProperties(keyValuePair, scopeToRegister, null)) != 0) {
            System.out.println(this.getMessage("CantRegisterProperty", new String[]{keyValuePair, String.valueOf(retval)}));
            System.out.println(this.getMessage("RegistryUpdateFailed", null));
            return;
        }
        this.reg.setBlock(sectionName, this.smcreg.getBlock(sectionName));
        this.reg.setProperty(sectionName, STAMP, dateFmt.format(new Date()));
    }

    protected void merge() {
        String BAKSUFFIX = ".bak";
        String[] files = new String[]{SMCREG, SMCUNREG};
        if (this.bSetup) {
            for (int i = 0; i < files.length; ++i) {
                File file = new File(files[i]);
                File fileBak = new File(files[i] + ".bak");
                if (!file.exists()) continue;
                file.renameTo(fileBak);
            }
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File fileBak = new File(files[i] + ".bak");
            if (!fileBak.exists()) continue;
            File file = new File(files[i]);
            if (!file.exists()) {
                fileBak.renameTo(file);
                continue;
            }
            SectionedProperties reg = new SectionedProperties();
            SectionedProperties regBak = new SectionedProperties();
            try {
                reg.load(new FileInputStream(files[i]));
                regBak.load(new FileInputStream(files[i] + ".bak"));
            }
            catch (Exception e) {
                Debug.trace((String)"Registry", (int)Debug.WARNING, null, (Throwable)e);
                continue;
            }
            Iterator it = reg.blockNames();
            int regLevel = 1;
            regLevel = 1;
            while (it.hasNext()) {
                ++regLevel;
                it.next();
            }
            it = regBak.blockNames();
            while (it.hasNext()) {
                String key = (String)it.next();
                reg.setBlock(key, regBak.getBlock(key));
                reg.setProperty(key, "regLevel", String.valueOf(regLevel));
                ++regLevel;
            }
            try {
                reg.store(new FileOutputStream(files[i]), null);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            fileBak.delete();
        }
    }

    public static void doEverything() {
        Registry reg = new Registry(true);
        File configScript = new File(VIPER_HOME + "/bin/smcpreconfig");
        if (configScript.exists()) {
            reg.runCommand(configScript.getPath(), new StringBuffer());
        }
        reg.merge();
        try {
            reg.loadPrereg();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            Debug.trace((String)"Registry", (int)Debug.WARNING, null, (Throwable)e);
        }
        try {
            reg.loadRegistry();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            Debug.trace((String)"Registry", (int)Debug.WARNING, null, (Throwable)e);
        }
        reg.updateRegistry();
        try {
            reg.storeRegistry();
        }
        catch (Exception e) {
            Debug.trace((String)"Registry", (int)Debug.WARNING, null, (Throwable)e);
        }
        reg = new Registry(false);
        reg.merge();
        try {
            reg.loadSmcreg();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            Debug.trace((String)"Registry", (int)Debug.WARNING, null, (Throwable)e);
        }
        try {
            reg.loadSmcunreg();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            Debug.trace((String)"Registry", (int)Debug.WARNING, null, (Throwable)e);
        }
        try {
            reg.loadRegistry();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            Debug.trace((String)"Registry", (int)Debug.WARNING, null, (Throwable)e);
        }
        reg.updateRegistry();
        try {
            reg.storeRegistry();
        }
        catch (Exception e) {
            Debug.trace((String)"Registry", (int)Debug.WARNING, null, (Throwable)e);
        }
    }

    public static void main(String[] args) {
        Registry.doEverything();
    }

    static {
        STAMP = "timestamp";
        SUFFIX = ".mcreg";
        VIPER_HOME = System.getProperty("viper.home");
        VIPER_RTHOME = System.getProperty("viper.rthome");
        STANDALONE = System.getProperty("standalone");
        SMCREG = VIPER_RTHOME + "/smcreg";
        SMCUNREG = VIPER_RTHOME + "/smcunreg";
        LIB = VIPER_RTHOME + "/lib";
        CODEBASE = VIPER_RTHOME + "/codebase";
        SCRIPTS = VIPER_RTHOME + "/scripts";
        CLASSLIST = VIPER_RTHOME + "/properties/classlist.txt";
    }
}

