/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.rmic2;

import com.sun.management.viperimpl.rmic2.Main;
import com.sun.management.viperimpl.rmic2.Names;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Vector;
import sun.rmi.rmic.BatchEnvironment;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.RMIConstants;
import sun.rmi.rmic.RemoteClass;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;

public class Generator
implements RMIConstants {
    private BatchEnvironment env;
    private RemoteClass remoteClass;
    private int version;
    private RemoteClass.Method[] remoteMethods;
    private Identifier remoteClassName;
    private Identifier agentClassName;
    private Identifier containerClassName;
    private Identifier interfaceClassName;
    private String[] methodFieldNames;
    private ClassDefinition defException;
    private ClassDefinition defRemoteException;
    private ClassDefinition defRuntimeException;

    public static void generate(BatchEnvironment env, ClassDefinition cdef, File destDir, int version, Vector list) {
        Generator gen;
        RemoteClass remoteClass = RemoteClass.forClass((BatchEnvironment)env, (ClassDefinition)cdef);
        if (remoteClass == null) {
            return;
        }
        try {
            gen = new Generator(env, remoteClass, version);
        }
        catch (ClassNotFound e) {
            env.error(0L, "rmic.class.not.found", (Object)e.name);
            return;
        }
        Identifier agentClassName = Names.agentFor(cdef.getName());
        File agentFile = Generator.getFileForClass(agentClassName, destDir, ".java");
        env.addGeneratedFile(agentFile);
        list.addElement(agentFile);
        try {
            IndentingWriter out = new IndentingWriter((Writer)new OutputStreamWriter(new FileOutputStream(agentFile)));
            gen.writeAgent(out);
            out.close();
            if (env.verbose()) {
                env.output(Main.getText("rmic.wrote", agentFile.getPath()));
            }
            env.parseFile(new ClassFile(agentFile));
        }
        catch (IOException e) {
            env.error(0L, "cant.write", (Object)agentFile.toString());
            return;
        }
        Identifier interfaceClassName = Names.interfaceFor(cdef.getName());
        File interfaceFile = Generator.getFileForClass(interfaceClassName, destDir, ".java");
        env.addGeneratedFile(interfaceFile);
        list.addElement(interfaceFile);
        try {
            IndentingWriter out = new IndentingWriter((Writer)new OutputStreamWriter(new FileOutputStream(interfaceFile)));
            gen.writeInterface(out);
            out.close();
            if (env.verbose()) {
                env.output(Main.getText("rmic.wrote", interfaceFile.getPath()));
            }
            env.parseFile(new ClassFile(interfaceFile));
        }
        catch (IOException e) {
            env.error(0L, "cant.write", (Object)interfaceFile.toString());
            return;
        }
        Identifier containerClassName = Names.containerFor(cdef.getName());
        File containerFile = Generator.getFileForClass(containerClassName, destDir, ".java");
        if (version == 1 || version == 2) {
            env.addGeneratedFile(containerFile);
            try {
                IndentingWriter out = new IndentingWriter((Writer)new OutputStreamWriter(new FileOutputStream(containerFile)));
                gen.writeContainer(out);
                out.close();
                if (env.verbose()) {
                    env.output(Main.getText("rmic.wrote", containerFile.getPath()));
                }
                env.parseFile(new ClassFile(containerFile));
                list.addElement(containerFile);
            }
            catch (IOException e) {
                env.error(0L, "cant.write", (Object)containerFile.toString());
                return;
            }
        } else {
            File containerClassFile = Generator.getFileForClass(containerClassName, destDir, ".class");
            containerFile.delete();
            containerClassFile.delete();
        }
    }

    private static File getFileForClass(Identifier className, File destDir, String suffix) {
        Identifier externalClassName = Names.mangleClass(className);
        String packageDirName = externalClassName.getQualifier().toString().replace('.', File.separatorChar);
        String classFileName = externalClassName.getName() + suffix;
        if (destDir != null) {
            File packageDir = new File(destDir, packageDirName);
            if (!packageDir.exists()) {
                packageDir.mkdirs();
            }
            return new File(packageDir, classFileName);
        }
        return new File(System.getProperty("user.dir"), classFileName);
    }

    private Generator(BatchEnvironment env, RemoteClass remoteClass, int version) throws ClassNotFound {
        this.env = env;
        this.remoteClass = remoteClass;
        this.version = version;
        this.remoteMethods = remoteClass.getRemoteMethods();
        this.remoteClassName = remoteClass.getName();
        this.agentClassName = Names.agentFor(this.remoteClassName);
        this.containerClassName = Names.containerFor(this.remoteClassName);
        this.interfaceClassName = Names.interfaceFor(this.remoteClassName);
        this.methodFieldNames = Generator.nameMethodFields(this.remoteMethods);
        this.defException = env.getClassDeclaration(idJavaLangException).getClassDefinition((Environment)env);
        this.defRemoteException = env.getClassDeclaration(idRemoteException).getClassDefinition((Environment)env);
        this.defRuntimeException = env.getClassDeclaration(idJavaLangRuntimeException).getClassDefinition((Environment)env);
    }

    private void writeAgent(IndentingWriter p) throws IOException {
        int i;
        p.pln("// Agent class generated by SMC's rmic1.2, do not edit.");
        p.pln();
        if (this.remoteClassName.isQualified()) {
            p.pln("package " + this.remoteClassName.getQualifier() + ";");
            p.pln();
        }
        p.plnI("public final class " + Names.mangleClass(this.agentClassName.getName()));
        p.pln("extends com.sun.management.viperimpl.ServiceAgent");
        ClassDefinition[] remoteInterfaces = this.remoteClass.getRemoteInterfaces();
        if (remoteInterfaces.length > 0) {
            p.p("implements ");
            for (i = 0; i < remoteInterfaces.length; ++i) {
                if (i > 0) {
                    p.p(", ");
                }
                p.p(remoteInterfaces[i].getName().toString());
            }
            p.pln();
        }
        p.pOlnI("{");
        this.writeAgentConstructors(p);
        p.pln();
        if (this.remoteMethods.length > 0) {
            p.pln("// methods from remote interfaces");
            for (i = 0; i < this.remoteMethods.length; ++i) {
                p.pln();
                this.writeAgentMethod(p, i);
            }
        }
        p.pOln("}");
    }

    private void writeAgentConstructors(IndentingWriter p) throws IOException {
        p.pln("// constructors");
        p.plnI("public " + Names.mangleClass(this.agentClassName.getName()) + "() {");
        p.pln("super();");
        p.pOln("}");
    }

    private void writeAgentMethod(IndentingWriter p, int opnum) throws IOException {
        int i;
        RemoteClass.Method method = this.remoteMethods[opnum];
        Identifier methodName = method.getName();
        Type methodType = method.getType();
        Type[] paramTypes = methodType.getArgumentTypes();
        String[] paramNames = Generator.nameParameters(paramTypes);
        Type returnType = methodType.getReturnType();
        ClassDeclaration[] exceptions = method.getExceptions();
        p.pln("// attach security token to " + methodType.typeString(methodName.toString(), true, false));
        p.p("public " + returnType + " " + methodName + "(");
        for (int i2 = 0; i2 < paramTypes.length; ++i2) {
            if (i2 > 0) {
                p.p(", ");
            }
            p.p(paramTypes[i2] + " " + paramNames[i2]);
        }
        p.plnI(")");
        boolean catchAME = true;
        String[] superAMEClasses = new String[]{"java.lang.Exception", "com.sun.management.viper.VException", "com.sun.management.viper.services.AuthenticationException", "com.sun.management.viper.services.AuthenticationMessageException"};
        if (exceptions.length > 0) {
            p.p("throws ");
            block1: for (i = 0; i < exceptions.length; ++i) {
                if (i > 0) {
                    p.p(", ");
                }
                p.p(exceptions[i].getName().toString());
                for (int w = 0; w < superAMEClasses.length; ++w) {
                    if (!exceptions[i].getName().toString().equals(superAMEClasses[w])) continue;
                    catchAME = false;
                    continue block1;
                }
            }
            p.pln();
        }
        p.pOlnI("{");
        if (catchAME) {
            p.plnI("try {");
        }
        p.p("Object [] paramArray = { ");
        for (i = 0; i < paramTypes.length; ++i) {
            if (i > 0) {
                p.p(", ");
            }
            p.p(Generator.wrapArgumentCode(paramTypes[i], paramNames[i]));
        }
        p.pln(" };");
        if (!returnType.isType(11)) {
            p.p("return ");
        }
        p.p("((" + Names.mangleClass(this.interfaceClassName.getName()) + ")containerStub)." + methodName + "(getMessageToken(paramArray)");
        for (i = 0; i < paramTypes.length; ++i) {
            p.p(", ");
            p.p(paramNames[i]);
        }
        p.pln(");");
        if (catchAME) {
            p.pOlnI("} catch (com.sun.management.viper.services.AuthenticationException e) {");
            p.pln("throw new java.rmi.RemoteException(e.getLocalizedMessage(java.util.Locale.getDefault()), e);");
            p.pOln("}");
        }
        p.pOln("}");
    }

    private void writeInterface(IndentingWriter p) throws IOException {
        p.pln("// Remote interface of Container generated by SMC rmic1.2, do not edit.");
        p.pln();
        if (this.remoteClassName.isQualified()) {
            p.pln("package " + this.remoteClassName.getQualifier() + ";");
            p.pln();
        }
        p.plnI("public interface " + Names.mangleClass(this.interfaceClassName.getName()));
        p.pln("extends java.rmi.Remote");
        p.pOlnI("{");
        if (this.remoteMethods.length > 0) {
            p.pln("// secured methods from remote interfaces");
            for (int i = 0; i < this.remoteMethods.length; ++i) {
                p.pln();
                this.writeInterfaceMethod(p, i);
            }
        }
        p.pOln("}");
    }

    private void writeInterfaceMethod(IndentingWriter p, int opnum) throws IOException {
        int i;
        RemoteClass.Method method = this.remoteMethods[opnum];
        Identifier methodName = method.getName();
        Type methodType = method.getType();
        Type[] paramTypes = methodType.getArgumentTypes();
        String[] paramNames = Generator.nameParameters(paramTypes);
        Type returnType = methodType.getReturnType();
        ClassDeclaration[] exceptions = method.getExceptions();
        p.pln("// secured version of " + methodType.typeString(methodName.toString(), true, false));
        p.p("public " + returnType + " " + methodName + "(com.sun.management.viperimpl.services.authentication.SecurityToken  $extra_param_1");
        for (i = 0; i < paramTypes.length; ++i) {
            p.p(", ");
            p.p(paramTypes[i] + " " + paramNames[i]);
        }
        p.p(")");
        p.plnI(" ");
        p.p("throws com.sun.management.viper.services.AuthenticationException");
        if (exceptions.length > 0) {
            for (i = 0; i < exceptions.length; ++i) {
                p.p(", ");
                p.p(exceptions[i].getName().toString());
            }
        }
        p.pOln(";");
    }

    private void writeContainer(IndentingWriter p) throws IOException {
        p.pln("// Container class generated by SMC rmic1.2, do not edit.");
        p.pln();
        if (this.remoteClassName.isQualified()) {
            p.pln("package " + this.remoteClassName.getQualifier() + ";");
            p.pln();
        }
        p.plnI("public final class " + Names.mangleClass(this.containerClassName.getName()));
        p.pln("extends com.sun.management.viperimpl.UnicastContainer");
        ClassDefinition[] remoteInterfaces = this.remoteClass.getRemoteInterfaces();
        if (remoteInterfaces.length > 0) {
            p.pln("implements " + Names.mangleClass(this.interfaceClassName.getName()));
        }
        p.pOlnI("{");
        this.writeOperationsArray(p);
        p.pln();
        if (this.version == 2 || this.version == 3) {
            p.pln("private static final long serialVersionUID = 2;");
            p.pln();
        }
        this.writeContainerConstructors(p);
        p.pln();
        if (this.remoteMethods.length > 0) {
            p.pln("// methods from remote interfaces");
            for (int i = 0; i < this.remoteMethods.length; ++i) {
                p.pln();
                this.writeContainerMethod(p, i);
            }
        }
        p.pOln("}");
    }

    private void writeContainerConstructors(IndentingWriter p) throws IOException {
        p.pln("// local reference to service bean object so doPrivileged() uses");
        p.pln(this.remoteClassName.getName() + " servicebean = null;");
        p.pln();
        p.pln("// constructors");
        p.plnI("public " + Names.mangleClass(this.containerClassName.getName()) + "() throws java.rmi.RemoteException {");
        p.plnI("super();");
        p.pOlnI("try {");
        p.p("bean = (com.sun.management.viper.ServiceProvider)java.beans.Beans.instantiate(getClass().getClassLoader(), ");
        p.pln("\"" + this.remoteClassName.getTopName() + "\");");
        p.pln("servicebean = (" + this.remoteClassName.getName() + ") bean;");
        p.pOlnI("} catch( Exception be ) {");
        p.pln("be.printStackTrace();");
        p.pOln("}");
        p.pOln("}");
    }

    private void writeContainerMethod(IndentingWriter p, int opnum) throws IOException {
        int i;
        int i2;
        RemoteClass.Method method = this.remoteMethods[opnum];
        Identifier methodName = method.getName();
        Type methodType = method.getType();
        Type[] paramTypes = methodType.getArgumentTypes();
        String[] paramNames = Generator.nameParameters(paramTypes);
        Type returnType = methodType.getReturnType();
        ClassDeclaration[] exceptions = method.getExceptions();
        p.pOlnI("// secured implementation of " + methodType.typeString(methodName.toString(), true, false));
        p.p("public " + returnType + " " + methodName + "(com.sun.management.viperimpl.services.authentication.SecurityToken $extra_param_1");
        for (i2 = 0; i2 < paramTypes.length; ++i2) {
            p.p(", final ");
            p.p(paramTypes[i2] + " " + paramNames[i2]);
        }
        p.plnI(")");
        p.p("throws com.sun.management.viper.services.AuthenticationException");
        for (i2 = 0; i2 < exceptions.length; ++i2) {
            p.p(", ");
            p.p(exceptions[i2].getName().toString());
        }
        p.pln();
        p.pOlnI("{");
        p.p("Object [] paramArray = { ");
        for (i2 = 0; i2 < paramTypes.length; ++i2) {
            if (i2 > 0) {
                p.p(", ");
            }
            p.p(Generator.wrapArgumentCode(paramTypes[i2], paramNames[i2]));
        }
        p.pln(" };");
        p.pln("java.security.AccessControlContext $acc_object_1 = getContext($extra_param_1, paramArray);");
        p.plnI("try {");
        p.pln("Object $result_object_1 = java.security.AccessController.doPrivileged(");
        p.plnI("new java.security.PrivilegedExceptionAction() {");
        p.p("public Object run() throws ");
        for (i2 = 0; i2 < exceptions.length; ++i2) {
            if (i2 > 0) {
                p.p(", ");
            }
            p.p(exceptions[i2].getName().toString());
        }
        p.pln();
        p.plnI("{");
        String callStatement = "servicebean." + methodName + "(";
        for (i = 0; i < paramTypes.length; ++i) {
            if (i > 0) {
                callStatement = callStatement + ", ";
            }
            callStatement = callStatement + paramNames[i];
        }
        callStatement = callStatement + ")";
        if (returnType.isType(11)) {
            p.p(callStatement);
            p.pln(";");
            p.pln("return null;");
        } else {
            p.p("return ");
            p.p(Generator.wrapArgumentCode(returnType, callStatement));
            p.pln(";");
        }
        p.pOln("}");
        p.pOln("}, $acc_object_1);");
        if (!returnType.isType(11)) {
            p.p("return ");
            p.p(Generator.unwrapArgumentCode(returnType, "$result_object_1"));
            p.pln(";");
        }
        p.pOlnI("} catch (java.security.PrivilegedActionException e) {");
        for (i = 0; i < exceptions.length; ++i) {
            p.pln("if (e.getException() instanceof " + exceptions[i].getName() + ")");
            p.pln("\tthrow (" + exceptions[i].getName() + ") e.getException();");
        }
        p.pln();
        p.pln("throw new java.rmi.ServerException(\"Runtime exception\", e.getException());");
        p.pOln("}");
        p.pOln("}");
    }

    private void writeOperationsArray(IndentingWriter p) throws IOException {
        p.plnI("private static final java.lang.String[] operations = {");
        for (int i = 0; i < this.remoteMethods.length; ++i) {
            if (i > 0) {
                p.pln(",");
            }
            p.p("\"" + this.formatMethod(this.remoteMethods[i].getOperationString()) + "\"");
        }
        p.pln();
        p.pOln("};");
        p.pln();
        p.plnI("public java.lang.String[] getRemoteOperations() {");
        p.pln("return operations;");
        p.pOln("}");
    }

    private String formatMethod(String operationString) {
        int i = operationString.indexOf(40);
        int j = operationString.substring(0, i).lastIndexOf(32);
        return this.remoteClassName.getTopName() + "." + operationString.substring(j + 1);
    }

    private void writeInterfaceHash(IndentingWriter p) throws IOException {
        p.pln("private static final long interfaceHash = " + this.remoteClass.getInterfaceHash() + "L;");
    }

    private void writeMethodFieldDeclarations(IndentingWriter p) throws IOException {
        for (int i = 0; i < this.methodFieldNames.length; ++i) {
            p.pln("private static java.lang.reflect.Method " + this.methodFieldNames[i] + ";");
        }
    }

    private void writeMethodFieldInitializers(IndentingWriter p) throws IOException {
        for (int i = 0; i < this.methodFieldNames.length; ++i) {
            p.p(this.methodFieldNames[i] + " = ");
            RemoteClass.Method method = this.remoteMethods[i];
            MemberDefinition def = method.getMemberDefinition();
            Identifier methodName = method.getName();
            Type methodType = method.getType();
            Type[] paramTypes = methodType.getArgumentTypes();
            p.p(def.getClassDefinition().getName() + ".class.getMethod(\"" + methodName + "\", new java.lang.Class[] {");
            for (int j = 0; j < paramTypes.length; ++j) {
                if (j > 0) {
                    p.p(", ");
                }
                p.p(paramTypes[j] + ".class");
            }
            p.pln("});");
        }
    }

    private static String[] nameMethodFields(RemoteClass.Method[] methods) {
        String[] names = new String[methods.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = "$method_" + methods[i].getName() + "_" + i;
        }
        return names;
    }

    private static String[] nameParameters(Type[] types) {
        String[] names = new String[types.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = "$param_" + Generator.generateNameFromType(types[i]) + "_" + (i + 1);
        }
        return names;
    }

    private static String generateNameFromType(Type type) {
        int typeCode = type.getTypeCode();
        switch (typeCode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return type.toString();
            }
            case 9: {
                return "arrayOf_" + Generator.generateNameFromType(type.getElementType());
            }
            case 10: {
                return Names.mangleClass(type.getClassName().getName()).toString();
            }
        }
        throw new Error("unexpected type code: " + typeCode);
    }

    private static void writeMarshalArgument(IndentingWriter p, String streamName, Type type, String name) throws IOException {
        int typeCode = type.getTypeCode();
        switch (typeCode) {
            case 0: {
                p.p(streamName + ".writeBoolean(" + name + ")");
                break;
            }
            case 1: {
                p.p(streamName + ".writeByte(" + name + ")");
                break;
            }
            case 2: {
                p.p(streamName + ".writeChar(" + name + ")");
                break;
            }
            case 3: {
                p.p(streamName + ".writeShort(" + name + ")");
                break;
            }
            case 4: {
                p.p(streamName + ".writeInt(" + name + ")");
                break;
            }
            case 5: {
                p.p(streamName + ".writeLong(" + name + ")");
                break;
            }
            case 6: {
                p.p(streamName + ".writeFloat(" + name + ")");
                break;
            }
            case 7: {
                p.p(streamName + ".writeDouble(" + name + ")");
                break;
            }
            case 9: 
            case 10: {
                p.p(streamName + ".writeObject(" + name + ")");
                break;
            }
            default: {
                throw new Error("unexpected type code: " + typeCode);
            }
        }
    }

    private static void writeMarshalArguments(IndentingWriter p, String streamName, Type[] types, String[] names) throws IOException {
        if (types.length != names.length) {
            throw new Error("paramter type and name arrays different sizes");
        }
        for (int i = 0; i < types.length; ++i) {
            Generator.writeMarshalArgument(p, streamName, types[i], names[i]);
            p.pln(";");
        }
    }

    private static boolean writeUnmarshalArgument(IndentingWriter p, String streamName, Type type, String name) throws IOException {
        boolean readObject = false;
        if (name != null) {
            p.p(name + " = ");
        }
        int typeCode = type.getTypeCode();
        switch (type.getTypeCode()) {
            case 0: {
                p.p(streamName + ".readBoolean()");
                break;
            }
            case 1: {
                p.p(streamName + ".readByte()");
                break;
            }
            case 2: {
                p.p(streamName + ".readChar()");
                break;
            }
            case 3: {
                p.p(streamName + ".readShort()");
                break;
            }
            case 4: {
                p.p(streamName + ".readInt()");
                break;
            }
            case 5: {
                p.p(streamName + ".readLong()");
                break;
            }
            case 6: {
                p.p(streamName + ".readFloat()");
                break;
            }
            case 7: {
                p.p(streamName + ".readDouble()");
                break;
            }
            case 9: 
            case 10: {
                p.p("(" + type + ") " + streamName + ".readObject()");
                readObject = true;
                break;
            }
            default: {
                throw new Error("unexpected type code: " + typeCode);
            }
        }
        return readObject;
    }

    private static boolean writeUnmarshalArguments(IndentingWriter p, String streamName, Type[] types, String[] names) throws IOException {
        if (types.length != names.length) {
            throw new Error("paramter type and name arrays different sizes");
        }
        boolean readObject = false;
        for (int i = 0; i < types.length; ++i) {
            if (Generator.writeUnmarshalArgument(p, streamName, types[i], names[i])) {
                readObject = true;
            }
            p.pln(";");
        }
        return readObject;
    }

    private static String wrapArgumentCode(Type type, String name) {
        int typeCode = type.getTypeCode();
        switch (typeCode) {
            case 0: {
                return "new java.lang.Boolean(" + name + ")";
            }
            case 1: {
                return "new java.lang.Byte(" + name + ")";
            }
            case 2: {
                return "new java.lang.Character(" + name + ")";
            }
            case 3: {
                return "new java.lang.Short(" + name + ")";
            }
            case 4: {
                return "new java.lang.Integer(" + name + ")";
            }
            case 5: {
                return "new java.lang.Long(" + name + ")";
            }
            case 6: {
                return "new java.lang.Float(" + name + ")";
            }
            case 7: {
                return "new java.lang.Double(" + name + ")";
            }
            case 9: 
            case 10: {
                return name;
            }
        }
        throw new Error("unexpected type code: " + typeCode);
    }

    private static String unwrapArgumentCode(Type type, String name) {
        int typeCode = type.getTypeCode();
        switch (typeCode) {
            case 0: {
                return "((java.lang.Boolean) " + name + ").booleanValue()";
            }
            case 1: {
                return "((java.lang.Byte) " + name + ").byteValue()";
            }
            case 2: {
                return "((java.lang.Character) " + name + ").charValue()";
            }
            case 3: {
                return "((java.lang.Short) " + name + ").shortValue()";
            }
            case 4: {
                return "((java.lang.Integer) " + name + ").intValue()";
            }
            case 5: {
                return "((java.lang.Long) " + name + ").longValue()";
            }
            case 6: {
                return "((java.lang.Float) " + name + ").floatValue()";
            }
            case 7: {
                return "((java.lang.Double) " + name + ").doubleValue()";
            }
            case 9: 
            case 10: {
                return "((" + type + ") " + name + ")";
            }
        }
        throw new Error("unexpected type code: " + typeCode);
    }
}

