/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.config;

import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.console.config.TaggedTextNode;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.NodeEx;
import com.sun.xml.tree.ParseContext;
import com.sun.xml.tree.XmlWriteContext;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class PropertiesNode
extends ElementNode {
    protected Properties properties = new Properties();
    private String key = null;

    public void doneChild(NodeEx n, ParseContext context) throws SAXException {
        super.doneChild(n, context);
        String childName = n.getNodeName();
        Node child = n.getFirstChild();
        String childValue = null;
        if (child != null) {
            childValue = child.getNodeValue();
        }
        try {
            if (childName.equals("Key")) {
                this.key = childValue;
            } else if (childName.equals("Value")) {
                this.properties.setProperty(this.key, childValue);
            }
        }
        catch (Exception e) {
            Debug.trace((String)"Configuration", (int)Debug.WARNING, (String)"Configuration error", (Throwable)e);
        }
    }

    public void writeXml(XmlWriteContext context) throws IOException {
        Writer w = context.getWriter();
        if (this.properties != null) {
            w.write("<Properties>");
            context.setIndentLevel(context.getIndentLevel() + 2);
            context.printIndent();
            Enumeration<?> e = this.properties.propertyNames();
            while (e != null && e.hasMoreElements()) {
                String key = (String)e.nextElement();
                w.write("<Key>" + key + "</Key> " + "<Value>" + this.properties.getProperty(key) + "</Value>");
                if (!e.hasMoreElements()) continue;
                context.printIndent();
            }
            context.setIndentLevel(context.getIndentLevel() - 2);
            context.printIndent();
            w.write("</Properties>");
        }
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        Node n;
        this.properties = properties;
        while ((n = this.getFirstChild()) != null) {
            this.removeChild(n);
        }
        Enumeration<?> en = properties.propertyNames();
        while (en != null && en.hasMoreElements()) {
            TaggedTextNode keyNode = new TaggedTextNode("Key");
            TaggedTextNode valNode = new TaggedTextNode("Value");
            this.appendChild((Node)((Object)keyNode));
            this.appendChild((Node)((Object)valNode));
            String key = (String)en.nextElement();
            String val = properties.getProperty(key);
            Document doc = this.getOwnerDocument();
            keyNode.appendChild(doc.createTextNode(key));
            keyNode.appendChild(doc.createTextNode(val));
        }
    }
}

