/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.config;

import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.console.config.BGImageNode;
import com.sun.management.viperimpl.console.config.VBaseNode;
import com.sun.management.viperimpl.console.config.VConfigurationNode;
import com.sun.xml.tree.NodeEx;
import com.sun.xml.tree.ParseContext;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class FolderNode
extends VBaseNode
implements VConfigurationNode {
    public FolderNode() {
        this.setTag("Folder");
        this.SLOT_NAME = 0;
        this.SLOT_DESCRIPTION = 1;
        this.SLOT_BGIMAGE = 2;
        this.SLOT_ICON = 3;
        this.SLOT_LARGEICON = 4;
        this.SLOT_SCOPE = 5;
        this.slots = new Node[6];
    }

    public void startParse(ParseContext context) throws SAXException {
        super.startParse(context);
        NamedNodeMap nnm = this.getAttributes();
        if (nnm == null) {
            return;
        }
        for (int i = 0; i < nnm.getLength(); ++i) {
            String attrName = nnm.item(i).getNodeName();
            String attrValue = nnm.item(i).getNodeValue();
            if (!attrName.equals("TreeDisplay")) continue;
            this.treeDisplay = this.isTrueValue(attrValue);
        }
    }

    public void doneChild(NodeEx n, ParseContext context) throws SAXException {
        super.doneChild(n, context);
        String childName = n.getNodeName();
        String childValue = n.getFirstChild().getNodeValue();
        try {
            if (childName.equals("Name")) {
                this.name = childValue;
                this.slots[this.SLOT_NAME] = n;
            } else if (childName.equals("Description")) {
                this.description = childValue;
                this.slots[this.SLOT_DESCRIPTION] = n;
            } else if (childName.equals("Scope")) {
                this.scope = childValue;
                this.slots[this.SLOT_SCOPE] = n;
            } else if (childName.equals("Icon")) {
                this.smallIcon = childValue;
                this.slots[this.SLOT_ICON] = n;
            } else if (childName.equals("LargeIcon")) {
                this.largeIcon = childValue;
                this.slots[this.SLOT_LARGEICON] = n;
            } else if (childName.equals("BackgroundImage")) {
                this.bgImage = ((BGImageNode)n).getURL();
                this.bgImageLoc = ((BGImageNode)n).getLocation();
                this.slots[this.SLOT_BGIMAGE] = n;
            }
        }
        catch (Exception e) {
            Debug.trace((String)"Configuration", (int)Debug.WARNING, (String)"Configuration error", (Throwable)e);
        }
    }

    protected void printNode(int indent) {
        super.printNode(indent);
        String nindent = this.indent(indent + 1);
        System.out.println(nindent + "Description: " + this.description);
        System.out.println(nindent + "Small Icon: " + this.smallIcon);
        System.out.println(nindent + "Large Icon: " + this.largeIcon);
        System.out.println(nindent + (this.treeDisplay ? "Displayed in Nav Panel" : "Hidden from Nav Panel"));
    }
}

