/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.common;

import com.sun.cns.authentication.CMDExecutionException;
import com.sun.cns.authentication.CSMAuthenticator;
import com.sun.cns.authentication.NotAuthenticatedException;
import com.sun.swup.client.common.ExecuteCommand;
import com.sun.swup.client.common.I18NHelper;
import com.sun.swup.client.common.InformationDialog;
import com.sun.swup.client.common.UMData;
import com.sun.swup.client.common.UpdateMgrProperties;
import com.sun.swup.client.common.WebClientException;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class UpdateMgrUtil {
    public static I18NHelper I18N = new I18NHelper(class$com$sun$swup$client$common$UpdateMgrUtil == null ? (class$com$sun$swup$client$common$UpdateMgrUtil = UpdateMgrUtil.class$("com.sun.swup.client.common.UpdateMgrUtil")) : class$com$sun$swup$client$common$UpdateMgrUtil, "resources/strings/application");
    private static UpdateMgrProperties properties = null;
    private static UpdateMgrUtil updateUtil = null;
    private static String encodedFileName;
    private static String stagedUpdatesData;
    static /* synthetic */ Class class$com$sun$swup$client$common$UpdateMgrUtil;

    private UpdateMgrUtil() {
        try {
            properties = UpdateMgrProperties.getInstance();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static UpdateMgrUtil getInstance() {
        if (updateUtil == null) {
            updateUtil = new UpdateMgrUtil();
        }
        return updateUtil;
    }

    public String getStoredDataLocation() {
        String location = null;
        if (properties != null) {
            location = properties.getProperty("analysis-data-directory");
        }
        return location;
    }

    public File getStoredDataFile(String name) {
        String directory = this.getStoredDataLocation();
        if (directory == null) {
            return null;
        }
        encodedFileName = this.getEncodedFileName(name);
        if (encodedFileName == null) {
            return null;
        }
        return new File(directory, encodedFileName);
    }

    public synchronized String getEncodedFileName(String name) {
        encodedFileName = null;
        String source = "";
        int result = -1;
        if (UMData.getDebug()) {
            System.out.println("UpdateMgrUtils.getEncodedFileName(): /usr/sbin/smpatch get patchpro.patch.source");
        }
        if ((encodedFileName = UMData.getEncodedFileName()) != null) {
            return encodedFileName;
        }
        ExecuteCommand cmd = new ExecuteCommand("/usr/sbin/smpatch get patchpro.patch.source");
        cmd.setCollectOutput(true);
        cmd.setOutputType(1);
        try {
            cmd.execute();
            source = cmd.getOutput();
            result = cmd.getResult();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (result == 0 && source != null && source.length() > 0) {
            if (UMData.getDebug()) {
                System.out.println("UpdateMgrUtils- patch source: " + source);
            }
        } else {
            if (UMData.getDebug()) {
                System.out.println("UpdateMgrUtils- patch source: returning null");
            }
            return null;
        }
        UMData.setCurrentPatchSource(source);
        String rawFileName = source + File.separator + name;
        try {
            encodedFileName = URLEncoder.encode(rawFileName, "UTF-8");
        }
        catch (UnsupportedEncodingException ue) {
            encodedFileName = rawFileName;
        }
        UMData.setEncodedFileName(encodedFileName);
        return encodedFileName;
    }

    public Properties getStagedUpdatesProps() {
        Properties stagedUpdatesProps = null;
        try {
            FileInputStream in = new FileInputStream(stagedUpdatesData);
            stagedUpdatesProps = new Properties();
            stagedUpdatesProps.load(in);
            in.close();
        }
        catch (FileNotFoundException fnotex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stagedUpdatesProps;
    }

    public static void enableAutoAnalysis() throws CMDExecutionException {
        Vector<String> args = new Vector<String>();
        args.add("changeAutoAnalysis");
        args.add("enable");
        try {
            CSMAuthenticator.getInstance().runCMD("/usr/lib/patch/changeAutoAnalysis", args);
        }
        catch (NotAuthenticatedException nae) {
            nae.printStackTrace();
        }
    }

    public static void disableAutoAnalysis() throws CMDExecutionException {
        Vector<String> args = new Vector<String>();
        args.add("changeAutoAnalysis");
        args.add("disable");
        try {
            CSMAuthenticator.getInstance().runCMD("/usr/lib/patch/changeAutoAnalysis", args);
        }
        catch (NotAuthenticatedException nae) {
            nae.printStackTrace();
        }
    }

    public static String insertNewlines(String message, int lineLength) {
        if (message == null) {
            return null;
        }
        String theMessage = message.replace('\n', ' ');
        for (int index = lineLength; index < theMessage.length() && (index = theMessage.indexOf(32, index)) != -1; index += lineLength) {
            String temp = theMessage.substring(index, theMessage.length());
            theMessage = theMessage.substring(0, index);
            theMessage = theMessage + temp.replaceFirst(" ", "\n");
        }
        return theMessage;
    }

    public void launchWebClient(JFrame frame, String url) {
        new WebClientThread("sdtwebclient", frame, url).start();
    }

    public static String getHostName() {
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            hostname = "";
        }
        return hostname;
    }

    public static void centerOverFrame(JDialog dialog, JFrame parentFrame) {
        double iX = parentFrame.getLocation().getX() + (double)((parentFrame.getSize().width - dialog.getSize().width) / 2);
        double iY = parentFrame.getLocation().getY() + (double)((parentFrame.getSize().height - dialog.getSize().height) / 6);
        dialog.setLocation((int)iX, (int)iY);
    }

    public static void centerOverScreen(Window window) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        double iX = (d.width - window.getSize().width) / 2;
        double iY = (d.height - window.getSize().height) / 6;
        window.setLocation((int)iX, (int)iY);
    }

    public static boolean isAnalyzeOutputValid(String output) {
        boolean result = false;
        if (output.equals("")) {
            result = true;
        } else {
            Pattern p = Pattern.compile("[0-9][0-9][0-9][0-9][0-9][0-9]-[0-9][0-9].id=[0-9][0-9][0-9][0-9][0-9][0-9]-[0-9][0-9]");
            StringTokenizer st = new StringTokenizer(output, "\n");
            while (st.hasMoreTokens()) {
                Matcher m = p.matcher(st.nextToken());
                if (!m.matches()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static boolean isRunningInGlobalZone() {
        String zoneName;
        File zoneNameFile = new File("/usr/bin/zonename");
        if (!zoneNameFile.exists()) {
            return true;
        }
        ExecuteCommand cmd = new ExecuteCommand("/usr/bin/zonename");
        cmd.setCollectOutput(true);
        cmd.setOutputType(1);
        try {
            cmd.execute();
            zoneName = cmd.getOutput();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
            return false;
        }
        return zoneName != null && zoneName.trim().equals("global");
    }

    public static String getCollectionName() {
        int result = -1;
        if (UMData.getDebug()) {
            System.out.println("entering getCollectionName()");
        }
        ExecuteCommand ec = new ExecuteCommand("/usr/sbin/smpatch get patchpro.patchset");
        ec.setCollectOutput(true);
        try {
            ec.execute();
            result = ec.getResult();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
            return null;
        }
        String cmdOutput = ec.getAllOutput();
        if (result != 0) {
            return null;
        }
        String colName = cmdOutput.trim();
        if (UMData.getDebug()) {
            System.out.println("getCollectionName(): smpatch returns colName=" + colName + "|");
        }
        return colName;
    }

    public static boolean newAnalysisRequired() {
        File analysisFile;
        boolean needAnalysis = true;
        String patchSet = UMData.getCurrentPatchset();
        if (patchSet == null) {
            patchSet = UpdateMgrUtil.getCollectionName();
            UMData.setCurrentPatchset(patchSet);
        }
        if ((analysisFile = UpdateMgrUtil.getInstance().getStoredDataFile(patchSet)) == null || !analysisFile.exists()) {
            return needAnalysis;
        }
        File contentsFile = new File("/var/sadm/install/contents");
        if (contentsFile.exists()) {
            long lastAnalysisModified = analysisFile.lastModified();
            long lastContentsModified = contentsFile.lastModified();
            if (lastContentsModified < lastAnalysisModified) {
                needAnalysis = false;
            }
        }
        if (UMData.getDebug()) {
            System.out.println("Do we need a new analysis: " + needAnalysis);
        }
        return needAnalysis;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        stagedUpdatesData = "/var/sadm/spool/disallowed_patch_list";
    }

    class WebClientThread
    extends Thread {
        String url;
        InformationDialog infoDialog;
        JFrame frame;

        public WebClientThread(String str, JFrame frame, String url) {
            super(str);
            this.url = url;
            this.infoDialog = this.infoDialog;
            this.frame = frame;
        }

        public void run() {
            try {
                String title = I18N.getString("web-client-info-title");
                String message = I18N.getString("web-client-info-message");
                this.infoDialog = new InformationDialog(this.frame, title, this.url, message);
                if (this.frame == null) {
                    UpdateMgrUtil.centerOverScreen(this.infoDialog);
                } else {
                    UpdateMgrUtil.centerOverFrame(this.infoDialog, this.frame);
                }
                this.infoDialog.setVisible(true);
                this.launchWebClient();
            }
            catch (WebClientException wcex) {
                String title = I18N.getString("webclient-error-title");
                String msg = wcex.getLocalizedMessage();
                JOptionPane.showMessageDialog(null, msg, title, 2);
            }
        }

        public void launchWebClient() throws WebClientException {
            String webClientPropVal = null;
            try {
                webClientPropVal = UpdateMgrProperties.getInstance().getProperty("WebClient");
            }
            catch (IOException ioex) {
                String msg = I18N.getString("web-client-read-error");
                throw new WebClientException(msg, ioex, 3);
            }
            if (webClientPropVal == null) {
                String msg = I18N.getString("web-client-not-set");
                throw new WebClientException(msg, 1);
            }
            Object[] args = new Object[]{this.url};
            MessageFormat msgFmt = new MessageFormat(webClientPropVal);
            String webClient = MessageFormat.format(webClientPropVal, args);
            ExecuteCommand ec = new ExecuteCommand(webClient);
            ec.setCollectOutput(false);
            try {
                ec.execute();
            }
            catch (InterruptedException ie) {
                String msg = I18N.getString("web-client-exec-error");
                throw new WebClientException(msg, ie, 4);
            }
            this.infoDialog.setVisible(false);
            int retStatus = ec.getResult();
            if (retStatus == 2) {
                String msg = I18N.getString("web-client-not-found");
                throw new WebClientException(msg, 2);
            }
        }
    }
}

