/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.swup.client.common.UMData;
import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.DependenciesDialog;
import com.sun.swup.client.ui.Dependency;
import com.sun.swup.client.ui.InstallDialog;
import com.sun.swup.client.ui.InstallSummaryDialog;
import com.sun.swup.client.ui.InstalledTable;
import com.sun.swup.client.ui.InstalledTableModel;
import com.sun.swup.client.ui.UninstallDialog;
import com.sun.swup.client.ui.UninstallSummaryDialog;
import com.sun.swup.client.ui.UpdateFrame;
import com.sun.swup.client.ui.UpdateUtility;
import com.sun.swup.client.ui.foundation.Utility;
import java.lang.ref.WeakReference;
import javax.swing.JFrame;

class UpdateDelegate {
    private WeakReference updateFrame;
    private boolean bAuthenticationResolved = false;
    private boolean bDependenciesResolved = false;
    private Update[] aInstallUpdates;
    private Update[] aUninstallUpdates;
    private Update[] aInstallSummaryUpdates;
    private Update[] aUninstallSummaryUpdates;
    private Dependency[] aInstallDependency;
    private Dependency[] aUninstallDependency;
    private InstallDialog installDialog;
    private UninstallDialog uninstallDialog;
    private InstallSummaryDialog installSummaryDialog;
    private UninstallSummaryDialog uninstallSummaryDialog;
    private int dependencyType;

    UpdateDelegate(UpdateFrame updateFrame) {
        this.setUpdateFrame(updateFrame);
    }

    void install() {
        this.setDependencyType(1);
        if (!this.isDependenciesResolved()) {
            Update[] aUpdate = Application.getInstance().getUpdateFrame().getDelegate().getInstallUpdates();
            if (UpdateUtility.getDependentUpdates(aUpdate, 1).length > 0) {
                this.displayDependenciesDialog();
            } else {
                this.setDependenciesResolved(true);
                this.install();
            }
        } else {
            this.displayInstallDialog();
        }
    }

    void uninstall() {
        if (UMData.getDebug()) {
            System.out.println("uninstall");
        }
        this.setDependencyType(2);
        InstalledTable iTable = Application.getInstance().getUpdateFrame().getInstalledPanel().getTable();
        InstalledTableModel iTableModel = (InstalledTableModel)iTable.getModel();
        Update[] checkedUpdates = iTableModel.getCheckedUpdates();
        if (!this.isDependenciesResolved()) {
            if (checkedUpdates.length > 0) {
                this.displayDependenciesDialog();
            } else {
                this.setDependenciesResolved(true);
                this.uninstall();
            }
        } else {
            this.displayUninstallDialog();
        }
    }

    private void displayDependenciesDialog() {
        DependenciesDialog dependenciesDialog = new DependenciesDialog(this.getUpdateFrame());
        Utility.centerOverFrame(dependenciesDialog, (JFrame)this.getUpdateFrame());
        dependenciesDialog.setVisible(true);
    }

    private void displayInstallDialog() {
        this.setDependenciesResolved(false);
        this.installDialog = new InstallDialog(this.getUpdateFrame());
        Utility.centerOverFrame(this.installDialog, (JFrame)this.getUpdateFrame());
        this.installDialog.beginInstall();
    }

    public void displayInstallSummaryDialog() {
        this.installSummaryDialog = new InstallSummaryDialog(this.getUpdateFrame());
        Utility.centerOverFrame(this.installSummaryDialog, (JFrame)this.getUpdateFrame());
        this.installSummaryDialog.setVisible(true);
    }

    public void displayUninstallSummaryDialog() {
        this.uninstallSummaryDialog = new UninstallSummaryDialog(this.getUpdateFrame());
        Utility.centerOverFrame(this.uninstallSummaryDialog, (JFrame)this.getUpdateFrame());
        this.uninstallSummaryDialog.setVisible(true);
    }

    public boolean isInstallDialogVisible() {
        if (this.installDialog != null) {
            return this.installDialog.isVisible();
        }
        return false;
    }

    public InstallDialog getInstallDialog() {
        return this.installDialog;
    }

    private void displayUninstallDialog() {
        if (UMData.getDebug()) {
            System.out.println("displayUninstallDialog");
        }
        this.setDependenciesResolved(false);
        this.uninstallDialog = new UninstallDialog(this.getUpdateFrame());
        Utility.centerOverFrame(this.uninstallDialog, (JFrame)this.getUpdateFrame());
        this.uninstallDialog.beginUninstall();
    }

    public boolean isUninstallDialogVisible() {
        if (this.uninstallDialog != null) {
            return this.uninstallDialog.isVisible();
        }
        return false;
    }

    public UninstallDialog getUninstallDialog() {
        return this.uninstallDialog;
    }

    void setDependenciesResolved(boolean bDependenciesResolved) {
        this.bDependenciesResolved = bDependenciesResolved;
    }

    boolean isDependenciesResolved() {
        return this.bDependenciesResolved;
    }

    void setInstallUpdates(Update[] aUpdate) {
        this.aInstallUpdates = aUpdate;
    }

    Update[] getInstallUpdates() {
        return this.aInstallUpdates;
    }

    void setInstallSummaryUpdates(Update[] aUpdate) {
        this.aInstallSummaryUpdates = aUpdate;
    }

    Update[] getInstallSummaryUpdates() {
        return this.aInstallSummaryUpdates;
    }

    void setUninstallSummaryUpdates(Update[] aUpdate) {
        this.aUninstallSummaryUpdates = aUpdate;
    }

    Update[] getUninstallSummaryUpdates() {
        return this.aUninstallSummaryUpdates;
    }

    void setInstallDependencies(Dependency[] aDependency) {
        this.aInstallDependency = aDependency;
    }

    Dependency[] getInstallDependencies() {
        return this.aInstallDependency;
    }

    void setUninstallUpdates(Update[] aUpdate) {
        this.aUninstallUpdates = aUpdate;
    }

    Update[] getUninstallUpdates() {
        return this.aUninstallUpdates;
    }

    void setUninstallDependencies(Dependency[] aDependency) {
        this.aUninstallDependency = aDependency;
    }

    Dependency[] getUninstallDependencies() {
        return this.aUninstallDependency;
    }

    private void setUpdateFrame(UpdateFrame updateFrame) {
        this.updateFrame = new WeakReference<UpdateFrame>(updateFrame);
    }

    private UpdateFrame getUpdateFrame() {
        return (UpdateFrame)this.updateFrame.get();
    }

    void setDependencyType(int dependencyType) {
        this.dependencyType = dependencyType;
    }

    int getDependencyType() {
        return this.dependencyType;
    }
}

