/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.swup.client.common.environment.Environment;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.UninstallDialog;
import com.sun.swup.client.ui.UpdateDelegate;
import com.sun.swup.client.ui.UpdateUtility;
import com.sun.swup.client.ui.foundation.Utility;
import com.sun.swup.client.ui.foundation.swing.InsetPanel;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

class UninstallPanel
extends InsetPanel {
    private static final int UNDEFINED = -1;
    private WeakReference uninstallDialog;
    private JLabel majorLabel;
    private JLabel minorLabel;
    private JProgressBar progressBar;
    private JLabel footerLabel;
    private JButton cancelButton;
    private InsetPanel footerPanel;
    private boolean isCanceled = false;
    private PropertyChangeListener propertyChangeListener;
    private String sUpdateName = "";
    private int iSecondsRemaining = -1;
    private int iKilobytesCompleted = -1;
    private int iKilobytesTotal = -1;
    private int iUpdateNumber = -1;
    private int iUpdateTotal = -1;
    private int iKilobytesRemaining = -1;

    UninstallPanel(UninstallDialog uninstallDialog) {
        this.setUninstallDialog(uninstallDialog);
        this.createComponents();
        this.createLayout();
        this.propertyChangeListener = new InstallPropertyChangeListener();
        this.setMajorLabel("  ");
        this.setProgressValue(0);
        this.setFooterLabel("  ");
        this.setUpdateName("");
        this.setUpdateNumber(0);
        this.setUpdateTotal(0);
        this.setSecondsRemaining(0);
        this.setKilobytesCompleted(0);
        this.setKilobytesTotal(0);
        this.setKilobytesRemaining(0);
    }

    JProgressBar getProgressBar() {
        return this.progressBar;
    }

    PropertyChangeListener getPropertyChangeListener() {
        return this.propertyChangeListener;
    }

    private void createComponents() {
        this.majorLabel = new JLabel();
        this.minorLabel = new JLabel();
        this.footerPanel = new InsetPanel();
        this.minorLabel.setFont(Utility.getReducedFont(this.minorLabel, "small-font-reduction"));
        this.progressBar = new JProgressBar();
        this.footerLabel = new JLabel();
        this.footerLabel.setFont(Utility.getReducedFont(this.footerLabel, "small-font-reduction"));
        this.cancelButton = new JButton(this.getUninstallDialog().getActionSet().getAction("cancel"));
        this.cancelButton.setMnemonic(UninstallDialog.I18N.getString("cancel.mnemonic").charAt(0));
    }

    private void createLayout() {
        this.setInsets(Environment.getInsets((String)"frame"));
        this.setLayout(new BoxLayout(this, 1));
        this.majorLabel.setHorizontalAlignment(2);
        this.majorLabel.setAlignmentX(0.0f);
        this.add(this.majorLabel);
        this.add(Box.createRigidArea(new Dimension(5, 5)));
        this.progressBar.setAlignmentX(0.0f);
        this.add(this.progressBar);
        this.add(Box.createRigidArea(new Dimension(5, 5)));
        this.footerPanel.setLayout(new BoxLayout(this.footerPanel, 0));
        this.footerPanel.setAlignmentX(0.0f);
        this.footerPanel.add(this.footerLabel);
        this.footerPanel.add(Box.createHorizontalGlue());
        this.footerPanel.add(this.cancelButton);
        this.add(this.footerPanel);
    }

    public void setMajorLabel(String text) {
        this.majorLabel.setText(text);
    }

    public void setFooterLabel(String text) {
        this.footerLabel.setText(text);
    }

    public void setProgressValue(int percent) {
        this.progressBar.setValue(percent);
    }

    private void setUpdateName(String sUpdateName) {
        this.sUpdateName = sUpdateName;
        this.refreshMajorLabel();
    }

    private void setUpdateNumber(int iUpdateNumber) {
        this.progressBar.getModel().setValue(iUpdateNumber);
        this.iUpdateNumber = iUpdateNumber;
        this.refreshFooterLabel();
    }

    private void setUpdateTotal(int iUpdateTotal) {
        this.iUpdateTotal = iUpdateTotal;
        this.refreshFooterLabel();
    }

    private void setSecondsRemaining(int iSecondsRemaining) {
        this.iSecondsRemaining = iSecondsRemaining;
        this.refreshMinorLabel();
    }

    private void setKilobytesCompleted(int iKilobytesCompleted) {
        this.iKilobytesCompleted = iKilobytesCompleted;
        this.refreshMinorLabel();
    }

    private void setKilobytesTotal(int iKilobytesTotal) {
        this.iKilobytesTotal = iKilobytesTotal;
        this.refreshMinorLabel();
    }

    private void setKilobytesRemaining(int iKilobytesRemaining) {
        this.iKilobytesRemaining = iKilobytesRemaining;
        this.refreshFooterLabel();
    }

    private void refreshMajorLabel() {
    }

    private void refreshMinorLabel() {
    }

    private void refreshFooterLabel() {
    }

    private String getSize(int iSize) {
        return UpdateUtility.getUpdateSizeDisplayString(new Integer(iSize));
    }

    private String getTimeRemaining() {
        String sString;
        int iSeconds = this.iSecondsRemaining;
        if (iSeconds < 60) {
            Object[] aObject = new Object[]{new Integer(iSeconds)};
            sString = iSeconds == 1 ? UninstallDialog.I18N.format("seconds-singular", aObject) : UninstallDialog.I18N.format("seconds-plural", aObject);
        } else {
            int iMinutes = iSeconds / 60;
            Object[] aObject = new Object[]{new Integer(iMinutes)};
            sString = iMinutes == 1 ? UninstallDialog.I18N.format("minutes-singular", aObject) : UninstallDialog.I18N.format("minutes-plural", aObject);
        }
        return sString;
    }

    private boolean isInitialized() {
        return !this.sUpdateName.equals("") && this.iSecondsRemaining != -1 && this.iKilobytesCompleted != -1 && this.iKilobytesTotal != -1 && this.iUpdateNumber != -1 && this.iUpdateTotal != -1 && this.iKilobytesRemaining != -1;
    }

    private void setUninstallDialog(UninstallDialog uninstallDialog) {
        this.uninstallDialog = new WeakReference<UninstallDialog>(uninstallDialog);
    }

    private UninstallDialog getUninstallDialog() {
        return (UninstallDialog)this.uninstallDialog.get();
    }

    public void setCancelFlag(boolean cancel) {
        this.isCanceled = cancel;
    }

    static /* synthetic */ boolean access$1100(UninstallPanel x0) {
        return x0.isInitialized();
    }

    class ProgressBarBoundedRangeModel
    extends DefaultBoundedRangeModel {
        ProgressBarBoundedRangeModel() {
        }
    }

    class InstallPropertyChangeListener
    implements PropertyChangeListener {
        private boolean bUninstallFinished = false;

        InstallPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            SwingUtilities.invokeLater(new Runnable(this, e){
                private final /* synthetic */ PropertyChangeEvent val$e;
                private final /* synthetic */ InstallPropertyChangeListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$e = val$e;
                }

                public void run() {
                    InstallPropertyChangeListener.access$000(this.this$1, this.val$e);
                }
            });
        }

        private void updateFields(PropertyChangeEvent e) {
            try {
                if (!UninstallPanel.this.isCanceled && e.getPropertyName().equals("update-name")) {
                    UninstallPanel.this.setUpdateName((String)e.getNewValue());
                } else if (!UninstallPanel.this.isCanceled && e.getPropertyName().equals("update-number")) {
                    UninstallPanel.this.setUpdateNumber((Integer)e.getNewValue());
                } else if (!UninstallPanel.this.isCanceled && e.getPropertyName().equals("update-total")) {
                    UninstallPanel.this.setUpdateTotal((Integer)e.getNewValue());
                } else if (!UninstallPanel.this.isCanceled && e.getPropertyName().equals("kilobytes-completed")) {
                    UninstallPanel.this.setKilobytesCompleted((Integer)e.getNewValue());
                } else if (!UninstallPanel.this.isCanceled && e.getPropertyName().equals("kilobytes-total")) {
                    UninstallPanel.this.setKilobytesTotal((Integer)e.getNewValue());
                } else if (!UninstallPanel.this.isCanceled && e.getPropertyName().equals("kilobytes-remaining")) {
                    UninstallPanel.this.setKilobytesRemaining((Integer)e.getNewValue());
                } else if (!UninstallPanel.this.isCanceled && e.getPropertyName().equals("seconds-remaining")) {
                    UninstallPanel.this.setSecondsRemaining((Integer)e.getNewValue());
                } else if (e.getPropertyName().equals("finished")) {
                    this.bUninstallFinished = true;
                    UninstallDialog uninstallDialog = UninstallPanel.this.getUninstallDialog();
                    uninstallDialog.refreshAvailableUpdates();
                    uninstallDialog.refreshInstalledUpdates();
                    uninstallDialog.setVisible(false);
                    uninstallDialog.dispose();
                    if (UninstallPanel.this.isCanceled) {
                        UninstallPanel.this.isCanceled = false;
                    }
                    UpdateDelegate ud = Application.getInstance().getUpdateFrame().getDelegate();
                    ud.displayUninstallSummaryDialog();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("error updating UninstallPanel UI: " + ex);
            }
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ InstallPropertyChangeListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    UninstallDialog uninstallDialog = UninstallPanel.access$900(InstallPropertyChangeListener.access$1000(this.this$1));
                    if (!uninstallDialog.isVisible() && !uninstallDialog.isAuthenticationNeeded() && UninstallPanel.access$1100(InstallPropertyChangeListener.access$1000(this.this$1)) && !InstallPropertyChangeListener.access$1200(this.this$1)) {
                        uninstallDialog.setVisible(true);
                    }
                }
            });
        }

        static /* synthetic */ void access$000(InstallPropertyChangeListener x0, PropertyChangeEvent x1) {
            x0.updateFields(x1);
        }

        static /* synthetic */ UninstallPanel access$1000(InstallPropertyChangeListener x0) {
            return x0.UninstallPanel.this;
        }

        static /* synthetic */ boolean access$1200(InstallPropertyChangeListener x0) {
            return x0.bUninstallFinished;
        }
    }
}

