/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.cns.authentication.CMDExecutionException;
import com.sun.swup.client.common.environment.Environment;
import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.InstallSummaryDialog;
import com.sun.swup.client.ui.InstallSummaryEditorPane;
import com.sun.swup.client.ui.UpdateDelegate;
import com.sun.swup.client.ui.foundation.Utility;
import com.sun.swup.client.ui.foundation.swing.GenericActionSet;
import com.sun.swup.client.ui.foundation.swing.InsetPanel;
import com.sun.swup.client.ui.foundation.swing.MessageTextArea;
import com.sun.swup.client.wrapper.PatchProWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

class InstallSummaryPanel
extends InsetPanel {
    private WeakReference installSummaryDialog;
    private JLabel processCompleteLabel;
    private JLabel failedInstallLabel;
    private JLabel downloadOnlyLabel;
    private JLabel restartRequiredLabel;
    private MessageTextArea failedInstallInfoTextArea;
    private MessageTextArea downloadOnlyInfoTextArea;
    private MessageTextArea restartRequiredInfoTextArea;
    private JScrollPane installSummaryScrollPane;
    private InstallSummaryEditorPane installSummaryEditorPane;
    private JButton okButton;
    private JCheckBox restartCheckBox;
    private boolean downloadOnlyType = false;
    private boolean failedInstallType = false;
    private boolean restartRequiredType = false;

    InstallSummaryPanel(InstallSummaryDialog installSummaryDialog) {
        this.setInstallSummaryDialog(installSummaryDialog);
        this.createComponents();
        this.createLayout();
    }

    InstallSummaryEditorPane getEditorPane() {
        return this.installSummaryEditorPane;
    }

    private void createComponents() {
        String sString;
        GenericActionSet actionSet = this.getInstallSummaryDialog().getActionSet();
        ImageIcon infoImageIcon = Environment.getImageIcon((String)"info_medium.gif");
        this.processCompleteLabel = new JLabel(InstallSummaryDialog.I18N.getString("process-complete"), infoImageIcon, 2);
        this.checkForUpdateTypes();
        int iReferenceWidth = this.getInstallSummaryDialog().getSize().width;
        if (this.downloadOnlyType) {
            ImageIcon downloadImageIcon = Environment.getImageIcon((String)"download-only.png");
            this.downloadOnlyLabel = new JLabel(InstallSummaryDialog.I18N.getString("download-only-manual-installation-required"), downloadImageIcon, 2);
            MessageFormat msgFmt = new MessageFormat(InstallSummaryDialog.I18N.getString("download-only-manual-installation-required-message"));
            String downloadDirectory = null;
            try {
                downloadDirectory = PatchProWrapper.getInstance().get("patchpro.download.directory");
            }
            catch (CMDExecutionException cmdex) {
                cmdex.printStackTrace();
            }
            Object[] msgArgs = new Object[]{downloadDirectory};
            sString = msgFmt.format(msgArgs);
            this.downloadOnlyInfoTextArea = new MessageTextArea(sString, iReferenceWidth);
            this.downloadOnlyInfoTextArea.setFont(Utility.getReducedFont(this, "small-font-reduction"));
            this.downloadOnlyInfoTextArea.setAlignmentX(0.0f);
        }
        if (this.restartRequiredType) {
            ImageIcon restartImageIcon = Environment.getImageIcon((String)"restart-required.png");
            this.restartRequiredLabel = new JLabel(InstallSummaryDialog.I18N.getString("restart-required-title"), restartImageIcon, 2);
            sString = InstallSummaryDialog.I18N.getString("installation-summary-restart-message");
            this.restartRequiredInfoTextArea = new MessageTextArea(sString, iReferenceWidth);
            this.restartRequiredInfoTextArea.setFont(Utility.getReducedFont(this, "small-font-reduction"));
            this.restartRequiredInfoTextArea.setAlignmentX(0.0f);
        }
        if (this.failedInstallType) {
            ImageIcon failedImageIcon = Environment.getImageIcon((String)"warning_medium.gif");
            this.failedInstallLabel = new JLabel(InstallSummaryDialog.I18N.getString("failed-installation"), failedImageIcon, 2);
            sString = InstallSummaryDialog.I18N.getString("failed-installation-message");
            this.failedInstallInfoTextArea = new MessageTextArea(sString, iReferenceWidth);
            this.failedInstallInfoTextArea.setFont(Utility.getReducedFont(this, "small-font-reduction"));
            this.failedInstallInfoTextArea.setAlignmentX(0.0f);
        }
        this.installSummaryEditorPane = new InstallSummaryEditorPane(this.getInstallSummaryDialog());
        this.installSummaryScrollPane = this.installSummaryEditorPane.getScrollPane();
        if (this.restartRequiredType) {
            this.getInstallSummaryDialog().setRestartUpdatesInstalled(true);
            this.restartCheckBox = new JCheckBox(actionSet.getAction("restart-system"));
            this.restartCheckBox.setMnemonic(InstallSummaryDialog.I18N.getString("restart-system-now.mnemonic").charAt(0));
        }
        this.okButton = new JButton(actionSet.getAction("ok"));
        this.okButton.setDefaultCapable(true);
        this.getInstallSummaryDialog().getRootPane().setDefaultButton(this.okButton);
        this.okButton.setMnemonic(InstallSummaryDialog.I18N.getString("ok.mnemonic").charAt(0));
    }

    private void createLayout() {
        InsetPanel headerPanel = new InsetPanel(new Insets(6, 6, 6, 6));
        headerPanel.setLayout(new BoxLayout(headerPanel, 1));
        headerPanel.setAlignmentY(0.0f);
        headerPanel.add(this.processCompleteLabel);
        headerPanel.add(Box.createRigidArea(Utility.VGAP10));
        if (this.failedInstallType) {
            headerPanel.add(this.failedInstallLabel);
            headerPanel.add(this.failedInstallInfoTextArea);
            headerPanel.add(Box.createRigidArea(Utility.VGAP10));
        }
        if (this.downloadOnlyType) {
            headerPanel.add(this.downloadOnlyLabel);
            headerPanel.add(this.downloadOnlyInfoTextArea);
            headerPanel.add(Box.createRigidArea(Utility.VGAP10));
        }
        if (this.restartRequiredType) {
            headerPanel.add(this.restartRequiredLabel);
            headerPanel.add(this.restartRequiredInfoTextArea);
            headerPanel.add(Box.createRigidArea(Utility.VGAP10));
        }
        InsetPanel footerPanel = new InsetPanel(new Insets(8, 0, 0, 0));
        footerPanel.setLayout(new BoxLayout(footerPanel, 0));
        if (this.restartRequiredType) {
            footerPanel.add(this.restartCheckBox);
        }
        footerPanel.add(Box.createHorizontalGlue());
        footerPanel.add(this.okButton);
        this.setInsets(new Insets(13, 13, 13, 13));
        this.setLayout(new BorderLayout());
        this.add((Component)headerPanel, "North");
        this.add((Component)this.installSummaryScrollPane, "Center");
        this.add((Component)footerPanel, "South");
    }

    private void checkForUpdateTypes() {
        UpdateDelegate ud = Application.getInstance().getUpdateFrame().getDelegate();
        Update[] aUpdates = ud.getInstallSummaryUpdates();
        for (int i = 0; i < aUpdates.length; ++i) {
            int us = aUpdates[i].getUpdateOperateStatus();
            if (us == 3) {
                this.downloadOnlyType = true;
                continue;
            }
            if (us == 2 || us == 4) {
                this.restartRequiredType = true;
                continue;
            }
            if (us != 1) continue;
            this.failedInstallType = true;
        }
    }

    private void setInstallSummaryDialog(InstallSummaryDialog installSummaryDialog) {
        this.installSummaryDialog = new WeakReference<InstallSummaryDialog>(installSummaryDialog);
    }

    private InstallSummaryDialog getInstallSummaryDialog() {
        return (InstallSummaryDialog)this.installSummaryDialog.get();
    }
}

