/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.cns.authentication.NotAuthenticatedException;
import com.sun.swup.client.common.LocalCache;
import com.sun.swup.client.common.UMData;
import com.sun.swup.client.engine.solaris.SolarisDataCollector;
import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.interfaces.UpdateCollection;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.AuthenticationManager;
import com.sun.swup.client.ui.AvailableComboBox;
import com.sun.swup.client.ui.AvailableComboBoxModel;
import com.sun.swup.client.ui.AvailableEditorPane;
import com.sun.swup.client.ui.AvailableTable;
import com.sun.swup.client.ui.AvailableTableModel;
import com.sun.swup.client.ui.CheckPanel;
import com.sun.swup.client.ui.DataController;
import com.sun.swup.client.ui.GatherDialog;
import com.sun.swup.client.ui.ManagedWidthButton;
import com.sun.swup.client.ui.SymbolPanel;
import com.sun.swup.client.ui.UpdateFrame;
import com.sun.swup.client.ui.foundation.Utility;
import com.sun.swup.client.ui.foundation.Worker;
import com.sun.swup.client.ui.foundation.WorkerEvent;
import com.sun.swup.client.ui.foundation.WorkerListener;
import com.sun.swup.client.ui.foundation.swing.GenericAction;
import com.sun.swup.client.ui.foundation.swing.GenericActionSet;
import com.sun.swup.client.ui.foundation.swing.InsetPanel;
import com.sun.swup.client.ui.foundation.swing.OrnamentTableHeader;
import com.sun.swup.client.ui.foundation.swing.SortedTableHeader;
import com.sun.swup.client.ui.foundation.swing.TabPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

class AvailablePanel
extends TabPanel {
    private WeakReference updateFrame;
    private JLabel messageLabel;
    private JLabel messageMarkedUpdatesLabel;
    private JLabel collectionLabel;
    private ComboBoxModel collectionComboBoxModel;
    private JComboBox collectionComboBox;
    private JPanel checkPanel;
    private SymbolPanel symbolPanel;
    private AvailableSplitPane availableSplitPane;
    private AvailableTable availableTable;
    private AvailableEditorPane availableEditorPane;
    private JButton installNowButton;
    private JButton checkForUpdatesButton;
    private JButton manageButton;
    private UpdateCollection updateCollection;
    private boolean bForceAnalysis = false;

    AvailablePanel(UpdateFrame updateFrame) {
        this.setUpdateFrame(updateFrame);
        this.getUpdateFrame().getActionSet().putAction("check-all", new CheckAllAction());
        this.getUpdateFrame().getActionSet().putAction("uncheck-all", new UncheckAllAction());
        this.getUpdateFrame().getActionSet().putAction("install-now", new InstallNowAction());
        this.getUpdateFrame().getActionSet().putAction("check-for-updates", new CheckForUpdatesAction());
        this.createComponents();
        this.createLayout();
        AbstractTableModel model = (AbstractTableModel)this.availableTable.getModel();
        model.addTableModelListener(new AvailableTableModelListener());
        model.fireTableDataChanged();
    }

    JComboBox getComboBox() {
        return this.collectionComboBox;
    }

    AvailableTable getTable() {
        return this.availableTable;
    }

    AvailableEditorPane getEditorPane() {
        return this.availableEditorPane;
    }

    void gatherUpdates() {
        GatherUpdatesAction action = new GatherUpdatesAction();
        ActionEvent e = new ActionEvent(this, 1001, null);
        action.actionPerformed(e);
    }

    private void createComponents() {
        this.messageLabel = new JLabel(" ");
        this.messageMarkedUpdatesLabel = new JLabel(UpdateFrame.I18N.getString("available-available-updates-marked-message"));
        this.messageMarkedUpdatesLabel.setFont(Utility.getReducedFont(this.messageMarkedUpdatesLabel, "small-font-reduction"));
        this.collectionLabel = new JLabel(UpdateFrame.I18N.getString("available-view-update-collection"));
        this.collectionLabel.setHorizontalAlignment(2);
        this.collectionLabel.setAlignmentX(0.0f);
        this.collectionLabel.setDisplayedMnemonic(UpdateFrame.I18N.getString("available-update-collection.mnemonic").charAt(0));
        this.collectionComboBoxModel = new AvailableComboBoxModel();
        this.collectionComboBox = new AvailableComboBox(this.collectionComboBoxModel);
        this.collectionComboBox.setOpaque(false);
        this.collectionComboBox.addItemListener(new AvailableComboBoxItemListener());
        this.collectionComboBox.getAccessibleContext().setAccessibleName(UpdateFrame.I18N.getString("available-view-update-collection"));
        this.collectionComboBox.getAccessibleContext().setAccessibleDescription(UpdateFrame.I18N.getString("available-update-collection-description"));
        this.collectionLabel.setLabelFor(this.collectionComboBox);
        Action checkAllAction = this.getUpdateFrame().getActionSet().getAction("check-all");
        Action uncheckAllAction = this.getUpdateFrame().getActionSet().getAction("uncheck-all");
        this.checkPanel = new CheckPanel(checkAllAction, uncheckAllAction);
        this.symbolPanel = new SymbolPanel();
        this.symbolPanel.addLabel("available-restart-required", "restart-required.png");
        this.symbolPanel.addLabel("available-download-only", "download-only.png");
        this.availableSplitPane = new AvailableSplitPane();
        GenericActionSet actionSet = this.getUpdateFrame().getActionSet();
        this.installNowButton = new ManagedWidthButton(actionSet.getAction("install-now"));
        ((ManagedWidthButton)this.installNowButton).setBestWidth(this.installNowButton.getPreferredSize().width);
        this.installNowButton.setOpaque(false);
        this.installNowButton.setDefaultCapable(true);
        this.setDefaultButton(this.installNowButton);
        this.installNowButton.setMnemonic(UpdateFrame.I18N.getString("available-install-now.mnemonic").charAt(0));
        this.getUpdateFrame().getRootPane().setDefaultButton(this.installNowButton);
        this.checkForUpdatesButton = new JButton(actionSet.getAction("check-for-updates"));
        this.checkForUpdatesButton.setOpaque(false);
        this.checkForUpdatesButton.setMnemonic(UpdateFrame.I18N.getString("available-check-for-updates.mnemonic").charAt(0));
        this.manageButton = Utility.createLinkStyleButton(actionSet.getAction("manage-at-portal"));
    }

    private void createLayout() {
        this.messageLabel.setHorizontalAlignment(2);
        this.messageLabel.setAlignmentX(0.0f);
        this.messageMarkedUpdatesLabel.setHorizontalAlignment(2);
        this.messageMarkedUpdatesLabel.setAlignmentX(0.0f);
        InsetPanel headerPanel = new InsetPanel(new Insets(6, 6, 6, 6));
        headerPanel.setLayout(new BoxLayout(headerPanel, 1));
        headerPanel.add(this.messageLabel);
        headerPanel.add(Box.createRigidArea(new Dimension(1, 3)));
        InsetPanel innerPanel = new InsetPanel();
        innerPanel.setLayout(new BoxLayout(innerPanel, 0));
        innerPanel.add(this.messageMarkedUpdatesLabel);
        innerPanel.add(Box.createHorizontalGlue());
        innerPanel.add(this.collectionLabel);
        innerPanel.add(Box.createRigidArea(new Dimension(4, 1)));
        innerPanel.add(this.collectionComboBox);
        innerPanel.setAlignmentX(0.0f);
        headerPanel.add(innerPanel);
        headerPanel.add(Box.createRigidArea(new Dimension(1, 3)));
        InsetPanel infoPanel = new InsetPanel();
        infoPanel.setLayout(new BoxLayout(infoPanel, 0));
        infoPanel.add(this.checkForUpdatesButton);
        infoPanel.add(Box.createHorizontalGlue());
        infoPanel.add(this.symbolPanel);
        infoPanel.setAlignmentX(0.0f);
        headerPanel.add(infoPanel);
        InsetPanel footerPanel = new InsetPanel(new Insets(6, 6, 6, 6));
        footerPanel.setLayout(new BoxLayout(footerPanel, 0));
        footerPanel.add(this.installNowButton);
        footerPanel.add(Box.createHorizontalGlue());
        footerPanel.add(this.manageButton);
        this.setLayout(new BorderLayout());
        this.add((Component)headerPanel, "North");
        this.add((Component)this.availableSplitPane, "Center");
        this.add((Component)footerPanel, "South");
    }

    private void setUpdateFrame(UpdateFrame updateFrame) {
        this.updateFrame = new WeakReference<UpdateFrame>(updateFrame);
    }

    private UpdateFrame getUpdateFrame() {
        return (UpdateFrame)this.updateFrame.get();
    }

    public boolean isAnalyzeDialogVisible() {
        if (this.getUpdateFrame().getGatherDialog() != null) {
            return this.getUpdateFrame().getGatherDialog().isVisible();
        }
        return false;
    }

    private void applyUpdateCollection(UpdateCollection updateCollection) {
        if (UMData.getDebug()) {
            System.out.println("inside AvailablePanel.applyUpdateCollection()");
        }
        if (UMData.getDebug()) {
            System.out.println("updateCollection: " + ((Object)updateCollection).toString());
        }
        if (updateCollection.getUpdates() == null) {
            if (UMData.getDebug()) {
                System.out.println("updateCollection.getUpdates() == null");
            }
        } else if (UMData.getDebug()) {
            System.out.println("updateCollection.getUpdates().length: " + updateCollection.getUpdates().length);
        }
        AvailableTable table = this.getTable();
        SortedTableHeader header = (SortedTableHeader)table.getTableHeader();
        AvailableTableModel model = (AvailableTableModel)table.getModel();
        model.getUpdateChoiceManager().clear(updateCollection);
        model.setUpdateCollection(updateCollection);
        model.sortColumn(header.getSortColumn(), header.getSortDirection());
        model.fireTableDataChanged();
        Rectangle rectangle = table.getCellRect(0, 0, false);
        if (rectangle != null) {
            table.scrollRectToVisible(rectangle);
        }
    }

    class GatherUpdatesWorker
    extends Worker
    implements WorkerListener,
    ActionListener {
        private UpdateCollection updateCollection;
        private boolean bAuthenticationNeeded = false;
        private GatherDialog gatherDialog;
        private boolean applyUpdates = true;

        GatherUpdatesWorker() {
            this.addWorkerListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            this.interrupt();
        }

        public void workStarted(WorkerEvent e) {
            boolean isStored = true;
            isStored = this.updateCollection.isStored();
            GenericActionSet actionSet = AvailablePanel.this.getUpdateFrame().getActionSet();
            actionSet.getAction("check-for-updates").setEnabled(false);
            Application.getInstance().getUpdateFrame().setCursor(Cursor.getPredefinedCursor(3));
            if (AvailablePanel.this.bForceAnalysis || !isStored) {
                this.gatherDialog = AvailablePanel.this.getUpdateFrame().getGatherDialog();
                this.gatherDialog.getActionSet().getAction("cancel").setEnabled(true);
                this.gatherDialog.getGatherPanel().getCancelButton().addActionListener(this);
                this.gatherDialog.setTitle(GatherDialog.I18N.getString("title"));
                this.gatherDialog.setMessage(GatherDialog.I18N.getString("message-updates"));
                if (!this.gatherDialog.isVisible()) {
                    Utility.centerOverFrame(this.gatherDialog, (JFrame)AvailablePanel.this.getUpdateFrame());
                    this.gatherDialog.setVisible(true);
                }
            }
        }

        public void workFinished(WorkerEvent e) {
            if (this.gatherDialog != null) {
                this.gatherDialog.setVisible(false);
                this.gatherDialog.getGatherPanel().setProgressing(false);
                this.gatherDialog.getGatherPanel().getProgressBar().setIndeterminate(false);
                this.gatherDialog.dispose();
                AvailablePanel.this.getUpdateFrame().setGatherDialog(null);
                this.gatherDialog = null;
            }
            if (this.bAuthenticationNeeded) {
                this.bAuthenticationNeeded = false;
                AuthenticationManager.getInstance().setAction(new GatherUpdatesAction());
                AuthenticationManager.getInstance().authenticate();
            } else if (this.applyUpdates) {
                AvailablePanel.this.applyUpdateCollection(this.updateCollection);
            }
            AvailableTableModel model = (AvailableTableModel)AvailablePanel.this.availableTable.getModel();
            int iRowCount = model.getRowCount();
            AvailablePanel.this.updateCollection.setAnalysisDateString(AvailablePanel.this.updateCollection.getLastAnalysisDate());
            Object[] aObject = new Object[]{new Integer(iRowCount), AvailablePanel.this.updateCollection.getAnalysisDateString()};
            String sString = UpdateFrame.I18N.format("available-available-updates-message", aObject);
            AvailablePanel.this.messageLabel.setText(sString);
            GenericActionSet actionSet = AvailablePanel.this.getUpdateFrame().getActionSet();
            actionSet.getAction("check-for-updates").setEnabled(true);
            Application.getInstance().getUpdateFrame().setCursor(Cursor.getDefaultCursor());
            UMData.setEncodedFileName(null);
        }

        public void workInterrupted(WorkerEvent e) {
            GenericActionSet actionSet = AvailablePanel.this.getUpdateFrame().getActionSet();
            actionSet.getAction("check-for-updates").setEnabled(true);
            Application.getInstance().getUpdateFrame().setCursor(Cursor.getDefaultCursor());
            AvailablePanel.this.getUpdateFrame().createCancelDialogContentPanel(this.gatherDialog);
            this.applyUpdates = false;
            UMData.setEncodedFileName(null);
        }

        void work(UpdateCollection updateCollection) {
            this.updateCollection = updateCollection;
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ GatherUpdatesWorker this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    GatherUpdatesWorker.access$800(this.this$1, 0, this);
                }
            });
            this.start();
        }

        public Object construct() {
            try {
                this.updateCollection.setUseStoredData(!AvailablePanel.this.bForceAnalysis);
                this.updateCollection.populate();
                if (UMData.getDebug()) {
                    System.out.println("Updating the local cache ...");
                }
                LocalCache.initInfo((boolean)UMData.getDebug());
                LocalCache.saveAnalysisResult((String)this.updateCollection.getName(), (boolean)UMData.getDebug());
                if (UMData.getDebug()) {
                    System.out.println("Updating the local cache complete.");
                }
            }
            catch (NotAuthenticatedException e) {
                this.bAuthenticationNeeded = true;
            }
            catch (Throwable throwable) {
                AvailablePanel.this.getUpdateFrame().showWarningDialog(throwable, this.gatherDialog);
            }
            try {
                if (!DataController.isLiveData()) {
                    Thread.sleep(2000L);
                }
            }
            catch (Exception e) {
                System.err.println("exception calling Thread.sleep()");
            }
            return new Object();
        }

        public void finished() {
            this.fireWorkerEvent(1, this);
        }

        static /* synthetic */ void access$800(GatherUpdatesWorker x0, int x1, Object x2) {
            x0.fireWorkerEvent(x1, x2);
        }
    }

    class GatherUpdatesAction
    extends AbstractAction {
        GatherUpdatesAction() {
        }

        public void actionPerformed(ActionEvent e) {
            GatherUpdatesWorker worker = new GatherUpdatesWorker();
            worker.work(AvailablePanel.this.updateCollection);
        }
    }

    class AvailableTableListSelectionListener
    implements ListSelectionListener {
        AvailableTableListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel selectionModel = (ListSelectionModel)e.getSource();
            AvailableTable table = AvailablePanel.this.getTable();
            AvailableTableModel model = (AvailableTableModel)table.getModel();
            int iRow = table.getSelectedRow();
            int[] aiSelectedRows = table.getSelectedRows();
            if (aiSelectedRows.length == 1 && iRow >= 0) {
                if (!e.getValueIsAdjusting()) {
                    Update update = model.getUpdateAt(iRow);
                    AvailablePanel.this.getEditorPane().setUpdate(update);
                }
            } else {
                AvailablePanel.this.getEditorPane().setUpdate(null);
            }
        }
    }

    class AvailableTableModelListener
    implements TableModelListener {
        AvailableTableModelListener() {
        }

        public void tableChanged(TableModelEvent e) {
            GenericActionSet actionSet = AvailablePanel.this.getUpdateFrame().getActionSet();
            AvailableTableModel model = (AvailableTableModel)AvailablePanel.this.availableTable.getModel();
            int iCheckedCount = model.getCheckedCount();
            ((InstallNowAction)actionSet.getAction("install-now")).setCount(iCheckedCount);
            if (iCheckedCount > 0) {
                actionSet.getAction("install-now").setEnabled(true);
                AvailablePanel.this.availableTable.updateTableHeader();
            } else {
                actionSet.getAction("install-now").setEnabled(false);
                AvailablePanel.this.availableTable.updateTableHeader();
            }
            int iRowCount = model.getRowCount();
            if (iRowCount > 0) {
                if (iCheckedCount < iRowCount) {
                    actionSet.getAction("check-all").setEnabled(true);
                    AvailablePanel.this.availableTable.updateTableHeader();
                } else {
                    actionSet.getAction("check-all").setEnabled(false);
                    AvailablePanel.this.availableTable.updateTableHeader();
                }
                if (iCheckedCount > 0) {
                    actionSet.getAction("uncheck-all").setEnabled(true);
                    AvailablePanel.this.availableTable.updateTableHeader();
                } else {
                    actionSet.getAction("uncheck-all").setEnabled(false);
                    AvailablePanel.this.availableTable.updateTableHeader();
                }
            } else {
                actionSet.getAction("check-all").setEnabled(false);
                actionSet.getAction("uncheck-all").setEnabled(false);
                AvailablePanel.this.availableTable.updateTableHeader();
            }
            Object[] aObject = AvailablePanel.this.updateCollection == null ? new Object[]{new Integer(iRowCount), new String("")} : new Object[]{new Integer(iRowCount), AvailablePanel.this.updateCollection.getAnalysisDateString()};
            String sString = UpdateFrame.I18N.format("available-available-updates-message", aObject);
            AvailablePanel.this.messageLabel.setText(sString);
        }
    }

    class AvailableComboBoxItemListener
    implements ItemListener {
        UpdateCollection updateCollection = null;

        AvailableComboBoxItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1 && e.getItem() instanceof UpdateCollection) {
                AvailablePanel.this.updateCollection = (UpdateCollection)e.getItem();
                this.updateCollection = AvailablePanel.this.updateCollection;
                Application.getInstance().getUpdateFrame().setCursor(Cursor.getPredefinedCursor(3));
                String currentPatchSet = UMData.getCurrentPatchset();
                if (currentPatchSet == null || !currentPatchSet.equals(this.updateCollection.getName())) {
                    GenericActionSet actionSet = AvailablePanel.this.getUpdateFrame().getActionSet();
                    actionSet.getAction("check-for-updates").setEnabled(true);
                    this.setPatchset();
                }
                if (this.updateCollection != null) {
                    if (this.updateCollection.getUpdates() == null || this.updateCollection.getUpdates().length == 0) {
                        AvailablePanel.this.bForceAnalysis = false;
                        AvailablePanel.this.gatherUpdates();
                    } else {
                        AvailablePanel.this.applyUpdateCollection(this.updateCollection);
                        Application.getInstance().getUpdateFrame().setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        }

        private void setPatchset() {
            try {
                String patchset = this.updateCollection.getName();
                DataController.getInstance().setPatchSet(patchset);
            }
            catch (NotAuthenticatedException nae) {
                AuthenticationManager.getInstance().authenticate();
                try {
                    String patchset = this.updateCollection.getName();
                    DataController.getInstance().setPatchSet(patchset);
                }
                catch (Throwable tr) {
                    AvailablePanel.this.getUpdateFrame().showWarningDialog(tr, null);
                }
            }
            catch (Throwable tr) {
                AvailablePanel.this.getUpdateFrame().showWarningDialog(tr, null);
            }
        }
    }

    class CheckForUpdatesAction
    extends GenericAction {
        CheckForUpdatesAction() {
            super(UpdateFrame.I18N.getString("available-check-for-updates"));
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            GenericActionSet actionSet = AvailablePanel.this.getUpdateFrame().getActionSet();
            actionSet.getAction("check-for-updates").setEnabled(false);
            Application.getInstance().getUpdateFrame().setCursor(Cursor.getPredefinedCursor(3));
            Application.getInstance().getUpdateFrame().getInstalledPanel().setRefreshInstalledUpdates(true);
            AvailablePanel.this.bForceAnalysis = true;
            if (!SolarisDataCollector.isCollCatDataValid()) {
                SolarisDataCollector.invalidateCategoriesObject();
                SolarisDataCollector.invalidateCollectionsObject();
            }
            if (AvailablePanel.this.updateCollection != null) {
                AvailablePanel.this.gatherUpdates();
            } else {
                Application.getInstance().getUpdateFrame().gatherUpdateCollections();
            }
        }
    }

    class InstallNowAction
    extends GenericAction {
        InstallNowAction() {
            super("");
            this.setCount(99);
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            AvailableTableModel model = (AvailableTableModel)AvailablePanel.this.getTable().getModel();
            Update[] aUpdate = model.getCheckedUpdates();
            AvailablePanel.this.getUpdateFrame().getDelegate().setInstallUpdates(aUpdate);
            AvailablePanel.this.getUpdateFrame().getDelegate().install();
        }

        void setCount(int iCount) {
            String sString;
            if (iCount == 1) {
                sString = UpdateFrame.I18N.getString("available-install-now-singular");
            } else if (iCount > 1) {
                Object[] aObject = new Object[]{new Integer(iCount)};
                sString = UpdateFrame.I18N.format("available-install-now-plural", aObject);
            } else {
                sString = UpdateFrame.I18N.getString("available-install-now");
            }
            this.putValue("Name", sString);
        }
    }

    class UncheckAllAction
    extends GenericAction {
        UncheckAllAction() {
            super("");
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            ((AvailableTableModel)AvailablePanel.this.getTable().getModel()).uncheckAll();
        }
    }

    class CheckAllAction
    extends GenericAction {
        CheckAllAction() {
            super("");
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            ((AvailableTableModel)AvailablePanel.this.getTable().getModel()).checkAll();
        }
    }

    class AvailableSplitPane
    extends JSplitPane {
        AvailableSplitPane() {
            super(0);
            AvailablePanel.this.availableTable = new AvailableTable(AvailablePanel.this.getUpdateFrame(), AvailablePanel.this.checkPanel);
            ListSelectionModel selectionModel = AvailablePanel.this.availableTable.getSelectionModel();
            selectionModel.addListSelectionListener(new AvailableTableListSelectionListener());
            JScrollPane tableScrollPane = AvailablePanel.this.availableTable.getScrollPane();
            tableScrollPane.setBorder(BorderFactory.createEmptyBorder());
            tableScrollPane.setCorner("UPPER_RIGHT_CORNER", new OrnamentTableHeader());
            AvailablePanel.this.availableEditorPane = new AvailableEditorPane();
            JScrollPane editorScrollPane = AvailablePanel.this.availableEditorPane.getScrollPane();
            editorScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.setContinuousLayout(true);
            this.setTopComponent(tableScrollPane);
            this.setBottomComponent(editorScrollPane);
            this.setResizeWeight(0.75);
            this.setDividerLocation(300);
        }
    }
}

