/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.cns.authentication.CSMAuthenticator;
import com.sun.swup.client.common.CCRUtils;
import com.sun.swup.client.common.I18NHelper;
import com.sun.swup.client.common.UMData;
import com.sun.swup.client.common.UpdateMgrUtil;
import com.sun.swup.client.common.environment.Environment;
import com.sun.swup.client.ui.AboutFrame;
import com.sun.swup.client.ui.DataController;
import com.sun.swup.client.ui.DataTester;
import com.sun.swup.client.ui.PreferencesFrame;
import com.sun.swup.client.ui.RegistrationManager;
import com.sun.swup.client.ui.SortArrowImage;
import com.sun.swup.client.ui.SymbolImage;
import com.sun.swup.client.ui.UpdateFrame;
import com.sun.swup.client.ui.Utils;
import com.sun.swup.client.ui.foundation.Utility;
import com.sun.swup.client.ui.foundation.swing.GenericApplication;
import com.sun.swup.client.ui.foundation.swing.StateManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.text.MessageFormat;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;

public final class Application
extends GenericApplication {
    public static I18NHelper I18N = new I18NHelper(class$com$sun$swup$client$ui$Application == null ? (class$com$sun$swup$client$ui$Application = Application.class$("com.sun.swup.client.ui.Application")) : class$com$sun$swup$client$ui$Application, "resources/strings/application");
    static boolean INITIATE_WIZARD = true;
    static boolean TEST_DATA = false;
    static boolean INITIATE_PORTAL_MGMT = false;
    static FileLock lck;
    private static Application application;
    private UpdateFrame updateFrame;
    private PreferencesFrame preferencesFrame;
    private AboutFrame aboutFrame;
    static /* synthetic */ Class class$com$sun$swup$client$ui$Application;

    public static void main(String[] args) {
        try {
            File lockFile = new File("/tmp/com.sun.swup.client.LOCK");
            if (!lockFile.exists()) {
                lockFile.createNewFile();
                String[] cmd = new String[]{"/usr/bin/chmod", "666", "/tmp/com.sun.swup.client.LOCK"};
                Process chmodProcess = Runtime.getRuntime().exec(cmd);
            }
            if ((lck = new FileOutputStream(lockFile).getChannel().tryLock()) == null) {
                if (Application.findArgumentIndex(args, "regForPortalMgmt") > -1) {
                    Utility.alert(I18N.getString("lock-error-title"), I18N.getString("lock-error-message-portal-mgmt"));
                } else {
                    Utility.alert(I18N.getString("lock-error-title"), I18N.getString("lock-error-message"));
                }
                System.exit(-1);
            }
        }
        catch (Exception e) {
            MessageFormat msgFmt = new MessageFormat(I18N.getString("lock-error-message2"));
            Object[] msgArgs = new Object[]{"/tmp/com.sun.swup.client.LOCK"};
            Utility.alert(I18N.getString("lock-error-title2"), msgFmt.format(msgArgs));
            System.exit(-1);
        }
        if (!UpdateMgrUtil.isRunningInGlobalZone()) {
            Utility.alert(I18N.getString("non-global-zone-error-title"), I18N.getString("non-global-zone-error-message"));
            System.exit(-1);
        }
        Application.handlePlatform();
        Application.handleArguments(args);
        try {
            new Application();
        }
        catch (HeadlessException he) {
            System.err.println(he.getMessage());
        }
        catch (InternalError ie) {
            System.err.println(ie.getMessage());
        }
    }

    static void handlePlatform() {
        String os = System.getProperty("os.name");
        if (os != null && os.equals("SunOS")) {
            DataController.setLiveData(true);
            INITIATE_WIZARD = true;
        } else {
            DataController.setLiveData(false);
            INITIATE_WIZARD = false;
        }
    }

    static void handleArguments(String[] args) {
        if (Application.findArgumentIndex(args, "live") > -1) {
            DataController.setLiveData(true);
        }
        if (Application.findArgumentIndex(args, "dummy") > -1) {
            DataController.setLiveData(false);
            INITIATE_WIZARD = false;
        }
        if (Application.findArgumentIndex(args, "noreg") > -1) {
            INITIATE_WIZARD = false;
        }
        if (Application.findArgumentIndex(args, "test") > -1) {
            TEST_DATA = true;
        }
        if (Application.findArgumentIndex(args, "-debug") > -1) {
            UMData.setDebug((boolean)true);
            DataController.getInstance().setDebug(true);
        }
        if (Application.findArgumentIndex(args, "regForPortalMgmt") > -1) {
            INITIATE_PORTAL_MGMT = true;
        }
    }

    static int findArgumentIndex(String[] args, String sArg) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(sArg) && !args[i].equals("-" + sArg)) continue;
            return i;
        }
        return -1;
    }

    public static Application getInstance() {
        return application;
    }

    private Application() {
        application = this;
        Environment.initializeEnvironment();
        this.initializeImages();
        this.initializeSizing();
        this.initializePreferences();
        this.initializeStateManager();
        if (TEST_DATA) {
            new DataTester();
            return;
        }
        CSMAuthenticator.getInstance().setDebug(UMData.getDebug());
        if (this.isRegistrationComplete()) {
            this.getUpdateFrame().setVisible(true, true);
            if (INITIATE_PORTAL_MGMT) {
                this.displayRegistration(2);
            }
        } else {
            this.getUpdateFrame().setVisible(true, false);
            Utils.debug("Registration required ...");
            this.displayRegistration();
        }
    }

    public UpdateFrame getUpdateFrame() {
        if (this.updateFrame == null) {
            this.updateFrame = new UpdateFrame();
        }
        return this.updateFrame;
    }

    PreferencesFrame getPreferencesFrame() {
        if (this.preferencesFrame == null) {
            this.preferencesFrame = new PreferencesFrame();
        }
        return this.preferencesFrame;
    }

    AboutFrame getAboutFrame() {
        if (this.aboutFrame == null) {
            this.aboutFrame = new AboutFrame();
        }
        return this.aboutFrame;
    }

    void clearUpdateFrame() {
        this.updateFrame = null;
    }

    void clearPreferencesFrame() {
        this.preferencesFrame = null;
    }

    void clearAboutFrame() {
        this.aboutFrame = null;
    }

    void displayRegistration() {
        application.displayRegistration(0);
    }

    void displayRegistration(int runMode) {
        Utils.debug("Application.displayRegistration mode: " + runMode);
        try {
            RegistrationManager registrationManager = new RegistrationManager();
            registrationManager.displayRegistration(runMode);
        }
        catch (ClassNotFoundException e) {
            this.handleRegistrationThrowable(e);
        }
        catch (NoClassDefFoundError e) {
            this.handleRegistrationThrowable(e);
        }
    }

    private void handleRegistrationThrowable(Throwable throwable) {
        throwable.printStackTrace();
        Utility.alert(I18N.getString("setup-wizard-error-title"), I18N.getString("setup-wizard-error-message"));
        if (!this.isRegistrationComplete()) {
            this.requestToQuit();
        }
    }

    void requestToQuit() {
        boolean bQuitAllowed = true;
        if (bQuitAllowed) {
            try {
                String[] cmd = new String[]{"/usr/bin/rm", "-rf", "/tmp/com.sun.swup.client.LOCK"};
                Process process = Runtime.getRuntime().exec(cmd);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    boolean isRegistrationComplete() {
        if (INITIATE_WIZARD) {
            return CCRUtils.isSystemRegistered();
        }
        return true;
    }

    private void initializeImages() {
        this.initializeImage("ascending-sort.png", new SortArrowImage(0));
        this.initializeImage("descending-sort.png", new SortArrowImage(1));
        this.initializeImage("restart-required.png", new SymbolImage(Color.lightGray));
        this.initializeImage("download-only.png", new SymbolImage(Color.gray));
        this.initializeImage("select-all.gif", new SymbolImage(Color.lightGray));
        this.initializeImage("deselect-all.gif", new SymbolImage(Color.lightGray));
        this.initializeImage("dependencies.png", new SymbolImage(Color.lightGray));
        this.initializeImage("installed.png", new SymbolImage(new Color(0, 199, 0)));
        this.initializeImage("partial-install.png", new SymbolImage(new Color(255, 208, 22)));
        this.initializeImage("install-failed.png", new SymbolImage(new Color(239, 0, 0)));
        this.initializeImage("uninstalled.png", new SymbolImage(new Color(137, 137, 137)));
        this.initializeImage("downloaded.png", new SymbolImage(new Color(43, 64, 162)));
    }

    private void initializeImage(String sImage, Image image) {
        ImageIcon imageIcon = Environment.getImageIcon((String)sImage);
        if (imageIcon == null || imageIcon.getIconWidth() == 1 && imageIcon.getIconHeight() == 1) {
            Environment.putImageIcon((String)sImage, (ImageIcon)new ImageIcon(image));
        }
    }

    private void initializeSizing() {
        Environment.putInsets((String)"frame", (Insets)new Insets(8, 8, 8, 8));
        Environment.putInsets((String)"editor-pane", (Insets)new Insets(8, 8, 8, 8));
        Environment.putInsets((String)"tab-panel", (Insets)new Insets(8, 8, 8, 8));
        Environment.putDimension((String)"inter-label", (Dimension)new Dimension(11, 1));
        Environment.putDimension((String)"inter-button", (Dimension)new Dimension(4, 1));
        Environment.putDimension((String)"safe-frame", (Dimension)new Dimension(850, 650));
        Environment.putDimension((String)"safe-window", (Dimension)new Dimension(630, 450));
        Environment.putInteger((String)"icon-text-gap", (int)4);
        Environment.putInteger((String)"small-font-reduction", (int)2);
        Environment.putInteger((String)"preferred-dialog-width", (int)400);
    }

    private void initializePreferences() {
        try {
            Preferences preferences = Preferences.userRoot().node("com/sun/swup/client");
            this.setPreferences(preferences);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private void initializeStateManager() {
        this.setStateManager(new StateManager());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

