/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.sample;

import com.sun.cns.authentication.CMDExecutionException;
import com.sun.cns.authentication.NotAuthenticatedException;
import com.sun.swup.client.interfaces.Uninstaller;
import com.sun.swup.client.interfaces.UninstallerMessenger;
import com.sun.swup.client.interfaces.Update;
import java.util.Timer;
import java.util.TimerTask;

public class UninstallerImpl
implements Uninstaller {
    private static final int SECONDS_PER_UPDATE = 2;
    private UninstallerMessenger uninstallerMessenger;
    private Update[] aUpdate;
    private int iCounter;
    private Timer timer;
    private TimerTask timerTask;
    private boolean bRestartRequired;

    public UninstallerMessenger getMessenger() {
        if (this.uninstallerMessenger == null) {
            this.uninstallerMessenger = new UninstallerMessenger();
        }
        return this.uninstallerMessenger;
    }

    public void beginUninstall(Update[] aUpdate) throws CMDExecutionException, NotAuthenticatedException {
        this.aUpdate = aUpdate;
        this.startTimer();
    }

    public void cancelUninstall() {
        this.timer.cancel();
        this.timer = null;
    }

    public void setRestartRequired(boolean bRestartRequired) {
        this.bRestartRequired = bRestartRequired;
    }

    public boolean isRestartRequired() {
        return this.bRestartRequired;
    }

    private void startTimer() {
        this.iCounter = 0;
        this.timer = new Timer();
        this.timerTask = new UninstallerTimerTask();
        this.timer.schedule(this.timerTask, 0L, 2000L);
    }

    private int calculateKilobytesRemaining() {
        int iKilobytes = 0;
        for (int i = this.iCounter; i < this.aUpdate.length; ++i) {
            Update update = this.aUpdate[i];
            iKilobytes += update.getSize().intValue();
        }
        return iKilobytes;
    }

    private int calculateSecondsRemaining() {
        int iSeconds = 0;
        for (int i = this.iCounter; i < this.aUpdate.length; ++i) {
            iSeconds += 2;
        }
        return iSeconds;
    }

    public Update[] getExpandedUninstallList(Update[] aUpdates, Update[] iUpdates) throws CMDExecutionException {
        return null;
    }

    class UninstallerTimerTask
    extends TimerTask {
        UninstallerTimerTask() {
        }

        public void run() {
            if (UninstallerImpl.this.iCounter >= UninstallerImpl.this.aUpdate.length) {
                UninstallerImpl.this.setRestartRequired(true);
                UninstallerImpl.this.getMessenger().uninstallFinished();
                this.cancel();
            } else {
                Update update = UninstallerImpl.this.aUpdate[UninstallerImpl.this.iCounter];
                UninstallerImpl.this.getMessenger().setUpdateName(update.getName());
                UninstallerImpl.this.getMessenger().setUpdateNumber(UninstallerImpl.this.iCounter + 1);
                UninstallerImpl.this.getMessenger().setUpdateTotal(UninstallerImpl.this.aUpdate.length);
                UninstallerImpl.this.getMessenger().setKilobytesRemaining(UninstallerImpl.this.calculateKilobytesRemaining());
                UninstallerImpl.this.getMessenger().setSecondsRemaining(UninstallerImpl.this.calculateSecondsRemaining());
            }
            UninstallerImpl.this.iCounter++;
        }
    }
}

