/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.sample;

import com.sun.swup.client.engine.solaris.SolarisDataCollector;
import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.interfaces.UpdateCollection;
import com.sun.swup.client.sample.UpdateCollectionImpl;
import com.sun.swup.client.sample.UpdateImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;

public class DataBuilder {
    private static DataBuilder dataBuilder;

    static DataBuilder getInstance() {
        if (dataBuilder == null) {
            dataBuilder = new DataBuilder();
        }
        return dataBuilder;
    }

    UpdateCollection[] defineAvailableUpdateCollections() {
        ArrayList<UpdateCollectionImpl> arrayList = new ArrayList<UpdateCollectionImpl>();
        UpdateCollectionImpl updateCollection = new UpdateCollectionImpl();
        updateCollection.setName("recommended-updates");
        updateCollection.setDescription("Recommended Updates");
        arrayList.add(updateCollection);
        updateCollection = new UpdateCollectionImpl();
        updateCollection.setName("all-current-updates");
        updateCollection.setDescription("All Current Updates");
        arrayList.add(updateCollection);
        return arrayList.toArray(new UpdateCollection[0]);
    }

    private void addDependencies(Update[] aUpdate) {
        String[] asString = new String[]{"112765-03"};
        aUpdate[0].setRequiredUpdateNames(asString);
        aUpdate[1].setRequiredUpdateNames(asString);
        aUpdate[2].setRequiredUpdateNames(asString);
    }

    Update[] createUpdates(String sName) {
        ArrayList arrayList = this.createUpdates();
        if (sName.equals("recommended-updates")) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Update update = (Update)arrayList.get(i);
                if (update.getCategory().equals("Recommended") || update.getCategory().equals("Security")) continue;
                arrayList.remove(i);
            }
        }
        Update[] aUpdate = arrayList.toArray(new Update[0]);
        if (sName.equals("all-current-updates")) {
            this.addDependencies(aUpdate);
        }
        return aUpdate;
    }

    private ArrayList createUpdates() {
        ArrayList<UpdateImpl> updates = new ArrayList<UpdateImpl>();
        String sLine = null;
        LineNumberReader lineNumberReader = null;
        try {
            URL url = this.getClass().getClassLoader().getResource("resources/strings/ppro_dummy_data.txt");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openStream()));
            lineNumberReader = new LineNumberReader(bufferedReader);
            sLine = lineNumberReader.readLine().trim();
        }
        catch (IOException ie) {
            System.out.println("IO error opneing the dummy data file.");
        }
        String sPatchID = null;
        String sPatchIDTemp = null;
        UpdateImpl update = new UpdateImpl();
        Random random = new Random();
        for (int iCount = 0; iCount < 50; ++iCount) {
            boolean bNewUpdate = false;
            while (!bNewUpdate && sLine != null) {
                int modRev;
                String[] asTokens = sLine.split("=");
                String sKey = asTokens[0].trim();
                String sValue = "";
                if (asTokens.length == 2) {
                    sValue = asTokens[1].trim();
                }
                sPatchID = sKey.substring(0, sKey.indexOf("."));
                String property = sKey.substring(sKey.indexOf(".") + 1);
                if (property.equals("id")) {
                    update.setUpdateID(sPatchID);
                    update.setName(sPatchID);
                    update.setUpdateReadme("README for patch: " + sPatchID);
                } else if (property.equals("syn")) {
                    update.setDescription(sValue);
                } else if (property.equals("req")) {
                    asTokens = sValue.split(" ");
                    block6: for (int i = 0; i < updates.size(); ++i) {
                        UpdateImpl curUpdate = (UpdateImpl)updates.get(i);
                        for (int ii = 0; ii < asTokens.length; ++ii) {
                            if (asTokens[ii] != curUpdate.getUpdateID()) continue;
                            update.addRequiredUpdate(curUpdate);
                            continue block6;
                        }
                    }
                } else if (property.equals("props")) {
                    asTokens = sValue.split(" ");
                    for (int i = 0; i < asTokens.length; ++i) {
                        if (asTokens[i].indexOf("reboot") != -1) {
                            update.setRestartRequired(new Boolean("true"));
                            break;
                        }
                        update.setRestartRequired(new Boolean("false"));
                    }
                } else if (property.equals("real")) {
                    asTokens = sValue.split(" ");
                    for (int i = 0; i < asTokens.length; ++i) {
                        if (asTokens[i].indexOf("Security") != -1) {
                            update.setCategory("Security");
                            break;
                        }
                        if (asTokens[i].indexOf("Recommended") != -1) {
                            update.setCategory("Recommended");
                            break;
                        }
                        update.setCategory("");
                    }
                }
                try {
                    sLine = lineNumberReader.readLine();
                }
                catch (IOException ie) {
                    System.out.println("read data file error");
                }
                if (sLine != null && !(sPatchIDTemp = sLine.trim().substring(0, sLine.indexOf("."))).equals(sPatchID)) {
                    bNewUpdate = true;
                }
                if (sLine != null && !bNewUpdate) continue;
                update.setUpdateStatus(new Integer(0));
                update.setDownloadOnly(new Boolean(false));
                Date date = this.createRandomDate();
                update.setAvailableDate(date);
                update.setInstallationDate(date);
                update.setSize(new Integer(random.nextInt(10000)));
                String revStr = sPatchID.substring(sPatchID.indexOf("-") + 1);
                int revInt = Integer.parseInt(revStr);
                if (random.nextInt(5) % 4 == 0 && (modRev = revInt - random.nextInt(3)) > 0) {
                    update.setInstalledRevision(new Integer(modRev).toString());
                }
                updates.add(update);
                update = new UpdateImpl();
            }
            if (sLine != null) continue;
            break;
        }
        return updates;
    }

    private Date createRandomDate() {
        int iYear = 2000;
        int iMonth = 0;
        int iDay = 1;
        GregorianCalendar calendar = null;
        Date date = null;
        Random random = new Random();
        iYear = 2000 + random.nextInt(5);
        iMonth = random.nextInt(12);
        iDay = 1 + random.nextInt(30);
        if (iMonth == 2 && iDay > 28) {
            iDay = 28;
        }
        calendar = new GregorianCalendar(iYear, iMonth, iDay);
        date = calendar.getTime();
        return date;
    }

    protected Update[] generateInstalledUpdates() {
        ArrayList<UpdateImpl> updates = new ArrayList<UpdateImpl>();
        UpdateImpl update = new UpdateImpl();
        LineNumberReader lr = null;
        String line = null;
        int iCount = 0;
        try {
            URL url = this.getClass().getClassLoader().getResource("resources/strings/ppro_dummy_data.txt");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openStream()));
            lr = new LineNumberReader(bufferedReader);
            line = lr.readLine();
            String patch1 = null;
            String patch2 = null;
            while (iCount < 50) {
                patch1 = line.substring(0, line.indexOf("."));
                if (patch1.equals(patch2 = (line = lr.readLine()).substring(0, line.indexOf(".")))) continue;
                ++iCount;
            }
        }
        catch (IOException ie) {
            System.out.println("IO error in open the dummy data file.");
        }
        String sPatchID = null;
        String sPatchIDTemp = null;
        Random random = new Random();
        while (iCount < 80) {
            boolean bNewUpdate = false;
            while (!bNewUpdate && line != null) {
                String[] toks = line.split("=");
                String key = toks[0].trim();
                String value = "";
                if (toks.length == 2) {
                    value = toks[1].trim();
                }
                sPatchID = key.substring(0, key.indexOf("."));
                String property = key.substring(key.indexOf(".") + 1);
                if (property.equals("id")) {
                    update.setUpdateID(sPatchID);
                    update.setName(sPatchID);
                } else if (!(property.equals("obs") || property.equals("inc") || property.equals("obsc") || property.equals("prf"))) {
                    if (property.equals("syn")) {
                        update.setDescription(value);
                    } else if (property.equals("req")) {
                        toks = value.split(" ");
                        block7: for (int i = 0; i < updates.size(); ++i) {
                            Update curUpdate = (Update)updates.get(i);
                            for (int ii = 0; ii < toks.length; ++ii) {
                                if (toks[ii] != curUpdate.getUpdateID()) continue;
                                update.addRequiredUpdate(curUpdate);
                                continue block7;
                            }
                        }
                    } else if (property.equals("props")) {
                        toks = value.split(" ");
                        for (int i = 0; i < toks.length; ++i) {
                            if (toks[i].indexOf("reboot") != -1) {
                                update.setRestartRequired(new Boolean("true"));
                                break;
                            }
                            update.setRestartRequired(new Boolean("false"));
                        }
                    } else if (property.equals("real")) {
                        toks = value.split(" ");
                        for (int i = 0; i < toks.length; ++i) {
                            if (toks[i].indexOf("Security") != -1) {
                                update.setCategory("Security");
                                break;
                            }
                            if (toks[i].indexOf("Recommended") != -1) {
                                update.setCategory("Recommended");
                                break;
                            }
                            update.setCategory("");
                        }
                    }
                }
                try {
                    line = lr.readLine();
                }
                catch (IOException ie) {
                    System.out.println("read data file error");
                }
                if (line != null && !(sPatchIDTemp = line.trim().substring(0, line.indexOf("."))).equals(sPatchID)) {
                    bNewUpdate = true;
                }
                if (line != null && !bNewUpdate) continue;
                int iUpdateStatus = random.nextInt(6);
                if (iUpdateStatus == 0) {
                    iUpdateStatus = 1;
                } else if (iUpdateStatus == 6) {
                    iUpdateStatus = 6;
                }
                update.setUpdateStatus(new Integer(iUpdateStatus));
                update.setDownloadOnly(new Boolean(false));
                Date date = this.createRandomDate();
                update.setAvailableDate(date);
                update.setInstallationDate(date);
                update.setSize(new Integer(random.nextInt(10000)));
                String revStr = sPatchID.substring(sPatchID.indexOf("-") + 1);
                int revInt = Integer.parseInt(revStr);
                update.setInstalledRevision(revStr);
                Random r = new Random();
                int iRandom = r.nextInt(10000);
                if (iRandom > 2000) {
                    update.setRemovable(new Boolean(true));
                } else {
                    update.setRemovable(new Boolean(false));
                }
                updates.add(update);
                update = new UpdateImpl();
            }
            ++iCount;
            if (line != null) continue;
            break;
        }
        return updates.toArray(new Update[0]);
    }

    public String[] generatePrecedenceSortedCategoryList() throws Throwable {
        return SolarisDataCollector.getCategoriesObject().getPrecedenceSortedCategories();
    }

    public String[] generateDisplayPrecedenceSortedCategoryList() throws Throwable {
        return SolarisDataCollector.getCategoriesObject().getDisplayPrecedenceSortedCategories();
    }
}

