/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.engine.solaris;

import com.sun.cns.authentication.CMDExecutionException;
import com.sun.cns.authentication.NotAuthenticatedException;
import com.sun.swup.client.common.I18NHelper;
import com.sun.swup.client.common.UMData;
import com.sun.swup.client.common.UpdateConstants;
import com.sun.swup.client.common.UpdateMgrUtil;
import com.sun.swup.client.engine.AbstractUpdateCollection;
import com.sun.swup.client.engine.solaris.CategoryFileException;
import com.sun.swup.client.engine.solaris.CollectionFileException;
import com.sun.swup.client.engine.solaris.PatchCategory;
import com.sun.swup.client.engine.solaris.PatchCollection;
import com.sun.swup.client.engine.solaris.ReadAnalysisDataException;
import com.sun.swup.client.engine.solaris.SolarisDataCollector;
import com.sun.swup.client.engine.solaris.SolarisPatch;
import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.interfaces.UpdateCollection;
import com.sun.swup.client.wrapper.PatchProWrapper;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class SolarisUpdateCollection
extends AbstractUpdateCollection {
    private static UpdateMgrUtil propertiesUtil = UpdateMgrUtil.getInstance();
    private boolean INSTALLED_COLLECTION = false;
    private static final String INSTALLED_PATCH_LIST_COMMAND = "/usr/sbin/smpatch list";
    private Hashtable installedPatchTable = new Hashtable();
    private static PatchProWrapper ppro = PatchProWrapper.getInstance();
    private File storedDataFile = null;
    private static PatchCollection collectionObj = null;
    private static PatchCategory categoryObj = null;
    private String analysisDateString = "";
    static I18NHelper I18N_UPDATE = new I18NHelper(class$com$sun$swup$client$engine$solaris$SolarisUpdateCollection == null ? (class$com$sun$swup$client$engine$solaris$SolarisUpdateCollection = SolarisUpdateCollection.class$("com.sun.swup.client.engine.solaris.SolarisUpdateCollection")) : class$com$sun$swup$client$engine$solaris$SolarisUpdateCollection, "resources/strings/update");
    static I18NHelper I18N_WARNING = new I18NHelper(class$com$sun$swup$client$engine$solaris$SolarisUpdateCollection == null ? (class$com$sun$swup$client$engine$solaris$SolarisUpdateCollection = SolarisUpdateCollection.class$("com.sun.swup.client.engine.solaris.SolarisUpdateCollection")) : class$com$sun$swup$client$engine$solaris$SolarisUpdateCollection, "resources/strings/warning");
    static /* synthetic */ Class class$com$sun$swup$client$engine$solaris$SolarisUpdateCollection;

    public SolarisUpdateCollection(String name) {
        if (name != null) {
            this.setName(name);
        }
    }

    public static UpdateCollection getInstance(String name) {
        return new SolarisUpdateCollection(name);
    }

    public void setIsInstalledCollection(boolean installed) {
        this.INSTALLED_COLLECTION = installed;
    }

    public void setAnalysisDateString(String analysisDateString) {
        this.analysisDateString = analysisDateString;
    }

    public String getAnalysisDateString() {
        return this.analysisDateString;
    }

    public boolean isInstalledCollection() {
        return this.INSTALLED_COLLECTION;
    }

    public void populate() throws CMDExecutionException, NotAuthenticatedException, CollectionFileException, CategoryFileException, ReadAnalysisDataException {
        Update[] updates;
        this.initUpdateList();
        if (this.isInstalledCollection()) {
            this.populateInstalledUpdates();
            return;
        }
        if (propertiesUtil == null) {
            return;
        }
        this.storedDataFile = propertiesUtil.getStoredDataFile(this.getName());
        if (this.storedDataFile == null) {
            this.restoreCollectionState();
            return;
        }
        if (!this.getUseStoredData()) {
            this.generateCollectionData(this.storedDataFile);
        } else if (!this.storedDataFile.exists()) {
            this.generateCollectionData(this.storedDataFile);
        }
        this.populateInstalledPatchTable();
        Properties stagedUpdates = null;
        if (propertiesUtil != null) {
            stagedUpdates = propertiesUtil.getStagedUpdatesProps();
        }
        if (categoryObj == null) {
            categoryObj = SolarisDataCollector.getCategoriesObject();
        }
        String[] categories = categoryObj.getPrecedenceSortedCategories();
        String category = categoryObj.getCategoryDisplayName("Generic");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Hashtable<String, Update> patchTable = new Hashtable<String, Update>();
        try {
            String line;
            FileInputStream fis = new FileInputStream(this.storedDataFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            Update patch = null;
            while ((line = br.readLine()) != null) {
                String[] toks;
                if (line.length() == 0 || line.indexOf("=") == -1 || line.indexOf(".") == -1) {
                    line = br.readLine();
                    continue;
                }
                String key = line.substring(0, line.indexOf("="));
                String value = line.substring(line.indexOf("=") + 1);
                key = key.trim();
                value = value.trim();
                String patchID = key.substring(0, key.indexOf("."));
                if (patchID != null && !patchTable.containsKey(patchID)) {
                    patch = SolarisPatch.getInstance();
                    patch.setUpdateID(patchID);
                    patch.setName(patchID);
                    patchTable.put(patchID, patch);
                } else {
                    if (patchID == null) continue;
                    if (patch != null && !patchID.equals(patch.getUpdateID())) {
                        patch = (Update)patchTable.get(patchID);
                    } else if (patch == null) continue;
                }
                String property = key.substring(key.indexOf(".") + 1);
                if (property.equals("syn")) {
                    patch.setDescription(value);
                } else if (property.equals("req")) {
                    if (!this.validatePatchID(value)) continue;
                    toks = value.split(" ");
                    if (toks.length > 0) {
                        patch.setRequiredUpdateNames(toks);
                    }
                } else if (property.equals("props")) {
                    toks = value.split(" ");
                    for (int i = 0; i < toks.length; ++i) {
                        if (this.isDownloadOnly(toks[i])) {
                            patch.setDownloadOnly(new Boolean("true"));
                            break;
                        }
                        if (!this.isRebootRequired(toks[i])) continue;
                        patch.setRestartRequired(new Boolean("true"));
                    }
                } else if (property.equals("real")) {
                    toks = value.split(" ");
                    String foundCategory = null;
                    for (int j = 0; j < categories.length; ++j) {
                        String[] tmpIDs = categoryObj.getCategoryRealizations(categories[j]);
                        for (int i = 0; i < toks.length; ++i) {
                            for (int k = 0; k < tmpIDs.length; ++k) {
                                if (toks[i].trim().indexOf(tmpIDs[k].trim()) == -1) continue;
                                category = foundCategory = categories[j];
                                break;
                            }
                            if (foundCategory != null) break;
                        }
                        if (foundCategory != null) break;
                    }
                    patch.setCategory(category);
                } else if (property.equals("rel") && value != null && value.trim().length() == 8) {
                    Date date = null;
                    try {
                        date = sdf.parse(value);
                    }
                    catch (ParseException pe) {
                        // empty catch block
                    }
                    patch.setAvailableDate(date);
                } else if (property.equals("size") && value != null) {
                    try {
                        patch.setSize(new Integer(value));
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                patchTable.put(patchID, patch);
            }
        }
        catch (IOException ie) {
            String title = I18N_WARNING.getString("read-analysis-data-error-title");
            String message = I18N_WARNING.getString("read-analysis-data-error");
            throw new ReadAnalysisDataException(title, message);
        }
        if (patchTable.size() > 0) {
            Enumeration patchIDs = patchTable.keys();
            while (patchIDs.hasMoreElements()) {
                String cat;
                String curID = (String)patchIDs.nextElement();
                Update curUpdate = (Update)patchTable.get(curID);
                if (stagedUpdates != null && ((Hashtable)stagedUpdates).containsKey(curID)) {
                    curUpdate.setUpdateStatus(new Integer(7));
                } else {
                    curUpdate.setUpdateStatus(new Integer(0));
                }
                String revision = this.getInstalledRevision(curID);
                if (revision != null) {
                    curUpdate.setInstalledRevision(revision);
                }
                if ((cat = curUpdate.getCategory()) == null || cat.length() == 0) {
                    curUpdate.setCategory("Generic");
                }
                this.addUpdate(curUpdate);
            }
        }
        if ((updates = this.getUpdates()) == null) {
            this.restoreCollectionState();
            return;
        }
        this.invokeRecursiveResolveUpdate(updates, true);
        this.restoreCollectionState();
    }

    private void invokeRecursiveResolveUpdate(Update[] updates, boolean required) {
        for (int i = 0; i < updates.length; ++i) {
            Update[] patches;
            Update curPatch = updates[i];
            if (required) {
                this.recursiveResolveDependency(curPatch, null);
                patches = curPatch.getRequiredUpdates();
            } else {
                this.recursiveResolveObsoletion(curPatch, null);
                patches = curPatch.getObsoleteUpdates();
            }
            if (patches == null || patches.length <= 0) continue;
            String[] patchNames = new String[patches.length];
            for (int j = 0; j < patches.length; ++j) {
                patchNames[j] = patches[j].getName();
            }
            if (required) {
                curPatch.setRequiredUpdateNames(patchNames);
                continue;
            }
            curPatch.setObsoleteUpdateNames(patchNames);
        }
    }

    private boolean validatePatchID(String line) {
        boolean valid = true;
        if (line.length() < 1) {
            return false;
        }
        String[] toks = line.split(" ");
        if (toks != null && toks.length > 0) {
            for (int i = 0; i < toks.length; ++i) {
                int sID = -1;
                int ver = -1;
                if (toks[i].trim().indexOf("-") == -1) {
                    valid = false;
                    break;
                }
                try {
                    sID = Integer.parseInt(toks[i].substring(0, toks[i].indexOf("-")));
                    ver = Integer.parseInt(toks[i].substring(toks[i].indexOf("-") + 1));
                    continue;
                }
                catch (NumberFormatException ne) {
                    valid = false;
                }
            }
        } else {
            valid = false;
        }
        return valid;
    }

    private void recursiveResolveDependency(Update curPatch, Update dependentPatch) {
        Update[] updates = this.getUpdates();
        String[] toks = null;
        toks = dependentPatch == null ? curPatch.getRequiredUpdateNames() : dependentPatch.getRequiredUpdateNames();
        if (toks != null && toks.length > 0) {
            block0: for (int j = 0; j < toks.length; ++j) {
                String id = toks[j];
                for (int k = 0; k < updates.length; ++k) {
                    Update loopPatch = updates[k];
                    if (!id.equals(loopPatch.getUpdateID())) continue;
                    curPatch.addRequiredUpdate(loopPatch);
                    if (loopPatch.isDownloadOnly().booleanValue() && !this.isInstalledCollection()) {
                        curPatch.setDownloadOnly(new Boolean("true"));
                    }
                    String[] reqUpdates = curPatch.getRequiredUpdateNames();
                    String[] depReqUpdates = loopPatch.getRequiredUpdateNames();
                    boolean isCircularDependent = false;
                    if (depReqUpdates != null) {
                        for (int l = 0; l < depReqUpdates.length; ++l) {
                            for (int m = 0; m < reqUpdates.length; ++m) {
                                if (!depReqUpdates[l].equals(reqUpdates[m])) continue;
                                isCircularDependent = true;
                                break;
                            }
                            if (isCircularDependent) break;
                        }
                    }
                    if (isCircularDependent || curPatch.getUpdateID().equals(loopPatch.getUpdateID())) continue;
                    this.recursiveResolveDependency(curPatch, loopPatch);
                    continue block0;
                }
            }
        }
    }

    private void recursiveResolveObsoletion(Update curPatch, Update obsoletePatch) {
        Update[] updates = this.getUpdates();
        String[] toks = null;
        toks = obsoletePatch == null ? curPatch.getObsoleteUpdateNames() : obsoletePatch.getObsoleteUpdateNames();
        if (toks != null && toks.length > 0) {
            block0: for (int j = 0; j < toks.length; ++j) {
                String id = toks[j];
                for (int k = 0; k < updates.length; ++k) {
                    Update loopPatch = updates[k];
                    if (!id.equals(loopPatch.getUpdateID())) continue;
                    curPatch.addObsoleteUpdate(loopPatch);
                    this.recursiveResolveDependency(curPatch, loopPatch);
                    continue block0;
                }
            }
        }
    }

    private void generateCollectionData(File storedDataFile) throws CMDExecutionException, NotAuthenticatedException, CollectionFileException, CategoryFileException {
        collectionObj = SolarisDataCollector.getCollectionsObject();
        categoryObj = SolarisDataCollector.getCategoriesObject();
        ppro.analyze(storedDataFile.getPath());
    }

    private void populateInstalledUpdates() throws CMDExecutionException, NotAuthenticatedException {
        Update[] updates;
        String output = ppro.list();
        if (output == null || output.length() == 0) {
            return;
        }
        String[] lines = output.split("\n");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Update patch = null;
        Hashtable<String, Update> patchTable = new Hashtable<String, Update>();
        for (int i = 0; i < lines.length; ++i) {
            String[] toks;
            String line = lines[i];
            if (line == null || line.trim().length() == 0 || line.indexOf("=") == -1) continue;
            String key = line.substring(0, line.indexOf("="));
            String value = line.substring(line.indexOf("=") + 1);
            key = key.trim();
            value = value.trim();
            String patchID = key.substring(0, key.indexOf("."));
            if (patchID != null && !patchTable.containsKey(patchID)) {
                patch = SolarisPatch.getInstance();
                patch.setUpdateID(patchID);
                patch.setName(patchID);
                String revision = patchID.substring(patchID.indexOf("-") + 1);
                patch.setInstalledRevision(revision);
                patch.setUpdateStatus(new Integer(1));
                patchTable.put(patchID, patch);
            } else {
                if (patchID == null) continue;
                if (patch != null && !patchID.equals(patch.getUpdateID())) {
                    patch = (Update)patchTable.get(patchID);
                } else if (patch == null) continue;
            }
            if (key.lastIndexOf(".syn") != -1) {
                String synopsis = value;
                if (synopsis == null || synopsis.equals("") || synopsis.equalsIgnoreCase("Not Available")) {
                    synopsis = I18N_UPDATE.getString("installed-synopsis-not-available");
                }
                patch.setDescription(synopsis);
            } else if (key.lastIndexOf(".ins") != -1 && value != null) {
                Date date = null;
                String[] toks2 = value.split(" ");
                if (toks2.length == 3) {
                    try {
                        date = sdf.parse(toks2[0]);
                    }
                    catch (ParseException pe) {
                        // empty catch block
                    }
                }
                patch.setInstallationDate(date);
            } else if (key.lastIndexOf(".bko") != -1) {
                String bkoValue = line.substring(line.indexOf("=") + 1);
                if (bkoValue != null && bkoValue.equals("true")) {
                    patch.setRemovable(new Boolean("true"));
                }
            } else if (key.lastIndexOf(".req") != -1) {
                if (!this.validatePatchID(value)) continue;
                toks = value.split(" ");
                if (toks.length > 0) {
                    patch.setRequiredUpdateNames(toks);
                }
            } else if (key.lastIndexOf(".obs") != -1) {
                if (!this.validatePatchID(value)) continue;
                toks = value.split(" ");
                if (toks.length > 0) {
                    patch.setObsoleteUpdateNames(toks);
                }
            }
            patchTable.put(patchID, patch);
        }
        if (patchTable.size() > 0) {
            Enumeration ids = patchTable.keys();
            while (ids.hasMoreElements()) {
                String curID = (String)ids.nextElement();
                Update curUpdate = (Update)patchTable.get(curID);
                this.addUpdate(curUpdate);
            }
        }
        if ((updates = this.getUpdates()) == null) {
            this.setIsInstalledCollection(false);
            this.restoreCollectionState();
            return;
        }
        this.invokeRecursiveResolveUpdate(updates, true);
        this.invokeRecursiveResolveUpdate(updates, false);
        this.setIsInstalledCollection(false);
    }

    private void restoreCollectionState() {
        this.setUseStoredData(true);
    }

    private String getInstalledRevision(String patchID) {
        String revision = null;
        String idPrefix = patchID.substring(0, patchID.indexOf("-"));
        if (this.installedPatchTable.containsKey(idPrefix)) {
            revision = (String)this.installedPatchTable.get(idPrefix);
        }
        return revision;
    }

    private void populateInstalledPatchTable() {
        this.installedPatchTable = new Hashtable();
        try {
            String line;
            Runtime runtime = Runtime.getRuntime();
            Process p = runtime.exec(INSTALLED_PATCH_LIST_COMMAND);
            DataInputStream is = new DataInputStream(p.getInputStream());
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                String[] tok = line.split(" ");
                String id = tok[1].substring(0, tok[1].indexOf("-"));
                String revision = tok[1].substring(tok[1].indexOf("-") + 1);
                if (this.installedPatchTable.containsKey(id)) {
                    try {
                        String lastRevStr = (String)this.installedPatchTable.get(id);
                        int lastRevision = Integer.parseInt(lastRevStr);
                        int currentRevision = Integer.parseInt(revision);
                        if (currentRevision <= lastRevision) continue;
                        this.installedPatchTable.put(id, revision);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                    }
                    continue;
                }
                this.installedPatchTable.put(id, revision);
            }
            br.close();
            ((InputStream)is).close();
            p.destroy();
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }

    public boolean isStored() {
        File dataFile;
        boolean stored = false;
        if (propertiesUtil != null && (dataFile = propertiesUtil.getStoredDataFile(this.getName())) != null && dataFile.exists()) {
            stored = true;
        }
        return stored;
    }

    public static void invalidateCachedData() throws CMDExecutionException, NotAuthenticatedException {
        File storedDataFile;
        String patchset = UMData.getCurrentPatchset();
        if (patchset == null) {
            patchset = ppro.get("patchpro.patchset");
            UMData.setCurrentPatchset((String)patchset);
        }
        if (propertiesUtil != null && (storedDataFile = propertiesUtil.getStoredDataFile(patchset)).exists()) {
            ppro.delete(storedDataFile.getPath());
        }
    }

    public String getLastAnalysisDate() {
        File storedDataFile = propertiesUtil.getStoredDataFile(this.getName());
        String datePattern = "yyyy/MM/dd HH:mm";
        long analysisTime = storedDataFile != null && storedDataFile.exists() ? storedDataFile.lastModified() : System.currentTimeMillis();
        Date analysisDate = new Date(analysisTime);
        DateFormat df = DateFormat.getInstance();
        SimpleDateFormat analysisDateFormat = (SimpleDateFormat)df;
        analysisDateFormat.applyPattern(datePattern);
        String dateStr = df.format(analysisDate);
        String[] toks = dateStr.split(" ");
        String date = toks[0];
        String time = toks[1];
        Object[] dates = date.split("/");
        String localizedTimeString = I18N_UPDATE.format("international-date-format", dates) + " " + time;
        return localizedTimeString;
    }

    private boolean isDownloadOnly(String prop) {
        boolean download_only = false;
        for (int i = 0; i < UpdateConstants.DOWNLOAD_ONLY_PROPS.length; ++i) {
            if (!prop.startsWith(UpdateConstants.DOWNLOAD_ONLY_PROPS[i])) continue;
            download_only = true;
            break;
        }
        return download_only;
    }

    private boolean isRebootRequired(String prop) {
        boolean reboot_required = false;
        for (int i = 0; i < UpdateConstants.REBOOT_REQUIRED_PROPS.length; ++i) {
            if (!prop.startsWith(UpdateConstants.REBOOT_REQUIRED_PROPS[i])) continue;
            reboot_required = true;
            break;
        }
        return reboot_required;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

