/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.agent;

import com.sun.swup.client.agent.SwupAgentData;
import com.sun.swup.client.agent.SwupCommand;
import com.sun.swup.client.common.ExecuteCommand;
import com.sun.swup.client.common.Status;
import com.sun.swup.client.common.StatusParser;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Vector;

public class SwupUninstallCommand
extends SwupCommand {
    private static boolean debug = false;
    private static SwupAgentData sad = null;
    private Vector updateNameList = null;
    private String commandOutput;
    private String[] updateNameStrArr;

    public SwupUninstallCommand() {
        sad = SwupAgentData.getInstance();
        debug = sad.getDebug();
        this.updateNameList = new Vector();
    }

    public boolean needFreshAnalysis() {
        return true;
    }

    void addUpdateName(String update) {
        if (update != null && update.length() > 0) {
            this.updateNameList.add(update);
        }
    }

    Vector getUpdateNames() {
        return this.updateNameList;
    }

    public String getCommand() {
        StringBuffer uninstCmd = new StringBuffer("/usr/sbin/smpatch remove");
        this.updateNameStrArr = new String[this.updateNameList.size()];
        int count = 0;
        if (this.updateNameList.size() > 0) {
            Iterator it = this.updateNameList.iterator();
            while (it.hasNext()) {
                uninstCmd.append(" -i ");
                String updatenm = (String)it.next();
                this.updateNameStrArr[count++] = updatenm;
                uninstCmd.append(updatenm);
            }
            uninstCmd.append(" -C patchpro.internal.statustags=true");
            return uninstCmd.toString();
        }
        return "";
    }

    public String getRespMsg() {
        StringBuffer resMsg = new StringBuffer();
        int cmdCode = this.getCmdErrorCode();
        String cmdStatus = cmdCode == 0 ? "SUCCESS" : "EXECUTION_ERROR";
        MessageFormat msgFmt = new MessageFormat("<swup:Response swup:id=\"{0}\" swup:locale=\"{1}\" swup:status=\"{2}\" xmlns:swup=\"http://www.sun.com/swup/command\">\n");
        String lang = sad.getLocale().toString();
        Object[] msgArgs = new Object[]{this.getRefID(), lang, cmdStatus};
        resMsg.append(msgFmt.format(msgArgs));
        resMsg.append("    <swup:UninstallCommand>\n");
        resMsg.append("        <swup:UpdateList>\n");
        if (this.updateNameList.size() > 0) {
            Iterator iUpdate = this.updateNameList.iterator();
            while (iUpdate.hasNext()) {
                String updateID = (String)iUpdate.next();
                Status curUpdateStatus = this.getSmpatchStatus(updateID);
                msgFmt = new MessageFormat("            <swup:Update swup:id=\"{0}\" swup:status=\"{1}\">\n");
                int cmdErrCode = curUpdateStatus.getUMStatus();
                String commandStatus = cmdErrCode == 0 ? "SUCCESS" : "FAILED";
                Object[] msgArgs2 = new Object[]{updateID, commandStatus};
                resMsg.append(msgFmt.format(msgArgs2));
                msgFmt = new MessageFormat("            <swup:Detail swup:code=\"{0}\" >\n");
                String completionCode = "smpatch." + curUpdateStatus.getCompletionCode();
                if (curUpdateStatus.getUMStatus() == -1) {
                    completionCode = "execerror";
                }
                Object[] msgArgs3 = new Object[]{completionCode};
                resMsg.append(msgFmt.format(msgArgs3));
                resMsg.append("                <swup:Message>\n");
                msgFmt = new MessageFormat("                    {0}");
                String completionMessage = curUpdateStatus.getCompletionMessage();
                if (curUpdateStatus.getUMStatus() == -1) {
                    completionMessage = this.commandOutput;
                }
                Object[] msgArgs5 = new Object[]{completionMessage};
                resMsg.append(msgFmt.format(msgArgs5));
                resMsg.append("                </swup:Message>\n");
                resMsg.append("            </swup:Detail >\n");
                resMsg.append("            </swup:Update>\n");
            }
        }
        resMsg.append("        </swup:UpdateList>\n");
        resMsg.append("    </swup:UninstallCommand>\n");
        resMsg.append("</swup:Response>");
        if (debug) {
            if (this.instStatus != null) {
                System.out.println("number of instStatus objects: " + this.instStatus.length);
                for (int ii = 0; ii < this.instStatus.length; ++ii) {
                    System.out.println("update: " + this.instStatus[ii].getUpdateID());
                    int umStatus = this.instStatus[ii].getUMStatus();
                    String umStatusStr = "NOT_SET";
                    if (umStatus == 0) {
                        umStatusStr = "SUCCESS";
                    } else if (umStatus == 2 || umStatus == 4) {
                        umStatusStr = "PENDING_REBOOT";
                    } else if (umStatus == 3) {
                        umStatusStr = "DOWNLOAD_ONLY";
                    } else if (umStatus == 1) {
                        umStatusStr = "FAILED";
                    }
                    System.out.println("   uninstall UM status:    " + umStatusStr);
                    System.out.println("   uninstall smpatch code: " + this.instStatus[ii].getCompletionCode());
                    System.out.println("   uninstall msg:          " + this.instStatus[ii].getCompletionMessage());
                    System.out.println("   ");
                }
            } else {
                System.out.println("There are no parsed status!!!");
            }
        }
        return resMsg.toString();
    }

    public void dumpIt() {
        System.out.println("\nSWUP Command:");
        System.out.println("cmd type: remove");
        System.out.println("Transport RefID: " + this.getTransportRefID());
        System.out.println("Swup Serv RefID: " + this.getRefID());
        if (this.updateNameList.size() > 0) {
            System.out.println("List of patches to remove:");
            Iterator it = this.updateNameList.iterator();
            while (it.hasNext()) {
                System.out.println((String)it.next());
            }
            System.out.println("Remove cmd: " + this.getCommand());
        } else {
            System.out.println("No patches found");
        }
    }

    public int executeCommand() {
        int retstatus = 0;
        String cmd = this.getCommand();
        if (cmd != null) {
            ExecuteCommand ec = new ExecuteCommand(cmd);
            if (debug) {
                System.out.println("in executeInstall(), install cmd:" + cmd);
            }
            ec.setCollectOutput(true);
            try {
                if (debug) {
                    System.out.println("starting to execute uninstall cmd....");
                }
                ec.execute();
            }
            catch (InterruptedException ie) {
                retstatus = -1;
                return retstatus;
            }
            String cmdOutput = ec.getAllOutput();
            if (debug) {
                System.out.println("collected output: \n" + cmdOutput);
            }
            this.instStatus = StatusParser.parseMessages((String[])this.updateNameStrArr, (String)cmdOutput);
            this.commandOutput = cmdOutput.trim();
            retstatus = ec.getResult();
            if (debug) {
                System.out.println("cmd ret status: " + retstatus);
            }
            this.setCmdErrorCode(retstatus);
            this.setCmdErrorMsg(cmdOutput);
        }
        return retstatus;
    }

    public void dumpResp() {
        System.out.println("\nSWUP Command Response:");
        System.out.println("resp type: remove");
        if (this.updateNameList.size() > 0) {
            System.out.println("List of patches to remove:");
            Iterator it = this.updateNameList.iterator();
            while (it.hasNext()) {
                System.out.println((String)it.next());
            }
            System.out.println("Response xml: \n" + this.getRespMsg());
        } else {
            System.out.println("No patches found");
        }
    }
}

