/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.tray.internal.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.jdic.tray.internal.TrayIconService;
import org.jdesktop.jdic.tray.internal.impl.GnomeSystemTrayService;
import org.jdesktop.jdic.tray.internal.impl.GnomeTrayAppletService;

public class GnomeTrayIconService
extends GnomeTrayAppletService
implements TrayIconService {
    private JPopupMenu menu;
    private JDialog popupMenuParent;
    private IconPanel iconPanel;
    private Icon icon;
    private HWToolTip tooltip;
    private BalloonMessageWindow bmw;
    private boolean autoSize;
    private LinkedList actionList = new LinkedList();
    private LinkedList balloonListeners = new LinkedList();
    static /* synthetic */ Class class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService;

    public GnomeTrayIconService() {
        this.initFrame();
    }

    void initFrame() {
        this.iconPanel = new IconPanel();
        this.frame.add(this.iconPanel);
        this.frame.setFocusable(true);
        this.frame.requestFocus();
        this.bmw = new BalloonMessageWindow(this.frame);
        this.initListeners();
        this.popupMenuParent = new JDialog((Frame)this.frame, "JDIC Tray Icon");
        this.popupMenuParent.setUndecorated(true);
    }

    void mousePressed(final MouseEvent mouseEvent) {
        if (this.tooltip != null) {
            this.tooltip.setVisible(false);
        }
        if (mouseEvent.isPopupTrigger()) {
            if (this.menu != null) {
                Dimension dimension = this.menu.getPreferredSize();
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                final Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
                point.x = point.x + dimension.width > dimension2.width ? point.x - dimension.width : point.x;
                point.y = point.y + dimension.height > dimension2.height ? point.y - dimension.height : point.y;
                SwingUtilities.convertPointFromScreen(point, this.popupMenuParent);
                this.popupMenuParent.setVisible(true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GnomeTrayIconService.this.menu.show(GnomeTrayIconService.this.popupMenuParent.getContentPane(), point.x, point.y);
                        GnomeTrayIconService.this.popupMenuParent.toFront();
                    }
                });
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Thread thread = new Thread(this){
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            ListIterator<E> listIterator = GnomeTrayIconService.access$300(2.access$200(this.this$1)).listIterator(0);
                            while (listIterator.hasNext()) {
                                ActionListener actionListener = (ActionListener)listIterator.next();
                                actionListener.actionPerformed(new ActionEvent(2.access$200(this.this$1), 1001, "PressAction", 2.access$400(this.this$1).getWhen(), 2.access$400(this.this$1).getModifiers()));
                            }
                        }
                    };
                    thread.start();
                }

                static /* synthetic */ GnomeTrayIconService access$200(2 var0) {
                    return var0.GnomeTrayIconService.this;
                }

                static /* synthetic */ MouseEvent access$400(2 var0) {
                    return var0.mouseEvent;
                }
            });
        }
    }

    void mouseEntered(MouseEvent mouseEvent) {
        if (this.tooltip != null && (this.menu == null || this.menu != null && !this.menu.isShowing())) {
            Dimension dimension = this.tooltip.getSize();
            Point point = this.frame.getLocationOnScreen();
            Dimension dimension2 = this.tooltip.getPreferredSize();
            this.tooltip.show(point.x, point.y - dimension2.height - 5);
        }
    }

    void mouseExited(MouseEvent mouseEvent) {
        if (this.tooltip != null) {
            this.tooltip.setVisible(false);
        }
    }

    void initListeners() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                GnomeTrayIconService.this.mousePressed(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                GnomeTrayIconService.this.mouseEntered(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                GnomeTrayIconService.this.mouseExited(mouseEvent);
            }
        };
        this.iconPanel.addMouseListener(mouseAdapter);
        this.frame.addMouseListener(mouseAdapter);
    }

    public void addNotify() {
        if (GnomeTrayAppletService.winMap.get(new Long(this.getWindow())) == null) {
            super.init();
            this.initFrame();
            if (this.icon != null) {
                this.setIcon(this.icon);
            }
            if (this.menu != null) {
                this.setPopupMenu(this.menu);
            }
            if (this.tooltip != null) {
                this.tooltip = new HWToolTip(this.tooltip.label.getTipText(), this.frame);
            }
        }
        GnomeSystemTrayService.dockWindow(this.getWindow());
        this.frame.setVisible(true);
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.menu = jPopupMenu;
        if (jPopupMenu != null) {
            jPopupMenu.setLightWeightPopupEnabled(false);
            jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    GnomeTrayIconService.this.popupMenuParent.setVisible(false);
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            });
            this.popupMenuParent.addWindowFocusListener(new WindowFocusListener(){

                public void windowGainedFocus(WindowEvent windowEvent) {
                }

                public void windowLostFocus(WindowEvent windowEvent) {
                    GnomeTrayIconService.this.menu.setVisible(false);
                }
            });
        }
    }

    public void setIcon(final Icon icon) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GnomeTrayIconService.this.icon = icon;
                if (GnomeTrayIconService.this.icon != null) {
                    int n = GnomeTrayIconService.this.icon.getIconWidth();
                    int n2 = GnomeTrayIconService.this.icon.getIconHeight();
                    GnomeTrayIconService.this.reshape(0, 0, n, n2);
                    GnomeTrayIconService.this.frame.setVisible(false);
                    GnomeTrayIconService.this.frame.remove(GnomeTrayIconService.this.iconPanel);
                    GnomeTrayIconService.this.iconPanel = new IconPanel();
                    GnomeTrayIconService.this.frame.add(GnomeTrayIconService.this.iconPanel);
                    GnomeTrayIconService.this.frame.setVisible(true);
                }
                GnomeTrayIconService.this.iconPanel.repaint();
            }
        });
    }

    public void setCaption(String string) {
        if (this.tooltip == null) {
            this.tooltip = new HWToolTip(string, this.frame);
        } else {
            this.tooltip.setCaption(string);
        }
    }

    public void setIconAutoSize(boolean bl) {
        this.autoSize = bl;
        if (this.autoSize && this.icon != null) {
            int n = this.icon.getIconWidth();
            int n2 = this.icon.getIconHeight();
            this.reshape(0, 0, n, n2);
            this.frame.setVisible(false);
            this.frame.remove(this.iconPanel);
            this.iconPanel = new IconPanel();
            this.frame.add(this.iconPanel);
            this.frame.setVisible(true);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionList.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionList.remove(actionListener);
    }

    public Point getLocationOnScreen() {
        Point point = null;
        if (this.iconPanel != null) {
            point = this.iconPanel.getLocationOnScreen();
        }
        return point;
    }

    public void showBalloonMessage(String string, String string2, int n) {
        if (string == null && string2 == null) {
            throw new NullPointerException();
        }
        this.bmw.showBalloonMessage(string, string2, n);
    }

    public void addBalloonActionListener(ActionListener actionListener) {
        this.balloonListeners.add(actionListener);
    }

    public void removeBalloonActionListener(ActionListener actionListener) {
        this.balloonListeners.remove(actionListener);
    }

    static /* synthetic */ LinkedList access$300(GnomeTrayIconService gnomeTrayIconService) {
        return gnomeTrayIconService.actionList;
    }

    static /* synthetic */ LinkedList access$1000(GnomeTrayIconService gnomeTrayIconService) {
        return gnomeTrayIconService.balloonListeners;
    }

    class BalloonMessageWindow
    extends JWindow {
        Dimension sd;
        Dimension pd;
        Dimension d;
        Point pp;
        Point p;
        boolean downToup;
        JLabel captionLabel;
        JLabel textLabel;
        private Thread showThread;
        private Thread hideThread;
        private int timeout;
        private int delay;
        private int pixel;
        private ActionListener hideAction;
        private Timer hideTimer;

        public BalloonMessageWindow(Window window) {
            super(window);
            this.downToup = true;
            this.captionLabel = new JLabel();
            this.textLabel = new JLabel();
            this.timeout = 10000;
            this.delay = 15;
            this.pixel = 2;
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            this.getContentPane().add(jPanel);
            jPanel.setLayout(new BorderLayout());
            jPanel.add(jPanel2);
            jPanel.setBorder(BorderFactory.createBevelBorder(0, new Color(13359859), new Color(3099256)));
            jPanel2.setLayout(new BorderLayout());
            jPanel2.setBorder(BorderFactory.createBevelBorder(1, new Color(13359859), new Color(3099256)));
            this.captionLabel.setFont(new Font("SansSerif", 1, 12));
            this.textLabel.setFont(new Font("SansSerif", 0, 12));
            jPanel2.setBackground(new Color(0xFFFFE1));
            jPanel2.setOpaque(true);
            this.textLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 3, 3));
            ImageIcon imageIcon = new ImageIcon((class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService == null ? (class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService = GnomeTrayIconService.class$("org.jdesktop.jdic.tray.internal.impl.GnomeTrayIconService")) : class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService).getResource("images/x.png"));
            ImageIcon imageIcon2 = new ImageIcon((class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService == null ? (class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService = GnomeTrayIconService.class$("org.jdesktop.jdic.tray.internal.impl.GnomeTrayIconService")) : class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService).getResource("images/xx.png"));
            ImageIcon imageIcon3 = new ImageIcon((class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService == null ? (class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService = GnomeTrayIconService.class$("org.jdesktop.jdic.tray.internal.impl.GnomeTrayIconService")) : class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService).getResource("images/xxx.png"));
            JButton jButton = new JButton(imageIcon);
            jButton.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
            jButton.setRolloverEnabled(true);
            jButton.setRolloverIcon(imageIcon2);
            jButton.setPressedIcon(imageIcon3);
            jButton.setBorder(null);
            jButton.addActionListener(new ActionListener(){
                private final /* synthetic */ GnomeTrayIconService val$this$0;
                private final /* synthetic */ BalloonMessageWindow this$1;
                {
                    this.this$1 = balloonMessageWindow;
                    this.val$this$0 = gnomeTrayIconService;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    BalloonMessageWindow.access$800(this.this$1);
                }
            });
            jButton.setToolTipText("Close");
            JPanel jPanel3 = new JPanel();
            jPanel3.setOpaque(false);
            jPanel3.setLayout(new BorderLayout());
            jPanel3.add((Component)jButton, "North");
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BorderLayout());
            jPanel4.setOpaque(false);
            jPanel4.add((Component)jPanel3, "East");
            jPanel4.add((Component)this.captionLabel, "Center");
            jPanel4.setBorder(BorderFactory.createEmptyBorder(3, 5, 0, 3));
            jPanel2.add((Component)jPanel4, "North");
            jPanel2.add((Component)this.textLabel, "Center");
            jPanel.addMouseListener(new MouseAdapter(){
                private final /* synthetic */ GnomeTrayIconService val$this$0;
                private final /* synthetic */ BalloonMessageWindow this$1;
                {
                    this.this$1 = balloonMessageWindow;
                    this.val$this$0 = gnomeTrayIconService;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    BalloonMessageWindow.access$800(this.this$1);
                    ListIterator<E> listIterator = GnomeTrayIconService.access$1000(BalloonMessageWindow.access$900(this.this$1)).listIterator(0);
                    while (listIterator.hasNext()) {
                        ActionListener actionListener = (ActionListener)listIterator.next();
                        actionListener.actionPerformed(new ActionEvent(BalloonMessageWindow.access$900(this.this$1), 1001, "PressAction", mouseEvent.getWhen(), mouseEvent.getModifiers()));
                    }
                }
            });
            this.hideAction = new ActionListener(this){
                private final /* synthetic */ BalloonMessageWindow this$1;
                {
                    this.this$1 = balloonMessageWindow;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    BalloonMessageWindow.access$1100(this.this$1);
                }
            };
            this.hideTimer = new Timer(this.timeout, this.hideAction);
            this.hideTimer.setRepeats(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void hideCurrentMessageWindowImmediately() {
            if (this.hideThread != null) {
                this.hideThread.interrupt();
            } else if (this.showThread != null) {
                this.hideTimer.stop();
                this.showThread.interrupt();
                this.setVisible(false);
                Class clazz = class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService == null ? (class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService = GnomeTrayIconService.class$("org.jdesktop.jdic.tray.internal.impl.GnomeTrayIconService")) : class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService;
                synchronized (clazz) {
                    (class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService == null ? (class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService = GnomeTrayIconService.class$("org.jdesktop.jdic.tray.internal.impl.GnomeTrayIconService")) : class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService).notify();
                    this.showThread = null;
                }
            }
        }

        public void showBalloonMessage(String string, String string2, int n) {
            if (this.showThread != null) {
                Thread thread = new Thread(){
                    private final /* synthetic */ String val$caption;
                    private final /* synthetic */ String val$text;
                    private final /* synthetic */ int val$type;
                    private final /* synthetic */ BalloonMessageWindow this$1;
                    {
                        this.this$1 = balloonMessageWindow;
                        this.val$caption = string;
                        this.val$text = string2;
                        this.val$type = n;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Class clazz = class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService == null ? (class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService = GnomeTrayIconService.class$("org.jdesktop.jdic.tray.internal.impl.GnomeTrayIconService")) : class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService;
                        synchronized (clazz) {
                            try {
                                if (BalloonMessageWindow.access$1200(this.this$1) != null) {
                                    (class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService == null ? (class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService = GnomeTrayIconService.class$("org.jdesktop.jdic.tray.internal.impl.GnomeTrayIconService")) : class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService).wait();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                        BalloonMessageWindow.access$1300(this.this$1, this.val$caption, this.val$text, this.val$type);
                    }
                };
                thread.start();
            } else {
                this.doShowMessageWindow(string, string2, n);
            }
        }

        private void doShowMessageWindow(String string, String string2, int n) {
            this.showThread = new Thread(){
                private final /* synthetic */ String val$caption;
                private final /* synthetic */ String val$text;
                private final /* synthetic */ int val$type;
                private final /* synthetic */ BalloonMessageWindow this$1;
                {
                    this.this$1 = balloonMessageWindow;
                    this.val$caption = string;
                    this.val$text = string2;
                    this.val$type = n;
                }

                public void run() {
                    BalloonMessageWindow.access$1400(this.this$1, this.val$caption, this.val$text, this.val$type);
                }
            };
            this.showThread.start();
        }

        private synchronized void doShow(String string, String string2, int n) {
            switch (n) {
                case 0: {
                    this.captionLabel.setIcon(new ImageIcon((class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService == null ? (class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService = GnomeTrayIconService.class$("org.jdesktop.jdic.tray.internal.impl.GnomeTrayIconService")) : class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService).getResource("images/info.png")));
                    break;
                }
                case 1: {
                    this.captionLabel.setIcon(new ImageIcon((class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService == null ? (class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService = GnomeTrayIconService.class$("org.jdesktop.jdic.tray.internal.impl.GnomeTrayIconService")) : class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService).getResource("images/error.png")));
                    break;
                }
                case 2: {
                    this.captionLabel.setIcon(new ImageIcon((class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService == null ? (class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService = GnomeTrayIconService.class$("org.jdesktop.jdic.tray.internal.impl.GnomeTrayIconService")) : class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService).getResource("images/warning.png")));
                    break;
                }
                default: {
                    this.captionLabel.setIcon(null);
                }
            }
            this.captionLabel.setText(string != null ? string : "");
            if (string2 != null) {
                string2 = "<html>" + string2.replaceAll("\\n", "<br>") + "</html>";
                this.textLabel.setText(string2);
            } else {
                this.textLabel.setText("");
            }
            this.pack();
            this.pp = GnomeTrayIconService.this.frame.getLocation();
            SwingUtilities.convertPointToScreen(this.pp, GnomeTrayIconService.this.frame);
            this.p = new Point();
            this.sd = Toolkit.getDefaultToolkit().getScreenSize();
            this.pd = GnomeTrayIconService.this.frame.getSize();
            this.d = this.getSize();
            this.pp.x -= 2;
            this.pp.y -= 4;
            this.pd.width += 2;
            this.pd.height += 6;
            this.p.x = this.pp.x + this.d.width < this.sd.width ? this.pp.x : this.sd.width - this.d.width;
            this.downToup = this.pp.y - this.d.height > 0;
            this.p.y = this.pp.y - this.d.height > 0 ? this.pp.y - this.d.height : this.pp.y + this.pd.height;
            try {
                if (this.downToup) {
                    this.setBounds(this.p.x, this.p.y + this.d.height, this.d.width, 1);
                } else {
                    this.setBounds(this.p.x, this.p.y, this.d.width, 1);
                }
                this.setVisible(true);
                for (int i = 1; i < this.d.height; i += this.pixel) {
                    Thread.sleep(this.delay);
                    if (this.downToup) {
                        this.setBounds(this.p.x, this.p.y + this.d.height - i, this.d.width, i);
                    } else {
                        this.setBounds(this.p.x, this.p.y, this.d.width, i);
                    }
                    this.validate();
                }
                if (this.p.y != this.getLocation().y || (double)this.d.height != this.getSize().getHeight()) {
                    this.setBounds(this.p.x, this.p.y, this.d.width, this.d.height);
                    this.validate();
                }
                this.hideTimer.start();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void doHide() {
            this.hideThread = new Thread(this){
                private final /* synthetic */ BalloonMessageWindow this$1;
                {
                    this.this$1 = balloonMessageWindow;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    this.this$1.p = this.this$1.getLocation();
                    this.this$1.d = this.this$1.getSize();
                    try {
                        for (int i = this.this$1.d.height; i >= 1; i -= BalloonMessageWindow.access$1500(this.this$1)) {
                            Thread.sleep(BalloonMessageWindow.access$1600(this.this$1));
                            if (this.this$1.downToup) {
                                this.this$1.setBounds(this.this$1.p.x, this.this$1.p.y + this.this$1.d.height - i, this.this$1.d.width, i);
                            } else {
                                this.this$1.setSize(this.this$1.d.width, i);
                            }
                            this.this$1.validate();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.this$1.setVisible(false);
                    Class clazz = class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService == null ? (class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService = GnomeTrayIconService.class$("org.jdesktop.jdic.tray.internal.impl.GnomeTrayIconService")) : class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService;
                    synchronized (clazz) {
                        BalloonMessageWindow.access$1202(this.this$1, null);
                        (class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService == null ? (class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService = GnomeTrayIconService.class$("org.jdesktop.jdic.tray.internal.impl.GnomeTrayIconService")) : class$org$jdesktop$jdic$tray$internal$impl$GnomeTrayIconService).notify();
                    }
                    BalloonMessageWindow.access$1702(this.this$1, null);
                }
            };
            this.hideThread.start();
        }

        static /* synthetic */ void access$800(BalloonMessageWindow balloonMessageWindow) {
            balloonMessageWindow.hideCurrentMessageWindowImmediately();
        }

        static /* synthetic */ GnomeTrayIconService access$900(BalloonMessageWindow balloonMessageWindow) {
            return balloonMessageWindow.GnomeTrayIconService.this;
        }

        static /* synthetic */ void access$1100(BalloonMessageWindow balloonMessageWindow) {
            balloonMessageWindow.doHide();
        }

        static /* synthetic */ Thread access$1200(BalloonMessageWindow balloonMessageWindow) {
            return balloonMessageWindow.showThread;
        }

        static /* synthetic */ void access$1300(BalloonMessageWindow balloonMessageWindow, String string, String string2, int n) {
            balloonMessageWindow.doShowMessageWindow(string, string2, n);
        }

        static /* synthetic */ void access$1400(BalloonMessageWindow balloonMessageWindow, String string, String string2, int n) {
            balloonMessageWindow.doShow(string, string2, n);
        }

        static /* synthetic */ int access$1500(BalloonMessageWindow balloonMessageWindow) {
            return balloonMessageWindow.pixel;
        }

        static /* synthetic */ int access$1600(BalloonMessageWindow balloonMessageWindow) {
            return balloonMessageWindow.delay;
        }

        static /* synthetic */ Thread access$1202(BalloonMessageWindow balloonMessageWindow, Thread thread) {
            balloonMessageWindow.showThread = thread;
            return balloonMessageWindow.showThread;
        }

        static /* synthetic */ Thread access$1702(BalloonMessageWindow balloonMessageWindow, Thread thread) {
            balloonMessageWindow.hideThread = thread;
            return balloonMessageWindow.hideThread;
        }
    }

    class HWToolTip
    extends JWindow {
        Font font;
        JToolTip label;

        public HWToolTip(String string, Window window) {
            super(window);
            this.font = new Font("Serif", 10, 0);
            this.setFocusableWindowState(false);
            this.setName("###overrideRedirect###");
            this.label = new JToolTip();
            this.label.setTipText(string);
            this.getContentPane().add(this.label);
        }

        public void setCaption(String string) {
            this.label.setTipText(string);
        }

        public void show(int n, int n2) {
            this.setLocation(n, n2);
            Dimension dimension = this.label.getPreferredSize();
            this.setSize(dimension.width, dimension.height);
            this.setVisible(true);
        }
    }

    class IconPanel
    extends JComponent {
        Image img;

        IconPanel() {
        }

        public void paintComponent(Graphics graphics) {
            Dimension dimension = GnomeTrayIconService.this.getAppletSize();
            graphics.clearRect(0, 0, dimension.width, dimension.height);
            if (GnomeTrayIconService.this.icon != null) {
                int n = GnomeTrayIconService.this.icon.getIconWidth();
                int n2 = GnomeTrayIconService.this.icon.getIconHeight();
                if (!GnomeTrayIconService.this.autoSize) {
                    GnomeTrayIconService.this.icon.paintIcon(this, graphics, 0, 0);
                } else {
                    if (this.img == null) {
                        this.img = this.createImage(n, n2);
                    }
                    GnomeTrayIconService.this.icon.paintIcon(this, this.img.getGraphics(), 0, 0);
                    graphics.drawImage(this.img, 0, 0, dimension.width, dimension.height, 0, 0, n, n2, this);
                }
            }
            super.paintComponent(graphics);
        }

        boolean doesIconReferenceImage(Icon icon, Image image) {
            Image image2 = icon != null && icon instanceof ImageIcon ? ((ImageIcon)icon).getImage() : null;
            return image2 == image;
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if (!this.isShowing() || !this.doesIconReferenceImage(GnomeTrayIconService.this.icon, image)) {
                return false;
            }
            return super.imageUpdate(image, n, n2, n3, n4, n5);
        }
    }
}

