/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.server;

import com.sun.net.ssl.HttpsURLConnection;
import com.sun.net.ssl.internal.ssl.Provider;
import com.sun.patchpro.host.SessionData;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.BadHttpResponseException;
import com.sun.patchpro.model.CancelManager;
import com.sun.patchpro.model.DownloadPatchEvent;
import com.sun.patchpro.model.DownloadPatchListener;
import com.sun.patchpro.model.InvalidPatchDownloadDirectoryException;
import com.sun.patchpro.model.PatchDownloadDirectoryAccessException;
import com.sun.patchpro.model.PatchDownloadIOException;
import com.sun.patchpro.model.PatchDownloadResponseException;
import com.sun.patchpro.model.PatchNotAvailableException;
import com.sun.patchpro.model.PatchNotFoundException;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.model.PatchProRuntimeException;
import com.sun.patchpro.model.PatchSignatureValidationException;
import com.sun.patchpro.model.ServerConnectionException;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchBundleInfo;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchInfoImpl;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.patch.PatchProperties;
import com.sun.patchpro.security.ManifestFileNotFoundException;
import com.sun.patchpro.security.NotSignedByKnownCertificateException;
import com.sun.patchpro.security.SSLTunnelSocketFactory;
import com.sun.patchpro.security.SignatureCheckFailedException;
import com.sun.patchpro.security.SignatureValidationException;
import com.sun.patchpro.security.SignatureValidationUtil;
import com.sun.patchpro.server.DownloadDocumentFileException;
import com.sun.patchpro.server.DownloadEntitlementFileException;
import com.sun.patchpro.server.DownloadPatchDBException;
import com.sun.patchpro.server.DownloadPatchException;
import com.sun.patchpro.server.DownloadRealizationException;
import com.sun.patchpro.server.NotSupportedException;
import com.sun.patchpro.server.PatchServiceProvider;
import com.sun.patchpro.server.PatchServiceUtil;
import com.sun.patchpro.server.ServerPatchServiceProviderException;
import com.sun.patchpro.server.ServerProxyAuthenticator;
import com.sun.patchpro.util.CachingDownloader;
import com.sun.patchpro.util.CannotReservePatchException;
import com.sun.patchpro.util.ConfigException;
import com.sun.patchpro.util.Downloader;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.Percentage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.SSLSocketFactory;

public class ServerPatchServiceProvider
implements PatchServiceProvider {
    private LocalizedMessages msgcat;
    PatchInfoImpl genPatchInfo = null;
    boolean downloadAuthenticate = true;
    boolean isPatchServer = false;
    boolean updateSessionData = true;
    boolean useCache = true;
    boolean debug = false;
    boolean internalStatus = false;
    PatchProProperties properties = PatchProProperties.getInstance();
    PatchProLog log;
    SignatureValidationUtil validationUtil;
    ServerProxyAuthenticator serverProxyAuthenticator = null;
    String keystoreLocation;
    String patchBundlePrefix = "";
    String serverURLString;
    String[] signingCertAliasArray;
    String signingCertAlias;
    String sunSolvePasswd = "";
    String sunSolveUser = "";
    String proxyUser = "";
    String proxyPasswd = "";
    String proxySvrCliHost = "";
    String proxySvrCliPort = "";
    String targetLocation;
    URL serverURL;
    Vector listeners;
    String entitlement_name = null;
    int totalIncrements = 0;
    int increments = 0;
    Percentage percentProgress;
    static final int SEGMENTED_PATCHLIST_SIZE = 10;
    static final String AUTHENTICATION_FAILED = "ServicePatchServiceProvider.AUTHENTICATION_FAILED";
    static final String DOWNLOAD_DIR_NOT_EXIST = "Patch download directory does not exist.";
    static final String DOWNLOAD_DIR_NOT_WRITABLE = "Patch download directory is not writable.";
    static final String FAILED_TO_CREATE_DOWNLOADER = "Failed to create a downloader to download patches.";
    static final String FAILED_TO_CONNECT_TO_SERVER = "Cannot connect to server. Verify that the patch server, local proxy server and Sunsolve user name & password information are all correct. Also, make sure that the network is currently available for use.";
    static final String FAILED_TO_DOWNLOAD_A_PATCH = "Problem encountered while downloading a patch. Determine if the file system containing the patch download directory is full; the file system is corrupted; or the directory permissions were changed during download.";
    static final String FAILED_TO_CREATE_VALIDATION_UTIL = "Failed to create the signature validation utility.";
    public static final String FAILED_TO_VALIDATE_SIGNATURE = "Failed to validate the digital signature(s).";
    static final String HTTP_PARTIAL_CONTENT = "Status code 206 returned.  The client's request was only partially fulfilled.";
    static final String HTTP_BAD_REQUEST = "Status code 400 returned. The server could not understand the request, probably due to a syntax error in the HTTP request.";
    static final String HTTP_UNAUTHORIZED = "Status code 401 returned. The request lacked proper authorization.";
    static final String HTTP_FORBIDDEN = "Status code 403 returned. The request was understood, but the server is not willing to fulfill it.";
    static final String HTTP_NOT_FOUND = "Status code 404 returned. The requested resource was not found or is not available.";
    static final String HTTP_INTERNAL_SERVER_ERROR = "Status code 500 returned. An unexpected error occurred inside the server that prevented it from fulfilling the request.";
    static final String HTTP_NOT_IMPLEMENTED = "Status code 501 returned. The server does not support the functionality needed to fulfill the request.";
    static final String HTTP_UNKNOWN_ERROR = "Unknown HTTP status code returned.";
    static final String PATCH_NOT_FOUND = "Patch cannot be found by server.";
    static final String PATCH_NOT_ON_DISK = "Patch could not be found locally.";
    static final String INCORRECT_URL = "Incorrect downloading URL specified.";
    static final String INVALID_DESTINATION_TYPE = "Download destination is not a String object that indicates  the download location.";
    static final String INVALID_FILE_PERMISSION = "The write permission is not set.";
    static final String INVALID_PATCH_BUNDLE_FILE_NAME = "Invalid patch bundle file name.";
    static final String KEYSTORE_LOCATION_NOT_SPECIFIED = "patchpro.security.kslocation is not specified.";
    static final String NOT_ABLE_TO_DETERMINE_SIGNING_CERT_SN = "Cannot determine signing certificate serial number.";
    static final String PATCH_DOWNLOAD_DONE = "Patch download is done.";
    static final String SERVER_NOT_SSL_ENABLED = "This server is not SSL-enabled. ";
    static final String SERVER_SSL_ENABLED = "This server is SSL-enabled. ";
    static final String SERVER_NOT_SPECIFIED = "patchpro.patch.source is not specified.";
    static final String PATCH_SERVER_NOT_DEFINED = "A patch source server has not been defined.";
    static final String PATCH_SERVER_PROPERTY_NOT_DEFINED = "A patch server source property is not defined.";
    static final String SIGNING_CERT_REVOKED = "Signing certificate has been revoked.";
    static final String UNKNOWN_CONTENT_TYPE = "Unknown content-type returned from the server.";
    static final String PATCH_SIGNING_CERTIFICATE_ALIAS_NOT_DEFINED = "The certificate(s) used to sign patches is not specified.";

    public ServerPatchServiceProvider() throws ServerPatchServiceProviderException, PatchProException {
        StringTokenizer stringTokenizer;
        String string;
        this.debug = this.properties.getProperty("patchpro.debug", "false").equals("true");
        this.internalStatus = this.properties.getProperty("patchpro.internal.statustags", "false").compareTo("true") == 0;
        this.log = PatchProLog.getInstance();
        this.listeners = new Vector();
        this.configure(this.properties);
        this.msgcat = new LocalizedMessages(this.properties.getLocale());
        this.downloadAuthenticate = this.properties.downloadAuthenticationRequired();
        if (this.downloadAuthenticate) {
            string = this.properties.getProperty("patchpro.security.patch.signingcert.alias");
            String[] stringArray = null;
            if (string != null) {
                stringTokenizer = new StringTokenizer(string, ":");
                stringArray = new String[stringTokenizer.countTokens()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = stringTokenizer.nextToken();
                }
            } else {
                this.log.println(this, 2, PATCH_SIGNING_CERTIFICATE_ALIAS_NOT_DEFINED);
                throw new ServerPatchServiceProviderException(PATCH_SIGNING_CERTIFICATE_ALIAS_NOT_DEFINED);
            }
            this.keystoreLocation = this.properties.getProperty("patchpro.security.kslocation");
            try {
                this.validationUtil = new SignatureValidationUtil(this.keystoreLocation, stringArray);
            }
            catch (SignatureValidationException signatureValidationException) {
                String string2 = "Failed to create the signature validation utility. " + signatureValidationException.getMessage();
                this.log.printStackTrace(this, 2, signatureValidationException);
                this.log.println(this, 3, string2);
                this.dispatchFailedEvent(PatchProLog.createMessage(2, FAILED_TO_CREATE_VALIDATION_UTIL));
                throw new ServerPatchServiceProviderException(signatureValidationException.getMessage());
            }
            this.signingCertAliasArray = this.validationUtil.getCertificateAliases();
            this.debug = this.properties.getProperty("patchpro.debug.default", "false").equals("true");
        }
        this.isPatchServer = this.properties.getProperty("patchpro.ispatchserver").equals("true");
        if (this.isPatchServer) {
            string = this.properties.getProperty("patchsvr.source.url");
            if (string == null) {
                string = this.properties.getProperty("patchsvr.source.0.url");
            }
            if (string != null) {
                stringTokenizer = new StringTokenizer(string, ",");
                if (!stringTokenizer.hasMoreElements()) {
                    this.log.println(this, 2, PATCH_SERVER_NOT_DEFINED);
                    throw new ServerPatchServiceProviderException(9);
                }
            } else {
                this.log.println(this, 2, PATCH_SERVER_PROPERTY_NOT_DEFINED);
                throw new ServerPatchServiceProviderException(10);
            }
            this.serverURLString = stringTokenizer.nextToken();
            this.useCache = this.properties.getProperty("patchsvr.use.cache").equals("true");
        } else {
            this.serverURLString = this.properties.getProperty("patchpro.patch.source");
        }
        this.log.println(this, 7, "Patch source locations: " + this.serverURLString);
        this.log.println(this, 7, "serverURLString: " + this.serverURLString);
        this.log.println(this, 7, "isPatchServer: " + this.isPatchServer);
        if (this.serverURLString == null) {
            this.log.println(this, 2, SERVER_NOT_SPECIFIED);
            throw new ServerPatchServiceProviderException(3);
        }
        this.serverURL = null;
        if (!this.downloadAuthenticate) {
            try {
                this.serverURL = new URL("file:" + File.separator);
            }
            catch (MalformedURLException malformedURLException) {
                this.log.printStackTrace(this, 2, malformedURLException);
            }
        } else {
            if (this.serverURLString.indexOf("https") == 0) {
                this.log.println(this, 7, "This server is SSL-enabled.  " + this.serverURLString);
                System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                Security.addProvider((java.security.Provider)new Provider());
                System.setProperty("javax.net.ssl.trustStore", this.keystoreLocation);
            } else if (this.serverURLString.indexOf("http") == 0) {
                this.log.println(this, 7, "This server is not SSL-enabled.  " + this.serverURLString);
            }
            try {
                this.serverURL = new URL(this.serverURLString);
            }
            catch (MalformedURLException malformedURLException) {
                this.log.printStackTrace(this, 2, malformedURLException);
                throw new ServerPatchServiceProviderException(8);
            }
        }
        if (this.proxyUser != null && this.proxyUser.compareTo("") != 0 && this.proxyPasswd != null && this.proxyPasswd.compareTo("") != 0) {
            this.serverProxyAuthenticator = new ServerProxyAuthenticator(this.proxyUser, this.proxyPasswd);
            Authenticator.setDefault(this.serverProxyAuthenticator);
        }
        if (!this.proxySvrCliHost.equals("") && !this.proxySvrCliPort.equals("")) {
            System.setProperty("https.proxyHost", this.proxySvrCliHost);
            System.setProperty("https.proxyPort", this.proxySvrCliPort);
            System.setProperty("http.proxyHost", this.proxySvrCliHost);
            System.setProperty("http.proxyPort", this.proxySvrCliPort);
        }
        this.genPatchInfo = new PatchInfoImpl();
        this.genPatchInfo.setProperties(new PatchProperties(""));
    }

    public String getPatchBundlePrefix() {
        return this.patchBundlePrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownloadPatchListener(DownloadPatchListener downloadPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(downloadPatchListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadPatchListener(DownloadPatchListener downloadPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(downloadPatchListener);
        }
    }

    public void configure(PatchProProperties patchProProperties) {
        this.sunSolveUser = patchProProperties.getProperty("patchpro.sun.user", "");
        this.sunSolvePasswd = patchProProperties.getProperty("patchpro.sun.passwd", "");
        this.proxyUser = patchProProperties.getProperty("patchpro.proxy.user", "");
        this.proxyPasswd = patchProProperties.getProperty("patchpro.proxy.passwd", "");
        this.entitlement_name = patchProProperties.getProperty("patchpro.entitlement.name", "entitlement");
        this.proxySvrCliHost = patchProProperties.getProperty("patchpro.proxy.host", "");
        this.proxySvrCliPort = patchProProperties.getProperty("patchpro.proxy.port", "");
        if (this.debug) {
            System.out.println("Effective proxy host : \"" + this.proxySvrCliHost + "\"");
            System.out.println("Effective proxy port : \"" + this.proxySvrCliPort + "\"");
            System.out.println("Effective proxy user : \"" + this.proxyUser + "\"");
        }
        this.log.println(this, 7, "SunSolve user: " + this.sunSolveUser + "\tpasswd: " + this.sunSolvePasswd);
        this.log.println(this, 7, "Proxy user: " + this.proxyUser + "\tproxyPasswd: " + this.proxyPasswd);
        this.log.println(this, 7, "Proxy host for LPS and Client is: " + this.proxySvrCliHost);
        this.log.println(this, 7, "Proxy port for LPS and client is: " + this.proxySvrCliPort);
    }

    public File downloadPatchDB(String string) throws DownloadPatchDBException, NotSupportedException, PatchProException {
        String string2 = "";
        String string3 = ".zip";
        int n = -1;
        string2 = string.startsWith("Database" + File.separator) ? string : "Database" + File.separator + string;
        n = string2.lastIndexOf(".zip");
        if (n != -1 && string3.equals(string2.substring(n))) {
            return this.downloadDatabaseFile(string2);
        }
        return this.downloadDatabaseFile(string2 + ".zip");
    }

    public File downloadOldPatchDB(String string) throws DownloadPatchDBException, NotSupportedException, PatchProException {
        if (string == null || string.equals("")) {
            string = "patchprodb";
        }
        if (this.debug) {
            System.out.println("... ServerPatchServiceProvider.downloadOldPatchDB: ARG databaseName is " + string);
        }
        File file = this.getCacheFile(string, "database");
        this.downloadFile(string, file, "downloadPatchDB", "database");
        if (this.debug) {
            System.out.println("... ... ... Download of database file should be successful");
        }
        return file;
    }

    public File downloadCategoryFile(String string) throws DownloadDocumentFileException, NotSupportedException, PatchProException {
        String string2 = "";
        string2 = string;
        if (this.debug) {
            System.out.println("... ServerPatchServiceProvider.downloadCategoryFile: ARG categoryName is " + string2);
        }
        File file = this.getCacheFile(string2, "category");
        if (this.debug) {
            System.out.println("... ... ...  Path to cached category file is : " + file.getAbsolutePath());
        }
        this.downloadFile(string2, file, "getFile", "category");
        if (this.debug) {
            System.out.println("... ... ... Download of category file should be successful");
        }
        return file;
    }

    public File downloadCollectionFile(String string) throws DownloadDocumentFileException, NotSupportedException, PatchProException {
        String string2 = string;
        if (this.debug) {
            System.out.println("... ServerPatchServiceProvider.downloadCollectionFile: ARG collectionName is " + string2);
        }
        File file = this.getCacheFile(string2, "collection");
        if (this.debug) {
            System.out.println("... ... ...  Path to cached collection file is : " + file.getAbsolutePath());
        }
        this.downloadFile(string2, file, "getFile", "collection");
        if (this.debug) {
            System.out.println("... ... ... Download of collection file should be successful");
        }
        return file;
    }

    public File downloadDatabaseFile(String string) throws DownloadDocumentFileException, NotSupportedException, PatchProException {
        String string2 = string;
        if (this.debug) {
            System.out.println("... ServerPatchServiceProvider.downloadDatabaseFile: ARG databaseName is " + string2);
        }
        File file = this.getCacheFile(string2, "Database");
        if (this.debug) {
            System.out.println("... ... ...  Path to cached collection file is : " + file.getAbsolutePath());
        }
        this.downloadFile(string2, file, "getFile", "Database");
        if (this.debug) {
            System.out.println("... ... ... Download of Database file should be successful");
        }
        return file;
    }

    public File getDetectorCacheFile(String string) throws ConfigException {
        return this.getCacheFile(string, "detectors");
    }

    public File getReadMeCacheFile(String string) throws ConfigException {
        return this.getCacheFile(string, "readme");
    }

    public File getCollectionCacheFile(String string) throws ConfigException {
        return this.getCacheFile(string, "collection");
    }

    public File getCategoryCacheFile(String string) throws ConfigException {
        return this.getCacheFile(string, "category");
    }

    public File downloadRealizationDetectors(String string) throws DownloadRealizationException, NotSupportedException, PatchProException {
        if (string == null || string.equals("")) {
            string = "pprodetectors";
        }
        File file = this.getCacheFile(string, "detectors");
        this.downloadFile(string, file, "downloadRealizationDetectors", "detectors");
        return file;
    }

    private void initProgress(int n) {
        this.totalIncrements = n;
        this.increments = 0;
        this.percentProgress = new Percentage(0);
    }

    private void incrementProgress(int n) {
        if (this.increments < this.totalIncrements) {
            this.increments += n;
            if (this.increments > this.totalIncrements) {
                this.increments = this.totalIncrements;
            }
            int n2 = (int)((double)((float)this.increments / (float)this.totalIncrements) * 100.0);
            try {
                this.percentProgress.setPercentage(n2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.dispatchProgressEvent(this.msgcat.getMessage("progress.message.downloading", "Downloading updates"));
        }
    }

    private File getCacheFile(String string, String string2) throws ConfigException {
        File file;
        String string3 = this.properties.getProperty("patchpro.cache." + string2 + ".tail", "");
        if (string3 == null) {
            string3 = "";
        }
        if (!(file = this.getCacheDirectory(this.isPatchServer, string2)).isAbsolute()) {
            throw new ConfigException(file + " is not an absolute path");
        }
        File file2 = new File(file, URLEncoder.encode(this.serverURL + "/" + string + string3));
        this.log.println(this, 7, "cacheFile is: " + file2);
        return file2;
    }

    private File getCacheDirectory(boolean bl, String string) {
        Object var3_3 = null;
        String string2 = "";
        string2 = bl ? this.properties.getProperty("patchsvr.cache.location", File.separator + "var" + File.separator + "sadm" + File.separator + "spool" + File.separator + "patchsvr") : this.properties.getProperty("patchpro.cache.directory", File.separator + "var" + File.separator + "sadm" + File.separator + "spool" + File.separator + "cache");
        string2 = string2 + File.separator;
        if (string.compareTo("readme") == 0) {
            string2 = string2 + "ReadMe";
        } else if (string.compareTo("collection") == 0) {
            string2 = string2 + "collection";
        } else if (string.compareTo("category") == 0) {
            string2 = string2 + "category";
        } else if (string.compareTo("Database") == 0) {
            string2 = string2 + "Database";
        } else if (string.compareTo(this.entitlement_name) == 0) {
            string2 = string2 + this.entitlement_name;
        } else if (bl) {
            string2 = string2 + "Misc";
        }
        return new File(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void downloadFile(String string, File file, String string2, String string3) throws PatchProException {
        file.getParentFile().mkdirs();
        if (this.debug) {
            System.out.println("... ServerPatchServiceProvider.downloadFile arguments");
            System.out.println("... \tname : " + string);
            System.out.println("... \tpath to cache file  : " + file.getAbsolutePath());
            System.out.println("...    action : " + string2);
            System.out.println("...    propKey : " + string3);
        }
        if (this.useCache) {
            CachingDownloader cachingDownloader;
            int n;
            int n2;
            if (this.debug) {
                System.out.println("... ... ... useCache is true. Thus, proceed to download");
            }
            if (this.isPatchServer) {
                n2 = Integer.parseInt(this.properties.getProperty("patchsvr." + string3 + ".cache.old.age", "2"));
                n = Integer.parseInt(this.properties.getProperty("patchsvr." + string3 + ".cache.dead.age", "2"));
                if (this.debug) {
                    System.out.println("... ... ... is a PatchServer : " + n2 + "," + n);
                }
            } else {
                n2 = Integer.parseInt(this.properties.getProperty("patchpro.cache.old.age.days." + string3, "2"));
                n = Integer.parseInt(this.properties.getProperty("patchpro.cache.dead.age.days." + string3, "2"));
                if (this.debug) {
                    System.out.println("... ... ... is not a PatchServer : " + n2 + "," + n);
                }
            }
            if (string3.equals("entitlement")) {
                if (n2 > 14) {
                    n2 = 14;
                }
                if (n > 14) {
                    n = 14;
                }
                if (this.debug) {
                    System.out.println("oldAge and deadAge are now:  " + n2 + "," + n);
                }
            }
            String string4 = "action=" + string2 + "&name=" + URLEncoder.encode(string) + "&version=2.1";
            if (this.debug) {
                System.out.println("... ... ... POST String : " + string4);
            }
            this.log.println(this, 7, "POST String: " + string4);
            boolean bl = false;
            String string5 = "";
            String string6 = "";
            try {
                cachingDownloader = new CachingDownloader(string, this.serverURL, string4, bl, string5, string6, file, CachingDownloader.days(n2), CachingDownloader.days(n), false);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.log.printStackTrace(this, 3, fileNotFoundException);
                throw new PatchProException(new FileNotFoundException(string + ": not found at " + this.serverURL));
            }
            catch (IOException iOException) {
                this.log.println(this, 3, "ServerPatchServiceProvider.downloadFile: Unable to create cache downloader.");
                this.log.printStackTrace(this, 3, iOException);
                throw new PatchProException(iOException);
            }
            try {
                if (this.debug) {
                    System.out.println("... ... ... Calling downloader.getValidCache");
                }
                cachingDownloader.getValidCache();
                if (!this.debug) return;
                System.out.println("... ... ... Returning from downloader.getValidCache");
                return;
            }
            catch (IOException iOException) {
                this.log.println(this, 3, "ServerPatchServiceProvider.downloadFile: Unable to download to " + file.getPath() + ".");
                throw new PatchProException(iOException);
            }
        }
        if (!this.debug) return;
        System.out.println("... ... ... useCache is false. Download not necessary.");
    }

    public File downloadEntitlementFile(String string) throws DownloadEntitlementFileException, NotSupportedException, PatchProException {
        if (string == null) {
            string = "";
        }
        File file = this.getEntitlementCacheFile(string);
        this.downloadFile(string, file, "getEntitlement", "entitlement");
        return file;
    }

    public File getEntitlementCacheFile(String string) throws ConfigException {
        if (this.isPatchServer) {
            return this.getCacheFile(this.entitlement_name + "_lps", this.entitlement_name);
        }
        return this.getCacheFile(this.entitlement_name + "_client", this.entitlement_name);
    }

    public PatchBundleInfo[] getDownloadedPatchBundlesInfo(PatchList patchList) throws PatchProException {
        String string = null;
        string = this.isPatchServer ? this.properties.getProperty("patchsvr.cache.location") + File.separator + "Patches" : this.properties.getProperty("patchpro.download.directory");
        if (this.useCache) {
            try {
                this.downloadPatches(patchList, string);
            }
            catch (DownloadPatchException downloadPatchException) {
            }
            catch (NotSupportedException notSupportedException) {
                // empty catch block
            }
        }
        long l = 0L;
        PatchBundleInfo[] patchBundleInfoArray = new PatchBundleInfo[patchList.size()];
        Vector<PatchBundleInfo> vector = new Vector<PatchBundleInfo>(patchList.size());
        for (int i = 0; i < patchList.size(); ++i) {
            Patch patch;
            try {
                patch = patchList.getPatchAt(i);
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 2, noSuchPatchException);
                continue;
            }
            String string2 = patch.getPatchID().getPatchID();
            l = this.patchExists(string, string2);
            if (l > 0L) {
                vector.addElement(new PatchBundleInfo(string2, string2 + ".jar", l));
                continue;
            }
            vector.addElement(new PatchBundleInfo(string2, string2 + ".jar", -1L));
        }
        Object[] objectArray = vector.toArray();
        PatchBundleInfo[] patchBundleInfoArray2 = new PatchBundleInfo[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            patchBundleInfoArray2[i] = (PatchBundleInfo)objectArray[i];
        }
        return patchBundleInfoArray2;
    }

    public Object getDownloadDestination() {
        return this.getPatchBundlePrefix();
    }

    public boolean isCertificateRevoked(String string) throws NotSupportedException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("action=isCertificateRevoked");
        stringBuffer2.append("&serialNumber=").append(URLEncoder.encode(string));
        this.log.println(this, 7, "CRL checking post string: " + stringBuffer2);
        URLConnection uRLConnection = null;
        try {
            Object object;
            uRLConnection = this.serverURL.openConnection();
            if (uRLConnection instanceof HttpsURLConnection) {
                object = System.getProperty("https.proxyHost");
                string2 = System.getProperty("https.proxyPort");
                if (object != null && string2 != null && ((String)object).length() > 0 && string2.length() > 0) {
                    ((HttpsURLConnection)uRLConnection).setSSLSocketFactory((SSLSocketFactory)new SSLTunnelSocketFactory((String)object, string2));
                }
            }
            uRLConnection.setDoOutput(true);
            object = new PrintWriter(uRLConnection.getOutputStream());
            ((PrintWriter)object).print(stringBuffer2);
            ((PrintWriter)object).close();
        }
        catch (IOException iOException) {
            this.log.printStackTrace(this, 2, iOException);
            return false;
        }
        int n = -1;
        try {
            n = ((HttpURLConnection)uRLConnection).getResponseCode();
        }
        catch (IOException iOException) {
            this.log.printStackTrace(this, 2, iOException);
        }
        if (n != 200) {
            string2 = this.httpResponseCode2Str(n);
            this.log.println(this, 2, string2);
            return true;
        }
        int n2 = uRLConnection.getHeaderFieldInt("patchproServiceCompletionCode", 200);
        return n2 == 200;
    }

    public void downloadPatches(PatchList patchList, Object object) throws DownloadPatchException, NotSupportedException, PatchProException {
        this.updateSessionData = false;
        this.downloadPatches(patchList, object, null);
    }

    public void downloadPatches(PatchList patchList, Object object, SessionData sessionData) throws DownloadPatchException, NotSupportedException, PatchProException {
        Object object2;
        int n;
        if (patchList == null || patchList.size() <= 0) {
            this.dispatchDoneEvent(PatchProLog.createMessage(7, PATCH_DOWNLOAD_DONE));
            return;
        }
        this.properties = sessionData != null ? sessionData.getProperties() : PatchProProperties.getInstance();
        boolean bl = false;
        if (this.connectingServer()) {
            n = patchList.size();
            this.log.println(this, 7, "Network connected.");
            for (int i = 0; i < this.signingCertAliasArray.length; ++i) {
                this.signingCertAlias = this.signingCertAliasArray[i];
                object2 = this.getCertSerialNumber(this.keystoreLocation, this.signingCertAlias);
                if (object2 == null) {
                    this.printTaggedMessage("STATUS DOWNLOAD_PATCH BEGIN", patchList, (String)null, (String)null, (String)null);
                    this.printTaggedMessage("STATUS DOWNLOAD_PATCH END", patchList, "DOWNLOAD_PATCH.5", "\"" + this.msgcat.getMessage("tagstatusmsg.DOWNLOAD_PATCH_CODE_BAD_CERT", "Request to download update {0} failed. Update download requests are not possible since the signing certificate is not valid.") + "\"", (String)null);
                    throw new DownloadPatchException(5);
                }
                try {
                    if (!this.isCertificateRevoked((String)object2)) continue;
                    this.log.println(this, 2, "Signing certificate has been revoked.: " + (String)object2);
                    this.printTaggedMessage("STATUS DOWNLOAD_PATCH BEGIN", patchList, (String)null, (String)null, (String)null);
                    this.printTaggedMessage("STATUS DOWNLOAD_PATCH END", patchList, "DOWNLOAD_PATCH.5", "\"" + this.msgcat.getMessage("tagstatusmsg.DOWNLOAD_PATCH_CODE_BAD_CERT", "Request to download update {0} failed. Update download requests are not possible since the signing certificate is not valid.") + "\"", (String)null);
                    throw new DownloadPatchException(6);
                }
                catch (NotSupportedException notSupportedException) {
                    this.log.printStackTrace(this, 2, notSupportedException);
                    throw notSupportedException;
                }
            }
            bl = true;
        } else {
            this.log.println(this, 7, "Network not connected.");
            System.out.println("... " + this.msgcat.getMessage("using_local_data", "Trying to use local data to service request.") + "\n");
        }
        n = 0;
        String string = null;
        if (object instanceof OutputStream) {
            this.log.println(this, 7, "Detected output stream...");
            string = this.isPatchServer ? this.properties.getProperty("patchsvr.cache.location", "/var/tmp") + File.separator + "Patches" : this.properties.getProperty("patchpro.download.directory", "/var/tmp");
            n = 1;
            this.log.println(this, 7, "What is downloadDir: " + string);
        } else if (object instanceof String) {
            string = (String)object;
        } else {
            this.dispatchFailedEvent(PatchProLog.createMessage(2, INVALID_DESTINATION_TYPE));
            this.log.println(this, 2, INVALID_DESTINATION_TYPE);
            if (this.updateSessionData) {
                object2 = new InvalidPatchDownloadDirectoryException("InvalidPatchDownloadDirectoryException", "InvalidPatchDownloadDirectoryException.MESSAGE", "InvalidPatchDownloadDirectoryException.REMEDY", 2);
                sessionData.addPatchProException((Throwable)object2);
            }
            throw new DownloadPatchException(INVALID_DESTINATION_TYPE);
        }
        if (string.indexOf("%") != -1) {
            this.setPatchBundlePrefix(PatchServiceUtil.generateTimeStampedString(string) + File.separator);
        } else {
            this.setPatchBundlePrefix(string + File.separator);
        }
        if (bl) {
            this.log.println(this, 7, "Invoking performDownloadPatches.");
            this.performDownloadPatches(patchList, sessionData);
        } else {
            this.log.println(this, 7, "Invoking performValidationOnDownloadedPatches.");
            this.performValidationOnDownloadedPatches(patchList, sessionData);
        }
        if (n != 0) {
            int n2 = 102400;
            byte[] byArray = new byte[n2];
            int n3 = 0;
            FileInputStream fileInputStream = null;
            String string2 = null;
            String string3 = null;
            for (int i = 0; i < patchList.size(); ++i) {
                try {
                    Patch patch = patchList.getPatchAt(i);
                    string2 = patch.getPatchID().getPatchID();
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.log.println(this, 2, "Should never receive NoSuchPatchException here.");
                    this.log.printStackTrace(this, 2, noSuchPatchException);
                    continue;
                }
                string3 = string + File.separator + string2 + ".jar";
                this.log.println(this, 7, "Requested patch file name: " + string3);
                try {
                    fileInputStream = new FileInputStream(string3);
                    while ((n3 = fileInputStream.read(byArray)) != -1) {
                        ((OutputStream)object).write(byArray, 0, n3);
                    }
                    fileInputStream.close();
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public File downloadReadMeFile(String string) throws DownloadDocumentFileException, NotSupportedException, PatchProException {
        if (this.debug) {
            System.out.println("... ServerPatchServiceProvider.downloadReadMeFile: ARG readMeName is " + string);
        }
        if (string == null || string.equals("")) {
            if (this.debug) {
                System.out.println("... ... ... Problem, the expected README file name is undefined");
            }
            throw new DownloadDocumentFileException("ERROR: Tthe expected README file name is undefined");
        }
        File file = this.getCacheFile(string, "readme");
        if (this.debug) {
            System.out.println("... ... ...  Path to cached README file is : " + file.getAbsolutePath());
        }
        this.downloadFile(string, file, "getFile", "readme");
        if (this.debug) {
            System.out.println("... ... ... Download of ReadMe file should be successful");
        }
        return file;
    }

    private void setPatchBundlePrefix(String string) {
        this.patchBundlePrefix = string;
    }

    private String httpResponseCode2Str(int n) {
        String string = "";
        switch (n) {
            case 206: {
                string = HTTP_PARTIAL_CONTENT;
                break;
            }
            case 400: {
                string = HTTP_BAD_REQUEST;
                break;
            }
            case 401: {
                string = HTTP_UNAUTHORIZED;
                break;
            }
            case 403: {
                string = HTTP_FORBIDDEN;
                break;
            }
            case 404: {
                string = HTTP_NOT_FOUND;
                break;
            }
            case 500: {
                string = HTTP_INTERNAL_SERVER_ERROR;
                break;
            }
            case 501: {
                string = HTTP_NOT_IMPLEMENTED;
                break;
            }
            default: {
                string = HTTP_UNKNOWN_ERROR;
            }
        }
        return string;
    }

    private void performDownloadPatches(PatchList patchList, SessionData sessionData) throws DownloadPatchException, NotSupportedException, PatchProException {
        PatchList patchList2;
        Object object;
        Object object2;
        int n;
        File file = new File(this.getPatchBundlePrefix());
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.canWrite()) {
            this.dispatchFailedEvent(PatchProLog.createMessage(2, DOWNLOAD_DIR_NOT_WRITABLE));
            this.log.println(this, 2, DOWNLOAD_DIR_NOT_WRITABLE);
            if (this.updateSessionData) {
                PatchDownloadDirectoryAccessException patchDownloadDirectoryAccessException = new PatchDownloadDirectoryAccessException("PatchDownloadDirectoryAccessException", "PatchDownloadDirectoryAccessException.MESSAGE", "PatchDownloadDirectoryAccessException.REMEDY", 2);
                sessionData.addPatchProException(patchDownloadDirectoryAccessException);
            }
            throw new DownloadPatchException(DOWNLOAD_DIR_NOT_WRITABLE);
        }
        int n2 = patchList.size();
        Vector<PatchListImpl> vector = new Vector<PatchListImpl>();
        PatchListImpl patchListImpl = new PatchListImpl();
        int n3 = 0;
        this.initProgress(n2);
        for (n = 0; n < n2; ++n) {
            try {
                object2 = new IPatch(patchList.getPatchAt(n));
                if (new File(file, ((PatchImpl)object2).getPatchID().getPatchID() + ".jar").exists()) {
                    if (this.updateSessionData) {
                        object = new String[]{((PatchImpl)object2).getPatchID().getPatchID()};
                        System.out.println(this.msgcat.getMessage("update_already_downloaded", (Object[])object, "Update " + ((PatchImpl)object2).getPatchID().getPatchID() + " will not be downloaded since it already exists" + " in the download directory."));
                        sessionData.addPatchAlreadyPresent((IPatch)object2);
                    }
                } else if (this.useCache) {
                    patchListImpl.addIPatch((IPatch)object2);
                    patchListImpl.setSelectionStatus(n3, patchList.getSelectionStatus(n));
                    ++n3;
                }
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 3, noSuchPatchException);
            }
            if ((n + 1) % 10 != 0 || patchListImpl.size() == 0) continue;
            vector.addElement(patchListImpl);
            patchListImpl = new PatchListImpl();
            n3 = 0;
        }
        if (n2 % 10 != 0 && patchListImpl.size() != 0) {
            vector.addElement(patchListImpl);
        }
        n = 0;
        object2 = CancelManager.getInstance();
        object = null;
        for (int i = 0; i < vector.size(); ++i) {
            try {
                if (this.proxyUser != null && this.proxyUser.compareTo("") != 0 && this.proxyPasswd != null && this.proxyPasswd.compareTo("") != 0) {
                    this.serverProxyAuthenticator.resetRetryAttempts();
                }
                this.requestDownload((PatchList)vector.elementAt(i), sessionData);
            }
            catch (DownloadPatchException downloadPatchException) {
                this.log.printStackTrace(this, 4, downloadPatchException);
            }
            if (this.debug) {
                System.out.println("Checking cancellation after each *patch list segment* download.");
            }
            n += ((PatchList)vector.elementAt(i)).size();
            if (!((CancelManager)object2).isCancelRequested()) continue;
            object = this.getCancelledPatches(patchList, n);
            ((CancelManager)object2).doExitIfCancelRequested("STATUS DOWNLOAD_PATCH END", (PatchList)object, "DOWNLOAD_PATCH.253", "\"" + this.msgcat.getMessage("tagstatusmsg.DOWNLOAD_PATCH_CODE_CANCELLED", "Download of update {0} was cancelled.") + "\"", null);
        }
        this.dispatchDoneEvent(PatchProLog.createMessage(7, PATCH_DOWNLOAD_DONE));
        if (sessionData != null && (patchList2 = sessionData.getPatchesDownloaded()).size() != 0) {
            String string = "";
            for (int i = 0; i < patchList2.size(); ++i) {
                try {
                    Patch patch = patchList2.getPatchAt(i);
                    if (i == patchList2.size() - 1) {
                        string = string + patch.getPatchID().getPatchID();
                        continue;
                    }
                    string = string + patch.getPatchID().getPatchID() + ", ";
                    continue;
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.log.printStackTrace(this, 2, noSuchPatchException);
                }
            }
            String string2 = this.properties.getProperty("patchpro.log.level");
            this.properties.setProperty("patchpro.log.level", "6");
            this.log.println(this, 6, "List of patches downloaded from " + this.serverURL.getHost() + ": " + string);
            this.properties.setProperty("patchpro.log.level", string2);
            if (this.debug) {
                System.out.println("List of patches downloaded from " + this.serverURL.getHost() + ": " + string);
            }
        }
        if (this.updateSessionData) {
            this.createDownloadSummaryFile(sessionData, patchList, this.getPatchBundlePrefix());
        }
    }

    private PatchList getCancelledPatches(PatchList patchList, int n) {
        PatchListImpl patchListImpl = new PatchListImpl();
        Patch patch = null;
        int n2 = patchList.size();
        if (n == n2) {
            System.out.println(this.msgcat.getMessage("cancel_after_download", "Cancel request received after download of updates."));
        }
        for (int i = n; i < n2; ++i) {
            try {
                patch = patchList.getPatchAt(i);
                patchListImpl.addIPatch((IPatch)patch);
                continue;
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 2, noSuchPatchException);
            }
        }
        return patchListImpl;
    }

    public Percentage getProgress() {
        return this.percentProgress;
    }

    private void performValidationOnDownloadedPatches(PatchList patchList, SessionData sessionData) throws DownloadPatchException, NotSupportedException, PatchProException {
        File file = new File(this.getPatchBundlePrefix());
        if (!file.exists()) {
            this.log.println(this, 2, DOWNLOAD_DIR_NOT_EXIST);
            if (this.updateSessionData) {
                PatchDownloadDirectoryAccessException patchDownloadDirectoryAccessException = new PatchDownloadDirectoryAccessException("PatchDownloadDirectoryAccessException", "PatchDownloadDirectoryAccessException.MESSAGE", "PatchDownloadDirectoryAccessException.REMEDY", 2);
                sessionData.addPatchProException(patchDownloadDirectoryAccessException);
            }
            throw new DownloadPatchException(DOWNLOAD_DIR_NOT_EXIST);
        }
        int n = patchList.size();
        boolean bl = false;
        String string = "";
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            Serializable serializable;
            IPatch iPatch;
            Patch patch;
            try {
                Patch patch2 = patchList.getPatchAt(i);
                string = patch2.getPatchID().getPatchID();
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 3, noSuchPatchException);
                continue;
            }
            string2 = this.getPatchBundlePrefix() + File.separator + string + ".jar";
            if (!new File(string2).exists()) {
                try {
                    patch = patchList.getPatchByPatchID(new PatchID(string));
                    iPatch = new IPatch(patch);
                    iPatch.setError(PATCH_NOT_ON_DISK);
                    if (this.updateSessionData) {
                        sessionData.addPatchUnavailable(iPatch);
                    }
                    this.log.println(this, 7, "Added patch " + patch.getPatchID().getPatchID() + " to the problem list. ErrString: " + PATCH_NOT_ON_DISK);
                    if (!this.updateSessionData) continue;
                    serializable = new PatchNotAvailableException("PatchNotAvailableException", "PatchNotAvailableException.MESSAGE", "PatchNotAvailableException.REMEDY", 3);
                    sessionData.addPatchProException((Throwable)serializable);
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.log.println(this, 2, "There exists no patch failing signaturevalidation");
                    this.log.printStackTrace(this, 3, noSuchPatchException);
                }
                catch (MalformedPatchException malformedPatchException) {
                    this.log.println(this, 4, "PatchProModel.evaluatePatchListExpression(): Malformed patch ID on applied Patch. " + malformedPatchException.getMessage());
                    this.log.printStackTrace(this, 3, malformedPatchException);
                }
                continue;
            }
            bl = false;
            if (this.downloadAuthenticate) {
                bl = this.validatePatchBundle(string, string2);
                this.log.println(this, 7, "Validation of local patch " + string2 + " is done");
            }
            if (bl) {
                if (this.updateSessionData) {
                    try {
                        serializable = new PatchID(string);
                        PatchImpl patchImpl = new PatchImpl(this.genPatchInfo, (PatchID)serializable);
                        sessionData.addPatchAlreadyPresent(patchImpl);
                    }
                    catch (Exception exception) {
                        this.log.printStackTrace(this, 3, exception);
                    }
                }
                this.log.println(this, 7, "The patch " + string2 + " has been validated");
                continue;
            }
            try {
                patch = patchList.getPatchByPatchID(new PatchID(string));
                iPatch = new IPatch(patch);
                iPatch.setError(FAILED_TO_VALIDATE_SIGNATURE);
                if (this.updateSessionData) {
                    sessionData.addPatchCorruptOnDownload(iPatch);
                }
                this.log.println(this, 7, "Added patch " + patch.getPatchID().getPatchID() + " to the list. ErrString: " + FAILED_TO_VALIDATE_SIGNATURE);
                if (!this.updateSessionData) continue;
                serializable = new PatchSignatureValidationException("PatchSignatureValidationException", "PatchSignatureValidationException.MESSAGE", "PatchSignatureValidationException.REMEDY", 2);
                sessionData.addPatchProException((Throwable)serializable);
                continue;
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.println(this, 2, "There exists no patch failing signaturevalidation");
                this.log.printStackTrace(this, 3, noSuchPatchException);
                continue;
            }
            catch (MalformedPatchException malformedPatchException) {
                this.log.println(this, 4, "PatchProModel.evaluatePatchListExpression(): Malformed patch ID on applied Patch. " + malformedPatchException.getMessage());
                this.log.printStackTrace(this, 3, malformedPatchException);
            }
        }
        this.dispatchDoneEvent(PatchProLog.createMessage(7, PATCH_DOWNLOAD_DONE));
        if (this.updateSessionData) {
            this.createDownloadSummaryFile(sessionData, patchList, file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestDownload(PatchList patchList, SessionData sessionData) throws DownloadPatchException, NotSupportedException {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        int n;
        String string;
        Object object4;
        Object object5;
        Object object6;
        String string2;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("action=patchDownload&version=2.1");
        Patch patch = null;
        int n3 = patchList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            try {
                if (!patchList.getSelectionStatus(n2)) continue;
                patch = patchList.getPatchAt(n2);
                String string3 = patch.getPatchID().getPatchID();
                this.printTaggedMessage("STATUS DOWNLOAD_PATCH BEGIN", string3, (String)null, (String)null, (String)null);
                this.log.println(this, 7, "Adding " + string3 + " to the POST list...");
                stringBuffer.append(string3).append(" ");
                stringBuffer2.append('&');
                stringBuffer2.append("patchId=").append(URLEncoder.encode(string3));
                continue;
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 2, noSuchPatchException);
            }
        }
        this.log.println(this, 7, "Post String: " + stringBuffer2);
        n2 = -1;
        Downloader downloader = null;
        try {
            downloader = this.sendPatchDownloadPostRequest(this.serverURL, stringBuffer2.toString(), this.sunSolveUser, this.sunSolvePasswd, sessionData);
            n2 = downloader.getResponseCode();
        }
        catch (DownloadPatchException downloadPatchException) {
            if (downloadPatchException.getReasonCode() == 4) {
                n2 = 500;
                this.printTaggedMessage("STATUS DOWNLOAD_PATCH END", patchList, "DOWNLOAD_PATCH.4", "\"" + this.msgcat.getMessage("tagstatusmsg.DOWNLOAD_PATCH_CODE_UNKNOWN_HTTP_RESPONSE_CODE", "Request to download update {0} failed. The HTTP response code is unknown.") + "\"", (String)null);
                this.log.println(this, 3, "Request to download update failed. The HTTP response code is unknown.");
            }
            this.printTaggedMessage("STATUS DOWNLOAD_PATCH END", patchList, "DOWNLOAD_PATCH.6", "\"" + this.msgcat.getMessage("tagstatusmsg.DOWNLOAD_PATCH_CODE_UNSUCCESSFUL_HTTP_RESPONSE_CODE", "Request to download update {0} failed. The HTTP response code is {1}.") + "\"", "\"" + n2 + "\"");
            this.log.println(this, 3, "Request to download update {0} failed. The HTTP response code is: " + n2);
            if (this.updateSessionData) {
                sessionData.addPatchesUnavailable(patchList, this.msgcat.getMessage(HTTP_UNKNOWN_ERROR, HTTP_UNKNOWN_ERROR));
            }
            throw downloadPatchException;
        }
        if (n2 == 401) {
            this.dispatchFailedEvent(PatchProLog.createMessage(4, this.msgcat.getMessage(AUTHENTICATION_FAILED, "The patch server failed to authenticate the request based on the current SunSolve user/password setting. Only public (non-contract) patches will be downloaded.")));
            this.log.println(this, 4, "Current SunSolve credential setting caused 401 response.");
            n2 = -1;
            try {
                downloader = this.sendPatchDownloadPostRequest(this.serverURL, stringBuffer2.toString(), "", "", sessionData);
                n2 = downloader.getResponseCode();
            }
            catch (DownloadPatchException downloadPatchException) {
                if (downloadPatchException.getReasonCode() == 4) {
                    this.printTaggedMessage("STATUS DOWNLOAD_PATCH END", patchList, "DOWNLOAD_PATCH.4", "\"" + this.msgcat.getMessage("tagstatusmsg.DOWNLOAD_PATCH_CODE_UNKNOWN_HTTP_RESPONSE_CODE", "Request to download update {0} failed.  The HTTP response code is unknown.") + "\"", (String)null);
                    n2 = 500;
                }
                this.printTaggedMessage("STATUS DOWNLOAD_PATCH END", patchList, "DOWNLOAD_PATCH.6", "\"" + this.msgcat.getMessage("tagstatusmsg.DOWNLOAD_PATCH_CODE_UNSUCCESSFUL_HTTP_RESPONSE_CODE", "Request to download update {0} failed. The HTTP response code is {1}.") + "\"", "\"" + n2 + "\"");
                if (this.updateSessionData) {
                    sessionData.addPatchesUnavailable(patchList, this.msgcat.getMessage(HTTP_UNKNOWN_ERROR, HTTP_UNKNOWN_ERROR));
                }
                throw downloadPatchException;
            }
        }
        this.log.println(this, 7, "HTTP response code: " + n2);
        if (n2 != 200 && n2 != 206) {
            string2 = this.httpResponseCode2Str(n2);
            this.log.println(this, 4, string2);
            if (this.updateSessionData) {
                BadHttpResponseException badHttpResponseException = new BadHttpResponseException("BadHttpResponseException", BadHttpResponseException.getBadHttpResponseExceptionMessage(n2), BadHttpResponseException.getBadHttpResponseExceptionRemedy(n2), 2);
                sessionData.addPatchProException(badHttpResponseException);
                this.printTaggedMessage("STATUS DOWNLOAD_PATCH END", patchList, "DOWNLOAD_PATCH.6", "\"" + this.msgcat.getMessage("tagstatusmsg.DOWNLOAD_PATCH_CODE_UNSUCCESSFUL_HTTP_RESPONSE_CODE", "Request to download update {0} failed. The HTTP response code is {1}.") + "\"", "\"" + n2 + "\"");
                sessionData.addPatchesUnavailable(patchList, this.msgcat.getMessage(HTTP_UNKNOWN_ERROR, HTTP_UNKNOWN_ERROR));
            }
            throw new DownloadPatchException(string2);
        }
        string2 = downloader.getHeaderField("patchFiles");
        String string4 = downloader.getHeaderField("rejects");
        String string5 = downloader.getHeaderField("requiredSize");
        this.log.println(this, 7, "Patches returned: " + string2);
        this.log.println(this, 7, "Patches rejected: " + string4);
        this.log.println(this, 7, "Patches required sizes: " + string5);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(downloader);
        if (string2 == null) {
            this.log.println(this, 4, "patchFiles is null.");
            string2 = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        int n4 = stringTokenizer.countTokens();
        String[] stringArray = new String[n4];
        String[] stringArray2 = new String[n4];
        String[] stringArray3 = new String[n4];
        int[] nArray = new int[n4];
        int n5 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object6 = stringTokenizer.nextToken();
            object5 = new StringTokenizer((String)object6, "&");
            object4 = ((StringTokenizer)object5).nextToken();
            stringArray[n5] = ((String)object4).substring(0, ((String)object4).indexOf(".jar"));
            stringArray2[n5] = this.patchBundlePrefix + (String)object4;
            stringArray3[n5] = object4;
            nArray[n5] = Integer.parseInt(((StringTokenizer)object5).nextToken());
            ++n5;
        }
        stringTokenizer = null;
        Properties properties = new Properties();
        if (string4 != null && !string4.equals("")) {
            object6 = new StringTokenizer(string4, "|");
            while (((StringTokenizer)object6).hasMoreTokens()) {
                object5 = ((StringTokenizer)object6).nextToken();
                object4 = new StringTokenizer((String)object5, "&");
                string = ((StringTokenizer)object4).nextToken();
                properties.setProperty(string, ((StringTokenizer)object4).nextToken());
            }
        }
        this.log.println(this, 7, "Number of patches returned: " + n4);
        for (int i = 0; i < n4; ++i) {
            this.log.println(this, 7, "PatchID: " + stringArray2[i] + "\tSize: " + nArray[i]);
            this.log.println(this, 7, "The patch returned by server is PatchID: " + stringArray2[i] + "\tSize: " + nArray[i]);
        }
        if (n4 != n3) {
            this.incrementProgress(n3 - n4);
        }
        if (n4 == 0) {
            Patch patch2 = null;
            object5 = null;
            object4 = null;
            for (int i = 0; i < n3; ++i) {
                try {
                    patch2 = patchList.getPatchAt(i);
                    object5 = new IPatch(patch2);
                    object4 = ((PatchImpl)object5).getPatchID().getPatchID();
                    String string6 = this.getErrorMessageKey(properties.getProperty((String)object4));
                    ((IPatch)object5).setError(this.msgcat.getMessage(string6, new String[]{object4}, PATCH_NOT_FOUND));
                    this.printTaggedMessage("STATUS DOWNLOAD_PATCH END", (String)object4, "DOWNLOAD_PATCH.1", "\"" + this.msgcat.getMessage("tagstatusmsg.DOWNLOAD_PATCH_CODE_PATCH_NOT_FOUND", "Download of update {0} failed. Update was not found on the server {1}.") + "\"", " \"" + (String)object4 + "\" \"" + this.serverURLString + "\"");
                    if (!this.updateSessionData) continue;
                    sessionData.addPatchUnavailable((IPatch)object5);
                    continue;
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.log.printStackTrace(this, 2, noSuchPatchException);
                }
            }
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                this.log.printStackTrace(this, 2, iOException);
            }
            return;
        }
        Patch patch3 = null;
        block41: for (int i = 0; i < n3; ++i) {
            try {
                patch3 = patchList.getPatchAt(i);
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 2, noSuchPatchException);
                continue;
            }
            object4 = patch3.getPatchID().getPatchID();
            string = (String)object4 + ".jar";
            for (n = 0; n < n4; ++n) {
                if (string.equals(stringArray3[n])) {
                    if (!this.updateSessionData) continue block41;
                    try {
                        sessionData.addPatchDownloaded((String)object4);
                    }
                    catch (MalformedPatchException malformedPatchException) {
                        this.log.println(this, 3, "Malformed patch string " + (String)object4);
                        this.printTaggedMessage("STATUS DOWNLOAD_PATCH END", (String)object4, "DOWNLOAD_PATCH.2", "\"" + this.msgcat.getMessage("tagstatusmsg.DOWNLOAD_PATCH_CODE_MALFORMED_PATCH_STRING", "Request to download update {0} failed. The  format of the update ID is invalid.") + "\"", " \"" + (String)object4 + "\"");
                    }
                    continue block41;
                }
                if (n + 1 != n4) continue;
                object3 = null;
                String string7 = "";
                try {
                    object3 = patchList.getPatchByPatchID(new PatchID((String)object4));
                    serializable = new IPatch((Patch)object3);
                    object2 = properties.getProperty((String)object4);
                    String string8 = this.getErrorMessageKey(properties.getProperty((String)object4));
                    string7 = this.msgcat.getMessage(string8, new String[]{object4}, PATCH_NOT_FOUND);
                    this.printTaggedMessage("STATUS DOWNLOAD_PATCH END", (String)object4, "DOWNLOAD_PATCH.1", "\"" + this.msgcat.getMessage("tagstatusmsg.DOWNLOAD_PATCH_CODE_PATCH_NOT_FOUND", "Download of update {0} failed. Update was not found on the server {1}.") + "\"", "\"" + (String)object4 + "\" \"" + this.serverURLString + "\"");
                    ((IPatch)serializable).setError(string7);
                    if (this.updateSessionData) {
                        sessionData.addPatchUnavailable((IPatch)serializable);
                        object = new PatchNotFoundException("PatchNotFoundException", string7, "PatchNotFoundException.REMEDY", 2);
                        sessionData.addPatchProException((Throwable)object);
                    }
                    this.log.println(this, 3, string7);
                    continue;
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.log.println(this, 3, "There exists no patch in the patch listto be downloaded.");
                    this.log.println(this, 3, noSuchPatchException.getMessage());
                    this.log.printStackTrace(this, 3, noSuchPatchException);
                    continue;
                }
                catch (MalformedPatchException malformedPatchException) {
                    this.log.println(this, 4, "ServerPatchServiceProvider.requestDownload(): Malformed patch ID on appliedPatch. " + malformedPatchException.getMessage());
                    this.log.printStackTrace(this, 4, malformedPatchException);
                    this.printTaggedMessage("STATUS DOWNLOAD_PATCH END", (String)object4, "DOWNLOAD_PATCH.2", "\"" + this.msgcat.getMessage("tagstatusmsg.DOWNLOAD_PATCH_CODE_MALFORMED_PATCH_STRING", "Request to download update {0} failed. The format of the update ID is invalid.") + "\"", "\"" + (String)object4 + "\"");
                }
            }
        }
        if (downloader.getContentType().compareTo("application/octet-stream") == 0) {
            Patch patch4 = null;
            int n6 = 0;
            int n7 = 0;
            n = downloader.getBufferLength();
            if (n <= 0) {
                n = 8192;
            }
            object3 = new byte[n];
            serializable = new File(this.patchBundlePrefix);
            if (!((File)serializable).exists()) {
                ((File)serializable).mkdirs();
            }
            serializable = null;
            boolean bl = false;
            object2 = CancelManager.getInstance();
            for (int i = 0; i < n4; ++i) {
                object = stringArray2[i] + ".tmp";
                this.log.println(this, 7, (String)object);
                this.incrementProgress(1);
                serializable = new File((String)object);
                if (((CancelManager)object2).isCancelRequested()) {
                    this.printTaggedMessage("STATUS DOWNLOAD_PATCH END", stringArray[i], "DOWNLOAD_PATCH.253", "\"" + this.msgcat.getMessage("tagstatusmsg.DOWNLOAD_PATCH_CODE_CANCELLED", "Download of update {0} was cancelled.") + "\"", " \"" + stringArray[i] + "\"");
                    continue;
                }
                if (bl || !Downloader.checkFreeSpace((File)serializable, nArray[i] * 2)) {
                    this.printTaggedMessage("STATUS DOWNLOAD_PATCH END", stringArray[i], "DOWNLOAD_PATCH.255", "\"" + this.msgcat.getMessage("tagstatusmsg.DOWNLOAD_PATCH_CODE_GENERIC_ERROR", new Object[]{new Integer(18)}, "Utility used to download the update failed with exit code {0}.\n{1}") + "\"", "\"" + this.msgcat.getMessage("tagstatusmsg.DOWNLOAD_PATCH_ISSUFFICIENT_FREESPACE", "Not enough file system space to perform  patch download.") + "\"");
                    bl = true;
                    continue;
                }
                try {
                    Serializable serializable2;
                    patch4 = patchList.getPatchByPatchID(new PatchID(stringArray[i]));
                    if (!patch4.lock()) {
                        throw new CannotReservePatchException("Unable to reserve patch " + stringArray[i] + " for the download process.");
                    }
                    ((File)serializable).delete();
                    ((File)serializable).createNewFile();
                    this.log.println(this, 7, "Created " + (String)object);
                    FileOutputStream fileOutputStream = new FileOutputStream((File)serializable);
                    n7 = 0;
                    n6 = 0;
                    int n8 = nArray[i] - n7;
                    while (n8 >= n && (n6 = bufferedInputStream.read((byte[])object3, 0, n)) != -1) {
                        n8 = nArray[i] - (n7 += n6);
                        fileOutputStream.write((byte[])object3, 0, n6);
                    }
                    if (n8 > 0) {
                        n6 = bufferedInputStream.read((byte[])object3, 0, n8);
                        fileOutputStream.write((byte[])object3, 0, n6);
                    }
                    fileOutputStream.close();
                    boolean bl2 = true;
                    if (this.downloadAuthenticate) {
                        bl2 = this.validatePatchBundle(stringArray[i], (String)object);
                        this.log.println(this, 7, "The downloader validation is done");
                    }
                    Patch patch5 = null;
                    if (bl2) {
                        this.log.println(this, 7, "The patch bundle is validated");
                        serializable2 = new File(stringArray2[i]);
                        ((File)serializable2).delete();
                        ((File)serializable).renameTo((File)serializable2);
                        this.printTaggedMessage("STATUS DOWNLOAD_PATCH END", stringArray[i], "DOWNLOAD_PATCH.0", "\"" + this.msgcat.getMessage("tagstatusmsg.DOWNLOAD_PATCH_CODE_SUCCESS", "Request to download update {0} was successful.") + "\"", " \"" + stringArray[i] + "\"");
                    } else {
                        try {
                            patch5 = patchList.getPatchByPatchID(new PatchID(stringArray[i]));
                            serializable2 = new IPatch(patch5);
                            ((IPatch)serializable2).setError(FAILED_TO_VALIDATE_SIGNATURE);
                            if (this.updateSessionData) {
                                sessionData.addPatchCorruptOnDownload((IPatch)serializable2);
                            }
                            this.log.println(this, 7, "Added patch " + patch5.getPatchID().getPatchID() + " to the list. ErrString: " + FAILED_TO_VALIDATE_SIGNATURE);
                            this.printTaggedMessage("STATUS DOWNLOAD_PATCH END", stringArray[i], "DOWNLOAD_PATCH.3", "\"" + this.msgcat.getMessage("tagstatusmsg.DOWNLOAD_PATCH_CODE_FAILED_TO_VALIDATE", "Request to download update {0} failed. It could not pass the digital signature validation process.") + "\"", "\"" + stringArray[i] + "\"");
                            File file = new File(stringArray2[i]);
                            file.delete();
                            file = null;
                            this.log.println(this, 3, FAILED_TO_VALIDATE_SIGNATURE);
                            if (this.updateSessionData) {
                                PatchSignatureValidationException patchSignatureValidationException = new PatchSignatureValidationException("PatchSignatureValidationException", "PatchSignatureValidationException.MESSAGE", "PatchSignatureValidationException.REMEDY", 2);
                                sessionData.addPatchProException(patchSignatureValidationException);
                            }
                        }
                        catch (NoSuchPatchException noSuchPatchException) {
                            this.log.println(this, 2, "There exists no patch failing signaturevalidation");
                            this.log.printStackTrace(this, 3, noSuchPatchException);
                        }
                        catch (MalformedPatchException malformedPatchException) {
                            this.log.println(this, 4, "PatchProModel.evaluatePatchListExpression(): Malformed patch ID on applied Patch. " + malformedPatchException.getMessage());
                            this.log.printStackTrace(this, 3, malformedPatchException);
                        }
                    }
                    if (!downloader.isCancelEnabled()) {
                        this.log.println(this, 6, "Downloading done.");
                        continue;
                    }
                    this.log.println(this, 6, "Downloading canceled.");
                    continue;
                }
                catch (CannotReservePatchException cannotReservePatchException) {
                    String string9 = cannotReservePatchException.getMessage();
                    this.log.printStackTrace(this, 3, cannotReservePatchException);
                    this.log.println(this, 3, string9);
                    this.dispatchFailedEvent(PatchProLog.createMessage(3, string9));
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    String string10 = "Invalid patch bundle file name.: " + (String)object;
                    this.log.printStackTrace(this, 3, fileNotFoundException);
                    this.log.println(this, 3, string10);
                    this.dispatchFailedEvent(PatchProLog.createMessage(3, INVALID_PATCH_BUNDLE_FILE_NAME));
                    continue;
                }
                catch (SecurityException securityException) {
                    String string11 = "The write permission is not set.: " + (String)object;
                    this.log.printStackTrace(this, 3, securityException);
                    this.log.println(this, 3, string11);
                    this.dispatchFailedEvent(PatchProLog.createMessage(3, INVALID_FILE_PERMISSION));
                    securityException.printStackTrace();
                    continue;
                }
                catch (IOException iOException) {
                    this.log.printStackTrace(this, 3, iOException);
                    if (this.updateSessionData) {
                        PatchDownloadIOException patchDownloadIOException = new PatchDownloadIOException("PatchDownloadIOException", "PatchDownloadIOException.MESSAGE", "PatchDownloadIOException.REMEDY", 2);
                        sessionData.addPatchProException(patchDownloadIOException);
                    }
                    throw new DownloadPatchException("I/O error: " + iOException.getMessage());
                }
                catch (Exception exception) {
                    this.log.printStackTrace(this, 3, exception);
                    if (this.updateSessionData) {
                        PatchDownloadIOException patchDownloadIOException = new PatchDownloadIOException("PatchDownloadIOException", "PatchDownloadIOException.MESSAGE", "PatchDownloadIOException.REMEDY", 2);
                        sessionData.addPatchProException(patchDownloadIOException);
                    }
                    this.dispatchFailedEvent(PatchProLog.createMessage(3, FAILED_TO_DOWNLOAD_A_PATCH));
                    continue;
                }
                finally {
                    ((File)serializable).delete();
                    patch4.unlock();
                }
            }
            if (bl) {
                this.log.println(this, 3, this.msgcat.getMessage("tagstatusmsg.DOWNLOAD_PATCH_ISSUFFICIENT_FREESPACE", "Not enough file system space to perform  patch download."));
                this.dispatchFailedEvent(PatchProLog.createMessage(3, this.msgcat.getMessage("tagstatusmsg.DOWNLOAD_PATCH_ISSUFFICIENT_FREESPACE", "Not enough file system space to perform  patch download.")));
            }
        } else {
            this.log.println(this, 4, UNKNOWN_CONTENT_TYPE);
            this.dispatchFailedEvent(PatchProLog.createMessage(4, UNKNOWN_CONTENT_TYPE));
            if (this.updateSessionData) {
                PatchDownloadResponseException patchDownloadResponseException = new PatchDownloadResponseException("PatchDownloadResponseException", "PatchDownloadResponseException.MESSAGE", "PatchDownloadResponseException.REMEDY", 2);
                sessionData.addPatchProException(patchDownloadResponseException);
            }
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                this.log.printStackTrace(this, 2, iOException);
            }
            if (this.updateSessionData) {
                sessionData.addPatchesUnavailable(patchList, this.msgcat.getMessage(HTTP_UNKNOWN_ERROR, HTTP_UNKNOWN_ERROR));
            }
        }
        try {
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            this.log.printStackTrace(this, 2, iOException);
        }
    }

    private String getErrorMessageKey(String string) {
        String string2;
        int n = string == null ? 0 : Integer.parseInt(string);
        switch (n) {
            case 1: {
                string2 = "download.unexpected.error";
                break;
            }
            case 2: {
                string2 = "download.patch.not.exist";
                break;
            }
            case 3: {
                string2 = "download.contract.patch";
                break;
            }
            case 4: {
                string2 = "download.duplicate.patch";
                break;
            }
            default: {
                string2 = "download.unidentified.error";
            }
        }
        return string2;
    }

    private void createDownloadSummaryFile(SessionData sessionData, PatchList patchList, String string) throws PatchProException {
        FileOutputStream fileOutputStream;
        File file = null;
        File file2 = null;
        file2 = new File(string);
        String string2 = !file2.canWrite() ? "/var/tmp/" : string;
        file = new File(string2 + File.separator + PatchServiceUtil.generateTimeStampedString("patchpro_dnld_'%Y.%m.%d@%T:%Z'") + "." + "txt");
        this.log.println(this, 7, "Dnld summary file: " + file.getPath());
        if (file.exists()) {
            file.delete();
        }
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PatchProException("Can't create " + fileNotFoundException.getMessage());
        }
        PrintStream printStream = new PrintStream(fileOutputStream);
        PatchList patchList2 = sessionData.getPatchesNotDownloaded();
        if (patchList2.size() == 0) {
            printStream.println(this.msgcat.getMessage("readmeHeader", "This patch bundle was generated by PatchPro.\n\nPlease refer to the README file for each patch for installation\ninstructions.  To properly patch your system, the following patches\nshould be installed in the listed order:\n\n"));
            this.printDownloadedPatches(printStream, patchList);
        } else {
            printStream.println(this.msgcat.getMessage("readmeFailedHeader", "This collection of patches is incomplete due to problems in downloading.\nIt is advisable to retry the download later and see if the\nremaining patches can be downloaded. If they can, then the new download\nsummary file will show the patches required and the order in which to\ninstall them. The patches failing to install are listed here:\n\n"));
            this.printProblemPatches(printStream, patchList2);
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new PatchProRuntimeException(iOException);
        }
        printStream.close();
    }

    private boolean validatePatchBundle(String string, String string2) {
        boolean bl = true;
        this.log.println(this, 7, "Entered downloader validatePatchBundle()");
        if (this.validationUtil == null) {
            String string3 = FAILED_TO_CREATE_VALIDATION_UTIL;
            this.log.println(this, 3, string3);
            this.dispatchFailedEvent(PatchProLog.createMessage(3, FAILED_TO_CREATE_VALIDATION_UTIL));
            return false;
        }
        try {
            this.validationUtil.validateJarFile(string2);
        }
        catch (ManifestFileNotFoundException manifestFileNotFoundException) {
            bl = false;
            String string4 = "Failed to validate the digital signature(s). for: " + string2 + ": " + manifestFileNotFoundException.getMessage();
            this.log.printStackTrace(this, 3, manifestFileNotFoundException);
            this.log.println(this, 3, string4);
            this.dispatchFailedEvent(PatchProLog.createMessage(3, FAILED_TO_VALIDATE_SIGNATURE));
        }
        catch (SignatureCheckFailedException signatureCheckFailedException) {
            bl = false;
            String string5 = "Failed to validate the digital signature(s). for: " + string2 + ": " + signatureCheckFailedException.getMessage();
            this.log.printStackTrace(this, 3, signatureCheckFailedException);
            this.log.println(this, 3, string5);
            this.dispatchFailedEvent(PatchProLog.createMessage(3, FAILED_TO_VALIDATE_SIGNATURE));
        }
        catch (NotSignedByKnownCertificateException notSignedByKnownCertificateException) {
            bl = false;
            String string6 = "Failed to validate the digital signature(s). for: " + string2 + ": " + notSignedByKnownCertificateException.getMessage();
            this.log.printStackTrace(this, 3, notSignedByKnownCertificateException);
            this.log.println(this, 3, string6);
            this.dispatchFailedEvent(PatchProLog.createMessage(3, FAILED_TO_VALIDATE_SIGNATURE));
        }
        catch (SignatureValidationException signatureValidationException) {
            bl = false;
            String string7 = "Failed to validate the digital signature(s). for: " + string2 + ": " + signatureValidationException.getMessage();
            this.log.printStackTrace(this, 3, signatureValidationException);
            this.log.println(this, 3, string7);
            this.dispatchFailedEvent(PatchProLog.createMessage(3, FAILED_TO_VALIDATE_SIGNATURE));
        }
        System.out.println("");
        if (bl) {
            System.out.println(string + " has been validated.");
        } else {
            System.out.println(string + " cannot be validated.");
            System.out.print("\n\n");
        }
        return bl;
    }

    private void printDownloadedPatches(PrintStream printStream, PatchList patchList) {
        int n = 0;
        int n2 = patchList.size();
        for (int i = 0; i < n2; ++i) {
            try {
                if (!patchList.getSelectionStatus(i)) continue;
                Patch patch = patchList.getPatchAt(i);
                String string = patch.getPatchID().getPatchID();
                this.log.println(this, 7, "Checking if " + string + " is available...");
                PatchProperties patchProperties = patch.getPatchInfo().getProperties();
                ++n;
                if (patchProperties.isNonstandard() || patchProperties.isInteractive()) {
                    printStream.println(n + ") " + string + " " + this.msgcat.getMessage("seeReadmeWarning", "!!! SEE README !!!"));
                    continue;
                }
                if (patchProperties.isRebootimmediate() || patchProperties.isReconfigimmediate()) {
                    printStream.println(n + ") " + string + " " + this.msgcat.getMessage("immediateRebootWarning", "!!! IMMEDIATE REBOOT !!!"));
                    continue;
                }
                if (patchProperties.isRebootafter() || patchProperties.isReconfigafter()) {
                    printStream.println(n + ") " + string + " " + this.msgcat.getMessage("rebootWarning", "!!! REBOOT !!!"));
                    continue;
                }
                if (patchProperties.isSingleuser()) {
                    printStream.println(n + ") " + string + " " + this.msgcat.getMessage("singleUserWarning", "!!! SINGLE USER !!!"));
                    continue;
                }
                printStream.println(n + ") " + string);
                continue;
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 2, noSuchPatchException);
            }
        }
    }

    private void printProblemPatches(PrintStream printStream, PatchList patchList) {
        int n = patchList.size();
        String string = "";
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            IPatch iPatch;
            try {
                iPatch = patchList.getIPatchAt(i);
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 2, noSuchPatchException);
                continue;
            }
            string = iPatch.getPatchID().getPatchID();
            string2 = iPatch.hasError() ? iPatch.getError() : "";
            this.log.println(this, 7, "Listing " + string + " w/ " + string2);
            printStream.println(string + " " + string2);
        }
    }

    private String getCertSerialNumber(String string, String string2) {
        String string3 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            KeyStore keyStore = KeyStore.getInstance("JKS", "SUN");
            keyStore.load(fileInputStream, null);
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string2);
            PublicKey publicKey = x509Certificate.getPublicKey();
            string3 = String.valueOf(x509Certificate.getSerialNumber());
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 3, exception);
        }
        return string3;
    }

    private boolean connectingServer() {
        URLConnection uRLConnection = null;
        Object var2_2 = null;
        Object var3_3 = null;
        Object[] objectArray = new String[]{this.serverURL.toString()};
        try {
            Object object;
            uRLConnection = this.serverURL.openConnection();
            uRLConnection.setAllowUserInteraction(true);
            if (uRLConnection instanceof HttpsURLConnection) {
                object = System.getProperty("https.proxyHost");
                String string = System.getProperty("https.proxyPort");
                if (object != null && string != null && ((String)object).length() > 0 && string.length() > 0) {
                    ((HttpsURLConnection)uRLConnection).setSSLSocketFactory((SSLSocketFactory)new SSLTunnelSocketFactory((String)object, string));
                }
            }
            uRLConnection.setDoOutput(true);
            object = new PrintWriter(uRLConnection.getOutputStream());
            ((PrintWriter)object).print("");
            ((PrintWriter)object).flush();
            if (((PrintWriter)object).checkError()) {
                this.log.println(this, 4, "PrinterWriter error!");
            }
            ((PrintWriter)object).close();
        }
        catch (IOException iOException) {
            this.log.printStackTrace(this, 2, iOException);
            System.out.println(this.msgcat.getMessage("not_connected", objectArray, "Cannot establish a network connection with the patch server."));
            this.dispatchFailedEvent(PatchProLog.createMessage(3, this.msgcat.getMessage("not_connected", objectArray, "Cannot establish a network connection with the patch server.")));
            return false;
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 2, exception);
            System.out.println(this.msgcat.getMessage("not_connected", objectArray, "Cannot establish a network connection with the patch server."));
            return false;
        }
        return true;
    }

    private Downloader sendServerRequest(URL uRL, String string) throws DownloadPatchException {
        int n = -1;
        Downloader downloader = null;
        try {
            downloader = this.sendPatchDownloadPostRequest(uRL, string, "", "", null);
            n = downloader.getResponseCode();
        }
        catch (DownloadPatchException downloadPatchException) {
            if (downloadPatchException.getReasonCode() == 4) {
                n = 500;
            }
            throw downloadPatchException;
        }
        this.log.println(this, 7, "HTTP response code: " + n);
        if (n != 200 && n != 206) {
            String string2 = this.httpResponseCode2Str(n);
            this.log.println(this, 4, string2);
            throw new DownloadPatchException(string2);
        }
        return downloader;
    }

    private Downloader sendPatchDownloadPostRequest(URL uRL, String string, String string2, String string3, SessionData sessionData) throws DownloadPatchException {
        Downloader downloader;
        block6: {
            downloader = null;
            boolean bl = false;
            if (string2 != null && string2.compareTo("") != 0 && string3 != null && string3.compareTo("") != 0) {
                bl = true;
            }
            String string4 = "";
            String string5 = "";
            if (bl) {
                string4 = string2;
                string5 = string3;
            }
            this.log.println(this, 7, "Password authentication: " + bl);
            try {
                downloader = new Downloader(uRL, string, bl, string4, string5);
                downloader.connectToURL();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.log.println(this, 2, "It's possible that " + this.serverURLString + " does not have \"/\" at the end.");
                this.log.println(this, 2, "Returning HTTP response code is > 400. Assume 500.");
                this.log.printStackTrace(this, 2, fileNotFoundException);
                throw new DownloadPatchException(4);
            }
            catch (IOException iOException) {
                this.log.printStackTrace(this, 2, iOException);
                if (downloader != null) break block6;
                this.dispatchFailedEvent(PatchProLog.createMessage(2, FAILED_TO_CONNECT_TO_SERVER));
                ServerConnectionException serverConnectionException = new ServerConnectionException("ServerConnectionException", "ServerConnectionException.MESSAGE", "ServerConnectionException.REMEDY", 2);
                if (sessionData != null) {
                    sessionData.addPatchProException(serverConnectionException);
                }
                throw new DownloadPatchException(FAILED_TO_CREATE_DOWNLOADER);
            }
        }
        return downloader;
    }

    private long patchExists(String string, String string2) {
        String string3 = string + File.separator + string2 + ".jar";
        File file = new File(string3);
        return file.length();
    }

    private void dispatchProgressEvent(String string) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchListener downloadPatchListener = (DownloadPatchListener)enumeration.nextElement();
            downloadPatchListener.downloadPatchProgress(new DownloadPatchEvent(this, string));
        }
    }

    private void dispatchDoneEvent(String string) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchListener downloadPatchListener = (DownloadPatchListener)enumeration.nextElement();
            downloadPatchListener.downloadPatchDone(new DownloadPatchEvent(this, string));
        }
    }

    private void dispatchFailedEvent(String string) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchListener downloadPatchListener = (DownloadPatchListener)enumeration.nextElement();
            downloadPatchListener.downloadPatchFailed(new DownloadPatchEvent(this, string));
        }
    }

    private void printTaggedMessage(String string, String string2, String string3, String string4, String string5) {
        String string6 = "";
        if (this.internalStatus) {
            string6 = string3 == null ? string + " " + string2 : (string4 == null ? string + " " + string2 + " " + string3 : (string5 == null ? string + " " + string2 + " " + string3 + " " + string4 : string + " " + string2 + " " + string3 + " " + string4 + " " + string5));
            System.out.println(string6.trim());
        }
    }

    private void printTaggedMessage(String string, PatchList patchList, String string2, String string3, String string4) {
        String string5 = "";
        if (this.internalStatus) {
            for (int i = 0; i < patchList.size(); ++i) {
                Patch patch;
                try {
                    patch = patchList.getPatchAt(i);
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    continue;
                }
                String string6 = patch.getPatchID().getPatchID();
                string5 = string2 == null ? string + " " + string6 : (string3 == null ? string + " " + string6 + " " + string2 : (string4 == null ? string + " " + string6 + " " + string2 + " " + string3 + " \"" + string6 + "\"" : string + " " + string6 + " " + string2 + " " + string3 + " \"" + string6 + "\" " + string4));
                System.out.println(string5.trim());
            }
        }
    }
}

