/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.server;

import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.PatchBundleInfo;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchInfoImpl;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.patch.PatchProperties;
import com.sun.patchpro.patch.SecurePatchListImpl;
import com.sun.patchpro.server.DownloadPatchException;
import com.sun.patchpro.server.NotSupportedException;
import com.sun.patchpro.server.PatchServerProxy;
import com.sun.patchpro.server.PatchServerProxyException;
import com.sun.patchpro.server.PatchServerServletProperties;
import com.sun.patchpro.server.ServletLog;
import com.sun.patchpro.util.StringUtilities;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sun.misc.BASE64Decoder;

public class PatchProServerServlet
extends HttpServlet
implements SingleThreadModel {
    protected static final String VERSION_2_0 = "2.0";
    protected static final String VERSION_2_1 = "2.1";
    public static final String DEFAULT_REQUESTED_DB_NAME = "patchprodb";
    public static final String DEFAULT_REQUESTED_DETECTORS_NAME = "pprodetectors";
    public static final String DEFAULT_ASSETID_ATTRIBUTE_NAME = "assetId";
    protected String protocolVersion = "";
    protected PatchProLog log;
    protected PatchServerServletProperties properties;
    protected PatchServerProxy patchServerProxy;
    protected boolean checkRequestAssetId = false;
    public static final int SUCCESS = 0;
    public static final int DUPLICATE_PARAMETER = 4;
    public static final int INVALID_PARAMETER = 8;
    public static final int INVALID_REQUEST = 16;
    public static final int MISSING_PARAMETER = 32;
    public static final int MISSING_VALUE = 36;
    public static final int MISSING_ASSETID = 40;
    public static final int IO_EXCEPTION = 48;
    public static final int EXCEPTION = 64;
    public static final int MALFORMED_PATCH_EXCEPTION = 100;
    public static final int DOWNLOADPATCH_EXCEPTION = 110;
    public static final int NOT_SUPPORTED_EXCEPTION = 120;
    public static final int PATCHBUNDLE_INFO_UNAVAILABLE = 130;
    public static final int EXPIRED_CERTIFICATE = 200;
    public static final int GOOD_CERTIFICATE = 201;
    public static final int DOWNLOADPATCHDB_EXCEPTION = 300;
    public static final int DOWNLOAD_REALIZATION_EXCEPTION = 400;
    public static final int DOWNLOAD_READMEFILE_EXCEPTION = 500;
    public static final int DOWNLOAD_CATEGORYFILE_EXCEPTION = 600;
    public static final int DOWNLOAD_COLLECTIONFILE_EXCEPTION = 700;
    public static final int DOWNLOAD_ENTITLEMENTFILE_EXCEPTION = 800;
    public static final int DOWNLOAD_DATABASEFILE_EXCEPTION = 900;

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        block159: {
            boolean bl = this.properties.getProperty("patchpro.debug", "false").equals("true");
            try {
                Object object;
                Object object2;
                String[] stringArray;
                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 0);
                httpServletResponse.setStatus(200);
                String[] stringArray2 = httpServletRequest.getParameterValues("version");
                if (stringArray2 == null || stringArray2.length == 0) {
                    this.protocolVersion = VERSION_2_0;
                } else if (stringArray2[0].compareTo(VERSION_2_0) == 0) {
                    this.protocolVersion = VERSION_2_0;
                } else if (stringArray2[0].compareTo(VERSION_2_1) == 0) {
                    this.protocolVersion = VERSION_2_1;
                } else {
                    this.log.println((Object)this, 3, "Invalid request: Invalid version specified.");
                    httpServletResponse.setIntHeader("PatchProServletCompletionCode", 16);
                    httpServletResponse.sendError(400);
                    return;
                }
                Object object3 = null;
                String string = null;
                String string2 = httpServletRequest.getHeader("Authorization");
                if (string2 != null && string2.toLowerCase().startsWith("basic ")) {
                    stringArray = string2.substring(6).trim();
                    object2 = new BASE64Decoder();
                    object = new String(object2.decodeBuffer((String)stringArray));
                    int n = ((String)object).indexOf(":");
                    object3 = ((String)object).substring(0, n);
                    string = ((String)object).substring(n + 1);
                    this.log.println((Object)this, 7, "UserID from Auth header" + (String)object3);
                }
                this.log.println((Object)this, 6, "Protocol version: " + this.protocolVersion);
                stringArray = httpServletRequest.getParameterValues("action");
                if (stringArray == null || stringArray.length > 1) {
                    this.log.println((Object)this, 3, "Invalid request: Either the \"action\" parameter was not specified or multiple \"action\" parameters were detected.");
                    httpServletResponse.setIntHeader("PatchProServletCompletionCode", 16);
                    httpServletResponse.sendError(400);
                    return;
                }
                if (stringArray[0].compareTo("patchDownload") == 0) {
                    String[] stringArray3;
                    String[] stringArray4;
                    object2 = httpServletRequest.getParameterNames();
                    while (object2.hasMoreElements()) {
                        object = (String)object2.nextElement();
                        if (((String)object).equals("action") || ((String)object).equals("patchId") || ((String)object).equals("user") || ((String)object).equals("passwd") || ((String)object).equals("text") || ((String)object).equals("maxSize") || ((String)object).equals("version")) continue;
                        this.log.println((Object)this, 3, "Invalid \"patchDownload\" request: Unknown parameter \"" + (String)object + "\" was detected.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 8);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    object2 = "";
                    if (this.protocolVersion.compareTo(VERSION_2_0) == 0) {
                        object = httpServletRequest.getParameterValues("user");
                        String[] stringArray5 = httpServletRequest.getParameterValues("passwd");
                        if (object != null) {
                            if (((Object)object).length > 1) {
                                this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Multiple \"user\" parameters were  detected.");
                                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 4);
                                httpServletResponse.sendError(400);
                                return;
                            }
                            if (((String)object[0]).equals("")) {
                                this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Value was not specified for the specified \"user\" parameter.");
                                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 36);
                                httpServletResponse.sendError(400);
                                return;
                            }
                            object3 = object[0];
                        }
                        if (stringArray5 != null) {
                            if (stringArray5.length > 1) {
                                this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Multiple \"passwd\" parameters were  detected.");
                                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 4);
                                httpServletResponse.sendError(400);
                                return;
                            }
                            if (stringArray5[0].equals("")) {
                                this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Value was not specified for the specified \"passwd\"  parameter.");
                                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 36);
                                httpServletResponse.sendError(400);
                                return;
                            }
                            string = stringArray5[0];
                        }
                    }
                    if (this.protocolVersion.compareTo(VERSION_2_0) != 0 && (stringArray4 = httpServletRequest.getParameterValues("maxSize")) != null && stringArray4.length > 0) {
                        this.log.println((Object)this, 7, "maxSize specified: " + stringArray4[0]);
                    }
                    if ((object = httpServletRequest.getParameterValues("text")) != null) {
                        if (((Object)object).length > 1) {
                            this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Multiple \"text\" parameters were detected.");
                            httpServletResponse.sendError(400);
                            return;
                        }
                        if (((String)object[0]).equals("")) {
                            this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Value was not specified for the specified \"text\" parameter.");
                            httpServletResponse.setIntHeader("PatchProServletCompletionCode", 36);
                            httpServletResponse.sendError(400);
                            return;
                        }
                        object2 = object[0];
                    }
                    if ((stringArray3 = httpServletRequest.getParameterValues("patchId")) == null || object3 != null && string == null || object3 == null && string != null) {
                        this.log.println((Object)this, 3, "Invalid \"patchDownload\" request: A required \"patchID\", \"user\" and/or \"passwd\" parameter was not specified");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 32);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    PatchListImpl patchListImpl = null;
                    patchListImpl = object3 != null ? new SecurePatchListImpl((String)object3, string, (String)object2) : new PatchListImpl((String)object2);
                    PatchInfoImpl patchInfoImpl = new PatchInfoImpl();
                    patchInfoImpl.setObsolesces("");
                    patchInfoImpl.setRequires("");
                    patchInfoImpl.setOS("");
                    patchInfoImpl.setProperties(new PatchProperties(""));
                    for (int i = 0; i < stringArray3.length; ++i) {
                        try {
                            patchListImpl.addIPatch(new IPatch(new PatchImpl(patchInfoImpl, new PatchID(stringArray3[i]))));
                            patchListImpl.setSelectionStatus(i, true);
                            continue;
                        }
                        catch (MalformedPatchException malformedPatchException) {
                            this.log.println((Object)this, 3, "Problem detected while servicing \"patchDownload\" request. Exception: " + malformedPatchException);
                            httpServletResponse.setIntHeader("PatchProServletCompletionCode", 100);
                            httpServletResponse.sendError(500);
                            return;
                        }
                    }
                    ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                    httpServletResponse.setContentType("application/octet-stream");
                    PatchBundleInfo[] patchBundleInfoArray = this.patchServerProxy.getDownloadedPatchBundlesInfo(patchListImpl);
                    this.log.println((Object)this, 7, "patchList.size: " + patchListImpl.size());
                    if (patchBundleInfoArray == null) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"patchDownload\" request. Cannot access patch bundle information.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 130);
                        httpServletResponse.sendError(500);
                        return;
                    }
                    int n = 200;
                    String string3 = "";
                    String string4 = "";
                    for (int i = 0; i < patchBundleInfoArray.length; ++i) {
                        long l = patchBundleInfoArray[i].getPatchBundleSize();
                        if (l < 0L) {
                            if (!string4.equals("")) {
                                string4 = string4 + "|";
                            }
                            String string5 = patchBundleInfoArray[i].getPatchBundleName();
                            string4 = string4 + string5.substring(0, string5.indexOf(".")) + "&" + Long.toString(-l);
                            n = 206;
                            continue;
                        }
                        if (!string3.equals("")) {
                            string3 = string3 + "|";
                        }
                        string3 = string3 + patchBundleInfoArray[i].getPatchBundleName() + "&" + Long.toString(l);
                    }
                    this.log.println((Object)this, 7, "patchFiles: " + string3);
                    this.log.println((Object)this, 7, "rejects: " + string4);
                    httpServletResponse.setHeader("patchFiles", string3);
                    if (this.protocolVersion.compareTo(VERSION_2_1) == 0 && string4.compareTo("") != 0) {
                        httpServletResponse.setHeader("rejects", string4);
                    }
                    httpServletResponse.setStatus(n);
                    try {
                        this.patchServerProxy.downloadPatches(patchListImpl, servletOutputStream);
                    }
                    catch (DownloadPatchException downloadPatchException) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"patchDownload\" request. Cannot download patch bundle.");
                        this.log.printStackTrace((Object)this, 3, downloadPatchException);
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 110);
                        httpServletResponse.sendError(500);
                        return;
                    }
                    catch (NotSupportedException notSupportedException) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"patchDownload\" request. \"patchDownload\" request is not supported.");
                        this.log.printStackTrace((Object)this, 3, notSupportedException);
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 120);
                        httpServletResponse.sendError(500);
                        return;
                    }
                    catch (Exception exception) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"patchDownload\" request. ");
                        this.log.printStackTrace((Object)this, 3, exception);
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 64);
                        httpServletResponse.sendError(500);
                        return;
                    }
                    this.log.println((Object)this, 7, "PatchProServerServlet.patchDownload done. Status: " + n);
                    break block159;
                }
                if (stringArray[0].compareTo("isCertificateRevoked") == 0) {
                    this.log.println((Object)this, 7, "Received a isCertificateRevoked request.");
                    object2 = httpServletRequest.getParameterNames();
                    while (object2.hasMoreElements()) {
                        object = (String)object2.nextElement();
                        if (((String)object).equals("action") || ((String)object).equals("serialNumber") || ((String)object).equals("version")) continue;
                        this.log.println((Object)this, 3, "Invalid \"isCertificateRevoked\" request: Unknown parameter \"" + (String)object + "\" detected.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 8);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    object2 = null;
                    object = httpServletRequest.getParameterValues("serialNumber");
                    if (object == null) {
                        this.log.println((Object)this, 3, "Invalid \"isCertificateRevoked\" request: The required \"serialNumber\" parameter was not specified.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 32);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    if (((String)object[0]).equals("")) {
                        this.log.println((Object)this, 3, "Invalid  \"isCertificateRevoked\" request: Value was not specified for thespecified \"serialNumber\" parameter.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 36);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    if (((Object)object).length > 1) {
                        this.log.println((Object)this, 3, "Invalid \"isCertificateRevoked\" request: Multiple \"serialNumber\" parameters are not allowed.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 4);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    object2 = object[0];
                    if (this.patchServerProxy.isCertificateRevoked((String)object2)) {
                        this.log.println((Object)this, 6, "Certificate has been revoked for " + (String)object2);
                        httpServletResponse.setIntHeader("patchproServiceCompletionCode", 200);
                    } else {
                        this.log.println((Object)this, 6, "This certificate is good: " + (String)object2);
                        httpServletResponse.setIntHeader("patchproServiceCompletionCode", 201);
                    }
                    return;
                }
                if (stringArray[0].compareTo("downloadPatchDB") == 0) {
                    FileInputStream fileInputStream;
                    object2 = httpServletRequest.getParameterNames();
                    while (object2.hasMoreElements()) {
                        object = (String)object2.nextElement();
                        if (((String)object).equals("action") || ((String)object).equals("version") || ((String)object).equals("name")) continue;
                        this.log.println((Object)this, 3, "Invalid \"downloadPatchDB\" request: Unknown parameter \"" + (String)object + "\" detected.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 8);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    object2 = httpServletRequest.getParameter("name");
                    if (object2 == null) {
                        object2 = DEFAULT_REQUESTED_DB_NAME;
                    }
                    this.log.println((Object)this, 7, "Requested Database Name: " + (String)object2);
                    httpServletResponse.setContentType("application/octet-stream");
                    object = httpServletResponse.getOutputStream();
                    try {
                        fileInputStream = new FileInputStream(this.patchServerProxy.downloadOldPatchDB((String)object2));
                    }
                    catch (PatchProException patchProException) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"downloadPatchDB\" request. " + patchProException.getMessage());
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 300);
                        if (patchProException.getTargetException() instanceof FileNotFoundException) {
                            httpServletResponse.setStatus(404);
                            httpServletResponse.sendError(404);
                        } else {
                            this.log.printStackTrace((Object)this, 3, patchProException);
                            httpServletResponse.setStatus(500);
                            httpServletResponse.sendError(500);
                        }
                        return;
                    }
                    try {
                        this.copyStream((OutputStream)object, fileInputStream);
                        break block159;
                    }
                    catch (IOException iOException) {
                        this.log.println((Object)this, 3, "downloadPatchDB - IOException while copying:  " + iOException.getMessage());
                        break block159;
                    }
                    finally {
                        ((InputStream)fileInputStream).close();
                    }
                }
                if (stringArray[0].compareTo("downloadRealizationDetectors") == 0) {
                    FileInputStream fileInputStream;
                    object2 = httpServletRequest.getParameterNames();
                    while (object2.hasMoreElements()) {
                        object = (String)object2.nextElement();
                        if (((String)object).equals("action") || ((String)object).equals("version") || ((String)object).equals("name")) continue;
                        this.log.println((Object)this, 3, "Invalid \"downloadRealizationDetectors\" request: Unknown parameter \"" + (String)object + "\" detected");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 8);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    object2 = httpServletRequest.getParameter("name");
                    if (object2 == null) {
                        object2 = DEFAULT_REQUESTED_DETECTORS_NAME;
                    }
                    this.log.println((Object)this, 7, "Requested Detector Name: " + (String)object2);
                    try {
                        StringUtilities.checkPath((String)object2);
                    }
                    catch (AccessControlException accessControlException) {
                        this.log.println((Object)this, 3, "Invalid \"downloadRealizationDetectors\" request:\n" + accessControlException.getMessage());
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 16);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    httpServletResponse.setContentType("application/octet-stream");
                    object = httpServletResponse.getOutputStream();
                    try {
                        fileInputStream = new FileInputStream(this.patchServerProxy.downloadRealizationDetectors((String)object2));
                    }
                    catch (PatchProException patchProException) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"downloadRealizationDetectors\" request. " + patchProException.getMessage());
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 400);
                        if (patchProException.getTargetException() instanceof FileNotFoundException) {
                            httpServletResponse.setStatus(404);
                            httpServletResponse.sendError(404);
                        } else {
                            this.log.printStackTrace((Object)this, 3, patchProException);
                            httpServletResponse.setStatus(500);
                            httpServletResponse.sendError(500);
                        }
                        return;
                    }
                    try {
                        this.copyStream((OutputStream)object, fileInputStream);
                    }
                    catch (IOException iOException) {
                        this.log.println((Object)this, 3, "downloadRealizationDetectors - IOException while copying:  " + iOException.getMessage());
                    }
                    finally {
                        ((InputStream)fileInputStream).close();
                    }
                    this.log.println((Object)this, 7, "PatchProServerServlet.downloadRealizationDetectors done.");
                    break block159;
                }
                if (stringArray[0].equals("getDocumentation") || stringArray[0].equals("getFile")) {
                    int n;
                    block161: {
                        n = 200;
                        if (bl) {
                            this.log.println((Object)this, 7, "Received a getDocumentation/getFile request.");
                        }
                        object = httpServletRequest.getParameterNames();
                        while (object.hasMoreElements()) {
                            String string6 = (String)object.nextElement();
                            if (string6.equals("action") || string6.equals("version") || string6.equals("name")) continue;
                            this.log.println((Object)this, 3, "Invalid \"getDocumentation\" or \"getFile\" request: Unknown parameter \"" + string6 + "\" detected");
                            httpServletResponse.setIntHeader("PatchProServletCompletionCode", 8);
                            httpServletResponse.sendError(400);
                            return;
                        }
                        if (bl) {
                            this.log.println((Object)this, 7, "... Parameter check passed");
                        }
                        try {
                            long l = 0L;
                            int n2 = -1;
                            String string7 = "";
                            String string8 = "";
                            String string9 = "";
                            String string10 = "";
                            FileInputStream fileInputStream = null;
                            ServletOutputStream servletOutputStream = null;
                            httpServletResponse.setContentType("application/octet-stream");
                            servletOutputStream = httpServletResponse.getOutputStream();
                            httpServletResponse.setStatus(n);
                            String[] stringArray6 = httpServletRequest.getParameterValues("name");
                            if (stringArray6 == null || stringArray6.length > 1) {
                                this.log.println((Object)this, 3, "Invalid request: Either the \"document\" parameter was not specified or multiple \"document\" parameters were detected.");
                                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 16);
                                httpServletResponse.sendError(400);
                                return;
                            }
                            if (bl) {
                                this.log.println((Object)this, 7, "... Full document name to retrieve is " + stringArray6[0]);
                            }
                            try {
                                StringUtilities.checkPath(stringArray6[0]);
                            }
                            catch (AccessControlException accessControlException) {
                                this.log.println((Object)this, 3, "Invalid \"getDocumentation\" or \"getFile\" request:\n" + accessControlException.getMessage());
                                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 16);
                                httpServletResponse.sendError(400);
                                return;
                            }
                            if (stringArray6[0].indexOf("ReadMe/") == 0) {
                                string8 = StringUtilities.getFileName(stringArray6[0]);
                                if (bl) {
                                    this.log.println((Object)this, 7, "... ReadMe file document to retrieve is " + string8);
                                }
                                if (string8 == null) {
                                    this.log.println((Object)this, 3, "The specified request to retrieve a patch README file is invalid. No README filename was passed to the request.");
                                    httpServletResponse.setIntHeader("PatchProServletCompletionCode", 16);
                                    httpServletResponse.sendError(400);
                                    return;
                                }
                                if (bl) {
                                    this.log.println((Object)this, 7, "... Requested ReadMe Name: " + string8);
                                }
                                try {
                                    if (bl) {
                                        this.log.println((Object)this, 7, "... Calling patchServerProxy.downloadReadMeFile");
                                    }
                                    fileInputStream = new FileInputStream(this.patchServerProxy.downloadReadMeFile(stringArray6[0]));
                                    if (bl) {
                                        this.log.println((Object)this, 7, "... Returning from  patchServerProxy.downloadReadMeFile");
                                    }
                                }
                                catch (PatchProException patchProException) {
                                    this.log.println((Object)this, 3, "Problem detected while servicing \"download README file\" request. " + patchProException.getMessage());
                                    httpServletResponse.setIntHeader("PatchProServletCompletionCode", 500);
                                    if (patchProException.getTargetException() instanceof FileNotFoundException) {
                                        httpServletResponse.setStatus(404);
                                        httpServletResponse.sendError(404);
                                    } else {
                                        this.log.printStackTrace((Object)this, 3, patchProException);
                                        httpServletResponse.setStatus(500);
                                        httpServletResponse.sendError(500);
                                    }
                                    return;
                                }
                                try {
                                    if (bl) {
                                        this.log.println((Object)this, 7, "... Writing input to output stream.");
                                    }
                                    this.copyStream((OutputStream)servletOutputStream, fileInputStream);
                                    if (bl) {
                                        this.log.println((Object)this, 7, "... Completed request to download README file.");
                                    }
                                    break block161;
                                }
                                catch (IOException iOException) {
                                    this.log.println((Object)this, 3, "download collection file - IOException while copying:  " + iOException.getMessage());
                                    break block161;
                                }
                                finally {
                                    ((InputStream)fileInputStream).close();
                                }
                            }
                            if (stringArray6[0].indexOf("category/") == 0) {
                                string8 = StringUtilities.getFileName(stringArray6[0]);
                                if (bl) {
                                    this.log.println((Object)this, 7, "... Category file document to retrieve is " + string8);
                                }
                                if (string8 == null || string8.equals("")) {
                                    string8 = "default";
                                }
                                if (bl) {
                                    this.log.println((Object)this, 7, "... Requested Category Name: " + string8);
                                }
                                try {
                                    if (bl) {
                                        this.log.println((Object)this, 7, "... Calling patchServerProxy.downloadCategoryFile");
                                    }
                                    fileInputStream = new FileInputStream(this.patchServerProxy.downloadCategoryFile(stringArray6[0]));
                                    if (bl) {
                                        this.log.println((Object)this, 7, "... Returning from patchServerProxy.downloadCategoryFile");
                                    }
                                }
                                catch (PatchProException patchProException) {
                                    this.log.println((Object)this, 3, "Problem detected while servicing \"download category file\" request. " + patchProException.getMessage());
                                    httpServletResponse.setIntHeader("PatchProServletCompletionCode", 600);
                                    if (patchProException.getTargetException() instanceof FileNotFoundException) {
                                        httpServletResponse.setStatus(404);
                                        httpServletResponse.sendError(404);
                                    } else {
                                        this.log.printStackTrace((Object)this, 3, patchProException);
                                        httpServletResponse.setStatus(500);
                                        httpServletResponse.sendError(500);
                                    }
                                    return;
                                }
                                try {
                                    if (bl) {
                                        this.log.println((Object)this, 7, "... Writing input to output stream.");
                                    }
                                    this.copyStream((OutputStream)servletOutputStream, fileInputStream);
                                    if (bl) {
                                        this.log.println((Object)this, 7, "... Completed request to download Category file.");
                                    }
                                    break block161;
                                }
                                catch (IOException iOException) {
                                    this.log.println((Object)this, 3, "download category file - IOException while copying:  " + iOException.getMessage());
                                    break block161;
                                }
                                finally {
                                    ((InputStream)fileInputStream).close();
                                }
                            }
                            if (stringArray6[0].indexOf("collection/") == 0) {
                                string8 = StringUtilities.getFileName(stringArray6[0]);
                                if (bl) {
                                    this.log.println((Object)this, 7, "... Collection file document to retrieve is " + string8);
                                }
                                if (string8 == null || string8.equals("")) {
                                    string8 = "default";
                                }
                                if (bl) {
                                    this.log.println((Object)this, 7, "... Requested Collection Name: " + string8);
                                }
                                try {
                                    if (bl) {
                                        this.log.println((Object)this, 7, "... Calling patchServerProxy.downloadCollectionFile");
                                    }
                                    fileInputStream = new FileInputStream(this.patchServerProxy.downloadCollectionFile(stringArray6[0]));
                                    if (bl) {
                                        this.log.println((Object)this, 7, "... Returning from  patchServerProxy.downloadCollectionFile");
                                    }
                                }
                                catch (PatchProException patchProException) {
                                    this.log.println((Object)this, 3, "Problem detected while servicing \"download collection file\" request. " + patchProException.getMessage());
                                    httpServletResponse.setIntHeader("PatchProServletCompletionCode", 700);
                                    if (patchProException.getTargetException() instanceof FileNotFoundException) {
                                        httpServletResponse.setStatus(404);
                                        httpServletResponse.sendError(404);
                                    } else {
                                        this.log.printStackTrace((Object)this, 3, patchProException);
                                        httpServletResponse.setStatus(500);
                                        httpServletResponse.sendError(500);
                                    }
                                    return;
                                }
                                try {
                                    if (bl) {
                                        this.log.println((Object)this, 7, "... Writing input to output stream.");
                                    }
                                    this.copyStream((OutputStream)servletOutputStream, fileInputStream);
                                    if (bl) {
                                        this.log.println((Object)this, 7, "... Completed request to download Collection file.");
                                    }
                                    break block161;
                                }
                                catch (IOException iOException) {
                                    this.log.println((Object)this, 3, "download collection file - IOException while copying:  " + iOException.getMessage());
                                    break block161;
                                }
                                finally {
                                    ((InputStream)fileInputStream).close();
                                }
                            }
                            if (stringArray6[0].indexOf("Database/") == 0) {
                                string8 = StringUtilities.getFileName(stringArray6[0]);
                                if (bl) {
                                    this.log.println((Object)this, 7, "... Database file document to retrieve is " + string8);
                                }
                                if (string8 == null || string8.equals("")) {
                                    string8 = "default";
                                }
                                if (bl) {
                                    this.log.println((Object)this, 7, "... Requested Database Name: " + string8);
                                }
                                try {
                                    if (bl) {
                                        this.log.println((Object)this, 7, "... Calling patchServerProxy.downloadPatchDB");
                                    }
                                    fileInputStream = new FileInputStream(this.patchServerProxy.downloadPatchDB(stringArray6[0]));
                                    if (bl) {
                                        this.log.println((Object)this, 7, "... Returning from  patchServerProxy.downloadPatchDB");
                                    }
                                }
                                catch (PatchProException patchProException) {
                                    this.log.println((Object)this, 3, "Problem detected while servicing \"download database file\" request. " + patchProException.getMessage());
                                    httpServletResponse.setIntHeader("PatchProServletCompletionCode", 900);
                                    if (patchProException.getTargetException() instanceof FileNotFoundException) {
                                        httpServletResponse.setStatus(404);
                                        httpServletResponse.sendError(404);
                                    } else {
                                        this.log.printStackTrace((Object)this, 3, patchProException);
                                        httpServletResponse.setStatus(500);
                                        httpServletResponse.sendError(500);
                                    }
                                    return;
                                }
                                try {
                                    if (bl) {
                                        this.log.println((Object)this, 7, "... Writing input to output stream.");
                                    }
                                    this.copyStream((OutputStream)servletOutputStream, fileInputStream);
                                    if (bl) {
                                        this.log.println((Object)this, 7, "... Completed request to download Database file.");
                                    }
                                    break block161;
                                }
                                catch (IOException iOException) {
                                    this.log.println((Object)this, 3, "download database file - IOException while copying:  " + iOException.getMessage());
                                    break block161;
                                }
                                finally {
                                    ((InputStream)fileInputStream).close();
                                }
                            }
                            this.log.println((Object)this, 3, "The type of \"document\" detected is unknown.");
                            httpServletResponse.setIntHeader("PatchProServletCompletionCode", 16);
                            httpServletResponse.sendError(400);
                            return;
                        }
                        catch (Exception exception) {
                            this.log.println((Object)this, 3, "Problem detected while servicing \"getDocumentation\" or \"getFile\" request. ");
                            this.log.printStackTrace((Object)this, 3, exception);
                            httpServletResponse.setStatus(500);
                            httpServletResponse.setIntHeader("PatchProServletCompletionCode", 64);
                            httpServletResponse.sendError(500);
                            return;
                        }
                    }
                    this.log.println((Object)this, 7, "PatchProServerServlet  getDocumentation/getFile done. Status: " + n);
                    break block159;
                }
                if (stringArray[0].compareTo("getEntitlement") == 0) {
                    object2 = (String)httpServletRequest.getAttribute(DEFAULT_ASSETID_ATTRIBUTE_NAME);
                    if (this.checkRequestAssetId && (object2 == null || ((String)object2).equals(""))) {
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 40);
                        httpServletResponse.sendError(403);
                        this.log.println((Object)this, 3, "Missing asset id attribute from request.");
                        return;
                    }
                    object = httpServletRequest.getParameterNames();
                    while (object.hasMoreElements()) {
                        String string11 = (String)object.nextElement();
                        if (string11.equals("action") || string11.equals("version") || string11.equals("name")) continue;
                        this.log.println((Object)this, 3, "Invalid \"downloadEntitlementFile\" request: Unknown parameter \"" + string11 + "\" detected");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 8);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    object = httpServletRequest.getParameter("name");
                    FileInputStream fileInputStream = null;
                    ServletOutputStream servletOutputStream = null;
                    httpServletResponse.setContentType("application/octet-stream");
                    servletOutputStream = httpServletResponse.getOutputStream();
                    try {
                        fileInputStream = new FileInputStream(this.patchServerProxy.downloadEntitlementFile((String)object2));
                    }
                    catch (PatchProException patchProException) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"downloadEntitlementFile\" request. " + patchProException.getMessage());
                        this.log.printStackTrace((Object)this, 3, patchProException);
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 800);
                        httpServletResponse.sendError(500);
                        return;
                    }
                    try {
                        httpServletResponse.setStatus(200);
                        this.copyStream((OutputStream)servletOutputStream, fileInputStream);
                    }
                    catch (IOException iOException) {
                        this.log.println((Object)this, 3, "downloadEntitlement - IOException while copying:  " + iOException.getMessage());
                    }
                    finally {
                        ((InputStream)fileInputStream).close();
                    }
                    return;
                }
                this.log.println((Object)this, 3, "Unknown \"action\" request was specified.");
                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 16);
                httpServletResponse.sendError(400);
                return;
            }
            catch (IOException iOException) {
                this.log.printStackTrace((Object)this, 3, iOException);
                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 48);
                httpServletResponse.setStatus(500);
                throw new ServletException(iOException.toString());
            }
            catch (Exception exception) {
                this.log.printStackTrace((Object)this, 3, exception);
                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 64);
                httpServletResponse.setStatus(500);
                throw new ServletException(exception.toString());
            }
        }
    }

    private void copyStream(OutputStream outputStream, InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[102400];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public synchronized void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.log = PatchProLog.getInstance();
        this.log.setLogger(new ServletLog(servletConfig.getServletContext()));
        this.properties = new PatchServerServletProperties(servletConfig);
        try {
            this.patchServerProxy = new PatchServerProxy(this.properties);
        }
        catch (PatchServerProxyException patchServerProxyException) {
        }
        catch (PatchProException patchProException) {
            // empty catch block
        }
        if (this.properties.getProperty("patchpro.debug", "false").equals("true")) {
            if (this.properties.getProperty("patchsvr.source.0.url") != null) {
                this.log.println((Object)this, 7, "PatchProServerServlet: patchsvr.source.0.url is " + this.properties.getProperty("patchsvr.source.0.url"));
            } else {
                this.log.println((Object)this, 7, "PatchProServerServlet: patchsvr.source.0.url is not defined.");
            }
            if (this.properties.getProperty("patchsvr.source.url") != null) {
                this.log.println((Object)this, 7, "PatchProServerServlet: patchsvr.source.url is " + this.properties.getProperty("patchsvr.source.url"));
            } else {
                this.log.println((Object)this, 7, "PatchProServerServlet: patchsvr.source.url is not defined.");
            }
        }
        this.checkRequestAssetId = this.properties.getProperty("patchpro.isdeliveryserver", "false").equals("true");
    }

    public void destroy() {
        this.log.println((Object)this, 7, "PatchProServerServlet: destroy...");
        this.log = null;
        this.properties = null;
    }
}

