/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.analysis;

import com.sun.patchpro.analysis.BaseDataDetector;
import com.sun.patchpro.analysis.DetectorClassLoader;
import com.sun.patchpro.analysis.DetectorEvent;
import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.DetectorListener;
import com.sun.patchpro.analysis.RealizationDetector;
import com.sun.patchpro.host.ExtendedHost;
import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.RealizationEnumerator;
import com.sun.patchpro.host.RealizationStatus;
import com.sun.patchpro.host.RestrictedHost;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.BaseDataDetectorEvent;
import com.sun.patchpro.model.BaseDataDetectorListener;
import com.sun.patchpro.model.DownloadDetectorsEvent;
import com.sun.patchpro.model.DownloadDetectorsListener;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.model.RealizationDetectorEvent;
import com.sun.patchpro.model.RealizationDetectorListener;
import com.sun.patchpro.model.RealizationSetEvent;
import com.sun.patchpro.model.RealizationSetListener;
import com.sun.patchpro.server.NotSupportedException;
import com.sun.patchpro.server.PatchServerProxy;
import com.sun.patchpro.server.PatchServerProxyException;
import com.sun.patchpro.util.CachingDownloader;
import com.sun.patchpro.util.DownloadEvent;
import com.sun.patchpro.util.DownloadListener;
import com.sun.patchpro.util.Downloader;
import com.sun.patchpro.util.FileFinder;
import com.sun.patchpro.util.InstallationParameters;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.Percentage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class HostAnalyzer
implements DetectorListener,
DownloadDetectorsListener,
RealizationSetListener {
    public static final String DETECTORLIST = "/com/sun/patchpro/detectors/detector.list";
    private PatchProProperties properties;
    private PatchProLog log;
    private Host targetHost;
    private Vector realizationDetectorListeners = new Vector();
    private Vector realizationSetListeners = new Vector();
    private Vector detectorListeners = new Vector();
    private Vector baseDataDetectorListeners = new Vector();
    private CachingDownloader detectorDownloader;
    private Vector downloadDetectorsListeners = new Vector();
    private Percentage[] progressList = new Percentage[2];
    private int baseDataProgress;
    private int realizationProgress;
    private Thread baseDataThread = null;
    private boolean targetHostIsNew = false;
    private boolean baseDataDetectorsDone = false;
    private boolean downloadDetectorsDone = false;
    private int currentDetector = -1;
    private boolean countEachDetector = false;
    private boolean realizationDetectorsStarted = false;
    private int totalDetectorCount;
    private int finishedDetectorCount;
    private int nextPercent = 0;
    private int runDetectorsPercent = 0;
    private int percentInterval = 0;
    private int accuPercentInterval = 0;
    private RealizationEnumerator realizationListEnum;
    private RealizationSet realizationSet;
    private InstallationParameters instParms = null;
    private boolean internalStatus;
    private LocalizedMessages catalog;
    private Locale locale;

    public HostAnalyzer() {
        this.properties = PatchProProperties.getInstance();
        this.log = PatchProLog.getInstance();
        this.instParms = InstallationParameters.getInstance();
        String string = this.properties.getProperty("patchpro.realization.provided");
        this.realizationSet = string == null || string.equals("") ? new RealizationSetAuto() : new RealizationSetCmdLn();
        this.catalog = this.locale != null ? new LocalizedMessages(this.locale) : new LocalizedMessages(Locale.ENGLISH);
        this.internalStatus = this.properties.getProperty("patchpro.internal.statustags", "false").compareTo("true") == 0;
    }

    public File getDetectorCacheFile() throws PatchProException {
        return this.realizationSet.getDetectorCacheFile();
    }

    public void cancel() {
        this.log.println(this, 2, "Cancel is not implemented in the HostAnalyzer.");
    }

    private BaseDataDetector getAnalyzerFromName(String string) throws DetectorFailedException {
        this.log.println(this, 7, "analyzerName=" + string);
        try {
            Class<?> clazz = Class.forName(string);
            BaseDataDetector baseDataDetector = (BaseDataDetector)clazz.newInstance();
            return baseDataDetector;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log.println(this, 4, "HostAnalyzer.getTargetBase(): Unable to open platform specific analyzer, " + string + ".");
            throw new DetectorFailedException("HostAnalyzer.getTargetBase(): Unable to open platform specific analyzer, " + string + ".");
        }
        catch (InstantiationException instantiationException) {
            this.log.println(this, 4, "HostAnalyzer.getTargetBase(): Unable to instantiate " + string + ".");
            throw new DetectorFailedException("HostAnalyzer.getTargetBase(): Unable to instantiate " + string + ".");
        }
        catch (IllegalAccessException illegalAccessException) {
            this.log.println(this, 4, "HostAnalyzer.getTargetBase(): Unable to access " + string + ".");
            throw new DetectorFailedException("HostAnalyzer.getTargetBase(): Unable to access " + string + ".");
        }
    }

    public synchronized Host getTargetBase() throws DetectorFailedException {
        this.targetHost = new ExtendedHost();
        String string = new String("com.sun.patchpro.analysis." + this.getOSName() + "TargetInfo");
        BaseDataDetector baseDataDetector = this.getAnalyzerFromName(string);
        baseDataDetector.setHost(this.targetHost);
        baseDataDetector.run();
        this.targetHostIsNew = true;
        Enumeration enumeration = null;
        FileFinder fileFinder = new FileFinder();
        String string2 = this.instParms.getClassesDirectoryPath();
        String string3 = this.properties.getProperty("patchpro.basedatadetector.prefix");
        if (string3 == null || string3.equals("")) {
            string3 = this.getOSName();
        }
        this.log.println(this, 7, "classesDir=" + string2);
        String string4 = new String(string3 + "TargetInfoExtension.class");
        try {
            enumeration = fileFinder.findAllMatchingFiles(string2, string4, FileFinder.FORMAT_CLASSNAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (enumeration.hasMoreElements()) {
            BaseDataDetector baseDataDetector2 = this.getAnalyzerFromName((String)enumeration.nextElement());
            baseDataDetector2.setHost(this.targetHost);
            baseDataDetector2.run();
        }
        return this.targetHost;
    }

    public synchronized void runBaseDataDetectors() throws DetectorFailedException {
        this.baseDataDetectorsDone = false;
        if (this.targetHost == null) {
            throw new DetectorFailedException("runBaseDataDetectors: Target host emulation does not yet exist.");
        }
        if (!this.targetHostIsNew) {
            throw new DetectorFailedException("runBaseDataDetectors: Target host emulation is stale.");
        }
        BaseDataDetector baseDataDetector = null;
        String string = new String("com.sun.patchpro.analysis." + this.getOSName() + "BaseData");
        baseDataDetector = this.getAnalyzerFromName(string);
        baseDataDetector.setHost(this.targetHost);
        baseDataDetector.addListener(this);
        this.baseDataThread = new Thread(baseDataDetector);
        this.targetHostIsNew = false;
        try {
            this.baseDataThread.setDaemon(false);
            this.baseDataThread.setPriority(10);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            this.log.println(this, 4, "HostAnalyzer.runBaseDataDetectors(): Couldn't mark the base data object as a daemon.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println(this, 4, "HostAnalyzer.runBaseDataDetectors(): Couldn't set the base data object thread priority.");
        }
        catch (SecurityException securityException) {
            this.log.println(this, 4, "HostAnalyzer.runBaseDataDetectors(): Couldn't set the base data object thread priority.");
        }
        this.baseDataThread.start();
    }

    public void downloadDetectors() throws PatchProException {
        this.realizationSet.addListener(this);
        this.realizationSet.prepare(this);
        this.realizationSet.removeListener(this);
    }

    public void runRealizationDetectors() throws PatchProException {
        this.realizationSet.addListener(this);
        this.realizationSet.getRealizationSet(this.targetHost);
        this.realizationSet.removeListener(this);
    }

    public Host getHost() {
        return this.targetHost;
    }

    private void loadRealizations(Enumeration enumeration, Host host) {
        while (enumeration.hasMoreElements()) {
            host.addRealization((Realization)enumeration.nextElement(), false);
        }
    }

    private String getOSName() {
        String string = System.getProperty("os.name");
        if (string.compareTo("Solaris") == 0) {
            string = "SunOS";
        }
        return string;
    }

    private void initializeProgress() {
        if (this.totalDetectorCount < 100) {
            this.countEachDetector = true;
        }
        this.nextPercent = 0;
        this.finishedDetectorCount = 0;
        this.realizationProgress = 0;
    }

    private void incrementProgress() {
        ++this.finishedDetectorCount;
        this.realizationProgress = (int)((double)((float)this.finishedDetectorCount / (float)this.totalDetectorCount) * 100.0);
        if (this.countEachDetector) {
            this.dispatchProgressEvent(new RealizationDetectorEvent(this, this.catalog.getMessage("progress.message.analyzing", "Analyzing system")));
        } else if (this.realizationProgress > this.nextPercent) {
            this.nextPercent += 5;
            this.dispatchProgressEvent(new RealizationDetectorEvent(this, this.catalog.getMessage("progress.message.analyzing", "Analyzing system")));
        }
    }

    public Percentage getBaseDataProgress() {
        Percentage percentage;
        try {
            percentage = new Percentage(this.baseDataProgress);
        }
        catch (Exception exception) {
            this.log.println(this, 4, "HostAnalyzer.getBaseDataProgress(): Unable to create a Percentage from " + this.baseDataProgress + ".");
            this.baseDataProgress = 100;
            percentage = new Percentage(this.baseDataProgress);
            this.baseDataDetectorsDone = true;
        }
        return percentage;
    }

    public Percentage getRealizationProgress() {
        Percentage percentage;
        try {
            percentage = new Percentage(this.realizationProgress);
        }
        catch (Exception exception) {
            this.log.println(this, 4, "HostAnalyzer.getRealizationProgress(): Unable to create a Percentage from " + this.realizationProgress + ".");
            percentage = new Percentage(100);
        }
        return percentage;
    }

    public Percentage getDetectorDownloadProgress() {
        Percentage percentage;
        try {
            percentage = this.realizationSet.getDownloadProgress();
        }
        catch (Exception exception) {
            this.log.println(this, 4, "HostAnalyzer.getDetectorDownloadProgress(): Unable to create a Percentage from realizationSet.getDownloadProgress().");
            percentage = new Percentage(100);
        }
        return percentage;
    }

    private void printTaggedMessage(String string) {
        if (this.internalStatus) {
            System.out.println(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(RealizationDetectorListener realizationDetectorListener) {
        Vector vector = this.realizationDetectorListeners;
        synchronized (vector) {
            this.realizationDetectorListeners.addElement(realizationDetectorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DetectorListener detectorListener) {
        Vector vector = this.detectorListeners;
        synchronized (vector) {
            this.detectorListeners.addElement(detectorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(BaseDataDetectorListener baseDataDetectorListener) {
        Vector vector = this.baseDataDetectorListeners;
        synchronized (vector) {
            this.baseDataDetectorListeners.addElement(baseDataDetectorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DownloadDetectorsListener downloadDetectorsListener) {
        Vector vector = this.downloadDetectorsListeners;
        synchronized (vector) {
            this.downloadDetectorsListeners.addElement(downloadDetectorsListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(RealizationDetectorListener realizationDetectorListener) {
        Vector vector = this.realizationDetectorListeners;
        synchronized (vector) {
            this.realizationDetectorListeners.removeElement(realizationDetectorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DetectorListener detectorListener) {
        Vector vector = this.detectorListeners;
        synchronized (vector) {
            this.detectorListeners.removeElement(detectorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(BaseDataDetectorListener baseDataDetectorListener) {
        Vector vector = this.baseDataDetectorListeners;
        synchronized (vector) {
            this.baseDataDetectorListeners.removeElement(baseDataDetectorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DownloadDetectorsListener downloadDetectorsListener) {
        Vector vector = this.downloadDetectorsListeners;
        synchronized (vector) {
            this.downloadDetectorsListeners.removeElement(downloadDetectorsListener);
        }
    }

    public synchronized void downloadDetectorsProgress(DownloadDetectorsEvent downloadDetectorsEvent) {
        this.dispatchProgressEvent(new DownloadDetectorsEvent(this, this.catalog.getMessage("progress.message.analyzing", "Analyzing system")));
    }

    public synchronized void downloadDetectorsDone(DownloadDetectorsEvent downloadDetectorsEvent) {
        this.dispatchDoneEvent(new DownloadDetectorsEvent(this));
    }

    public synchronized void downloadDetectorsFailed(DownloadDetectorsEvent downloadDetectorsEvent) {
        this.dispatchErrorEvent(new DownloadDetectorsEvent(this));
    }

    public synchronized void detectorProgress(DetectorEvent detectorEvent) {
        Percentage percentage = ((BaseDataDetector)detectorEvent.getSource()).percentComplete();
        this.baseDataProgress = percentage.getPercentage();
        this.dispatchProgressEvent(new BaseDataDetectorEvent(this, this.catalog.getMessage("progress.message.analyzing", "Analyzing system")));
        if (this.baseDataProgress >= 100 && !this.baseDataDetectorsDone) {
            this.baseDataDetectorsDone = true;
            this.dispatchDoneEvent(new BaseDataDetectorEvent(this));
        }
    }

    public synchronized void detectorDone(DetectorEvent detectorEvent) {
        this.baseDataDetectorsDone = true;
        this.dispatchDoneEvent(new BaseDataDetectorEvent(this));
    }

    public void detectorFailed(DetectorEvent detectorEvent) {
        this.dispatchErrorEvent(detectorEvent);
    }

    private void dispatchErrorEvent(DetectorEvent detectorEvent) {
        Enumeration enumeration = this.detectorListeners.elements();
        while (enumeration.hasMoreElements()) {
            DetectorListener detectorListener = (DetectorListener)enumeration.nextElement();
            detectorListener.detectorFailed(detectorEvent);
        }
    }

    private void dispatchProgressEvent(RealizationDetectorEvent realizationDetectorEvent) {
        Enumeration enumeration = this.realizationDetectorListeners.elements();
        while (enumeration.hasMoreElements()) {
            RealizationDetectorListener realizationDetectorListener = (RealizationDetectorListener)enumeration.nextElement();
            realizationDetectorListener.realizationDetectorProgress(realizationDetectorEvent);
        }
    }

    private void dispatchDoneEvent(RealizationDetectorEvent realizationDetectorEvent) {
        Enumeration enumeration = this.realizationDetectorListeners.elements();
        while (enumeration.hasMoreElements()) {
            RealizationDetectorListener realizationDetectorListener = (RealizationDetectorListener)enumeration.nextElement();
            realizationDetectorListener.realizationDetectorDone(realizationDetectorEvent);
        }
    }

    protected void dispatchErrorEvent(RealizationDetectorEvent realizationDetectorEvent) {
        Enumeration enumeration = this.realizationDetectorListeners.elements();
        while (enumeration.hasMoreElements()) {
            RealizationDetectorListener realizationDetectorListener = (RealizationDetectorListener)enumeration.nextElement();
            realizationDetectorListener.realizationDetectorFailed(realizationDetectorEvent);
        }
    }

    public void realizationSetProgress(RealizationSetEvent realizationSetEvent) {
        Enumeration enumeration = this.realizationDetectorListeners.elements();
        RealizationDetectorEvent realizationDetectorEvent = new RealizationDetectorEvent(this, realizationSetEvent.getErrorMessage());
        while (enumeration.hasMoreElements()) {
            RealizationDetectorListener realizationDetectorListener = (RealizationDetectorListener)enumeration.nextElement();
            realizationDetectorListener.realizationDetectorProgress(realizationDetectorEvent);
        }
    }

    public void realizationSetDone(RealizationSetEvent realizationSetEvent) {
        Enumeration enumeration = this.realizationDetectorListeners.elements();
        RealizationDetectorEvent realizationDetectorEvent = new RealizationDetectorEvent(this);
        while (enumeration.hasMoreElements()) {
            RealizationDetectorListener realizationDetectorListener = (RealizationDetectorListener)enumeration.nextElement();
            realizationDetectorListener.realizationDetectorDone(realizationDetectorEvent);
        }
    }

    public void realizationSetFailed(RealizationSetEvent realizationSetEvent) {
        Enumeration enumeration = this.realizationDetectorListeners.elements();
        RealizationDetectorEvent realizationDetectorEvent = new RealizationDetectorEvent(this);
        while (enumeration.hasMoreElements()) {
            RealizationDetectorListener realizationDetectorListener = (RealizationDetectorListener)enumeration.nextElement();
            realizationDetectorListener.realizationDetectorFailed(realizationDetectorEvent);
        }
    }

    private void dispatchProgressEvent(DownloadDetectorsEvent downloadDetectorsEvent) {
        Enumeration enumeration = this.downloadDetectorsListeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadDetectorsListener downloadDetectorsListener = (DownloadDetectorsListener)enumeration.nextElement();
            downloadDetectorsListener.downloadDetectorsProgress(downloadDetectorsEvent);
        }
    }

    private void dispatchDoneEvent(DownloadDetectorsEvent downloadDetectorsEvent) {
        Enumeration enumeration = this.downloadDetectorsListeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadDetectorsListener downloadDetectorsListener = (DownloadDetectorsListener)enumeration.nextElement();
            downloadDetectorsListener.downloadDetectorsDone(downloadDetectorsEvent);
        }
        this.downloadDetectorsDone = true;
        this.realizationSet.removeListener(this);
    }

    private void dispatchErrorEvent(DownloadDetectorsEvent downloadDetectorsEvent) {
        Enumeration enumeration = this.downloadDetectorsListeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadDetectorsListener downloadDetectorsListener = (DownloadDetectorsListener)enumeration.nextElement();
            downloadDetectorsListener.downloadDetectorsFailed(downloadDetectorsEvent);
        }
        this.downloadDetectorsDone = true;
        this.realizationSet.removeListener(this);
    }

    private void dispatchProgressEvent(BaseDataDetectorEvent baseDataDetectorEvent) {
        Enumeration enumeration = this.baseDataDetectorListeners.elements();
        while (enumeration.hasMoreElements()) {
            BaseDataDetectorListener baseDataDetectorListener = (BaseDataDetectorListener)enumeration.nextElement();
            baseDataDetectorListener.baseDataDetectorProgress(baseDataDetectorEvent);
        }
    }

    private void dispatchDoneEvent(BaseDataDetectorEvent baseDataDetectorEvent) {
        Enumeration enumeration = this.baseDataDetectorListeners.elements();
        while (enumeration.hasMoreElements()) {
            BaseDataDetectorListener baseDataDetectorListener = (BaseDataDetectorListener)enumeration.nextElement();
            baseDataDetectorListener.baseDataDetectorDone(baseDataDetectorEvent);
        }
    }

    private class RealizationSetCmdLn
    implements RealizationSet {
        Vector realizationSetListeners = new Vector();
        RealizationSetListener realizationSetListener = null;
        HostAnalyzer hostAnalyzer = null;

        private RealizationSetCmdLn() {
        }

        public File getDetectorCacheFile() {
            return null;
        }

        public void prepare(HostAnalyzer hostAnalyzer) {
            Vector vector = new Vector();
            this.hostAnalyzer = hostAnalyzer;
            HostAnalyzer.this.realizationProgress = 100;
            DownloadDetectorsEvent downloadDetectorsEvent = new DownloadDetectorsEvent(this);
            Enumeration enumeration = HostAnalyzer.this.downloadDetectorsListeners.elements();
            while (enumeration.hasMoreElements()) {
                DownloadDetectorsListener downloadDetectorsListener = (DownloadDetectorsListener)enumeration.nextElement();
                downloadDetectorsListener.downloadDetectorsProgress(downloadDetectorsEvent);
                downloadDetectorsListener.downloadDetectorsDone(downloadDetectorsEvent);
            }
        }

        public Percentage getDownloadProgress() {
            return new Percentage(100);
        }

        public void getRealizationSet(Host host) {
            String string = "patchpro.realization.provided";
            String string2 = HostAnalyzer.this.properties.getProperty(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",\n");
            Vector<RealizationStatus> vector = new Vector<RealizationStatus>();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                HostAnalyzer.this.log.println(this, 7, "The token is: " + string3);
                try {
                    Realization realization = new Realization(string3);
                    RealizationStatus realizationStatus = new RealizationStatus(realization, false);
                    vector.addElement(realizationStatus);
                    HostAnalyzer.this.realizationListEnum = new RealizationEnumerator(vector.elements());
                    if (HostAnalyzer.this.realizationListEnum == null) continue;
                    host.addRealizations(HostAnalyzer.this.realizationListEnum);
                }
                catch (NoSuchRealizationException noSuchRealizationException) {
                    HostAnalyzer.this.log.println(this, 4, "The realization is invalid: " + noSuchRealizationException.getMessage());
                    HostAnalyzer.this.log.printStackTrace(this, 4, noSuchRealizationException);
                    for (int i = 0; i < this.realizationSetListeners.size(); ++i) {
                        this.realizationSetListener = (RealizationSetListener)this.realizationSetListeners.elementAt(i);
                        this.realizationSetListener.realizationSetFailed(new RealizationSetEvent(this, noSuchRealizationException.getMessage()));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(DownloadDetectorsListener downloadDetectorsListener) {
            Vector vector = HostAnalyzer.this.downloadDetectorsListeners;
            synchronized (vector) {
                HostAnalyzer.this.downloadDetectorsListeners.addElement(downloadDetectorsListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(DownloadDetectorsListener downloadDetectorsListener) {
            Vector vector = HostAnalyzer.this.downloadDetectorsListeners;
            synchronized (vector) {
                HostAnalyzer.this.downloadDetectorsListeners.removeElement(downloadDetectorsListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(RealizationSetListener realizationSetListener) {
            Vector vector = this.realizationSetListeners;
            synchronized (vector) {
                this.realizationSetListeners.addElement(realizationSetListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(RealizationSetListener realizationSetListener) {
            Vector vector = this.realizationSetListeners;
            synchronized (vector) {
                this.realizationSetListeners.removeElement(realizationSetListener);
            }
        }
    }

    private class RealizationSetAuto
    implements RealizationSet,
    DownloadListener {
        private ReadOnlyHost currentHost;
        private Enumeration associates;
        private PatchProProperties properties;
        Vector realizationSetListeners = new Vector();
        Vector downloadDetectorsListeners = new Vector();
        RealizationSetListener realizationSetListener = null;
        HostAnalyzer hostAnalyzer = null;
        int hostCount = 1;
        int hostsRemaining = 1;
        Percentage downloadProgress = new Percentage(0);
        boolean downloadDetectorDone;
        boolean debug = false;

        public RealizationSetAuto() {
            this.properties = PatchProProperties.getInstance();
        }

        public void prepare(HostAnalyzer hostAnalyzer) throws PatchProException {
            this.hostAnalyzer = hostAnalyzer;
            this.currentHost = hostAnalyzer.getHost();
            if (this.currentHost != null) {
                this.properties = this.properties.getHostSpecificProperties(this.currentHost);
                this.associates = this.currentHost.getAssociates();
                this.hostCount = this.hostsRemaining = this.currentHost.getAssociateCount() + 1;
            } else {
                this.associates = new Vector().elements();
            }
            boolean bl = true;
            do {
                if (!bl) {
                    this.currentHost = (ReadOnlyHost)this.associates.nextElement();
                    this.properties = this.properties.getHostSpecificProperties(this.currentHost);
                }
                this.downloadDetectors();
                bl = false;
            } while (this.associates.hasMoreElements());
        }

        public void getRealizationSet(Host host) throws PatchProException {
            BufferedReader bufferedReader = null;
            RealizationDetector realizationDetector = null;
            ClassLoader classLoader = HostAnalyzer.class.getClassLoader();
            this.hostsRemaining = this.hostCount;
            HostAnalyzer.this.realizationDetectorsStarted = true;
            this.initializeProgress();
            boolean bl = this.debug = this.properties.getProperty("patchpro.realization.debug", "false").equals("true");
            if (HostAnalyzer.this.targetHost == null) {
                HostAnalyzer.this.log.println(this, 3, "RealizationSetAuto.getRealizationSet(): Target host emulation does not yet exist.");
            } else if (!HostAnalyzer.this.downloadDetectorsDone) {
                HostAnalyzer.this.log.println(this, 3, "RealizationSetAuto.getRealizationSet(): RealizationDetectors have not been downloaded.");
            } else {
                this.currentHost = host;
                if (this.currentHost != null) {
                    this.properties = this.properties.getHostSpecificProperties(this.currentHost);
                    this.associates = host.getAssociates();
                    this.hostCount = this.hostsRemaining = this.currentHost.getAssociateCount() + 1;
                    HostAnalyzer.this.percentInterval = 100 / this.hostCount;
                } else {
                    this.associates = new Vector().elements();
                    HostAnalyzer.this.percentInterval = 100;
                }
                if (this.debug) {
                    System.out.println("Host Count which includes primary and associate Hosts is : " + this.hostCount);
                }
                boolean bl2 = true;
                do {
                    Object object;
                    Object object2;
                    if (!bl2) {
                        this.currentHost = (ReadOnlyHost)this.associates.nextElement();
                        this.properties = this.properties.getHostSpecificProperties(this.currentHost);
                        if (this.debug) {
                            System.out.println("Processing an AssociatedHost ....");
                            System.out.println("Current Host: " + this.currentHost.getHostName());
                            System.out.println("Current Host Type is " + this.currentHost.getType());
                            object2 = this.currentHost.getHardwareComponents();
                            while (object2.hasMoreElements()) {
                                System.out.println("\n---------------------------------------------------");
                                object = (HardwareComponent)object2.nextElement();
                                System.out.println("... HardwareComponent Product " + ((HardwareComponent)object).getProduct());
                                System.out.println("... HardwareComponent Revision " + ((HardwareComponent)object).getRevision());
                                System.out.println("---------------");
                                System.out.println("Has exact hardware component ? : " + this.currentHost.hasExactHardwareComponent(((HardwareComponent)object).getProduct(), ((HardwareComponent)object).getRevision()));
                                System.out.println("---------------------------------------------------");
                            }
                        }
                    }
                    if (this.debug && bl2) {
                        System.out.println("Current host: " + this.currentHost.getHostName());
                    }
                    if ((object2 = this.getDetectorCacheFile()) == null) {
                        this.dispatchErrorEvent(new DownloadDetectorsEvent(this));
                        return;
                    }
                    if (this.debug) {
                        System.out.println("Detector source name is : " + object2);
                    }
                    object = classLoader != null ? new DetectorClassLoader((File)object2, classLoader) : new DetectorClassLoader((File)object2);
                    try {
                        bufferedReader = new BufferedReader(new InputStreamReader(((ClassLoader)object).getResourceAsStream(HostAnalyzer.DETECTORLIST)));
                    }
                    catch (Exception exception) {
                        HostAnalyzer.this.log.println(this, 4, exception.getMessage());
                    }
                    try {
                        String string;
                        String string2 = bufferedReader.readLine().trim();
                        HostAnalyzer.this.totalDetectorCount = new Integer(string2);
                        HostAnalyzer.this.finishedDetectorCount = 0;
                        if (this.debug) {
                            System.out.println("TotalDetectorCount : " + HostAnalyzer.this.totalDetectorCount);
                        }
                        while ((string = bufferedReader.readLine()) != null) {
                            try {
                                realizationDetector = (RealizationDetector)((ClassLoader)object).loadClass(string).newInstance();
                                if (this.debug) {
                                    System.out.println(" ... CurrentDetectorName is " + string);
                                }
                                HostAnalyzer.this.loadRealizations(realizationDetector.getRealizations(), (Host)this.currentHost);
                                realizationDetector.analyze((RestrictedHost)((Object)this.currentHost));
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                HostAnalyzer.this.log.println(this, 4, "HostAnalyzer.runRealizationDetectors(): Unable to locate class " + string + ".");
                                HostAnalyzer.this.log.printStackTrace(this, 2, classNotFoundException);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                HostAnalyzer.this.log.println(this, 4, "HostAnalyzer.runRealizationDetectors(): Forbidden to access class " + string + ".");
                                HostAnalyzer.this.log.printStackTrace(this, 2, illegalAccessException);
                            }
                            catch (InstantiationException instantiationException) {
                                HostAnalyzer.this.log.println(this, 4, "HostAnalyzer.runRealizationDetectors(): Unable to instantiate class " + string + ".");
                                HostAnalyzer.this.log.printStackTrace(this, 2, instantiationException);
                            }
                            catch (DetectorFailedException detectorFailedException) {
                                HostAnalyzer.this.log.println(this, 4, "HostAnalyzer.runRealizationDetectors(): " + string + " failed.");
                                HostAnalyzer.this.log.printStackTrace(this, 2, detectorFailedException);
                            }
                            catch (Exception exception) {
                                HostAnalyzer.this.log.println(this, 4, exception.getMessage());
                            }
                            this.incrementProgress();
                        }
                    }
                    catch (IOException iOException) {
                        HostAnalyzer.this.log.println(this, 0, "HostAnalyzer.runRealizationDetectors(): IOException thrown with message : " + iOException.getMessage());
                        HostAnalyzer.this.log.printStackTrace(this, 2, iOException);
                    }
                    catch (Exception exception) {
                        HostAnalyzer.this.log.println(this, 4, exception.getMessage());
                    }
                    if (bl2) {
                        bl2 = false;
                    }
                    --this.hostsRemaining;
                } while (this.associates.hasMoreElements());
                for (int i = 0; i < this.realizationSetListeners.size(); ++i) {
                    this.realizationSetListener = (RealizationSetListener)this.realizationSetListeners.get(i);
                    this.realizationSetListener.realizationSetProgress(new RealizationSetEvent(this, HostAnalyzer.this.catalog.getMessage("progress.message.analyzing", "Analyzing system")));
                    this.realizationSetListener.realizationSetDone(new RealizationSetEvent(this));
                }
            }
        }

        private void downloadDetectors() throws PatchProException {
            String string = this.properties.getProperty("patchpro.detectors.download.method");
            String string2 = this.properties.getProperty("patchpro.detectors.name");
            HostAnalyzer.this.printTaggedMessage("STATUS DOWNLOAD_DETECTORS BEGIN");
            if (string.equalsIgnoreCase("post")) {
                this.downloadDetectorsWithPOST(string2);
            } else {
                this.downloadDetectorsWithGET(string2);
            }
            HostAnalyzer.this.printTaggedMessage("STATUS DOWNLOAD_DETECTORS END DOWNLOAD_DETECTORS.0 \"" + HostAnalyzer.this.catalog.getMessage("tagstatusmsg.DOWNLOAD_DETECTORS_CODE_SUCCESS", "Download of {0} was successful.") + "\" \"" + string2 + "\"");
        }

        private void downloadDetectorsWithPOST(String string) throws PatchProException {
            PatchServerProxy patchServerProxy = null;
            try {
                patchServerProxy = new PatchServerProxy(this.properties);
            }
            catch (PatchServerProxyException patchServerProxyException) {
                HostAnalyzer.this.log.printStackTrace(this, 3, patchServerProxyException);
                String string2 = "";
                StringTokenizer stringTokenizer = new StringTokenizer(patchServerProxyException.getMessage(), ":");
                int n = stringTokenizer.countTokens();
                for (int i = 0; i < n; ++i) {
                    string2 = stringTokenizer.nextToken();
                }
                throw new PatchProException(string2);
            }
            try {
                patchServerProxy.downloadRealizationDetectors(string);
            }
            catch (NotSupportedException notSupportedException) {
                notSupportedException.printStackTrace();
            }
            this.downloadProgress(null);
            this.downloadDone(null);
        }

        private void downloadDetectorsWithGET(String string) throws PatchProException {
            try {
                File file = this.getDetectorCacheFile();
                URL uRL = this.getDetectorSourceURL();
                HostAnalyzer.this.log.println(this, 7, "RealizationSetAuto.prepare(): new CachingDownloader(" + uRL + ")");
                int n = Integer.parseInt(this.properties.getProperty("patchpro.cache.old.age.days.detectors"));
                int n2 = Integer.parseInt(this.properties.getProperty("patchpro.cache.dead.age.days.detectors"));
                HostAnalyzer.this.detectorDownloader = new CachingDownloader(string, uRL, file, CachingDownloader.days(n), CachingDownloader.days(n2), false);
                this.downloadDetectorDone = false;
                HostAnalyzer.this.detectorDownloader.addListener(this);
                InnerDownloadDetectorsThread innerDownloadDetectorsThread = new InnerDownloadDetectorsThread(HostAnalyzer.this.detectorDownloader, file.getPath());
                innerDownloadDetectorsThread.start();
                while (!this.downloadDetectorDone) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                HostAnalyzer.this.detectorDownloader.close();
            }
            catch (IOException iOException) {
                throw new PatchProException(HostAnalyzer.this.catalog.getMessage("wrong_detector_source_url", ""), iOException);
            }
        }

        public File getDetectorCacheFile() throws PatchProException {
            String string = this.properties.getProperty("patchpro.detectors.download.method");
            if (string.equalsIgnoreCase("post")) {
                String string2 = this.properties.getProperty("patchpro.detectors.name");
                PatchServerProxy patchServerProxy = new PatchServerProxy(this.properties);
                return patchServerProxy.getDetectorCacheFile(string2);
            }
            return new File(this.properties.getProperty("patchpro.cache.directory"), URLEncoder.encode(this.getDetectorSourceURL().toString()));
        }

        private URL getDetectorSourceURL() throws PatchProException {
            String string = this.properties.getProperty("patchpro.detectors.name");
            try {
                return new URL(this.properties.getProperty("patchpro.detectors.url.head") + string + this.properties.getProperty("patchpro.detectors.url.tail"));
            }
            catch (MalformedURLException malformedURLException) {
                throw new PatchProException(malformedURLException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(DownloadDetectorsListener downloadDetectorsListener) {
            Vector vector = this.downloadDetectorsListeners;
            synchronized (vector) {
                this.downloadDetectorsListeners.addElement(downloadDetectorsListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(DownloadDetectorsListener downloadDetectorsListener) {
            Vector vector = this.downloadDetectorsListeners;
            synchronized (vector) {
                this.downloadDetectorsListeners.removeElement(downloadDetectorsListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(RealizationSetListener realizationSetListener) {
            Vector vector = this.realizationSetListeners;
            synchronized (vector) {
                this.realizationSetListeners.addElement(realizationSetListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(RealizationSetListener realizationSetListener) {
            Vector vector = this.realizationSetListeners;
            synchronized (vector) {
                this.realizationSetListeners.removeElement(realizationSetListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void downloadProgress(DownloadEvent downloadEvent) {
            int n = downloadEvent == null ? 100 : ((Downloader)downloadEvent.getSource()).getProgress().getPercentage();
            Percentage percentage = this.downloadProgress;
            synchronized (percentage) {
                this.downloadProgress = new Percentage((int)(((double)(this.hostCount - this.hostsRemaining) * 100.0 + (double)n) / (double)this.hostCount));
            }
            this.dispatchProgressEvent(new DownloadDetectorsEvent(this, HostAnalyzer.this.catalog.getMessage("progress.message.analyzing", "Analyzing system")));
        }

        public synchronized void downloadDone(DownloadEvent downloadEvent) {
            this.downloadDetectorDone = true;
            if (--this.hostsRemaining == 0) {
                this.dispatchDoneEvent(new DownloadDetectorsEvent(this));
            }
        }

        public synchronized void downloadFailed(DownloadEvent downloadEvent) {
            this.dispatchErrorEvent(new DownloadDetectorsEvent(this));
        }

        private void dispatchProgressEvent(DownloadDetectorsEvent downloadDetectorsEvent) {
            Enumeration enumeration = this.downloadDetectorsListeners.elements();
            while (enumeration.hasMoreElements()) {
                DownloadDetectorsListener downloadDetectorsListener = (DownloadDetectorsListener)enumeration.nextElement();
                downloadDetectorsListener.downloadDetectorsProgress(downloadDetectorsEvent);
            }
        }

        public Percentage getDownloadProgress() {
            return this.downloadProgress;
        }

        private void dispatchDoneEvent(DownloadDetectorsEvent downloadDetectorsEvent) {
            Enumeration enumeration = this.downloadDetectorsListeners.elements();
            while (enumeration.hasMoreElements()) {
                DownloadDetectorsListener downloadDetectorsListener = (DownloadDetectorsListener)enumeration.nextElement();
                downloadDetectorsListener.downloadDetectorsDone(downloadDetectorsEvent);
            }
        }

        private void dispatchErrorEvent(DownloadDetectorsEvent downloadDetectorsEvent) {
            Enumeration enumeration = this.downloadDetectorsListeners.elements();
            while (enumeration.hasMoreElements()) {
                DownloadDetectorsListener downloadDetectorsListener = (DownloadDetectorsListener)enumeration.nextElement();
                downloadDetectorsListener.downloadDetectorsFailed(downloadDetectorsEvent);
            }
        }

        private void initializeProgress() {
            if (HostAnalyzer.this.totalDetectorCount < 100) {
                HostAnalyzer.this.countEachDetector = true;
            }
            HostAnalyzer.this.nextPercent = 0;
            HostAnalyzer.this.finishedDetectorCount = 0;
            HostAnalyzer.this.realizationProgress = 0;
        }

        private void incrementProgress() {
            HostAnalyzer.this.finishedDetectorCount++;
            HostAnalyzer.this.runDetectorsPercent = (int)((float)HostAnalyzer.this.finishedDetectorCount * (float)HostAnalyzer.this.percentInterval / (float)HostAnalyzer.this.totalDetectorCount);
            if (HostAnalyzer.this.runDetectorsPercent == HostAnalyzer.this.percentInterval) {
                HostAnalyzer.this.accuPercentInterval = HostAnalyzer.this.accuPercentInterval + HostAnalyzer.this.percentInterval;
                HostAnalyzer.this.realizationProgress = HostAnalyzer.this.accuPercentInterval;
            } else {
                HostAnalyzer.this.realizationProgress = HostAnalyzer.this.accuPercentInterval + HostAnalyzer.this.runDetectorsPercent;
            }
            if (this.hostsRemaining - 1 == 0 && HostAnalyzer.this.finishedDetectorCount == HostAnalyzer.this.totalDetectorCount) {
                HostAnalyzer.this.realizationProgress = 100;
            }
            if (this.debug) {
                System.out.println("RealizationSetAuto: Progress is " + HostAnalyzer.this.realizationProgress);
            }
            if (HostAnalyzer.this.realizationProgress > HostAnalyzer.this.nextPercent) {
                HostAnalyzer.this.nextPercent += 5;
                HostAnalyzer.this.realizationSetProgress(new RealizationSetEvent(this, HostAnalyzer.this.catalog.getMessage("progress.message.analyzing", "Analyzing system")));
            }
        }
    }

    private static interface RealizationSet {
        public void prepare(HostAnalyzer var1) throws PatchProException;

        public void getRealizationSet(Host var1) throws PatchProException;

        public File getDetectorCacheFile() throws PatchProException;

        public void addListener(DownloadDetectorsListener var1);

        public void removeListener(DownloadDetectorsListener var1);

        public void addListener(RealizationSetListener var1);

        public void removeListener(RealizationSetListener var1);

        public Percentage getDownloadProgress();
    }

    private class InnerDownloadDetectorsThread
    extends Thread {
        private CachingDownloader downloader;
        private String cacheName;

        public InnerDownloadDetectorsThread(CachingDownloader cachingDownloader, String string) {
            this.downloader = cachingDownloader;
            this.cacheName = string;
        }

        public void run() {
            try {
                HostAnalyzer.this.detectorDownloader.getValidCache();
            }
            catch (IOException iOException) {
                HostAnalyzer.this.log.println(this, 3, "InnerDownloadDetectorsThread.run(): Unable to download to " + this.cacheName + ".");
            }
        }
    }
}

