#!/usr/bin/perl
# -----------------------------------------------------------------------------
# ident	"@(#)diskless_cmm.pl	1.22	06/01/23 SMI"
# -----------------------------------------------------------------------------
#
# Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
# -----------------------------------------------------------------------------

package DISKLESS_CMM;

use strict;
use variables;

#------------------------------------------------------------------------------
#
# Configure CMM 
#
#------------------------------------------------------------------------------
sub cmm_configure {

  my ($proto_node_id) = @_;
  
  my $proto_ip   = COMMON::get_external_ip($proto_node_id);
  
  my $node_name_template;
  my $node_root;
  
  my $local_nodename = "$WORKING_DIR/nodename" ;
  my $remote_nodename;
  
  for my $node (0..$#NODE_LIST) {
    
    if (($NODE_LIST[$node]{type} == $DISKLESS_NODE) 
	&& ($NODE_LIST[$node]{concerned})) {
      
      my $node_id = $NODE_LIST[$node]{id};
      $node_name_template = COMMON::build_node_name($node_id, "") ;
      
      COMMON::print_subaction("configuring $node_name_template ...");
      
      $node_root = "/export/root/$node_name_template";
      $remote_nodename = "$node_root/etc/nodename";
      
      
      #
      # create nodename file
      #
      open(NODENAME, ">$local_nodename") ||
	COMMON::error("Unable to create $local_nodename");
      my $node_name_value = COMMON::build_node_name($node_id,
	$USE_CGTP ? "CGTP" : "NIC0");
      print NODENAME "${node_name_value}\n";
      close(NODENAME);
      
      #
      # remote copy nodename
      #
      COMMON::put_file($proto_ip, "$local_nodename", "$remote_nodename");
    }
  }	
}				

#------------------------------------------------------------------------------
#
# installation  of CDT
#
#------------------------------------------------------------------------------

sub diskless_cdt {

  ($NODE_ID) = @_;

  COMMON::print_stage_node("Tools installation for diskless") ;
  COMPONENT::install_diskless_component($NODE_ID, "CDT", "");
}

#------------------------------------------------------------------------------
#
# recovery after failure
#
#------------------------------------------------------------------------------

sub recovery_diskless_cdt {

  ($NODE_ID) = @_;

  COMMON::print_recovery_node("Tools installation clean-up for diskless") ;
  COMPONENT::remove_diskless_component($NODE_ID, "CDT");
}

#------------------------------------------------------------------------------
#
# installation and configuration of CMM
#
#------------------------------------------------------------------------------

sub diskless_cmm {

  ($NODE_ID) = @_;

  COMMON::print_stage_node("Cluster Membership Monitor (CMM) installation for diskless") ;
  COMPONENT::install_diskless_component($NODE_ID, "CMM", "");
  
  COMMON::print_action("CMM configuration") ;
  cmm_configure($NODE_ID);

}

#------------------------------------------------------------------------------
#
# recovery after failure
#
#------------------------------------------------------------------------------

sub recovery_diskless_cmm {

  ($NODE_ID) = @_;

  COMMON::print_recovery_node("Cluster Membership Monitor (CMM) clean-up for diskless") ;
  COMPONENT::remove_diskless_component($NODE_ID, "CMM");
}

{
}
