#!/tools/ns/bin/perl5
#------------------------------------------------------------------------
# This script is triggered from the iPlanet Web Server plug-in to call 
# Resonate's Central Dispatch command line action tool. This event occurs
# when the thread pool in the Web Server reaches a specific threshold
# and Central Dispatch must be adjusted to meet the conditions.
#
# Note: This is a sample script which must be customized by the Resonate 
# system administrator. This script is made generic for your 
# implementation needs. Required changes are noted throughout the script.

#------------------------------------------------------------------------
# [1] On Windows NT, Resonate does not use a path statement; the location
#     is stored in the DOS environment variable RES_DISPATCH_COMMAND.
#     To use this, you must install a Perl library that contains Env.pm.
#     Or, you can hard code the file name, e.g.,
#        $resonate_cmd='C:\Program Files\Resonate\bin\CDAction.exe';
$resonate_cmd='CDAction';
# [2] Change the host variable to represent the Central Dispatch host
#     affect.
$host="myhost";
# [3] Change the node variable to represent the Central Dispatch node to
#     affect. This is characteristically a content server.
$node="mynode";
$command="set_weight";
$weight="100";
$args="$node:$weight";
#
# On NT quote arguments
# and use port
$port=2101;
$args="\"$args\"";
$cmdline="-p $port $host $command $args";
# Uncomment for diagnostic
# print "$cmdline \n";
exec $resonate_cmd $cmdline;print STDERR "Could not exec $resonate_cmd";
