/**
 * PROPRIETARY/CONFIDENTIAL. Use of this product is subject to
 * license terms. Copyright  2001 Sun Microsystems, Inc.
 * Some preexisting portions Copyright  2001 Netscape Communications Corp.
 * All rights reserved.
 */
/*
 * putil.h: Private proxy utility functions
 *
 * Intended for internal use only, not for public use.
 *
 *
 *
 *
 * Ari Luotonen
 * Copyright (c) 1995, 1996 Netscape Communcations Corporation
 *
 */

#ifndef PRIVATE_UTIL_H
#define PRIVATE_UTIL_H

#include "base/session.h"
#include "frame/req.h"


/*
 * Storage for a list of strings
 */
typedef struct _LineNode LineNode;
struct _LineNode {
    char     *line;
    int       len;
    LineNode *next;
};

/* usleep function */
void util_usleep( unsigned int  delay );

/*
 * A horrid hack to get cache-root working when using Chroot.
 *
 */
char *chroot_hack(char *name);


char **util_string_array_parse_header(char *hdr_block);
char **util_string_array_merge_hdrs(char **cache_hdrs,
				    LineNode *resp_hdrs,
				    char *regexp_exclude_1,
				    char *regexp_exclude_2,
				    int *total_length);
void util_string_array_replace_headers(char **cache_hdrs,
				       LineNode *resp_hdrs,
				       char *regexp_relevant_1,
				       char *regexp_relevant_2);

NSPR_BEGIN_EXTERN_C

/*
 * Power function for integers:
 *
 *	util_pow(x,y) == x^y
 *
 */
NSAPI_PUBLIC long util_pow(long x, int y);

/*
 * Simple logarithm function for integers:
 *
 * y = util_log(n,x)  <=>  n^y == x
 *
 */
NSAPI_PUBLIC int util_log(int n, int x);

NSPR_END_EXTERN_C

/*
 * Returns a newly allocated string which contains the
 * requested path prepended with http:// or https://
 * and the server_hostname and port (when non-default).
 *
 * If already a non-local path, returns a copy of the path.
 *
 */
char *make_into_complete_self_reference(char *path);


/*
 * Makes the URL completely (if local path), and adds
 * a trailing slash in a newly allocated string.
 *
 * If the trailing slash is already there it's an error,
 * and NULL will be returned.
 *
 */
char *make_self_ref_and_add_trail_slash(char *url);

void merge_srvhdrs( pblock *resp_304_hdrs);

void replace_srvhdrs( Request *rq, pblock *resp_304_hdrs, char *rep_default, char *cache_replace);


#endif

