/**
 * PROPRIETARY/CONFIDENTIAL. Use of this product is subject to
 * license terms. Copyright  2001 Sun Microsystems, Inc.
 * Some preexisting portions Copyright  2001 Netscape Communications Corp.
 * All rights reserved.
 */
/*
 * cutil.h: Cache utility functions
 *
 *
 *
 *
 *
 * Ari Luotonen
 * Copyright (c) 1995 Netscape Communcations Corporation
 */

#ifndef NS_CACHE_UTIL_H
#define NS_CACHE_UTIL_H

NSPR_BEGIN_EXTERN_C

/*
 * Array of chars that can appear in the cache file and directory names
 * (order is significant).
 *
 */
NSAPI_PUBLIC extern char cache_file_chars[];


/*
 * Make a binary buffer b[blen] into a printable buffer p[plen+1]
 * (the +1 is for terminating null, so plen stands for max string len).
 *
 *
 */
NSAPI_PUBLIC void util_make_printable(unsigned char *b, int blen, char *p, int plen);


/*
 * Concatenate a directory name and a filename into a newly-allocated
 * string.  Useful when there's a bunch of files which all go to the
 * same directory.
 *
 */
NSAPI_PUBLIC char *util_make_filename(char *root, char *name);


/*
 * Concatenate the lock suffix to the filename, into a newly-allocated
 * string.
 *
 */
NSAPI_PUBLIC char *util_make_lockname(char *fn);


/*
 * Return the section table index given the number of sections.
 *
 *
 */
#define cache_sect_idx2(digest, ndirs) \
    ((int)(((unsigned char)(digest[0])) & ((unsigned char)(ndirs - 1))))

/*
 * Return the section table index.
 *
 * Parameter is the MD5 of the URL, in unsigned char digest[16].
 *
 */
#define cache_sect_idx(digest) \
    cache_sect_idx2((digest), cache_ndirs)


/*
 * Return the directory name (a single character) under the cache
 * section (you get the cache section index from cache_sec_idx().
 *
 * Parameter is the MD5 of the URL, in unsigned char digest[16].
 *
 */
#define cache_dir_char(digest) \
    (cache_file_chars[(unsigned char)(digest[1] & 63)])


/*
 * Returns the cache file name for the URL whose MD5 signature
 * is passed as the digest parameter.
 *
 *
 */
NSAPI_PUBLIC char *cache_filename(unsigned char digest[16]);


/*
 * Turn a cache filename back into an MD5 digest
 * (only partial, only the first 48 bits will be set).
 *
 *
 */
NSAPI_PUBLIC void cache_fn_to_dig(char *name, unsigned char digest[16]);
int ParseHexDigit(char c);

NSAPI_PUBLIC void util_blks_to_disk(char *root, char *name, long blks);
NSAPI_PUBLIC long util_blks_from_disk(char *root, char *name, time_t *written);


/*
 * util_get_string_from_file()
 * util_get_long_from_file()
 * util_get_int_from_file()
 *	each get a single line from a file, and return it in the form
 *	described by their name.  This is a utility for storing single
 *	words or numbers in files.
 */
NSAPI_PUBLIC char * util_get_string_from_file(char *filename, char *buf, int maxsize);
NSAPI_PUBLIC long   util_get_long_from_file(char *filename);
NSAPI_PUBLIC int    util_get_int_from_file(char *filename);
NSAPI_PUBLIC char * util_get_string_from_aux_file(char *root, char *name,
						  char *buf, int maxsize);
NSAPI_PUBLIC long   util_get_long_from_aux_file(char *root, char *name);
NSAPI_PUBLIC int    util_get_int_from_aux_file(char *root, char *name);


/*
 * util_put_string_to_file()
 * util_put_long_to_file()
 * util_put_int_to_file()
 *	each write a single line to file, either a string or a number.
 *	This is a utility for storing single words or numbers in files
 *	for easy access and update.
 *
 */
NSAPI_PUBLIC int util_put_string_to_file(char *filename, char *str);
NSAPI_PUBLIC int util_put_long_to_file(char *filename, long l);
NSAPI_PUBLIC int util_put_int_to_file(char *filename, int i);
NSAPI_PUBLIC int util_put_string_to_aux_file(char *root, char *name, char *str);

/*
 * Make a section id given the section dim and index.
 *
 */
NSAPI_PUBLIC void util_sect_id(int dim, int idx, char *buf);

/* The following is internal. Do not use !! */
NSAPI_PUBLIC PRFileDesc *fopen_aux_file(char *root, char *name, char *type);

NSPR_END_EXTERN_C

#endif

