/**
 * PROPRIETARY/CONFIDENTIAL. Use of this product is subject to
 * license terms. Copyright  2001 Sun Microsystems, Inc.
 * Some preexisting portions Copyright  2001 Netscape Communications Corp.
 * All rights reserved.
 */
/*
 * cpart.h: Cache partition handling
 *
 *
 *
 *
 *
 * Ari Luotonen
 * Copyright (c) 1995 Netscape Communcations Corporation
 *
 */

#ifndef NS_CACHE_PARTITION_H
#define NS_CACHE_PARTITION_H

#define CACHE_MAX_PARTITIONS	 32


typedef struct _CPart {
    char *	root;
    int		dim;		/* current dimension */
    int		open;		/* used by gc */
    int		initialized;
    PRLock	*lock;
    int		still_used;
    int		dirty;
    int		fs_full;
    long	fs_blk_size;
    long	max_blks;
    long	min_avail;
    long	lo_water_mark;	/* don't go below this even if fs full */
    long	chng;
    long	cur_blks;	/* used by gc */
    long	cur_avail;
    long	must_remove;
    long	task_removing;
    int		rem_id;
} CPart;


/* Cache partitions */
extern int	part_max;
extern CPart	parts[CACHE_MAX_PARTITIONS];


NSAPI_PUBLIC int close_partition(int idx);
NSAPI_PUBLIC  int open_part(char* root, int i);

NSPR_BEGIN_EXTERN_C

NSAPI_PUBLIC int  dry_partition_init(pblock *pb);

NSAPI_PUBLIC void cache_shutdown(void);
void pre_cache_shutdown(void);
void pre_bu_terminate(void);
NSPR_END_EXTERN_C

void cache_reset(void);
void cache_chroot(void);



/*
 * Notify about cache partition becoming out-of-space.
 * To be called if write() returns errno ENOSPC.
 *
 */
void cpart_fs_full(CPart *partition);


/*
 * Automatically called by the server after the magnus.conf file has
 * been enterily processed (and so all the partitions have been opened).
 *
 */
int config_load_complete(void);


/*
 * Stuff all change info into a single multiplex notification packet.
 *
 *
 */
/* Commented this function as another function will be called from GC */
/* int multiplex_notify(void); */


#endif

