/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.util;

import com.sun.web.admin.util.SlashUtil;
import com.sun.web.admin.util.XmlNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class XmlConfig {
    private boolean isValidating = true;
    private String xmlFile;
    private File file;
    private long lastModTime = 0L;
    private XmlNode root = null;
    private EntityResolver resolver = null;

    public XmlConfig(String string) {
        this.xmlFile = SlashUtil.de_slashes(string.trim());
        this.file = new File(this.xmlFile);
        this.lastModTime = this.file.lastModified();
    }

    public XmlConfig(String string, String string2, String string3) {
        this(string);
        this.resolver = new WEntityResolver(string2, string3);
    }

    public XmlConfig(String string, HashMap hashMap) {
        this(string);
        this.resolver = new WEntityResolver(hashMap);
    }

    public void setValidation(boolean bl) {
        this.isValidating = bl;
    }

    public XmlNode parseConfig() throws Exception {
        return this.parseConfig(null);
    }

    public XmlNode parseConfig(ErrorHandler errorHandler) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("file:");
        int n = this.xmlFile.indexOf(58);
        int n2 = this.xmlFile.indexOf(47);
        if (n != -1 && n < n2) {
            stringBuffer.append('/');
        }
        stringBuffer.append(this.xmlFile);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(false);
        sAXParserFactory.setValidating(this.isValidating);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        Parser parser = sAXParser.getParser();
        if (this.resolver != null) {
            parser.setEntityResolver(this.resolver);
        }
        this.root = new XmlNode();
        ConfigHandler configHandler = new ConfigHandler(this.xmlFile, this.root);
        parser.setDocumentHandler(configHandler);
        if (errorHandler != null) {
            parser.setErrorHandler(errorHandler);
        }
        parser.parse(stringBuffer.toString());
        return this.root;
    }

    public String getXmlFile() {
        return this.xmlFile;
    }

    public boolean fileExists() {
        return this.file.exists();
    }

    public long getLastModified() {
        return this.lastModTime;
    }

    public boolean isModified() {
        return this.file.lastModified() > this.lastModTime;
    }

    public void saveConfig(PrintWriter printWriter) throws IOException {
        XmlNode xmlNode;
        if (this.root != null && (xmlNode = this.root.getFirstChild()) != null) {
            xmlNode.save(printWriter);
        }
    }

    public XmlNode getConfig() {
        return this.root;
    }

    public XmlNode findConfig(String string) {
        XmlNode xmlNode = this.getConfig();
        return xmlNode == null ? null : xmlNode.findConfig(string);
    }

    public String getString(String string, String string2) {
        XmlNode xmlNode = this.findConfig(string);
        return xmlNode == null ? string2 : xmlNode.getString();
    }

    public int getInt(String string, int n) {
        XmlNode xmlNode = this.findConfig(string);
        return xmlNode == null ? n : xmlNode.getInt();
    }

    public int getInterval(String string, int n) {
        XmlNode xmlNode = this.findConfig(string);
        return xmlNode == null ? n : xmlNode.getInterval(string, n);
    }

    public boolean getBoolean(String string, boolean bl) {
        XmlNode xmlNode = this.findConfig(string);
        return xmlNode == null ? bl : xmlNode.getBoolean(string, bl);
    }

    class WEntityResolver
    implements EntityResolver {
        HashMap dtdMap;

        public WEntityResolver(HashMap hashMap) {
            this.dtdMap = hashMap;
        }

        public WEntityResolver(String string, String string2) {
            this.dtdMap = new HashMap(1);
            this.dtdMap.put(string, string2);
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            if (string != null) {
                String string3 = (String)this.dtdMap.get(string);
                if (string3 != null) {
                    InputStream inputStream = this.getClass().getResourceAsStream(string3);
                    InputSource inputSource = new InputSource(inputStream);
                    return inputSource;
                }
                return null;
            }
            return null;
        }
    }

    static class ConfigHandler
    extends HandlerBase {
        String xmlFile;
        ArrayList elements = new ArrayList();
        XmlNode node;
        Locator locator;
        boolean beginText;

        ConfigHandler(String string, XmlNode xmlNode) {
            this.xmlFile = string;
            this.node = xmlNode;
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startElement(String string, AttributeList attributeList) throws SAXException {
            XmlNode xmlNode;
            if (this.beginText) {
                throw this.error("Cannot have elements in text block");
            }
            this.node = xmlNode = this.node.addChild(string, null, this.locator.getSystemId(), this.locator.getLineNumber());
            for (int i = 0; i < attributeList.getLength(); ++i) {
                String string2 = attributeList.getName(i);
                String string3 = attributeList.getValue(i);
                XmlNode xmlNode2 = xmlNode.addChild(string2, string3, this.locator.getSystemId(), this.locator.getLineNumber(), true);
            }
            this.beginText = false;
        }

        private boolean isWhitespace(char c) {
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    return true;
                }
            }
            return false;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            int n3;
            while (n2 > 0 && ((n3 = cArray[n]) == 32 || n3 == 9 || n3 == 10 || n3 == 13)) {
                ++n;
                --n2;
            }
            n3 = 32;
            while (n2 > 0 && ((n3 = cArray[n + n2 - 1]) == 32 || n3 == 9 || n3 == 10 || n3 == 13)) {
                --n2;
            }
            if (n2 <= 0) {
                return;
            }
            if (this.node.getFirstChild() != null) {
                throw this.error("Cannot have elements in text block");
            }
            this.node.value = this.node.value == null ? new String(cArray, n, n2) : this.node.value + new String(cArray, n, n2);
            this.beginText = true;
        }

        SAXException error(String string) {
            return new SAXException(this.locator.getSystemId() + ":" + this.locator.getLineNumber() + ": " + string);
        }

        public void endElement(String string) {
            if (this.node != null) {
                this.node = this.node.parentNode;
            }
            this.beginText = false;
        }
    }
}

