/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.cmds;

import com.sun.web.admin.beans.AdminConfig;
import com.sun.web.admin.beans.MagObj;
import com.sun.web.admin.util.MiscUtil;
import com.sun.web.admin.util.XmlNode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;

public class CmdUtil {
    private static String SERVER_ROOT = "com.sun.web.instanceRoot";
    private static String SERVER_XML_FILE = "server.xml";
    private static String CONFIG_DIR = "config";
    private static String WEBXML_DTD_ID = "-//Sun Microsystems Inc.//DTD Sun ONE Web Server 6.1//EN";
    private static String WEBXML_DTD_RESOURCE = "sun-web-server_6_1.dtd";
    private static final String WEBXML_DTD_DOCLINE = "<!DOCTYPE SERVER PUBLIC \"-//Sun Microsystems Inc.//DTD Sun ONE Web Server 6.1//EN\" \"file://";
    private static final String WEBXML_DTD_DOCLINE2 = "/bin/https/dtds/sun-web-server_6_1.dtd\">";
    private static String instUser;
    private static boolean changeOwner;

    public static void usage() {
        System.out.println("Wrong usage. use -h to see proper usage");
    }

    public static void Usage() {
        System.out.println("Usage: HttpServerAdmin is deprecated.");
        System.out.println("HttpServerAdmin commandname commandoptions -sinst <http instance> -d <serverroot>");
        System.out.println("");
        System.out.println("where commandname can be any one of these:");
        System.out.println("    list create delete control");
        System.out.println("where the command options are as follows");
        System.out.println("    list -l                          list all listen sockets");
        System.out.println("    list -c                          list all classes");
        System.out.println("    list -v                          list all virtual servers");
        System.out.println("    list -r                          list all jndi/jdbc resources");
        System.out.println("    list -r -jdbcconnectionpool      list all jdbc connection pools");
        System.out.println("    list -r -jdbc                    list all jdbc resources");
        System.out.println("    list -r -custom                  list all custom resources");
        System.out.println("    list -r -external                list all external jndi resources");
        System.out.println("    list -r -mail                    list all mail resources");
        System.out.println("");
        System.out.println("    create -l -id <id> -ip <ip> -port <port> -sname serverName -defaultvs <defaultvs> [-sec security (false/true)] [-acct <#accthreads>]");
        System.out.println("    create -c -cl <classname> -docroot <docroot> [-obj <objconf>] [acptlang <acptlang>]");
        System.out.println("    create -v -id <id> -cl <classname> -urlh <urlhosts> -lsid | -conngroupid <listensocketID> [-state <state>] [-docroot <docroot>] [-mime <mime>] [-aclid <aclid> | -aclfile <aclfilepath>]");
        System.out.println("");
        System.out.println("    create -r -jdbc -jndiname <jndiname> -poolname <poolname> [-desc <description>] [-enabled <true|false>]");
        System.out.println("");
        System.out.print("    create -r -jdbcconnectionpool -poolname <poolname> -classname <classname> [-steadypoolsize <steadypoolsize>] [-maxpoolsize <maxpoolsize>]");
        System.out.print(" [-poolresizequantity <poolresizequantity>] [-idletimeout <idletimeout>] [-maxwaittime <maxwaittime>] [-connectionvalidation <true|false>]");
        System.out.print(" [-connectionvalidationmethod  <connectionvalidationmethod>] [-validationtablename <validationtablename>] [-failall <true|false>] [-desc description]");
        System.out.println(" [-property propertyname1=value1[,propertyname2=value2,..]]");
        System.out.println("");
        System.out.print("    create -r -custom -jndiname <jndiname> -resourcetype <resourcetype> -factoryclass <factoryclassname> [-desc <description>] [-enabled <true|false>]");
        System.out.println(" [-property propertyname1=value1[,propertyname2=value2,..]]");
        System.out.println("");
        System.out.print("    create -r -external -jndiname <jndiname> -jndilookupname <jndilookupname> -restype <restype> -factoryclass <factoryclass> [-desc <description>] [-enabled <true|false>]");
        System.out.println(" [-property propertyname1=value1[,propertyname2=value2,..]]");
        System.out.println("");
        System.out.print("    create -r -mail -jndiname <jndiname> -host <host> -user <user> -from <from> [-storeprotocol <storeprotocol>] [-storeprotocolclass <storeprotocolclass>]");
        System.out.print(" [-transportprotocol <transportprotocol>] [-transportprotocolclass <transportprotocolclass>] [-enabled <true|false>] [-desc <description>]");
        System.out.println(" [-property propertyname1=value1[,propertyname2=value2,..]]");
        System.out.println("");
        System.out.println("    delete -l -id <id>");
        System.out.println("    delete -c -cl <classname>");
        System.out.println("    delete -v -id <id> -cl <classname>");
        System.out.println("    delete -r -jdbc -jndiname <jndiname>");
        System.out.println("    delete -r -jdbcconnectionpool -poolname <poolname>");
        System.out.println("    delete -r -custom -jndiname <jndiname>");
        System.out.println("    delete -r -external -jndiname <jndiname>");
        System.out.println("    delete -r -mail -jndiname <jndiname>");
        System.out.println("");
        System.out.println("    control -cl <classname> -start [-id <id>]");
        System.out.println("    control -cl <classname> -stop [-id <id>]");
        System.out.println("    control -cl <classname> -disable [-id <id>]");
    }

    public static final void writeToXmlFile(String string, XmlNode xmlNode, String string2) {
        try {
            boolean bl = MiscUtil.isDir(string);
            if (xmlNode == null || !bl) {
                throw new Exception(" Invalid instance-root : " + string);
            }
            AdminConfig.writeXmlToFile(xmlNode, string, string2);
        }
        catch (Exception exception) {
            exception.fillInStackTrace();
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private static void checkUser(String string, String string2) {
        if (!CmdUtil.isWindows()) {
            try {
                MagObj magObj = new MagObj();
                magObj.init(string, string2);
                instUser = magObj.get_mag_var("User");
                String string3 = System.getProperty("user.name");
                if (!string3.equals(instUser)) {
                    if (!string3.equals("root")) {
                        System.out.println("\nWarning: You should be running either as super-user or as the same user that the server instance runs as.");
                        System.out.println("You are running as " + string3 + " and the instance is running as " + instUser + ".");
                    } else {
                        changeOwner = true;
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("Exception when checking the server user in magnus.conf file " + exception.getMessage());
            }
        }
    }

    public static final void createObjectFile(String string, String string2, String string3, String string4) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string4)));
        String string5 = "<Object name=default>\nAuthTrans fn=\"match-browser\" browser=\"*MSIE*\" ssl-unclean-shutdown=\"true\"\nNameTrans fn=\"ntrans-j2ee\" name=\"j2ee\"\nNameTrans fn=pfx2dir from=/mc-icons dir=\"" + string + "//ns-icons\"" + " name=\"es-internal\"";
        int n = string5.length();
        printWriter.write(string5);
        printWriter.flush();
        printWriter.close();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string3));
        PrintWriter printWriter2 = new PrintWriter(new FileOutputStream(string4));
        boolean bl3 = false;
        String string6 = bufferedReader.readLine();
        while (string6 != null) {
            if (!string6.startsWith("#") && !bl3) {
                printWriter2.println(string5);
                bl3 = true;
            }
            printWriter2.println(string6);
            string6 = bufferedReader.readLine();
        }
        printWriter2.close();
        bufferedReader.close();
        CmdUtil.checkUser(string, string2);
        if (changeOwner) {
            MiscUtil.changeOwner(instUser, string4);
        }
    }

    public static String getDefaultLS(XmlNode xmlNode) {
        String string = "";
        String string2 = "";
        Iterator iterator = xmlNode.iterate();
        while (iterator.hasNext()) {
            XmlNode xmlNode2 = (XmlNode)iterator.next();
            if (!xmlNode2.getName().equals("LS") || (string = xmlNode2.getString("defaultvs", "")).equals("")) continue;
            string2 = xmlNode2.getString("id", "");
            break;
        }
        return string2;
    }

    public static String getDefaultAcl(XmlNode xmlNode) {
        String string = "";
        Iterator iterator = xmlNode.iterate();
        while (iterator.hasNext()) {
            XmlNode xmlNode2 = (XmlNode)iterator.next();
            if (!xmlNode2.getName().equals("ACLFILE")) continue;
            string = xmlNode2.getString("id", "");
            break;
        }
        return string;
    }

    public static String getDefaultMime(XmlNode xmlNode) {
        String string = "";
        Iterator iterator = xmlNode.iterate();
        while (iterator.hasNext()) {
            XmlNode xmlNode2 = (XmlNode)iterator.next();
            if (!xmlNode2.getName().equals("MIME")) continue;
            string = xmlNode2.getString("id", "");
            break;
        }
        return string;
    }

    public static String getDocroot(String string, String string2, String string3) throws IOException {
        String string4 = null;
        boolean bl = false;
        String string5 = "$id/docs";
        string4 = string2.equals("defaultclass") ? string + "/" + string3 + "/" + "conf_bk/" + "obj.conf" : string + "/" + string3 + "/" + "conf_bk/" + string2 + ".obj.conf";
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string4));
        String string6 = bufferedReader.readLine();
        while (string6 != null) {
            int n = string6.length();
            int n2 = string6.indexOf("document-root");
            if (n2 == -1) {
                string6 = bufferedReader.readLine();
                continue;
            }
            String string7 = string6.substring(n2 += 13, n);
            int n3 = string7.length();
            n2 = string7.indexOf("root=");
            if (n2 == -1) break;
            string5 = string7.substring(n2 += 5, n3);
            n3 = string5.length();
            n2 = string5.indexOf("\"");
            if (n2 == -1) break;
            string5 = string5.substring(++n2, n3 - 1);
            break;
        }
        return string5;
    }

    private static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    static {
        changeOwner = false;
    }
}

