/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.beans;

import com.sun.web.admin.beans.IWSStatsBean;
import com.sun.web.admin.util.XmlNode;
import java.io.PrintWriter;
import java.util.Iterator;

public class RequestStatsBean {
    private IWSStatsBean statsBean;
    private XmlNode parentNode = null;
    private String[] pidlist = null;
    private String[] categoryNameList = new String[]{"count2xx", "count3xx", "count4xx", "count5xx", "countOther", "count200", "count302", "count304", "count400", "count401", "count403", "count404"};
    private String[] categoryPresentableNameList = new String[]{"Number Of 2xx Requests", "Number Of 3xx Requests", "Number Of 4xx Requests", "Number Of 5xx Requests", "Number Of Other Requests", "Number Of 200 Requests", "Number Of 302 Requests", "Number Of 304 Requests", "Number Of 400 Requests", "Number Of 401 Requests", "Number Of 403 Requests", "Number Of 404 Requests"};
    private int[] categoryValueList = null;
    private String[] categoryPercentageList = null;
    private int totalRequests = 0;
    private long bytesReceived = 0L;
    private long bytesSent = 0L;
    private int noofPids = 0;
    private PrintWriter out = null;

    public void cleanUp() {
        this.statsBean.cleanUp();
    }

    public final void returnError(String string, String string2, PrintWriter printWriter) {
        this.out = printWriter;
        this.returnError(string, string2);
    }

    public final void returnError(String string, String string2) {
        this.out.println("<script language=\"JavaScript\">");
        this.out.println("alert('" + string + "');");
        this.out.println(" window.location='" + string2 + "'");
        this.out.println("</script>");
    }

    public int init(String string, String string2, String string3, String string4, PrintWriter printWriter) throws Exception {
        int n;
        this.out = printWriter;
        this.statsBean = new IWSStatsBean();
        this.parentNode = this.statsBean.getStatsXmlNode(string, string2, string4);
        if (this.parentNode == null) {
            return -1;
        }
        Iterator iterator = this.parentNode.iterate("server");
        XmlNode xmlNode = null;
        if (!iterator.hasNext()) {
            return -1;
        }
        xmlNode = (XmlNode)iterator.next();
        int n2 = 0;
        iterator = xmlNode.iterate("process");
        while (iterator.hasNext()) {
            XmlNode xmlNode2 = (XmlNode)iterator.next();
            ++n2;
        }
        this.noofPids = n2;
        this.pidlist = new String[n2 + 1];
        this.totalRequests = 0;
        this.bytesReceived = 0L;
        this.bytesSent = 0L;
        this.categoryValueList = new int[this.categoryNameList.length];
        this.categoryPercentageList = new String[this.categoryNameList.length];
        for (n = 0; n < this.categoryNameList.length; ++n) {
            this.categoryValueList[n] = 0;
            this.categoryPercentageList[n] = "0%";
        }
        iterator = xmlNode.iterate("process");
        n = 0;
        if (string3.equals("All")) {
            while (iterator.hasNext()) {
                XmlNode xmlNode3 = (XmlNode)iterator.next();
                this.pidlist[n] = xmlNode3.getString("pid", "null");
                Iterator iterator2 = xmlNode3.iterate("thread");
                while (iterator2.hasNext()) {
                    XmlNode xmlNode4 = (XmlNode)iterator2.next();
                    Iterator iterator3 = xmlNode4.iterate("request-bucket");
                    if (!iterator3.hasNext()) continue;
                    XmlNode xmlNode5 = (XmlNode)iterator3.next();
                    this.totalRequests += Integer.parseInt(xmlNode5.getString("countRequests", "null"));
                    this.bytesReceived += Long.parseLong(xmlNode5.getString("countBytesReceived", "null"));
                    this.bytesSent += Long.parseLong(xmlNode5.getString("countBytesTransmitted", "null"));
                    for (int i = 0; i < this.categoryNameList.length; ++i) {
                        int n3 = i;
                        this.categoryValueList[n3] = this.categoryValueList[n3] + Integer.parseInt(xmlNode5.getString(this.categoryNameList[i], "null"));
                    }
                }
                ++n;
            }
            for (int i = 0; i < this.categoryPercentageList.length; ++i) {
                int n4 = this.categoryValueList[i];
                int n5 = 0;
                if (this.totalRequests != 0) {
                    n5 = n4 * 100 / this.totalRequests;
                }
                this.categoryPercentageList[i] = n5 + "%";
            }
        } else {
            while (iterator.hasNext()) {
                XmlNode xmlNode6 = (XmlNode)iterator.next();
                this.pidlist[n] = xmlNode6.getString("pid", "null");
                if (string3.equals(this.pidlist[n])) {
                    Iterator iterator4 = xmlNode6.iterate("thread");
                    while (iterator4.hasNext()) {
                        int n6;
                        XmlNode xmlNode7 = (XmlNode)iterator4.next();
                        Iterator iterator5 = xmlNode7.iterate("request-bucket");
                        if (!iterator5.hasNext()) continue;
                        XmlNode xmlNode8 = (XmlNode)iterator5.next();
                        int n7 = 0;
                        this.totalRequests = Integer.parseInt(xmlNode8.getString("countRequests", "null"));
                        this.bytesReceived = Long.parseLong(xmlNode8.getString("countBytesReceived", "null"));
                        this.bytesSent = Long.parseLong(xmlNode8.getString("countBytesTransmitted", "null"));
                        for (n6 = 0; n6 < this.categoryNameList.length; ++n6) {
                            this.categoryValueList[n6] = Integer.parseInt(xmlNode8.getString(this.categoryNameList[n6], "null"));
                            n7 += this.categoryValueList[n6];
                        }
                        for (n6 = 0; n6 < this.categoryPercentageList.length; ++n6) {
                            int n8 = this.categoryValueList[n6];
                            int n9 = 0;
                            if (n7 != 0) {
                                n9 = n8 * 100 / this.totalRequests;
                            }
                            this.categoryPercentageList[n6] = n9 + "%";
                        }
                    }
                }
                ++n;
            }
        }
        this.pidlist[n] = "All";
        this.statsBean.cleanUp();
        System.gc();
        return 0;
    }

    public String[] getAllPids() {
        return this.pidlist;
    }

    public int getTotalRequests() {
        return this.totalRequests;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public int getNumberOfPids() {
        return this.noofPids;
    }

    public String[] getCategoryNameList() {
        return this.categoryPresentableNameList;
    }

    public String[] getCategoryPercentageList() {
        return this.categoryPercentageList;
    }

    public int[] getCategoryValueList() {
        return this.categoryValueList;
    }
}

