/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.beans;

import com.sun.web.admin.util.MiscUtil;
import java.util.HashMap;
import java.util.Vector;

class Ciphers {
    private Vector ciphersVector = null;
    private HashMap ciphersMap = null;

    public Ciphers(String string) {
        String[] stringArray = MiscUtil.tokenizeArr(string);
        this.ciphersVector = new Vector(stringArray.length);
        this.ciphersMap = new HashMap(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            Boolean bl = Boolean.TRUE;
            if (string2.charAt(0) == '+') {
                string2 = string2.substring(1);
            } else if (string2.charAt(0) == '-') {
                string2 = string2.substring(1);
                bl = Boolean.FALSE;
            }
            this.ciphersVector.add(string2);
            this.ciphersMap.put(string2, bl);
        }
    }

    public boolean isCipherKnown(String string) {
        return this.ciphersMap.containsKey(string);
    }

    public boolean isCipherEnabled(String string) {
        Boolean bl = (Boolean)this.ciphersMap.get(string);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public boolean isCipherDisabled(String string) {
        Boolean bl = (Boolean)this.ciphersMap.get(string);
        if (bl == null) {
            return false;
        }
        return bl == false;
    }

    public void enableCipher(String string) {
        if (!this.isCipherKnown(string)) {
            this.ciphersVector.add(string);
        }
        this.ciphersMap.put(string, Boolean.TRUE);
    }

    public void disableCipher(String string) {
        if (!this.isCipherKnown(string)) {
            this.ciphersVector.add(string);
        }
        this.ciphersMap.put(string, Boolean.FALSE);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.ciphersVector.size(); ++i) {
            String string;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.isCipherEnabled(string = (String)this.ciphersVector.elementAt(i)) ? (char)'+' : '-');
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

