/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.beans;

import com.sun.web.admin.beans.AdminConfig;
import com.sun.web.admin.beans.MagObj;
import com.sun.web.admin.beans.XmlNodeWrapper;
import com.sun.web.admin.util.CacheUtil;
import com.sun.web.admin.util.SlashUtil;
import com.sun.web.admin.util.XmlNode;
import java.io.File;
import java.io.PrintWriter;
import java.util.Iterator;

public class CacheBean {
    private XmlNodeWrapper wrapperXmlNode_ = null;
    private String serverRoot_ = null;
    private String instanceName_ = null;
    private XmlNode cacheNode = null;
    private XmlNode[] partitionNodes = null;
    private String serverXml_ = null;
    private XmlNode serverNode = null;
    private String referer = null;
    private String magUser = null;
    private PrintWriter out = null;
    private static final String INVALID_CACHE_WORKING_DIR = "Invalid Cache working directory. Cache working directory must be specified by a correct absolute path.";
    private MagObj magObject = null;

    public void init(String string, String string2, String string3, PrintWriter printWriter) throws Exception {
        this.referer = string3;
        this.out = printWriter;
        this.init(string, string2);
    }

    public void init(String string, String string2) throws Exception {
        this.serverRoot_ = string.trim();
        this.instanceName_ = string2.trim();
        this.magObject = new MagObj();
        this.magObject.init(this.serverRoot_, this.instanceName_);
        this.magUser = this.magObject.get_mag_var("User");
        XmlNode xmlNode = AdminConfig.getInstance(this.serverRoot_, this.instanceName_);
        this.wrapperXmlNode_ = new XmlNodeWrapper(xmlNode);
        this.serverNode = this.wrapperXmlNode_.getServerRootNode();
        this.cacheNode = this.wrapperXmlNode_.getCacheNode();
        if (this.cacheNode != null) {
            this.partitionNodes = this.getAllPartitionNodes();
        }
        this.serverXml_ = this.serverRoot_ + System.getProperty("file.separator") + this.instanceName_ + System.getProperty("file.separator") + "conf_bk" + System.getProperty("file.separator") + "server.xml";
    }

    public final void returnError(String string, String string2, PrintWriter printWriter) {
        try {
            this.out = printWriter;
        }
        catch (Exception exception) {
            System.out.println("IO Exception caught");
        }
        this.returnError(string, string2);
    }

    public final void returnError(String string, String string2) {
        this.out.println("<script language=\"JavaScript\">");
        this.out.println("alert('" + string + "');");
        this.out.println(" window.location='" + string2 + "'");
        this.out.println("</script>");
    }

    public boolean isCacheNodeAvailable() {
        return this.cacheNode != null;
    }

    public String getInstanceName() {
        return this.instanceName_;
    }

    public int getNumOfPartitions() {
        int n = 0;
        if (this.cacheNode != null && this.partitionNodes != null) {
            n = this.partitionNodes.length;
        }
        return n;
    }

    public int getTotalNumOfSections() throws Exception {
        long l = this.getCacheCapacity();
        int n = (int)(l / 125L);
        n = n <= 0 || n > 256 ? 8 : n;
        return n;
    }

    public int getNumOfSections(int n) throws Exception {
        String string = this.getPartitionLocation(n);
        int n2 = CacheUtil.getPartitionCurrentSections(string);
        return n2 > 0 ? n2 : 0;
    }

    public int getNumOfSections(String string) throws Exception {
        if (string != null) {
            String string2 = this.getPartitionLocation(string);
            int n = CacheUtil.getPartitionCurrentSections(string2);
            return n > 0 ? n : 0;
        }
        return 0;
    }

    private XmlNode getPartition(int n) throws Exception {
        if (n >= this.partitionNodes.length) {
            throw new Exception("Partition " + n + "does not exist");
        }
        return this.partitionNodes[n];
    }

    public XmlNode[] getAllPartitionNodes() {
        if (this.cacheNode != null) {
            Iterator iterator = this.cacheNode.iterate("PARTITION");
            int n = 0;
            while (iterator.hasNext()) {
                iterator.next();
                ++n;
            }
            this.partitionNodes = new XmlNode[n];
            iterator = this.cacheNode.iterate("PARTITION");
            for (int i = 0; i < n; ++i) {
                this.partitionNodes[i] = (XmlNode)iterator.next();
            }
        }
        System.out.println("Total # partitions : = " + this.partitionNodes.length);
        return this.partitionNodes;
    }

    public void setCacheStatus(String string) throws Exception {
        this.cacheNode.setAttribute("enabled", string);
        for (int i = 0; i < this.partitionNodes.length; ++i) {
            this.setPartitionStatus(i, string.equals("true") ? "true" : "false");
        }
    }

    public void setCacheWorkingDir(String string) throws Exception {
        string = this.makeDir(string);
        CacheUtil.changeOwnership(string, this.magUser);
        this.cacheNode.setAttribute("cachedir", string);
        String string2 = string + System.getProperty("file.separator") + ".cache-data";
        string2 = this.makeDir(string2);
        CacheUtil.changeOwnership(string2, this.magUser);
    }

    public void setCacheCapacity(long l, String string) throws Exception {
        this.makeSections(String.valueOf(l), string);
        this.cacheNode.setAttribute("cachecapacity", Long.toString(l));
    }

    public void setCacheCapacity(long l) throws Exception {
        if (!this.isCacheCapacityValid(l)) {
            this.returnMessage("Invalid cacheCapacity " + l + "MB. Cache capacity cannot be less than the sum of max sizes of all the partitions " + this.getSumOfPartitionMaxSizes() + "MB. Please decrease the MaxSize/CacheSize or increase the Cache Capacity.", this.referer);
        } else {
            int n = this.getCacheDim();
            long l2 = l / 125L;
            int n2 = (int)(Math.log(l2) / Math.log(2.0));
            System.out.println("oldDim = " + n + " newDim = " + n2 + " Resizing cache");
            if (n2 == n) {
                System.out.println("Cache capacity left unchanged.");
                this.returnMessage("Cache capacity left unchanged.", this.referer);
            } else {
                CacheUtil.resizeCache(n, n2, this.serverXml_, this.magUser);
                this.cacheNode.getAttribute("cachecapacity").setValue(Long.toString(l));
            }
        }
    }

    public String getCacheStatus() throws Exception {
        if (this.cacheNode != null) {
            return this.cacheNode.getAttribute("enabled").getValue();
        }
        return null;
    }

    public String getCacheWorkingDir() throws Exception {
        if (this.cacheNode != null) {
            return this.cacheNode.getAttribute("cachedir").getValue();
        }
        return null;
    }

    public String getCacheNDirs() throws Exception {
        return String.valueOf(this.getTotalNumOfSections());
    }

    public int getCacheDim() throws Exception {
        String string = this.getCacheNDirs();
        double d = Double.valueOf(string);
        double d2 = Math.log(d) / Math.log(2.0);
        return (int)d2;
    }

    public long getCacheCapacity() throws Exception {
        if (this.cacheNode != null) {
            String string = this.cacheNode.getAttribute("cachecapacity").getValue();
            string = string != null ? string : "0";
            return Long.valueOf(string);
        }
        return 0L;
    }

    public String getOptimumCapacity() throws Exception {
        long l = this.getCacheCapacity();
        String string = String.valueOf(l < 1000L ? l : l / 1000L) + (l < 1000L ? " M" : " G") + "B";
        return string;
    }

    public String getCacheCapacityRange() throws Exception {
        long l = Long.valueOf(this.getCacheNDirs());
        long l2 = l * 125L;
        long l3 = l > 1L ? l2 / 2L : 0L;
        long l4 = l2 * 2L;
        String string = String.valueOf(l3 < 1000L ? l3 : l3 / 1000L) + (l3 < 1000L ? " M" : " G") + "B - " + String.valueOf(l4 < 1000L ? l4 : l4 / 1000L) + (l4 < 1000L ? " M" : " G") + "B";
        return string;
    }

    public void setPartitionStatus(int n, String string) throws Exception {
        this.getPartition(n).setAttribute("enabled", string.equals("true") ? "true" : "false");
    }

    public void setPartitionLocation(String string, String string2) throws Exception {
        string2 = this.makeDir(string2);
        CacheUtil.changeOwnership(string2, this.magUser);
        String string3 = string2 + System.getProperty("file.separator") + ".cache-data";
        string3 = this.makeDir(string3);
        CacheUtil.changeOwnership(string3, this.magUser);
        this.getPartition(string).setAttribute("partitiondir", string2);
    }

    public void setPartitionMnemonicName(String string, String string2) throws Exception {
        this.getPartition(string).setAttribute("partitionname", string2);
    }

    public void setPartitionMaxSize(String string, String string2) throws Exception {
        if (string2 != null) {
            if (!this.isMaxSizeValid(string, Long.parseLong(string2))) {
                this.returnMessage("Invalid MaxSize/CacheSize " + string2 + "MB. Sum of max sizes of all the partitions " + this.getSumOfPartitionMaxSizes(string, Long.parseLong(string2)) + "MB cannot exceed the Cache capacity " + this.getCacheCapacity() + "MB. Please decrease the MaxSize/CacheSize or increase the Cache Capacity.", this.referer);
            } else {
                this.getPartition(string).setAttribute("maxsize", string2);
            }
        }
    }

    public void setPartitionMinAvailSize(String string, String string2) throws Exception {
        if (string2 != null) {
            this.getPartition(string).setAttribute("minspace", string2);
        }
    }

    public String getPartitionMnemonicName(int n) throws Exception {
        return this.getPartition(n).getAttribute("partitionname").getValue();
    }

    public String getPartitionLocation(String string) throws Exception {
        return this.getPartition(string).getAttribute("partitiondir").getValue();
    }

    public String getPartitionStatus(String string) throws Exception {
        return CacheUtil.readPartitionStatusFile(this.getPartitionLocation(string));
    }

    public long getPartitionMaxSize(String string) throws Exception {
        return Long.valueOf(this.getPartition(string).getAttribute("maxsize").getValue());
    }

    public long getPartitionMinAvailSize(String string) throws Exception {
        return Long.valueOf(this.getPartition(string).getAttribute("minspace").getValue());
    }

    public String getPartitionLocation(int n) throws Exception {
        return this.getPartition(n).getAttribute("partitiondir").getValue();
    }

    public String getPartitionName(int n) throws Exception {
        return this.getPartitionMnemonicName(n);
    }

    public long getPartitionMaxSize(int n) throws Exception {
        return Long.valueOf(this.getPartition(n).getAttribute("maxsize").getValue());
    }

    public long getPartitionActualMaxSize(int n) throws Exception {
        long l;
        long l2;
        long l3;
        long l4 = CacheUtil.getPartitionCurrentSize(this.getPartitionLocation(n));
        long l5 = l4 + (l3 = CacheUtil.getAvailableSpace(this.getPartitionLocation(n))) - (l2 = this.getPartitionMinAvailSize(n));
        l5 = l5 > (l = this.getPartitionMaxSize(n)) ? l : l5;
        return l5;
    }

    public long getPartitionMinAvailSize(int n) throws Exception {
        return Long.valueOf(this.getPartition(n).getAttribute("minspace").getValue());
    }

    public String getPartitionStatus(int n) throws Exception {
        return this.getPartitionStatus(this.getPartitionName(n));
    }

    public long getPartitionSize(int n) throws Exception {
        return CacheUtil.getPartitionCurrentSize(this.getPartitionLocation(n));
    }

    public long getPartitionSize(String string) throws Exception {
        return CacheUtil.getPartitionCurrentSize(this.getPartitionLocation(string));
    }

    public long getSpaceAvailable(int n) throws Exception {
        return this.getPartitionActualMaxSize(n) - this.getPartitionSize(n);
    }

    public long getActualSpaceAvailable(int n) throws Exception {
        return CacheUtil.getAvailableSpace(this.getPartitionLocation(n));
    }

    public long getActualSpaceAvailable(String string) throws Exception {
        return CacheUtil.getAvailableSpace(this.getPartitionLocation(string));
    }

    public void createPartition(String string, String string2, String string3, String string4) throws Exception {
        if (this.cacheNode != null && string3 != null) {
            if (this.getSumOfPartitionMaxSizes() + Long.parseLong(string3) > this.getCacheCapacity()) {
                this.returnMessage("Invalid MaxSize/CacheSize " + string3 + "MB. Sum of max sizes of all the partitions " + (this.getSumOfPartitionMaxSizes() + Long.parseLong(string3)) + "MB cannot exceed the Cache capacity " + this.getCacheCapacity() + "MB. Please decrease the MaxSize/CacheSize or increase the Cache Capacity " + "before creating the new partition.", this.referer);
            } else {
                string2 = this.makeDir(string2);
                CacheUtil.changeOwnership(string2, this.magUser);
                String string5 = string2 + System.getProperty("file.separator") + ".cache-data";
                string5 = this.makeDir(string5);
                CacheUtil.changeOwnership(string5, this.magUser);
                String string6 = this.getCacheStatus();
                XmlNode xmlNode = new XmlNode();
                xmlNode.setName("PARTITION");
                xmlNode.addChild("enabled", string6, true);
                xmlNode.addChild("partitionname", string, true);
                xmlNode.addChild("partitiondir", string2, true);
                xmlNode.addChild("maxsize", string3, true);
                xmlNode.addChild("minspace", string4, true);
                this.cacheNode.addChild(xmlNode);
                CacheUtil.createPartitionStatusFile(string2, 0);
            }
        }
    }

    private String makeDir(String string) throws Exception {
        boolean bl;
        File file = new File(string = SlashUtil.de_slashes(string));
        if (!file.exists() && !(bl = file.mkdirs())) {
            throw new Exception("Cannot create the specified " + string + "directory.");
        }
        return string;
    }

    public int makeSections(String string, String string2) throws Exception {
        System.out.println("Making Sections");
        int n = 0;
        if (this.partitionNodes.length <= 0 || !this.scanForSections()) {
            string = string != null ? string : "0";
            n = (int)(Long.parseLong(string) / 125L);
            n = n <= 0 || n > 256 ? 8 : n;
            int n2 = (int)(Math.log(n) / Math.log(2.0));
            for (int i = 0; i < n; ++i) {
                CacheUtil.makeSection(string2, n2, i);
            }
        }
        return n;
    }

    public void createNewCachingNode(String string, String string2, String string3, String string4) throws Exception {
        if (this.serverNode != null) {
            XmlNode xmlNode;
            string = string.equals("1") ? "true" : "false";
            this.cacheNode = xmlNode = new XmlNode(this.serverNode, "CACHE", "", "", 0);
            this.partitionNodes = this.getAllPartitionNodes();
            this.setCacheStatus(string);
            this.setCacheWorkingDir(string3);
            this.setCacheCapacity(string2 != null ? Long.valueOf(string2) : 0L, string3);
            if (this.getNumOfPartitions() == 0) {
                this.createPartition("part1", string3, string4 != null ? string4 : "100", "0");
            }
            int n = this.makeSections(string2, string3);
            this.serverNode.addChild(xmlNode);
        }
    }

    public void updateCachingConfigData(String string, String string2, String string3, String string4, String string5) throws Exception {
        if (this.cacheNode != null) {
            this.makeSections(string4, string3);
            string2 = string2.equals("1") ? "true" : "false";
            this.setCacheStatus(string2);
            this.setCacheWorkingDir(string3);
            this.setCacheCapacity(string4 != null ? Long.valueOf(string4) : 0L, string3);
            if (this.getNumOfPartitions() == 0) {
                this.createPartition("part1", string3, string5 != null ? string5 : "100", "0");
            } else if (this.getNumOfPartitions() == 1) {
                String string6 = this.getPartitionName(0);
                this.setPartitionMaxSize(string6, string5);
            }
        }
    }

    public void updatePartitionConfigData(String string, String string2, String string3, String string4, String string5) throws Exception {
        if (!this.getPartition(string).getAttribute("partitiondir").equals(string3)) {
            this.setPartitionLocation(string, string3);
        }
        this.setPartitionMaxSize(string, string4);
        this.setPartitionMinAvailSize(string, string5);
        this.setPartitionMnemonicName(string, string2);
    }

    public void deletePartition(String string) throws Exception {
        int n = this.getNumOfSections(string);
        if (n == 0) {
            XmlNode xmlNode = this.getPartition(string);
            this.cacheNode.removeChild(xmlNode);
        } else {
            this.returnError("Cannot delete a non-empty Partition. Please move all the sections in this partition to another Partition first.", "cacheSectionTable.jsp");
        }
    }

    private XmlNode getPartition(String string) throws Exception {
        if (string != null) {
            for (int i = 0; i < this.partitionNodes.length; ++i) {
                if (!this.partitionNodes[i].getAttribute("partitionname").getValue().equals(string)) continue;
                return this.partitionNodes[i];
            }
        }
        return null;
    }

    public boolean saveXMLConfiguration() throws Exception {
        XmlNode xmlNode = null;
        if (this.wrapperXmlNode_ != null) {
            xmlNode = this.wrapperXmlNode_.getServerRootNode();
        }
        AdminConfig.writeXmlToFile(xmlNode, this.serverRoot_, this.serverXml_);
        return true;
    }

    public long getSectionCurrentSize(String string) throws Exception {
        return CacheUtil.getPartitionCurrentSize(string);
    }

    public String getSectionCurrentStatus(String string) throws Exception {
        return CacheUtil.getPartitionCurrentStatus(string);
    }

    public void updateSectionConfigData(String string, String string2, String string3, String string4) {
        double d = 0.0;
        long l = 0L;
        d = Double.parseDouble(string);
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 8.0) {
            d = 8.0;
        }
        l = (long)Math.pow(2.0, d);
        int n = 0;
        while ((long)n < l) {
            if (string3 != null && string4 != null && !string3.equals(string4)) {
                System.out.print("moving source = " + string3 + "/" + string2);
                CacheUtil.moveSection(string3 + "/" + string2, string4 + "/" + string2);
            }
            ++n;
        }
    }

    public String getCapacityString(int n) throws Exception {
        long l = (long)n * 125L;
        long l2 = n > 1 ? l / 2L : 0L;
        long l3 = l * 2L;
        String string = String.valueOf(l < 1000L ? l : l / 1000L) + (l < 1000L ? " M" : " G") + "B (" + String.valueOf(l2 < 1000L ? l2 : l2 / 1000L) + (l2 < 1000L ? " M" : " G") + "B - " + String.valueOf(l3 < 1000L ? l3 : l3 / 1000L) + (l3 < 1000L ? " M" : " G") + "B)";
        return string;
    }

    public String getCacheFormat() throws Exception {
        int n = this.getCacheDim();
        String string = "s" + String.valueOf(n) + "." + (n <= 3 ? "X" : (n <= 6 ? "XX" : "XXX"));
        return string;
    }

    private boolean scanForSections() throws Exception {
        for (int i = 0; i < this.partitionNodes.length; ++i) {
            String string = this.getPartitionLocation(i);
            for (int j = 0; j <= 8; ++j) {
                String string2 = string + "/s" + j + "." + (j < 4 ? "0" : (j < 7 ? "00" : "000"));
                File file = new File(string2);
                if (file.exists()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isMaxSizeValid(String string, long l) throws Exception {
        long l2 = this.getSumOfPartitionMaxSizes(string, l);
        return this.getCacheCapacity() >= l2;
    }

    private boolean isCacheCapacityValid(long l) throws Exception {
        return l >= this.getSumOfPartitionMaxSizes();
    }

    private long getSumOfPartitionMaxSizes() throws Exception {
        long l = 0L;
        int n = this.getNumOfPartitions();
        if (n > 0) {
            for (int i = 0; i < this.getNumOfPartitions(); ++i) {
                l += this.getPartitionMaxSize(i);
            }
            return l;
        }
        return 0L;
    }

    private long getSumOfPartitionMaxSizes(String string, long l) throws Exception {
        long l2 = 0L;
        if (this.cacheNode != null) {
            for (int i = 0; i < this.getNumOfPartitions(); ++i) {
                if (string.equals(this.getPartitionName(i))) {
                    l2 += l;
                    continue;
                }
                l2 += this.getPartitionMaxSize(i);
            }
        }
        return l2;
    }

    private void returnMessage(String string, String string2) {
        this.out.println("<script language=\"JavaScript\">");
        this.out.println("alert('" + string + "');");
        this.out.println(" window.location='" + string2 + "'");
        this.out.println("</script>");
    }
}

