/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.servlets;

import com.sun.web.admin.beans.AdminConfig;
import com.sun.web.admin.servlets.AdminServlet;
import com.sun.web.admin.servlets.ColumnInfo;
import com.sun.web.admin.util.XmlConfig;
import com.sun.web.admin.util.XmlNode;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class MonitorStats
extends AdminServlet {
    private URL xmlURL = null;
    private URL dtdURL = null;
    private String statsXmlFileName = null;
    private String statsDtdFileName = null;
    private String serverHostName = null;
    private String serverInstanceName = null;
    private String protocolName = null;
    private String pollInterval = null;
    private String statisticsType = null;
    private XmlConfig xConfig = null;
    private XmlNode rootNode = null;
    private XmlNode parentNode = null;
    private String refreshRequest = null;

    private void getInputParameters(HttpServletRequest httpServletRequest) {
        this.pollInterval = httpServletRequest.getParameter("pollInterval");
        this.statisticsType = httpServletRequest.getParameter("statisticsType");
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    protected void getExecute(HttpSession httpSession, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.postExecute(httpSession, httpServletRequest, httpServletResponse);
    }

    protected void postExecute(HttpSession httpSession, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("text/html");
        this.getInputParameters(httpServletRequest);
        this.out = httpServletResponse.getWriter();
        try {
            this.serverInstanceName = this.getServerInstanceName(httpServletRequest);
            String string = this.getServerPortNumber(this.serverInstanceName, httpServletRequest);
            this.protocolName = this.getProtocolName(httpServletRequest);
            this.xmlURL = new URL(this.protocolName + "://" + this.serverHostName + ":" + string + "/stats-xml");
            this.dtdURL = new URL(this.protocolName + "://" + this.serverHostName + ":" + string + "/stats-xml/iwsstats.dtd");
            this.getStatsFiles(httpServletRequest);
            this.parseStatsXml();
            this.sendHtmlHeader(httpServletRequest);
            this.sendHtmlContent();
            this.sendHtmlFooter();
            this.cleanUp();
        }
        catch (Throwable throwable) {
            this.returnError(AdminConfig.getMessage((String)this.sRoot, (String)"ErrorMonitorStats1"), "../profile");
        }
    }

    private void getStatsFiles(HttpServletRequest httpServletRequest) throws Exception {
        try {
            int n;
            String string;
            URLConnection uRLConnection = this.xmlURL.openConnection();
            File file = File.createTempFile("stats", ".dtd");
            File file2 = File.createTempFile("stats", ".xml");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            FileOutputStream fileOutputStream2 = new FileOutputStream(file2);
            file.deleteOnExit();
            file2.deleteOnExit();
            this.statsXmlFileName = file2.getPath();
            this.statsDtdFileName = file.getPath();
            DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
            byte[] byArray = "\n".getBytes();
            while ((string = dataInputStream.readLine()) != null) {
                Object object;
                int n2 = string.length();
                int n3 = string.indexOf("iwsstats.dtd");
                if (n3 == -1) {
                    object = string.getBytes();
                    fileOutputStream2.write((byte[])object);
                } else {
                    object = string.substring(0, n3);
                    String string2 = file.getName();
                    String string3 = string.substring(n3 + 12, n2);
                    byte[] byArray2 = ((String)object).getBytes();
                    byte[] byArray3 = string2.getBytes();
                    byte[] byArray4 = string3.getBytes();
                    fileOutputStream2.write(byArray2);
                    fileOutputStream2.write(byArray3);
                    fileOutputStream2.write(byArray4);
                }
                fileOutputStream2.write(byArray);
            }
            dataInputStream.close();
            fileOutputStream2.close();
            URLConnection uRLConnection2 = this.dtdURL.openConnection();
            DataInputStream dataInputStream2 = new DataInputStream(uRLConnection2.getInputStream());
            while ((n = dataInputStream2.read()) != -1) {
                fileOutputStream.write(n);
            }
            dataInputStream2.close();
            fileOutputStream.close();
        }
        catch (Throwable throwable) {
            this.returnError(AdminConfig.getMessage((String)this.sRoot, (String)"ErrorMonitorStats2"), "../profile");
        }
    }

    private String getProtocolName(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getRequestURI();
        int n = string.indexOf("https:");
        if (n < 0) {
            return "http";
        }
        return "https";
    }

    private String getServerInstanceName(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("INSTANCE_NAME");
        int n = string.length();
        int n2 = string.indexOf("proxy-");
        String string2 = string.substring(n2 += 6, n);
        return string2;
    }

    private String getServerPortNumber(String string, HttpServletRequest httpServletRequest) throws Exception {
        XmlNode xmlNode = null;
        try {
            xmlNode = AdminConfig.getInstance((String)this.sRoot, (String)httpServletRequest.getParameter("INSTANCE_NAME"));
        }
        catch (Throwable throwable) {
            ServletException servletException = new ServletException(throwable.toString());
            throw servletException;
        }
        XmlNode xmlNode2 = xmlNode.findConfig("SERVER");
        Iterator iterator = xmlNode2.iterate("LS");
        while (iterator.hasNext()) {
            XmlNode xmlNode3 = (XmlNode)iterator.next();
            if (!xmlNode3.getString("defaultvs", "null").equals(string)) continue;
            this.serverHostName = xmlNode3.getString("servername", "null");
            return xmlNode3.getString("port", "null");
        }
        return "-1";
    }

    private void parseStatsXml() throws Exception {
        this.xConfig = new XmlConfig(this.statsXmlFileName);
        this.rootNode = null;
        try {
            this.rootNode = this.xConfig.parseConfig();
        }
        catch (Throwable throwable) {
            ServletException servletException = new ServletException(throwable.toString());
            throw servletException;
        }
        this.parentNode = this.xConfig.findConfig("stats");
    }

    private void sendHtmlHeader(HttpServletRequest httpServletRequest) {
        this.refreshRequest = this.protocolName + "://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort() + "/" + "proxy-" + this.serverInstanceName + "/bin/monitor" + "?pollInterval=" + this.pollInterval + "&statisticsType=" + this.statisticsType;
        this.out.println("<html>");
        this.out.println("<meta http-equiv=\"Refresh\" Content=\"" + this.pollInterval + "\" " + "url=\"" + this.refreshRequest + "\">");
        this.out.println("<head><title>Web Proxy Server Statistics</title></head>");
        this.out.println("<BODY BGCOLOR=\"#ffffff\" LINK=\"#666699\" VLINK=\"#666699\" ALINK=\"#333366\" >");
        this.out.println("<FONT SIZE=\"3\" FACE=\"PrimaSans BT, Verdana, sans-serif\">");
        this.out.println("<TABLE BORDER=\"0\" BGCOLOR=\"#9999cc\" CELLPADDING=\"5\" CELLSPACING=\"0\" WIDTH=\"100%\">");
        this.out.println("<TR>");
        this.out.println("<TD NOWRAP><BR><FONT FACE=\"PrimaSans BT, Verdana, sans-serif\" SIZE=\"3\" COLOR=\"white\"><B>Web Proxy Server Statistics</B></FONT></TD>");
        this.out.println("</TR>");
        this.out.println("</TABLE>");
        this.out.println("<P>");
        this.out.println("<SCRIPT LANGUAGE=\"JavaScript\">");
        this.out.println("function pop_up(url) {");
        this.out.println("window.open(url, \"BarChart\", \"toolbar=0,location=0,status=0,menubar=0,scrollbars=1,resizable=1\");");
        this.out.println("}");
        this.out.println("</SCRIPT>");
    }

    private void sendHtmlContent() {
        if (this.statisticsType.equals("cnxs")) {
            this.sendConnectionStatistics();
        } else if (this.statisticsType.equals("thread")) {
            this.sendThreadStatistics();
        } else if (this.statisticsType.equals("dns")) {
            this.sendDNSStatistics();
        } else if (this.statisticsType.equals("kalive")) {
            this.sendKeepaliveStatistics();
        } else if (this.statisticsType.equals("cache")) {
            this.sendCacheStatistics();
        } else if (this.statisticsType.equals("virtualServer")) {
            this.sendVirtualServerStatistics();
        }
    }

    private void sendHtmlFooter() {
        this.out.println("</body>");
        this.out.println("</html>");
    }

    private void sendConnectionStatistics() {
        Iterator iterator = this.parentNode.iterate("server");
        XmlNode xmlNode = null;
        Vector<ColumnInfo> vector = new Vector<ColumnInfo>(20);
        Vector<ColumnInfo> vector2 = new Vector<ColumnInfo>(20);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (!iterator.hasNext()) {
            return;
        }
        xmlNode = (XmlNode)iterator.next();
        vector.addElement(new ColumnInfo("pid", 25));
        vector2.addElement(new ColumnInfo("Pid", 8));
        vector.addElement(new ColumnInfo("connection-queue", 8));
        vector2.addElement(new ColumnInfo("Q Id", 8));
        vector.addElement(new ColumnInfo("countTotalConnections", 8));
        vector2.addElement(new ColumnInfo("Total Conn.", 8));
        vector.addElement(new ColumnInfo("countQueued", 8));
        vector2.addElement(new ColumnInfo("Queued", 8));
        vector.addElement(new ColumnInfo("peakQueued", 8));
        vector2.addElement(new ColumnInfo("Peak Queued", 8));
        vector.addElement(new ColumnInfo("maxQueued", 20));
        vector2.addElement(new ColumnInfo("Max Queued", 8));
        vector.addElement(new ColumnInfo("countOverflows", 8));
        vector2.addElement(new ColumnInfo("Overflow", 8));
        vector.addElement(new ColumnInfo("countTotalQueued", 8));
        vector2.addElement(new ColumnInfo("Total Queued", 8));
        vector.addElement(new ColumnInfo("ticksTotalQueued", 8));
        vector2.addElement(new ColumnInfo("Ticks Queued", 8));
        iterator = xmlNode.iterate("process");
        int n8 = 0;
        this.out.println("<b>    Connection Queue Statistics : </b>");
        this.out.println("<P>");
        while (iterator.hasNext()) {
            ++n8;
            XmlNode xmlNode2 = (XmlNode)iterator.next();
            String string = xmlNode2.getString("pid", "null");
            Iterator iterator2 = xmlNode2.iterate("connection-queue-bucket");
            while (iterator2.hasNext()) {
                XmlNode xmlNode3 = (XmlNode)iterator2.next();
                ((ColumnInfo)vector.elementAt(0)).setNextData(string);
                ((ColumnInfo)vector.elementAt(1)).setNextData(xmlNode3.getString("connection-queue", "null"));
                ((ColumnInfo)vector.elementAt(2)).setNextData(xmlNode3.getString("countTotalConnections", "null"));
                ((ColumnInfo)vector.elementAt(3)).setNextData(xmlNode3.getString("countQueued", "null"));
                ((ColumnInfo)vector.elementAt(4)).setNextData(xmlNode3.getString("peakQueued", "null"));
                ((ColumnInfo)vector.elementAt(5)).setNextData(xmlNode3.getString("maxQueued", "null"));
                ((ColumnInfo)vector.elementAt(6)).setNextData(xmlNode3.getString("countOverflows", "null"));
                ((ColumnInfo)vector.elementAt(7)).setNextData(xmlNode3.getString("countTotalQueued", "null"));
                ((ColumnInfo)vector.elementAt(8)).setNextData(xmlNode3.getString("ticksTotalQueued", "null"));
                n += Integer.parseInt(xmlNode3.getString("countTotalConnections", "null").trim());
                n2 += Integer.parseInt(xmlNode3.getString("countQueued", "null").trim());
                n3 += Integer.parseInt(xmlNode3.getString("peakQueued", "null").trim());
                n4 += Integer.parseInt(xmlNode3.getString("maxQueued", "null").trim());
                n5 += Integer.parseInt(xmlNode3.getString("countOverflows", "null").trim());
                n6 += Integer.parseInt(xmlNode3.getString("countTotalQueued", "null").trim());
                n7 += Integer.parseInt(xmlNode3.getString("ticksTotalQueued", "null").trim());
            }
        }
        ((ColumnInfo)vector.elementAt(0)).setNextData("AllProcesses");
        ((ColumnInfo)vector.elementAt(1)).setNextData("-");
        ((ColumnInfo)vector.elementAt(2)).setNextData(Integer.toString(n));
        ((ColumnInfo)vector.elementAt(3)).setNextData(Integer.toString(n2));
        ((ColumnInfo)vector.elementAt(4)).setNextData(Integer.toString(n3));
        ((ColumnInfo)vector.elementAt(5)).setNextData(Integer.toString(n4));
        ((ColumnInfo)vector.elementAt(6)).setNextData(Integer.toString(n5));
        ((ColumnInfo)vector.elementAt(7)).setNextData(Integer.toString(n6));
        ((ColumnInfo)vector.elementAt(8)).setNextData(Integer.toString(n7));
        this.displayTable(vector, vector2);
    }

    private void sendThreadStatistics() {
        this.out.println("TBD");
    }

    private void sendDNSStatistics() {
        Iterator iterator = this.parentNode.iterate("server");
        XmlNode xmlNode = null;
        Vector<ColumnInfo> vector = new Vector<ColumnInfo>(20);
        Vector<ColumnInfo> vector2 = new Vector<ColumnInfo>(20);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (!iterator.hasNext()) {
            return;
        }
        xmlNode = (XmlNode)iterator.next();
        vector.addElement(new ColumnInfo("pid", 8));
        vector2.addElement(new ColumnInfo("Pid", 8));
        vector.addElement(new ColumnInfo("flagCacheEnabled", 8));
        vector2.addElement(new ColumnInfo("Enabled", 8));
        vector.addElement(new ColumnInfo("countCacheEntries", 16));
        vector2.addElement(new ColumnInfo("Current Entries", 16));
        vector.addElement(new ColumnInfo("maxCacheEntries", 16));
        vector2.addElement(new ColumnInfo("Max. Entries", 16));
        vector.addElement(new ColumnInfo("countCacheHits", 16));
        vector2.addElement(new ColumnInfo("Hits", 16));
        vector.addElement(new ColumnInfo("countCacheMisses", 16));
        vector2.addElement(new ColumnInfo("Misses", 16));
        vector.addElement(new ColumnInfo("flagAsyncEnabled", 16));
        vector2.addElement(new ColumnInfo("Async Enable", 16));
        vector.addElement(new ColumnInfo("countAsyncNameLookups", 16));
        vector2.addElement(new ColumnInfo("Async Name Lookup", 16));
        vector.addElement(new ColumnInfo("countAsyncAddrLookups", 16));
        vector2.addElement(new ColumnInfo("Async Addr. Lookup", 16));
        vector.addElement(new ColumnInfo("countAsyncLookupsInProgress", 16));
        vector2.addElement(new ColumnInfo("Async Lookups", 16));
        iterator = xmlNode.iterate("process");
        int n8 = 0;
        this.out.println("<b>    DNS Statistics : </b>");
        this.out.println("<P>");
        while (iterator.hasNext()) {
            ++n8;
            XmlNode xmlNode2 = (XmlNode)iterator.next();
            String string = xmlNode2.getString("pid", "null");
            Iterator iterator2 = xmlNode2.iterate("dns-bucket");
            while (iterator2.hasNext()) {
                XmlNode xmlNode3 = (XmlNode)iterator2.next();
                ((ColumnInfo)vector.elementAt(0)).setNextData(string);
                ((ColumnInfo)vector.elementAt(1)).setNextData(xmlNode3.getString("flagCacheEnabled", "null"));
                ((ColumnInfo)vector.elementAt(2)).setNextData(xmlNode3.getString("countCacheEntries", "null"));
                ((ColumnInfo)vector.elementAt(3)).setNextData(xmlNode3.getString("maxCacheEntries", "null"));
                ((ColumnInfo)vector.elementAt(4)).setNextData(xmlNode3.getString("countCacheHits", "null"));
                ((ColumnInfo)vector.elementAt(5)).setNextData(xmlNode3.getString("countCacheMisses", "null"));
                ((ColumnInfo)vector.elementAt(6)).setNextData(xmlNode3.getString("flagAsyncEnabled", "null"));
                ((ColumnInfo)vector.elementAt(7)).setNextData(xmlNode3.getString("countAsyncNameLookups", "null"));
                ((ColumnInfo)vector.elementAt(8)).setNextData(xmlNode3.getString("countAsyncAddrLookups", "null"));
                ((ColumnInfo)vector.elementAt(9)).setNextData(xmlNode3.getString("countAsyncLookupsInProgress", "null"));
                n += Integer.parseInt(xmlNode3.getString("countCacheEntries", "null").trim());
                n2 += Integer.parseInt(xmlNode3.getString("maxCacheEntries", "null").trim());
                n3 += Integer.parseInt(xmlNode3.getString("countCacheHits", "null").trim());
                n4 += Integer.parseInt(xmlNode3.getString("countCacheMisses", "null").trim());
                n5 += Integer.parseInt(xmlNode3.getString("countAsyncNameLookups", "null").trim());
                n6 += Integer.parseInt(xmlNode3.getString("countAsyncAddrLookups", "null").trim());
                n7 += Integer.parseInt(xmlNode3.getString("countAsyncLookupsInProgress", "null").trim());
            }
        }
        ((ColumnInfo)vector.elementAt(0)).setNextData("AllProcesses");
        ((ColumnInfo)vector.elementAt(1)).setNextData("-");
        ((ColumnInfo)vector.elementAt(2)).setNextData(Integer.toString(n));
        ((ColumnInfo)vector.elementAt(3)).setNextData(Integer.toString(n2));
        ((ColumnInfo)vector.elementAt(4)).setNextData(Integer.toString(n3));
        ((ColumnInfo)vector.elementAt(5)).setNextData(Integer.toString(n4));
        ((ColumnInfo)vector.elementAt(6)).setNextData("-");
        ((ColumnInfo)vector.elementAt(7)).setNextData(Integer.toString(n5));
        ((ColumnInfo)vector.elementAt(8)).setNextData(Integer.toString(n6));
        ((ColumnInfo)vector.elementAt(9)).setNextData(Integer.toString(n7));
        this.displayTable(vector, vector2);
    }

    private void sendKeepaliveStatistics() {
        Iterator iterator = this.parentNode.iterate("server");
        XmlNode xmlNode = null;
        Vector<ColumnInfo> vector = new Vector<ColumnInfo>(20);
        Vector<ColumnInfo> vector2 = new Vector<ColumnInfo>(20);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (!iterator.hasNext()) {
            return;
        }
        xmlNode = (XmlNode)iterator.next();
        vector.addElement(new ColumnInfo("pid", 8));
        vector2.addElement(new ColumnInfo("Pid", 8));
        vector.addElement(new ColumnInfo("countConnections", 16));
        vector2.addElement(new ColumnInfo("Connections", 16));
        vector.addElement(new ColumnInfo("maxConnections", 16));
        vector2.addElement(new ColumnInfo("Max Connections", 16));
        vector.addElement(new ColumnInfo("countHits", 16));
        vector2.addElement(new ColumnInfo("Hits", 16));
        vector.addElement(new ColumnInfo("countFlushes", 16));
        vector2.addElement(new ColumnInfo("Flushes", 16));
        vector.addElement(new ColumnInfo("countRefusals", 16));
        vector2.addElement(new ColumnInfo("Refusals", 16));
        vector.addElement(new ColumnInfo("countTimeouts", 16));
        vector2.addElement(new ColumnInfo("Timeouts", 16));
        vector.addElement(new ColumnInfo("secondsTimeout", 8));
        vector2.addElement(new ColumnInfo("Timeout", 8));
        iterator = xmlNode.iterate("process");
        int n8 = 0;
        this.out.println("<b>    Keep-Alive Statistics : </b>");
        this.out.println("<P>");
        while (iterator.hasNext()) {
            ++n8;
            XmlNode xmlNode2 = (XmlNode)iterator.next();
            String string = xmlNode2.getString("pid", "null");
            Iterator iterator2 = xmlNode2.iterate("keepalive-bucket");
            while (iterator2.hasNext()) {
                XmlNode xmlNode3 = (XmlNode)iterator2.next();
                ((ColumnInfo)vector.elementAt(0)).setNextData(string);
                ((ColumnInfo)vector.elementAt(1)).setNextData(xmlNode3.getString("countConnections", "null"));
                ((ColumnInfo)vector.elementAt(2)).setNextData(xmlNode3.getString("maxConnections", "null"));
                ((ColumnInfo)vector.elementAt(3)).setNextData(xmlNode3.getString("countHits", "null"));
                ((ColumnInfo)vector.elementAt(4)).setNextData(xmlNode3.getString("countFlushes", "null"));
                ((ColumnInfo)vector.elementAt(4)).setNextData(xmlNode3.getString("countRefusals", "null"));
                ((ColumnInfo)vector.elementAt(4)).setNextData(xmlNode3.getString("countTimeouts", "null"));
                ((ColumnInfo)vector.elementAt(5)).setNextData(xmlNode3.getString("secondsTimeout", "null"));
                n += Integer.parseInt(xmlNode3.getString("countConnections", "null").trim());
                n2 += Integer.parseInt(xmlNode3.getString("maxConnections", "null").trim());
                n3 += Integer.parseInt(xmlNode3.getString("countHits", "null").trim());
                n4 += Integer.parseInt(xmlNode3.getString("countFlushes", "null").trim());
                n5 += Integer.parseInt(xmlNode3.getString("countRefusals", "null").trim());
                n6 += Integer.parseInt(xmlNode3.getString("countTimeouts", "null").trim());
                n7 += Integer.parseInt(xmlNode3.getString("secondsTimeout", "null").trim());
            }
        }
        ((ColumnInfo)vector.elementAt(0)).setNextData("AllProcesses");
        ((ColumnInfo)vector.elementAt(1)).setNextData(Integer.toString(n));
        ((ColumnInfo)vector.elementAt(2)).setNextData(Integer.toString(n2));
        ((ColumnInfo)vector.elementAt(3)).setNextData(Integer.toString(n3));
        ((ColumnInfo)vector.elementAt(4)).setNextData(Integer.toString(n4));
        ((ColumnInfo)vector.elementAt(4)).setNextData(Integer.toString(n5));
        ((ColumnInfo)vector.elementAt(4)).setNextData(Integer.toString(n6));
        ((ColumnInfo)vector.elementAt(5)).setNextData(Integer.toString(n7));
        this.displayTable(vector, vector2);
    }

    private void sendCacheStatistics() {
        Iterator iterator = this.parentNode.iterate("server");
        XmlNode xmlNode = null;
        Vector<ColumnInfo> vector = new Vector<ColumnInfo>(20);
        Vector<ColumnInfo> vector2 = new Vector<ColumnInfo>(20);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        if (!iterator.hasNext()) {
            return;
        }
        xmlNode = (XmlNode)iterator.next();
        vector.addElement(new ColumnInfo("pid", 8));
        vector2.addElement(new ColumnInfo("Pid", 8));
        vector.addElement(new ColumnInfo("flagEnabled", 8));
        vector2.addElement(new ColumnInfo("Enable", 8));
        vector.addElement(new ColumnInfo("secondsMaxAge", 8));
        vector2.addElement(new ColumnInfo("Max Age (secs)", 8));
        vector.addElement(new ColumnInfo("countEntries", 16));
        vector2.addElement(new ColumnInfo("Entries", 16));
        vector.addElement(new ColumnInfo("countOpenEntries", 16));
        vector2.addElement(new ColumnInfo("Open Entries", 16));
        vector.addElement(new ColumnInfo("maxOpenEntries", 16));
        vector2.addElement(new ColumnInfo("Max Open Entries", 16));
        vector.addElement(new ColumnInfo("sizeHeapCache", 16));
        vector2.addElement(new ColumnInfo("Heap Cache", 16));
        vector.addElement(new ColumnInfo("maxHeapCacheSize", 16));
        vector2.addElement(new ColumnInfo("Max Heap Size", 16));
        vector.addElement(new ColumnInfo("sizeMmapCache", 16));
        vector2.addElement(new ColumnInfo("Mmap Cache", 16));
        vector.addElement(new ColumnInfo("maxMmapCacheSize", 16));
        vector2.addElement(new ColumnInfo("Max Mmap Size", 16));
        vector.addElement(new ColumnInfo("countHits", 16));
        vector2.addElement(new ColumnInfo("Hits", 16));
        vector.addElement(new ColumnInfo("countMisses", 16));
        vector2.addElement(new ColumnInfo("Miss", 16));
        vector.addElement(new ColumnInfo("countInfoHits", 16));
        vector2.addElement(new ColumnInfo("Info Hits", 16));
        vector.addElement(new ColumnInfo("countInfoMisses", 16));
        vector2.addElement(new ColumnInfo("Info Miss", 16));
        vector.addElement(new ColumnInfo("countContentHits", 16));
        vector2.addElement(new ColumnInfo("Content Hits", 16));
        vector.addElement(new ColumnInfo("countContentMisses", 16));
        vector2.addElement(new ColumnInfo("Content Miss", 16));
        iterator = xmlNode.iterate("process");
        int n15 = 0;
        this.out.println("<b>    Cache Statistics : </b>");
        this.out.println("<P>");
        while (iterator.hasNext()) {
            ++n15;
            XmlNode xmlNode2 = (XmlNode)iterator.next();
            String string = xmlNode2.getString("pid", "null");
            Iterator iterator2 = xmlNode2.iterate("cache-bucket");
            while (iterator2.hasNext()) {
                XmlNode xmlNode3 = (XmlNode)iterator2.next();
                ((ColumnInfo)vector.elementAt(0)).setNextData(string);
                ((ColumnInfo)vector.elementAt(1)).setNextData(xmlNode3.getString("flagEnabled", "null"));
                ((ColumnInfo)vector.elementAt(2)).setNextData(xmlNode3.getString("secondsMaxAge", "null"));
                ((ColumnInfo)vector.elementAt(3)).setNextData(xmlNode3.getString("countEntries", "null"));
                ((ColumnInfo)vector.elementAt(4)).setNextData(xmlNode3.getString("countOpenEntries", "null"));
                ((ColumnInfo)vector.elementAt(5)).setNextData(xmlNode3.getString("maxOpenEntries", "null"));
                ((ColumnInfo)vector.elementAt(6)).setNextData(xmlNode3.getString("sizeHeapCache", "null"));
                ((ColumnInfo)vector.elementAt(7)).setNextData(xmlNode3.getString("maxHeapCacheSize", "null"));
                ((ColumnInfo)vector.elementAt(8)).setNextData(xmlNode3.getString("sizeMmapCache", "null"));
                ((ColumnInfo)vector.elementAt(9)).setNextData(xmlNode3.getString("maxMmapCacheSize", "null"));
                ((ColumnInfo)vector.elementAt(10)).setNextData(xmlNode3.getString("countHits", "null"));
                ((ColumnInfo)vector.elementAt(11)).setNextData(xmlNode3.getString("countMisses", "null"));
                ((ColumnInfo)vector.elementAt(12)).setNextData(xmlNode3.getString("countInfoHits", "null"));
                ((ColumnInfo)vector.elementAt(13)).setNextData(xmlNode3.getString("countInfoMisses", "null"));
                ((ColumnInfo)vector.elementAt(14)).setNextData(xmlNode3.getString("countContentHits", "null"));
                ((ColumnInfo)vector.elementAt(15)).setNextData(xmlNode3.getString("countContentMisses", "null"));
                n += Integer.parseInt(xmlNode3.getString("secondsMaxAge", "null").trim());
                n2 += Integer.parseInt(xmlNode3.getString("countEntries", "null").trim());
                n3 += Integer.parseInt(xmlNode3.getString("countOpenEntries", "null").trim());
                n4 += Integer.parseInt(xmlNode3.getString("maxOpenEntries", "null").trim());
                n5 += Integer.parseInt(xmlNode3.getString("sizeHeapCache", "null").trim());
                n6 += Integer.parseInt(xmlNode3.getString("maxHeapCacheSize", "null").trim());
                n7 += Integer.parseInt(xmlNode3.getString("sizeMmapCache", "null").trim());
                n8 += Integer.parseInt(xmlNode3.getString("maxMmapCacheSize", "null").trim());
                n9 += Integer.parseInt(xmlNode3.getString("countHits", "null").trim());
                n10 += Integer.parseInt(xmlNode3.getString("countMisses", "null").trim());
                n11 += Integer.parseInt(xmlNode3.getString("countInfoHits", "null").trim());
                n12 += Integer.parseInt(xmlNode3.getString("countInfoMisses", "null").trim());
                n13 += Integer.parseInt(xmlNode3.getString("countContentHits", "null").trim());
                n14 += Integer.parseInt(xmlNode3.getString("countContentMisses", "null").trim());
            }
        }
        ((ColumnInfo)vector.elementAt(0)).setNextData("AllProcesses");
        ((ColumnInfo)vector.elementAt(1)).setNextData("-");
        ((ColumnInfo)vector.elementAt(2)).setNextData(Integer.toString(n));
        ((ColumnInfo)vector.elementAt(3)).setNextData(Integer.toString(n2));
        ((ColumnInfo)vector.elementAt(4)).setNextData(Integer.toString(n3));
        ((ColumnInfo)vector.elementAt(5)).setNextData(Integer.toString(n4));
        ((ColumnInfo)vector.elementAt(6)).setNextData(Integer.toString(n5));
        ((ColumnInfo)vector.elementAt(7)).setNextData(Integer.toString(n6));
        ((ColumnInfo)vector.elementAt(8)).setNextData(Integer.toString(n7));
        ((ColumnInfo)vector.elementAt(9)).setNextData(Integer.toString(n8));
        ((ColumnInfo)vector.elementAt(10)).setNextData(Integer.toString(n9));
        ((ColumnInfo)vector.elementAt(11)).setNextData(Integer.toString(n10));
        ((ColumnInfo)vector.elementAt(12)).setNextData(Integer.toString(n11));
        ((ColumnInfo)vector.elementAt(13)).setNextData(Integer.toString(n12));
        ((ColumnInfo)vector.elementAt(14)).setNextData(Integer.toString(n13));
        ((ColumnInfo)vector.elementAt(15)).setNextData(Integer.toString(n14));
        this.displayTable(vector, vector2);
    }

    private void sendVirtualServerStatistics() {
        Iterator iterator = this.parentNode.iterate("server");
        XmlNode xmlNode = null;
        Vector<ColumnInfo> vector = new Vector<ColumnInfo>(20);
        Vector<ColumnInfo> vector2 = new Vector<ColumnInfo>(20);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        if (!iterator.hasNext()) {
            return;
        }
        xmlNode = (XmlNode)iterator.next();
        vector.addElement(new ColumnInfo("id", 12));
        vector2.addElement(new ColumnInfo("id", 12));
        vector.addElement(new ColumnInfo("countRequests", 16));
        vector2.addElement(new ColumnInfo("Total Reqs.", 16));
        vector.addElement(new ColumnInfo("countBytesReceived", 16));
        vector2.addElement(new ColumnInfo("Bytes Recv.", 16));
        vector.addElement(new ColumnInfo("countBytesTransmitted", 20));
        vector2.addElement(new ColumnInfo("Bytes Sent.", 16));
        vector.addElement(new ColumnInfo("count2xx", 8));
        vector2.addElement(new ColumnInfo("2xx", 8));
        vector.addElement(new ColumnInfo("count3xx", 8));
        vector2.addElement(new ColumnInfo("3xx", 8));
        vector.addElement(new ColumnInfo("count4xx", 8));
        vector2.addElement(new ColumnInfo("4xx", 8));
        vector.addElement(new ColumnInfo("count5xx", 8));
        vector2.addElement(new ColumnInfo("5xx", 8));
        vector.addElement(new ColumnInfo("countOther", 8));
        vector2.addElement(new ColumnInfo("Other", 8));
        vector.addElement(new ColumnInfo("count200", 8));
        vector2.addElement(new ColumnInfo("200", 8));
        vector.addElement(new ColumnInfo("count302", 8));
        vector2.addElement(new ColumnInfo("302", 8));
        vector.addElement(new ColumnInfo("count304", 8));
        vector2.addElement(new ColumnInfo("304", 8));
        vector.addElement(new ColumnInfo("count400", 8));
        vector2.addElement(new ColumnInfo("400", 8));
        vector.addElement(new ColumnInfo("count401", 8));
        vector2.addElement(new ColumnInfo("401", 8));
        vector.addElement(new ColumnInfo("count403", 8));
        vector2.addElement(new ColumnInfo("403", 8));
        vector.addElement(new ColumnInfo("count404", 8));
        vector2.addElement(new ColumnInfo("404", 8));
        iterator = xmlNode.iterate("virtual-server");
        int n16 = 0;
        this.out.println("<b>    Virtual Server Statistics : </b>");
        this.out.println("<P>");
        while (iterator.hasNext()) {
            ++n16;
            XmlNode xmlNode2 = (XmlNode)iterator.next();
            String string = xmlNode2.getString("id", "null");
            Iterator iterator2 = xmlNode2.iterate("request-bucket");
            while (iterator2.hasNext()) {
                XmlNode xmlNode3 = (XmlNode)iterator2.next();
                ((ColumnInfo)vector.elementAt(0)).setNextData(string);
                ((ColumnInfo)vector.elementAt(1)).setNextData(xmlNode3.getString("countRequests", "null"));
                ((ColumnInfo)vector.elementAt(2)).setNextData(xmlNode3.getString("countBytesReceived", "null"));
                ((ColumnInfo)vector.elementAt(3)).setNextData(xmlNode3.getString("countBytesTransmitted", "null"));
                ((ColumnInfo)vector.elementAt(4)).setNextData(xmlNode3.getString("count2xx", "null"));
                ((ColumnInfo)vector.elementAt(5)).setNextData(xmlNode3.getString("count3xx", "null"));
                ((ColumnInfo)vector.elementAt(6)).setNextData(xmlNode3.getString("count4xx", "null"));
                ((ColumnInfo)vector.elementAt(7)).setNextData(xmlNode3.getString("count5xx", "null"));
                ((ColumnInfo)vector.elementAt(8)).setNextData(xmlNode3.getString("countOther", "null"));
                ((ColumnInfo)vector.elementAt(9)).setNextData(xmlNode3.getString("count200", "null"));
                ((ColumnInfo)vector.elementAt(10)).setNextData(xmlNode3.getString("count302", "null"));
                ((ColumnInfo)vector.elementAt(11)).setNextData(xmlNode3.getString("count304", "null"));
                ((ColumnInfo)vector.elementAt(12)).setNextData(xmlNode3.getString("count400", "null"));
                ((ColumnInfo)vector.elementAt(13)).setNextData(xmlNode3.getString("count401", "null"));
                ((ColumnInfo)vector.elementAt(14)).setNextData(xmlNode3.getString("count403", "null"));
                ((ColumnInfo)vector.elementAt(15)).setNextData(xmlNode3.getString("count404", "null"));
                n += Integer.parseInt(xmlNode3.getString("countRequests", "null").trim());
                n2 += Integer.parseInt(xmlNode3.getString("countBytesReceived", "null").trim());
                n3 += Integer.parseInt(xmlNode3.getString("countBytesTransmitted", "null").trim());
                n4 += Integer.parseInt(xmlNode3.getString("count2xx", "null").trim());
                n5 += Integer.parseInt(xmlNode3.getString("count3xx", "null").trim());
                n6 += Integer.parseInt(xmlNode3.getString("count4xx", "null").trim());
                n7 += Integer.parseInt(xmlNode3.getString("count5xx", "null").trim());
                n8 += Integer.parseInt(xmlNode3.getString("countOther", "null").trim());
                n9 += Integer.parseInt(xmlNode3.getString("count200", "null").trim());
                n10 += Integer.parseInt(xmlNode3.getString("count302", "null").trim());
                n11 += Integer.parseInt(xmlNode3.getString("count304", "null").trim());
                n12 += Integer.parseInt(xmlNode3.getString("count400", "null").trim());
                n13 += Integer.parseInt(xmlNode3.getString("count401", "null").trim());
                n14 += Integer.parseInt(xmlNode3.getString("count403", "null").trim());
                n15 += Integer.parseInt(xmlNode3.getString("count404", "null").trim());
            }
        }
        ((ColumnInfo)vector.elementAt(0)).setNextData("AllVS");
        ((ColumnInfo)vector.elementAt(1)).setNextData(Integer.toString(n));
        ((ColumnInfo)vector.elementAt(2)).setNextData(Integer.toString(n2));
        ((ColumnInfo)vector.elementAt(3)).setNextData(Integer.toString(n3));
        ((ColumnInfo)vector.elementAt(4)).setNextData(Integer.toString(n4));
        ((ColumnInfo)vector.elementAt(5)).setNextData(Integer.toString(n5));
        ((ColumnInfo)vector.elementAt(6)).setNextData(Integer.toString(n6));
        ((ColumnInfo)vector.elementAt(7)).setNextData(Integer.toString(n7));
        ((ColumnInfo)vector.elementAt(8)).setNextData(Integer.toString(n8));
        ((ColumnInfo)vector.elementAt(9)).setNextData(Integer.toString(n9));
        ((ColumnInfo)vector.elementAt(10)).setNextData(Integer.toString(n10));
        ((ColumnInfo)vector.elementAt(11)).setNextData(Integer.toString(n11));
        ((ColumnInfo)vector.elementAt(12)).setNextData(Integer.toString(n12));
        ((ColumnInfo)vector.elementAt(13)).setNextData(Integer.toString(n13));
        ((ColumnInfo)vector.elementAt(14)).setNextData(Integer.toString(n14));
        ((ColumnInfo)vector.elementAt(15)).setNextData(Integer.toString(n15));
        this.displayTable(vector, vector2);
    }

    private void displayTable(Vector vector, Vector vector2) {
        int n;
        int n2 = 0;
        int n3 = vector.size();
        String string = null;
        String[] stringArray = null;
        String string2 = null;
        String[] stringArray2 = null;
        stringArray = new String[n3];
        stringArray2 = new String[n3];
        this.out.println("<table width=50% border=1>");
        this.out.println("<tr>");
        for (n2 = 0; n2 < n3; ++n2) {
            ColumnInfo columnInfo = (ColumnInfo)vector2.elementAt(n2);
            this.out.println("<TH BGCOLOR=\"#9999cc\" NOWRAP> <FONT FACE=\"PrimaSans BT, Verdana, sans-serif\" COLOR=\"white\" SIZE=\"3\">");
            this.out.println("<B><center>");
            if (n2 == 0) {
                string = columnInfo.getName();
                string = string.replace(' ', '+');
            }
            stringArray[n2] = columnInfo.getName();
            stringArray[n2] = stringArray[n2].replace(' ', '+');
            this.out.println(columnInfo.getName());
            this.out.println("</B></center></FONT></tH>");
        }
        this.out.println("</tr>");
        int n4 = ((ColumnInfo)vector.elementAt(0)).getNumberOfRows();
        ColumnInfo columnInfo = (ColumnInfo)vector.elementAt(0);
        for (int i = 0; i < n4; ++i) {
            this.out.println("<tr>");
            for (n = 0; n < n3; ++n) {
                ColumnInfo columnInfo2 = (ColumnInfo)vector.elementAt(n);
                this.out.println("<TD NOWRAP> <FONT FACE=\"PrimaSans BT, Verdana, sans-serif\" SIZE=\"3\">");
                if (n == 0) {
                    if (i == 0) {
                        string2 = columnInfo2.getData(i);
                    } else if (i < n4 - 1) {
                        string2 = string2 + "+";
                        string2 = string2 + columnInfo2.getData(i);
                    }
                }
                if (i == 0) {
                    stringArray2[n] = columnInfo2.getData(i);
                } else if (i < n4 - 1) {
                    int n5 = n;
                    stringArray2[n5] = stringArray2[n5] + "+";
                    int n6 = n;
                    stringArray2[n6] = stringArray2[n6] + columnInfo2.getData(i);
                }
                this.out.println("" + columnInfo2.getData(i));
                this.out.println("</font> </td>");
            }
            this.out.println("</tr>");
        }
        this.out.println("<tr>");
        for (n = 0; n < n3; ++n) {
            this.out.println("<TD NOWRAP> <FONT FACE=\"PrimaSans BT, Verdana, sans-serif\" SIZE=\"3\">");
            this.out.println("<A HREF=javascript:pop_up('barChart.jsp?xlabel=" + string + "&ylabel=" + stringArray[n] + "&xvalues=" + string2 + "&yvalues=" + stringArray2[n] + "')> See BarChart </A>");
            this.out.println("</font> </td>");
        }
        this.out.println("</tr>");
        this.out.println("</table>");
    }

    private void cleanUp() {
        File file = new File(this.statsXmlFileName);
        file.delete();
        File file2 = new File(this.statsDtdFileName);
        file2.delete();
    }

    public String returnErrorString() {
        return "../profile";
    }
}

