/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.CommandLineCompiler;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JavaCompiler;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.ServletWriter;

public class CommandLineContext
implements JspCompilationContext {
    String classPath;
    JspReader reader;
    ServletWriter writer;
    URLClassLoader loader;
    boolean errPage;
    String jspFile;
    String servletClassName;
    String servletPackageName;
    String servletJavaFileName;
    String contentType;
    Options options;
    String uriBase;
    File uriRoot;
    boolean outputInDirs;

    public CommandLineContext(String string, String string2, String string3, String string4, boolean bl, Options options) throws JasperException {
        this.classPath = string;
        this.uriBase = string3;
        String string5 = string4;
        this.jspFile = string2;
        this.errPage = bl;
        this.options = options;
        if (this.uriBase == null) {
            this.uriBase = "/";
        } else if (this.uriBase.charAt(0) != '/') {
            this.uriBase = "/" + this.uriBase;
        }
        if (this.uriBase.charAt(this.uriBase.length() - 1) != '/') {
            this.uriBase = this.uriBase + '/';
        }
        if (string5 == null) {
            this.uriRoot = new File("");
        } else {
            this.uriRoot = new File(string5);
            if (!this.uriRoot.exists() || !this.uriRoot.isDirectory()) {
                throw new JasperException(Constants.getString("jsp.error.jspc.uriroot_not_dir"));
            }
        }
    }

    public String getClassPath() {
        URL[] uRLArray = this.loader.getURLs();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < uRLArray.length; ++i) {
            stringBuffer.append(uRLArray[i].getFile());
            stringBuffer.append(File.pathSeparatorChar);
        }
        stringBuffer.append(System.getProperty("java.class.path"));
        stringBuffer.append(File.pathSeparatorChar);
        stringBuffer.append(this.classPath);
        return stringBuffer.toString();
    }

    public JspReader getReader() {
        return this.reader;
    }

    public ServletWriter getWriter() {
        return this.writer;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public boolean isErrorPage() {
        return this.errPage;
    }

    public String getOutputDir() {
        return this.options.getScratchDir().toString();
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public String getServletClassName() {
        return this.servletClassName;
    }

    public String getServletPackageName() {
        return this.servletPackageName;
    }

    public String getServletJavaFileName() {
        return this.servletJavaFileName;
    }

    public boolean keepGenerated() {
        return this.options.getKeepGenerated();
    }

    public String getContentType() {
        return this.contentType;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setClassLoader(URLClassLoader uRLClassLoader) {
        this.loader = uRLClassLoader;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public void setReader(JspReader jspReader) {
        this.reader = jspReader;
    }

    public void setWriter(ServletWriter servletWriter) {
        this.writer = servletWriter;
    }

    public void setServletClassName(String string) {
        this.servletClassName = string;
    }

    public void setServletPackageName(String string) {
        this.servletPackageName = string;
    }

    public void setServletJavaFileName(String string) {
        this.servletJavaFileName = string;
    }

    public void setErrorPage(boolean bl) {
        this.errPage = bl;
    }

    public void setOutputInDirs(boolean bl) {
        this.outputInDirs = true;
    }

    public boolean isOutputInDirs() {
        return this.outputInDirs;
    }

    public Compiler createCompiler() throws JasperException {
        CommandLineCompiler commandLineCompiler = new CommandLineCompiler(this);
        Class clazz = this.options.getJspCompilerPlugin();
        if (clazz != null) {
            JavaCompiler javaCompiler = null;
            try {
                javaCompiler = (JavaCompiler)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new JasperException(Constants.getString("jsp.warning.compiler.class.cantcreate", new Object[]{clazz, exception}));
            }
            String string = this.options.getJspCompilerPath();
            if (string != null) {
                javaCompiler.setCompilerPath(string);
            }
            commandLineCompiler.setJavaCompiler(javaCompiler);
        }
        return commandLineCompiler;
    }

    public String resolveRelativeUri(String string) {
        if (string.startsWith("/") || string.startsWith(File.separator)) {
            return string;
        }
        return this.uriBase + string;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream;
        try {
            inputStream = new FileInputStream(this.getRealPath(string));
        }
        catch (IOException iOException) {
            inputStream = null;
        }
        if (inputStream == null) {
            try {
                inputStream = new FileInputStream(string);
            }
            catch (IOException iOException) {
                inputStream = null;
            }
        }
        if (inputStream == null) {
            inputStream = this.loader.getResourceAsStream(string);
        }
        return inputStream;
    }

    public URL getResource(String string) throws MalformedURLException {
        File file = new File(this.getRealPath(string));
        if (file.exists()) {
            return file.toURL();
        }
        return this.loader.getResource(string);
    }

    public String getRealPath(String string) {
        if ((string = this.resolveRelativeUri(string)).startsWith("/")) {
            string = string.substring(1);
        }
        File file = new File(this.uriRoot, string.replace('/', File.separatorChar));
        return file.getAbsolutePath();
    }

    public String[] getTldLocation(String string) throws JasperException {
        String[] stringArray = this.options.getTldLocationsCache().getLocation(string);
        return stringArray;
    }
}

