/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Store;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public abstract class StoreBase
implements Lifecycle,
Runnable,
Store {
    protected static String info = "StoreBase/1.0";
    protected int checkInterval = 60;
    protected String threadName = "StoreBase";
    protected static String storeName = "StoreBase";
    protected Thread thread = null;
    protected boolean threadDone = false;
    protected int debug = 0;
    protected boolean started = false;
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected StringManager sm = StringManager.getManager("org.apache.catalina.session");
    protected Manager manager;

    public String getInfo() {
        return info;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setDebug(int n) {
        this.debug = n;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setCheckInterval(int n) {
        int n2 = this.checkInterval;
        this.checkInterval = n;
        this.support.firePropertyChange("checkInterval", new Integer(n2), new Integer(this.checkInterval));
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public void setManager(Manager manager) {
        Manager manager2 = this.manager;
        this.manager = manager;
        this.support.firePropertyChange("manager", manager2, this.manager);
    }

    public Manager getManager() {
        return this.manager;
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    protected void processExpires() {
        long l = System.currentTimeMillis();
        String[] stringArray = null;
        if (!this.started) {
            return;
        }
        try {
            stringArray = this.keys();
        }
        catch (IOException iOException) {
            this.log(iOException.toString());
            iOException.printStackTrace();
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                StandardSession standardSession = (StandardSession)this.load(stringArray[i]);
                if (standardSession.isValid()) continue;
                standardSession.expire();
                this.remove(standardSession.getId());
                continue;
            }
            catch (IOException iOException) {
                this.log(iOException.toString());
                iOException.printStackTrace();
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.log(classNotFoundException.toString());
                classNotFoundException.printStackTrace();
            }
        }
    }

    protected void log(String string) {
        Logger logger = null;
        Container container = this.manager.getContainer();
        if (container != null) {
            logger = container.getLogger();
        }
        if (logger != null) {
            logger.log(this.getStoreName() + "[" + container.getName() + "]: " + string);
        } else {
            String string2 = null;
            if (container != null) {
                string2 = container.getName();
            }
            System.out.println(this.getStoreName() + "[" + string2 + "]: " + string);
        }
    }

    protected void log(String string, int n) {
        Logger logger = null;
        Container container = this.manager.getContainer();
        if (container != null) {
            logger = container.getLogger();
        }
        if (logger != null) {
            logger.log(this.getStoreName() + "[" + container.getName() + "]: " + string, n);
        } else {
            this.log(string);
        }
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.processExpires();
        }
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString(this.getStoreName() + ".alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.threadStart();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.threadStop();
    }

    protected void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        this.thread = new Thread((Runnable)this, this.getThreadName());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void threadSleep() {
        try {
            Thread.sleep((long)this.checkInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }
}

