/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.servlets.InvokerHttpRequest;
import org.apache.catalina.util.StringManager;

public final class InvokerServlet
extends HttpServlet
implements ContainerServlet {
    private Context context = null;
    private int debug = 0;
    private static StringManager sm = StringManager.getManager("org.apache.catalina.servlets");
    private Wrapper wrapper = null;

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
        this.context = wrapper == null ? null : (Context)wrapper.getParent();
    }

    public void destroy() {
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.serveRequest(httpServletRequest, httpServletResponse);
    }

    public void doHead(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.serveRequest(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.serveRequest(httpServletRequest, httpServletResponse);
    }

    public void init() throws ServletException {
        if (this.wrapper == null || this.context == null) {
            throw new UnavailableException(sm.getString("invokerServlet.noWrapper"));
        }
        String string = null;
        try {
            string = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.debug >= 1) {
            this.log("init: Associated with Context '" + this.context.getPath() + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serveRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        boolean bl;
        if (httpServletRequest.getAttribute("org.apache.catalina.NAMED") != null) {
            throw new ServletException(sm.getString("invokerServlet.notNamed"));
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl2 = bl = httpServletRequest.getAttribute("javax.servlet.include.request_uri") != null;
        if (bl) {
            string = (String)httpServletRequest.getAttribute("javax.servlet.include.request_uri");
            string2 = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
            string3 = (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
        } else {
            string = httpServletRequest.getRequestURI();
            string2 = httpServletRequest.getServletPath();
            string3 = httpServletRequest.getPathInfo();
        }
        if (this.debug >= 1) {
            this.log("included='" + bl + "', requestURI='" + string + "'");
            this.log("  servletPath='" + string2 + "', pathInfo='" + string3 + "'");
        }
        if (string3 == null) {
            if (this.debug >= 1) {
                this.log("Invalid pathInfo '" + string3 + "'");
            }
            if (bl) {
                throw new ServletException(sm.getString("invokerServlet.invalidPath", string));
            }
            this.log(sm.getString("invokerServlet.invalidPath", string));
            httpServletResponse.sendError(404);
            return;
        }
        String string4 = string3;
        String string5 = string4.substring(1);
        int n = string5.indexOf(47);
        if (n >= 0) {
            string4 = string5.substring(n);
            string5 = string5.substring(0, n);
        } else {
            string4 = "";
        }
        if (this.debug >= 1) {
            this.log("Processing servlet '" + string5 + "' with path info '" + string4 + "'");
        }
        String string6 = "org.apache.catalina.INVOKER." + string5;
        String string7 = string2 + "/" + string5 + "/*";
        Wrapper wrapper = null;
        Object object = this;
        synchronized (object) {
            wrapper = (Wrapper)this.context.findChild(string5);
            if (wrapper == null) {
                wrapper = (Wrapper)this.context.findChild(string6);
            }
            if (wrapper != null) {
                if (this.debug >= 1) {
                    this.log("Using wrapper for servlet '" + wrapper.getName() + "' with mapping '" + string7 + "'");
                }
                this.context.addServletMapping(string7, wrapper.getName());
            } else {
                if (this.debug >= 1) {
                    this.log("Creating wrapper for '" + string5 + "' with mapping '" + string7 + "'");
                }
                try {
                    wrapper = this.context.createWrapper();
                    wrapper.setName(string6);
                    wrapper.setLoadOnStartup(1);
                    wrapper.setServletClass(string5);
                    this.context.addChild(wrapper);
                    this.context.addServletMapping(string7, string6);
                }
                catch (Throwable throwable) {
                    this.log(sm.getString("invokerServlet.cannotCreate", string), throwable);
                    this.context.removeServletMapping(string7);
                    this.context.removeChild(wrapper);
                    if (bl) {
                        throw new ServletException(sm.getString("invokerServlet.cannotCreate", string), throwable);
                    }
                    this.log(sm.getString("invokerServlet.invalidPath", string));
                    httpServletResponse.sendError(404);
                    return;
                }
            }
        }
        object = new InvokerHttpRequest(httpServletRequest);
        ((InvokerHttpRequest)((Object)object)).setRequestURI(string);
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append("/");
        stringBuffer.append(string5);
        ((InvokerHttpRequest)((Object)object)).setServletPath(stringBuffer.toString());
        if (string4 == null || string4.length() < 1) {
            ((InvokerHttpRequest)((Object)object)).setPathInfo(null);
            ((InvokerHttpRequest)((Object)object)).setPathTranslated(null);
        } else {
            ((InvokerHttpRequest)((Object)object)).setPathInfo(string4);
            ((InvokerHttpRequest)((Object)object)).setPathTranslated(this.getServletContext().getRealPath(string4));
        }
        Servlet servlet = null;
        try {
            servlet = wrapper.allocate();
        }
        catch (ServletException servletException) {
            this.log(sm.getString("invokerServlet.allocate", string), servletException);
            this.context.removeServletMapping(string7);
            this.context.removeChild(wrapper);
            Throwable throwable = servletException.getRootCause();
            if (throwable == null) {
                throwable = servletException;
            }
            if (throwable instanceof ClassNotFoundException) {
                this.log(sm.getString("invokerServlet.invalidPath", string));
                httpServletResponse.sendError(404);
                return;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof ServletException) {
                throw (ServletException)throwable;
            }
            throw new ServletException(sm.getString("invokerServlet.allocate", string), throwable);
        }
        catch (Throwable throwable) {
            this.log(sm.getString("invokerServlet.allocate", string), throwable);
            this.context.removeServletMapping(string7);
            this.context.removeChild(wrapper);
            throw new ServletException(sm.getString("invokerServlet.allocate", string), throwable);
        }
        if (bl) {
            ((InvokerHttpRequest)((Object)object)).setRequestURI(httpServletRequest.getRequestURI());
            ((InvokerHttpRequest)((Object)object)).setPathInfo(httpServletRequest.getPathInfo());
            ((InvokerHttpRequest)((Object)object)).setServletPath(httpServletRequest.getServletPath());
        }
        try {
            String string8 = wrapper.getJspFile();
            if (string8 != null) {
                httpServletRequest.setAttribute("org.apache.catalina.jsp_file", (Object)string8);
            } else {
                httpServletRequest.removeAttribute("org.apache.catalina.jsp_file");
            }
            httpServletRequest.setAttribute("org.apache.catalina.INVOKED", (Object)httpServletRequest.getServletPath());
            servlet.service((ServletRequest)object, (ServletResponse)httpServletResponse);
            httpServletRequest.removeAttribute("org.apache.catalina.INVOKED");
            httpServletRequest.removeAttribute("org.apache.catalina.jsp_file");
        }
        catch (IOException iOException) {
            httpServletRequest.removeAttribute("org.apache.catalina.INVOKED");
            httpServletRequest.removeAttribute("org.apache.catalina.jsp_file");
            try {
                wrapper.deallocate(servlet);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw iOException;
        }
        catch (UnavailableException unavailableException) {
            this.context.removeServletMapping(string7);
            httpServletRequest.removeAttribute("org.apache.catalina.INVOKED");
            httpServletRequest.removeAttribute("org.apache.catalina.jsp_file");
            try {
                wrapper.deallocate(servlet);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw unavailableException;
        }
        catch (ServletException servletException) {
            httpServletRequest.removeAttribute("org.apache.catalina.INVOKED");
            httpServletRequest.removeAttribute("org.apache.catalina.jsp_file");
            try {
                wrapper.deallocate(servlet);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw servletException;
        }
        catch (RuntimeException runtimeException) {
            httpServletRequest.removeAttribute("org.apache.catalina.INVOKED");
            httpServletRequest.removeAttribute("org.apache.catalina.jsp_file");
            try {
                wrapper.deallocate(servlet);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            httpServletRequest.removeAttribute("org.apache.catalina.INVOKED");
            httpServletRequest.removeAttribute("org.apache.catalina.jsp_file");
            try {
                wrapper.deallocate(servlet);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw new ServletException("Invoker service() exception", throwable);
        }
        try {
            wrapper.deallocate(servlet);
        }
        catch (ServletException servletException) {
            this.log(sm.getString("invokerServlet.deallocate", string), servletException);
            throw servletException;
        }
        catch (Throwable throwable) {
            this.log(sm.getString("invokerServlet.deallocate", string), throwable);
            throw new ServletException(sm.getString("invokerServlet.deallocate", string), throwable);
        }
    }
}

