/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import org.apache.catalina.Container;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.util.HexUtils;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.MD5Encoder;
import org.apache.catalina.util.StringManager;

public abstract class RealmBase
implements Lifecycle,
Realm {
    protected Container container = null;
    protected int debug = 0;
    protected String digest = null;
    protected static final String info = "org.apache.catalina.realm.RealmBase/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected MessageDigest md = null;
    protected static final MD5Encoder md5Encoder = new MD5Encoder();
    protected static MessageDigest md5Helper;
    protected static StringManager sm;
    protected boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected boolean validate = true;

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        Container container2 = this.container;
        this.container = container;
        this.support.firePropertyChange("container", container2, this.container);
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int n) {
        this.debug = n;
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String string) {
        this.digest = string;
    }

    public String getInfo() {
        return info;
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setValidate(boolean bl) {
        this.validate = bl;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public Principal authenticate(String string, String string2) {
        String string3 = this.getPassword(string);
        if (string3 == null || !string3.equals(string2)) {
            return null;
        }
        return this.getPrincipal(string);
    }

    public Principal authenticate(String string, byte[] byArray) {
        return this.authenticate(string, byArray.toString());
    }

    public Principal authenticate(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        String string9 = this.getDigest(string, string7);
        if (string9 == null) {
            return null;
        }
        String string10 = string9 + ":" + string3 + ":" + string4 + ":" + string5 + ":" + string6 + ":" + string8;
        String string11 = md5Encoder.encode(md5Helper.digest(string10.getBytes()));
        if (string11.equals(string2)) {
            return this.getPrincipal(string);
        }
        return null;
    }

    public Principal authenticate(X509Certificate[] x509CertificateArray) {
        if (x509CertificateArray == null || x509CertificateArray.length < 1) {
            return null;
        }
        if (this.debug >= 1) {
            this.log("Authenticating client certificate chain");
        }
        if (this.validate) {
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                if (this.debug >= 2) {
                    this.log(" Checking validity for '" + x509CertificateArray[i].getSubjectDN().getName() + "'");
                }
                try {
                    x509CertificateArray[i].checkValidity();
                    continue;
                }
                catch (Exception exception) {
                    if (this.debug >= 2) {
                        this.log("  Validity exception", exception);
                    }
                    return null;
                }
            }
        }
        return this.getPrincipal(x509CertificateArray[0].getSubjectDN().getName());
    }

    public boolean hasRole(Principal principal, String string) {
        if (principal == null || string == null || !(principal instanceof GenericPrincipal)) {
            return false;
        }
        GenericPrincipal genericPrincipal = (GenericPrincipal)principal;
        if (genericPrincipal.getRealm() != this) {
            return false;
        }
        boolean bl = genericPrincipal.hasRole(string);
        if (this.debug >= 2) {
            String string2 = principal.getName();
            if (bl) {
                this.log(sm.getString("realmBase.hasRoleSuccess", string2, string));
            } else {
                this.log(sm.getString("realmBase.hasRoleFailure", string2, string));
            }
        }
        return bl;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public Principal getAlternatePrincipal(HttpRequest httpRequest) {
        return null;
    }

    public String getAlternateAuthType(HttpRequest httpRequest) {
        return null;
    }

    public void setRealmName(String string, String string2) {
    }

    public String getRealmName() {
        return null;
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new IllegalStateException(sm.getString("realmBase.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.digest != null) {
            try {
                this.md = MessageDigest.getInstance(this.digest);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new LifecycleException(sm.getString("realmBase.algorithm", this.digest), noSuchAlgorithmException);
            }
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.md = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String digest(String string) {
        if (!this.hasMessageDigest()) {
            return string;
        }
        RealmBase realmBase = this;
        synchronized (realmBase) {
            try {
                this.md.reset();
                this.md.update(string.getBytes());
                return HexUtils.convert(this.md.digest());
            }
            catch (Exception exception) {
                this.log(sm.getString("realmBase.digest"), exception);
                return string;
            }
        }
    }

    protected boolean hasMessageDigest() {
        return this.md != null;
    }

    protected String getDigest(String string, String string2) {
        if (md5Helper == null) {
            try {
                md5Helper = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSuchAlgorithmException.printStackTrace();
                throw new IllegalStateException();
            }
        }
        String string3 = string + ":" + string2 + ":" + this.getPassword(string);
        byte[] byArray = md5Helper.digest(string3.getBytes());
        return md5Encoder.encode(byArray);
    }

    protected abstract String getName();

    protected abstract String getPassword(String var1);

    protected abstract Principal getPrincipal(String var1);

    protected void log(String string) {
        Logger logger = null;
        String string2 = null;
        if (this.container != null) {
            logger = this.container.getLogger();
            string2 = this.container.getName();
        }
        if (logger != null) {
            logger.log(this.getName() + "[" + string2 + "]: " + string);
        } else {
            System.out.println(this.getName() + "[" + string2 + "]: " + string);
        }
    }

    protected void log(String string, Throwable throwable) {
        Logger logger = null;
        String string2 = null;
        if (this.container != null) {
            logger = this.container.getLogger();
            string2 = this.container.getName();
        }
        if (logger != null) {
            logger.log(this.getName() + "[" + string2 + "]: " + string, throwable);
        } else {
            System.out.println(this.getName() + "[" + string2 + "]: " + string);
            throwable.printStackTrace(System.out);
        }
    }

    public static final String Digest(String string, String string2) {
        try {
            MessageDigest messageDigest = (MessageDigest)MessageDigest.getInstance(string2).clone();
            messageDigest.update(string.getBytes());
            return HexUtils.convert(messageDigest.digest());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 2 && stringArray[0].equalsIgnoreCase("-a")) {
            for (int i = 2; i < stringArray.length; ++i) {
                System.out.print(stringArray[i] + ":");
                System.out.println(RealmBase.Digest(stringArray[i], stringArray[1]));
            }
        } else {
            System.out.println("Usage: RealmBase -a <algorithm> <credentials>");
        }
    }

    static {
        sm = StringManager.getManager("org.apache.catalina.realm");
    }
}

