/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.logger;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Logger;

public abstract class LoggerBase
implements Logger {
    protected Container container = null;
    protected static final String info = "org.apache.catalina.logger.LoggerBase/1.0";
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected int verbosity = 1;

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        Container container2 = this.container;
        this.container = container;
        this.support.firePropertyChange("container", container2, this.container);
    }

    public String getInfo() {
        return info;
    }

    public int getVerbosity() {
        return this.verbosity;
    }

    public void setVerbosity(int n) {
        this.verbosity = n;
    }

    public void setVerbosityLevel(String string) {
        if ("FATAL".equalsIgnoreCase(string)) {
            this.verbosity = Integer.MIN_VALUE;
        } else if ("ERROR".equalsIgnoreCase(string)) {
            this.verbosity = 1;
        } else if ("WARNING".equalsIgnoreCase(string)) {
            this.verbosity = 2;
        } else if ("INFORMATION".equalsIgnoreCase(string)) {
            this.verbosity = 3;
        } else if ("DEBUG".equalsIgnoreCase(string)) {
            this.verbosity = 4;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public abstract void log(String var1);

    public void log(Exception exception, String string) {
        this.log(string, exception);
    }

    public void log(String string, Throwable throwable) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        printWriter.println(string);
        throwable.printStackTrace(printWriter);
        Throwable throwable2 = null;
        if (throwable instanceof LifecycleException) {
            throwable2 = ((LifecycleException)throwable).getThrowable();
        } else if (throwable instanceof ServletException) {
            throwable2 = ((ServletException)throwable).getRootCause();
        }
        if (throwable2 != null) {
            printWriter.println("----- Root Cause -----");
            throwable2.printStackTrace(printWriter);
        }
        this.log(charArrayWriter.toString());
    }

    public void log(String string, int n) {
        if (this.verbosity >= n) {
            this.log(string);
        }
    }

    public void log(String string, Throwable throwable, int n) {
        if (this.verbosity >= n) {
            this.log(string, throwable);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }
}

